// Class _ExternBase___default
// Dafny class __default compiled into Java
package software.amazon.cryptography.keystore.internaldafny;

import software.amazon.cryptography.keystore.internaldafny.types.*;
import software.amazon.cryptography.materialproviders.internaldafny.types.*;
import AwsArnParsing_Compile.*;
import AwsKmsMrkMatchForDecrypt_Compile.*;
import AwsKmsUtils_Compile.*;
import Structure_Compile.*;
import KMSKeystoreOperations_Compile.*;
import DDBKeystoreOperations_Compile.*;
import CreateKeys_Compile.*;
import CreateKeyStoreTable_Compile.*;
import GetKeys_Compile.*;
import AwsCryptographyKeyStoreOperations_Compile.*;

@SuppressWarnings({"unchecked", "deprecation"})
public abstract class _ExternBase___default {
  public _ExternBase___default() {
  }
  public static software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig DefaultKeyStoreConfig() {
    return software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig.create(dafny.DafnySequence.asString("None"), software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration.create(dafny.DafnySequence.asString("1234abcd-12ab-34cd-56ef-1234567890ab")), dafny.DafnySequence.asString("None"), Wrappers_Compile.Option.<dafny.DafnySequence<? extends Character>>create_None(), Wrappers_Compile.Option.<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>>create_None(), Wrappers_Compile.Option.<software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient>create_None(), Wrappers_Compile.Option.<software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient>create_None());
  }
  public static Wrappers_Compile.Result<KeyStoreClient, software.amazon.cryptography.keystore.internaldafny.types.Error> KeyStore(software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig config)
  {
    Wrappers_Compile.Result<KeyStoreClient, software.amazon.cryptography.keystore.internaldafny.types.Error> res = (Wrappers_Compile.Result<KeyStoreClient, software.amazon.cryptography.keystore.internaldafny.types.Error>)null;
    Wrappers_Compile.Outcome<software.amazon.cryptography.keystore.internaldafny.types.Error> _285_valueOrError0 = Wrappers_Compile.Outcome.<software.amazon.cryptography.keystore.internaldafny.types.Error>Default();
    _285_valueOrError0 = Wrappers_Compile.__default.<software.amazon.cryptography.keystore.internaldafny.types.Error>Need(software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), (software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__KeyIdType(((config).dtor_kmsConfiguration()).dtor_kmsKeyArn())) && ((AwsArnParsing_Compile.__default.ParseAwsKmsArn(((config).dtor_kmsConfiguration()).dtor_kmsKeyArn())).is_Success()), software.amazon.cryptography.keystore.internaldafny.types.Error.create_KeyStoreException(dafny.DafnySequence.asString("Invalid AWS KMS Key Arn")));
    if ((_285_valueOrError0).IsFailure(software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor())) {
      res = (_285_valueOrError0).<KeyStoreClient>PropagateFailure(software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
      return res;
    }
    Wrappers_Compile.Result<dafny.DafnySequence<? extends dafny.DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _286_grantTokens;
    _286_grantTokens = AwsKmsUtils_Compile.__default.GetValidGrantTokens((config).dtor_grantTokens());
    Wrappers_Compile.Outcome<software.amazon.cryptography.keystore.internaldafny.types.Error> _287_valueOrError1 = Wrappers_Compile.Outcome.<software.amazon.cryptography.keystore.internaldafny.types.Error>Default();
    _287_valueOrError1 = Wrappers_Compile.__default.<software.amazon.cryptography.keystore.internaldafny.types.Error>Need(software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), (true) && ((_286_grantTokens).is_Success()), software.amazon.cryptography.keystore.internaldafny.types.Error.create_KeyStoreException(dafny.DafnySequence.asString("CreateKey received invalid grant tokens")));
    if ((_287_valueOrError1).IsFailure(software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor())) {
      res = (_287_valueOrError1).<KeyStoreClient>PropagateFailure(software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
      return res;
    }
    dafny.DafnySequence<? extends Character> _288_keyStoreId = dafny.DafnySequence.<Character> empty(dafny.TypeDescriptor.CHAR);
    if (((config).dtor_id()).is_Some()) {
      _288_keyStoreId = ((config).dtor_id()).dtor_value();
    } else {
      Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends Character>> _289_maybeUuid;
      Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, dafny.DafnySequence<? extends Character>> _out44;
      _out44 = UUID.__default.GenerateUUID();
      _289_maybeUuid = _out44;
      dafny.DafnySequence<? extends Character> _290_uuid;
      Wrappers_Compile.Result<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.keystore.internaldafny.types.Error> _291_valueOrError2 = Wrappers_Compile.Result.<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.keystore.internaldafny.types.Error>Default(dafny.DafnySequence.<Character> empty(dafny.TypeDescriptor.CHAR));
      _291_valueOrError2 = (_289_maybeUuid).<software.amazon.cryptography.keystore.internaldafny.types.Error>MapFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<dafny.DafnySequence<? extends Character>, software.amazon.cryptography.keystore.internaldafny.types.Error>)(_292_e_boxed0) -> {
        dafny.DafnySequence<? extends Character> _292_e = ((dafny.DafnySequence<? extends Character>)(java.lang.Object)(_292_e_boxed0));
        return software.amazon.cryptography.keystore.internaldafny.types.Error.create_KeyStoreException(_292_e);
      }));
      if ((_291_valueOrError2).IsFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor())) {
        res = (_291_valueOrError2).<KeyStoreClient>PropagateFailure(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
        return res;
      }
      _290_uuid = (_291_valueOrError2).Extract(dafny.DafnySequence.<Character>_typeDescriptor(dafny.TypeDescriptor.CHAR), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor());
      _288_keyStoreId = _290_uuid;
    }
    software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient _293_kmsClient = null;
    software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient _294_ddbClient = null;
    Wrappers_Compile.Result<AwsArnParsing_Compile.AwsKmsIdentifier, dafny.DafnySequence<? extends Character>> _295_keyArn;
    _295_keyArn = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(((config).dtor_kmsConfiguration()).dtor_kmsKeyArn());
    Wrappers_Compile.Option<dafny.DafnySequence<? extends Character>> _296_kmsRegion;
    _296_kmsRegion = AwsArnParsing_Compile.__default.GetRegion((_295_keyArn).dtor_value());
    if (((config).dtor_kmsClient()).is_None()) {
      Wrappers_Compile.Result<software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _297_maybeKmsClient;
      Wrappers_Compile.Result<software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out45;
      _out45 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClientForRegion((_296_kmsRegion).dtor_value());
      _297_maybeKmsClient = _out45;
      Wrappers_Compile.Result<software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient, software.amazon.cryptography.keystore.internaldafny.types.Error> _298_valueOrError3 = (Wrappers_Compile.Result<software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient, software.amazon.cryptography.keystore.internaldafny.types.Error>)null;
      _298_valueOrError3 = (_297_maybeKmsClient).<software.amazon.cryptography.keystore.internaldafny.types.Error>MapFailure(software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.services.kms.internaldafny.types.Error, software.amazon.cryptography.keystore.internaldafny.types.Error>)(_299_e_boxed0) -> {
        software.amazon.cryptography.services.kms.internaldafny.types.Error _299_e = ((software.amazon.cryptography.services.kms.internaldafny.types.Error)(java.lang.Object)(_299_e_boxed0));
        return software.amazon.cryptography.keystore.internaldafny.types.Error.create_ComAmazonawsKms(_299_e);
      }));
      if ((_298_valueOrError3).IsFailure(software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor())) {
        res = (_298_valueOrError3).<KeyStoreClient>PropagateFailure(software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
        return res;
      }
      _293_kmsClient = (_298_valueOrError3).Extract(software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor());
    } else {
      _293_kmsClient = ((config).dtor_kmsClient()).dtor_value();
    }
    if (((config).dtor_ddbClient()).is_None()) {
      Wrappers_Compile.Result<software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _300_maybeDdbClient;
      Wrappers_Compile.Result<software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out46;
      _out46 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DDBClientForRegion((_296_kmsRegion).dtor_value());
      _300_maybeDdbClient = _out46;
      Wrappers_Compile.Result<software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient, software.amazon.cryptography.keystore.internaldafny.types.Error> _301_valueOrError4 = (Wrappers_Compile.Result<software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient, software.amazon.cryptography.keystore.internaldafny.types.Error>)null;
      _301_valueOrError4 = (_300_maybeDdbClient).<software.amazon.cryptography.keystore.internaldafny.types.Error>MapFailure(software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), ((java.util.function.Function<software.amazon.cryptography.services.dynamodb.internaldafny.types.Error, software.amazon.cryptography.keystore.internaldafny.types.Error>)(_302_e_boxed0) -> {
        software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _302_e = ((software.amazon.cryptography.services.dynamodb.internaldafny.types.Error)(java.lang.Object)(_302_e_boxed0));
        return software.amazon.cryptography.keystore.internaldafny.types.Error.create_ComAmazonawsDynamodb(_302_e);
      }));
      if ((_301_valueOrError4).IsFailure(software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor())) {
        res = (_301_valueOrError4).<KeyStoreClient>PropagateFailure(software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
        return res;
      }
      _294_ddbClient = (_301_valueOrError4).Extract(software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor());
    } else {
      _294_ddbClient = ((config).dtor_ddbClient()).dtor_value();
    }
    Wrappers_Compile.Outcome<software.amazon.cryptography.keystore.internaldafny.types.Error> _303_valueOrError5 = Wrappers_Compile.Outcome.<software.amazon.cryptography.keystore.internaldafny.types.Error>Default();
    _303_valueOrError5 = Wrappers_Compile.__default.<software.amazon.cryptography.keystore.internaldafny.types.Error>Need(software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName((config).dtor_ddbTableName()), software.amazon.cryptography.keystore.internaldafny.types.Error.create_KeyStoreException(dafny.DafnySequence.asString("Invalid Amazon DynamoDB Table Name")));
    if ((_303_valueOrError5).IsFailure(software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor())) {
      res = (_303_valueOrError5).<KeyStoreClient>PropagateFailure(software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
      return res;
    }
    KeyStoreClient _304_client;
    KeyStoreClient _nw0 = new KeyStoreClient();
    _nw0.__ctor(AwsCryptographyKeyStoreOperations_Compile.Config.create(_288_keyStoreId, (config).dtor_ddbTableName(), (config).dtor_logicalKeyStoreName(), (config).dtor_kmsConfiguration(), (_286_grantTokens).dtor_value(), _293_kmsClient, _294_ddbClient));
    _304_client = _nw0;
    res = Wrappers_Compile.Result.<KeyStoreClient, software.amazon.cryptography.keystore.internaldafny.types.Error>create_Success(_304_client);
    return res;
  }
  @Override
  public java.lang.String toString() {
    return "KeyStore._default";
  }
}
