/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore;

import dafny.DafnyMap;
import dafny.DafnySequence;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import software.amazon.cryptography.keystore.KeyStore;
import software.amazon.cryptography.keystore.internaldafny.types.CreateKeyStoreOutput;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.Error_CollectionOfErrors;
import software.amazon.cryptography.keystore.internaldafny.types.Error_KeyStoreException;
import software.amazon.cryptography.keystore.internaldafny.types.Error_Opaque;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.GetKeyStoreInfoOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.keystore.model.BeaconKeyMaterials;
import software.amazon.cryptography.keystore.model.BranchKeyMaterials;
import software.amazon.cryptography.keystore.model.CollectionOfErrors;
import software.amazon.cryptography.keystore.model.CreateKeyInput;
import software.amazon.cryptography.keystore.model.CreateKeyOutput;
import software.amazon.cryptography.keystore.model.CreateKeyStoreInput;
import software.amazon.cryptography.keystore.model.CreateKeyStoreOutput;
import software.amazon.cryptography.keystore.model.GetActiveBranchKeyInput;
import software.amazon.cryptography.keystore.model.GetActiveBranchKeyOutput;
import software.amazon.cryptography.keystore.model.GetBeaconKeyInput;
import software.amazon.cryptography.keystore.model.GetBeaconKeyOutput;
import software.amazon.cryptography.keystore.model.GetBranchKeyVersionInput;
import software.amazon.cryptography.keystore.model.GetBranchKeyVersionOutput;
import software.amazon.cryptography.keystore.model.GetKeyStoreInfoOutput;
import software.amazon.cryptography.keystore.model.KMSConfiguration;
import software.amazon.cryptography.keystore.model.KeyStoreConfig;
import software.amazon.cryptography.keystore.model.KeyStoreException;
import software.amazon.cryptography.keystore.model.OpaqueError;
import software.amazon.cryptography.keystore.model.VersionKeyInput;
import software.amazon.cryptography.keystore.model.VersionKeyOutput;
import software.amazon.smithy.dafny.conversion.ToNative;

public class ToNative {
    public static OpaqueError Error(Error_Opaque dafnyValue) {
        OpaqueError.Builder nativeBuilder = OpaqueError.builder();
        nativeBuilder.obj(dafnyValue.dtor_obj());
        return nativeBuilder.build();
    }

    public static CollectionOfErrors Error(Error_CollectionOfErrors dafnyValue) {
        CollectionOfErrors.Builder nativeBuilder = CollectionOfErrors.builder();
        nativeBuilder.list(ToNative.Aggregate.GenericToList(dafnyValue.dtor_list(), ToNative::Error));
        nativeBuilder.message(ToNative.Simple.String(dafnyValue.dtor_message()));
        return nativeBuilder.build();
    }

    public static KeyStoreException Error(Error_KeyStoreException dafnyValue) {
        KeyStoreException.Builder nativeBuilder = KeyStoreException.builder();
        nativeBuilder.message(ToNative.Simple.String(dafnyValue.dtor_message()));
        return nativeBuilder.build();
    }

    public static RuntimeException Error(Error dafnyValue) {
        if (dafnyValue.is_KeyStoreException()) {
            return ToNative.Error((Error_KeyStoreException)dafnyValue);
        }
        if (dafnyValue.is_Opaque()) {
            return ToNative.Error((Error_Opaque)dafnyValue);
        }
        if (dafnyValue.is_CollectionOfErrors()) {
            return ToNative.Error((Error_CollectionOfErrors)dafnyValue);
        }
        if (dafnyValue.is_ComAmazonawsDynamodb()) {
            return software.amazon.cryptography.services.dynamodb.internaldafny.ToNative.Error(dafnyValue.dtor_ComAmazonawsDynamodb());
        }
        if (dafnyValue.is_ComAmazonawsKms()) {
            return software.amazon.cryptography.services.kms.internaldafny.ToNative.Error(dafnyValue.dtor_ComAmazonawsKms());
        }
        OpaqueError.Builder nativeBuilder = OpaqueError.builder();
        nativeBuilder.obj(dafnyValue);
        return nativeBuilder.build();
    }

    public static BeaconKeyMaterials BeaconKeyMaterials(software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials dafnyValue) {
        BeaconKeyMaterials.Builder nativeBuilder = BeaconKeyMaterials.builder();
        nativeBuilder.beaconKeyIdentifier(ToNative.Simple.String(dafnyValue.dtor_beaconKeyIdentifier()));
        nativeBuilder.encryptionContext(ToNative.EncryptionContext(dafnyValue.dtor_encryptionContext()));
        if (dafnyValue.dtor_beaconKey().is_Some()) {
            nativeBuilder.beaconKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_beaconKey().dtor_value()));
        }
        if (dafnyValue.dtor_hmacKeys().is_Some()) {
            nativeBuilder.hmacKeys(ToNative.HmacKeyMap(dafnyValue.dtor_hmacKeys().dtor_value()));
        }
        return nativeBuilder.build();
    }

    public static BranchKeyMaterials BranchKeyMaterials(software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials dafnyValue) {
        BranchKeyMaterials.Builder nativeBuilder = BranchKeyMaterials.builder();
        nativeBuilder.branchKeyIdentifier(ToNative.Simple.String(dafnyValue.dtor_branchKeyIdentifier()));
        nativeBuilder.branchKeyVersion(ToNative.Simple.DafnyUtf8Bytes(dafnyValue.dtor_branchKeyVersion()));
        nativeBuilder.encryptionContext(ToNative.EncryptionContext(dafnyValue.dtor_encryptionContext()));
        nativeBuilder.branchKey(ToNative.Simple.ByteBuffer(dafnyValue.dtor_branchKey()));
        return nativeBuilder.build();
    }

    public static CreateKeyInput CreateKeyInput(software.amazon.cryptography.keystore.internaldafny.types.CreateKeyInput dafnyValue) {
        CreateKeyInput.Builder nativeBuilder = CreateKeyInput.builder();
        if (dafnyValue.dtor_branchKeyIdentifier().is_Some()) {
            nativeBuilder.branchKeyIdentifier(ToNative.Simple.String(dafnyValue.dtor_branchKeyIdentifier().dtor_value()));
        }
        if (dafnyValue.dtor_encryptionContext().is_Some()) {
            nativeBuilder.encryptionContext(ToNative.EncryptionContext(dafnyValue.dtor_encryptionContext().dtor_value()));
        }
        return nativeBuilder.build();
    }

    public static CreateKeyOutput CreateKeyOutput(software.amazon.cryptography.keystore.internaldafny.types.CreateKeyOutput dafnyValue) {
        CreateKeyOutput.Builder nativeBuilder = CreateKeyOutput.builder();
        nativeBuilder.branchKeyIdentifier(ToNative.Simple.String(dafnyValue.dtor_branchKeyIdentifier()));
        return nativeBuilder.build();
    }

    public static CreateKeyStoreInput CreateKeyStoreInput(software.amazon.cryptography.keystore.internaldafny.types.CreateKeyStoreInput dafnyValue) {
        CreateKeyStoreInput.Builder nativeBuilder = CreateKeyStoreInput.builder();
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.keystore.model.CreateKeyStoreOutput CreateKeyStoreOutput(CreateKeyStoreOutput dafnyValue) {
        CreateKeyStoreOutput.Builder nativeBuilder = software.amazon.cryptography.keystore.model.CreateKeyStoreOutput.builder();
        nativeBuilder.tableArn(ToNative.Simple.String(dafnyValue.dtor_tableArn()));
        return nativeBuilder.build();
    }

    public static GetActiveBranchKeyInput GetActiveBranchKeyInput(software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyInput dafnyValue) {
        GetActiveBranchKeyInput.Builder nativeBuilder = GetActiveBranchKeyInput.builder();
        nativeBuilder.branchKeyIdentifier(ToNative.Simple.String(dafnyValue.dtor_branchKeyIdentifier()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.keystore.model.GetActiveBranchKeyOutput GetActiveBranchKeyOutput(GetActiveBranchKeyOutput dafnyValue) {
        GetActiveBranchKeyOutput.Builder nativeBuilder = software.amazon.cryptography.keystore.model.GetActiveBranchKeyOutput.builder();
        nativeBuilder.branchKeyMaterials(ToNative.BranchKeyMaterials(dafnyValue.dtor_branchKeyMaterials()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.keystore.model.GetBeaconKeyInput GetBeaconKeyInput(GetBeaconKeyInput dafnyValue) {
        GetBeaconKeyInput.Builder nativeBuilder = software.amazon.cryptography.keystore.model.GetBeaconKeyInput.builder();
        nativeBuilder.branchKeyIdentifier(ToNative.Simple.String(dafnyValue.dtor_branchKeyIdentifier()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.keystore.model.GetBeaconKeyOutput GetBeaconKeyOutput(GetBeaconKeyOutput dafnyValue) {
        GetBeaconKeyOutput.Builder nativeBuilder = software.amazon.cryptography.keystore.model.GetBeaconKeyOutput.builder();
        nativeBuilder.beaconKeyMaterials(ToNative.BeaconKeyMaterials(dafnyValue.dtor_beaconKeyMaterials()));
        return nativeBuilder.build();
    }

    public static GetBranchKeyVersionInput GetBranchKeyVersionInput(software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionInput dafnyValue) {
        GetBranchKeyVersionInput.Builder nativeBuilder = GetBranchKeyVersionInput.builder();
        nativeBuilder.branchKeyIdentifier(ToNative.Simple.String(dafnyValue.dtor_branchKeyIdentifier()));
        nativeBuilder.branchKeyVersion(ToNative.Simple.String(dafnyValue.dtor_branchKeyVersion()));
        return nativeBuilder.build();
    }

    public static GetBranchKeyVersionOutput GetBranchKeyVersionOutput(software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput dafnyValue) {
        GetBranchKeyVersionOutput.Builder nativeBuilder = GetBranchKeyVersionOutput.builder();
        nativeBuilder.branchKeyMaterials(ToNative.BranchKeyMaterials(dafnyValue.dtor_branchKeyMaterials()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.keystore.model.GetKeyStoreInfoOutput GetKeyStoreInfoOutput(GetKeyStoreInfoOutput dafnyValue) {
        GetKeyStoreInfoOutput.Builder nativeBuilder = software.amazon.cryptography.keystore.model.GetKeyStoreInfoOutput.builder();
        nativeBuilder.keyStoreId(ToNative.Simple.String(dafnyValue.dtor_keyStoreId()));
        nativeBuilder.keyStoreName(ToNative.Simple.String(dafnyValue.dtor_keyStoreName()));
        nativeBuilder.logicalKeyStoreName(ToNative.Simple.String(dafnyValue.dtor_logicalKeyStoreName()));
        nativeBuilder.grantTokens(ToNative.GrantTokenList(dafnyValue.dtor_grantTokens()));
        nativeBuilder.kmsConfiguration(ToNative.KMSConfiguration(dafnyValue.dtor_kmsConfiguration()));
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.keystore.model.KeyStoreConfig KeyStoreConfig(KeyStoreConfig dafnyValue) {
        KeyStoreConfig.Builder nativeBuilder = software.amazon.cryptography.keystore.model.KeyStoreConfig.builder();
        nativeBuilder.ddbTableName(ToNative.Simple.String(dafnyValue.dtor_ddbTableName()));
        nativeBuilder.kmsConfiguration(ToNative.KMSConfiguration(dafnyValue.dtor_kmsConfiguration()));
        nativeBuilder.logicalKeyStoreName(ToNative.Simple.String(dafnyValue.dtor_logicalKeyStoreName()));
        if (dafnyValue.dtor_id().is_Some()) {
            nativeBuilder.id(ToNative.Simple.String(dafnyValue.dtor_id().dtor_value()));
        }
        if (dafnyValue.dtor_grantTokens().is_Some()) {
            nativeBuilder.grantTokens(ToNative.GrantTokenList(dafnyValue.dtor_grantTokens().dtor_value()));
        }
        if (dafnyValue.dtor_ddbClient().is_Some()) {
            nativeBuilder.ddbClient(software.amazon.cryptography.services.dynamodb.internaldafny.ToNative.DynamoDB_20120810(dafnyValue.dtor_ddbClient().dtor_value()));
        }
        if (dafnyValue.dtor_kmsClient().is_Some()) {
            nativeBuilder.kmsClient(software.amazon.cryptography.services.kms.internaldafny.ToNative.TrentService(dafnyValue.dtor_kmsClient().dtor_value()));
        }
        return nativeBuilder.build();
    }

    public static VersionKeyInput VersionKeyInput(software.amazon.cryptography.keystore.internaldafny.types.VersionKeyInput dafnyValue) {
        VersionKeyInput.Builder nativeBuilder = VersionKeyInput.builder();
        nativeBuilder.branchKeyIdentifier(ToNative.Simple.String(dafnyValue.dtor_branchKeyIdentifier()));
        return nativeBuilder.build();
    }

    public static VersionKeyOutput VersionKeyOutput(software.amazon.cryptography.keystore.internaldafny.types.VersionKeyOutput dafnyValue) {
        VersionKeyOutput.Builder nativeBuilder = VersionKeyOutput.builder();
        return nativeBuilder.build();
    }

    public static software.amazon.cryptography.keystore.model.KMSConfiguration KMSConfiguration(KMSConfiguration dafnyValue) {
        KMSConfiguration.Builder nativeBuilder = software.amazon.cryptography.keystore.model.KMSConfiguration.builder();
        if (dafnyValue.is_kmsKeyArn()) {
            nativeBuilder.kmsKeyArn(ToNative.Simple.String(dafnyValue.dtor_kmsKeyArn()));
        }
        return nativeBuilder.build();
    }

    public static List<String> GrantTokenList(DafnySequence<? extends DafnySequence<? extends Character>> dafnyValue) {
        return ToNative.Aggregate.GenericToList(dafnyValue, ToNative.Simple::String);
    }

    public static Map<String, String> EncryptionContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> dafnyValue) {
        return ToNative.Aggregate.GenericToMap(dafnyValue, ToNative.Simple::DafnyUtf8Bytes, ToNative.Simple::DafnyUtf8Bytes);
    }

    public static Map<String, ByteBuffer> HmacKeyMap(DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> dafnyValue) {
        return ToNative.Aggregate.GenericToMap(dafnyValue, ToNative.Simple::String, ToNative.Simple::ByteBuffer);
    }

    public static KeyStore KeyStore(IKeyStoreClient dafnyValue) {
        return new KeyStore(dafnyValue);
    }
}

