/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.internaldafny.types;

import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class KeyStoreConfig {
    public DafnySequence<? extends Character> _ddbTableName;
    public KMSConfiguration _kmsConfiguration;
    public DafnySequence<? extends Character> _logicalKeyStoreName;
    public Option<DafnySequence<? extends Character>> _id;
    public Option<DafnySequence<? extends DafnySequence<? extends Character>>> _grantTokens;
    public Option<IDynamoDBClient> _ddbClient;
    public Option<IKMSClient> _kmsClient;
    private static final KeyStoreConfig theDefault = KeyStoreConfig.create((DafnySequence<? extends Character>)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR), KMSConfiguration.Default(), (DafnySequence<? extends Character>)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR), Option.Default(), Option.Default(), Option.Default(), Option.Default());
    private static final TypeDescriptor<KeyStoreConfig> _TYPE = TypeDescriptor.referenceWithInitializer(KeyStoreConfig.class, () -> KeyStoreConfig.Default());

    public KeyStoreConfig(DafnySequence<? extends Character> ddbTableName, KMSConfiguration kmsConfiguration, DafnySequence<? extends Character> logicalKeyStoreName, Option<DafnySequence<? extends Character>> id, Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens, Option<IDynamoDBClient> ddbClient, Option<IKMSClient> kmsClient) {
        this._ddbTableName = ddbTableName;
        this._kmsConfiguration = kmsConfiguration;
        this._logicalKeyStoreName = logicalKeyStoreName;
        this._id = id;
        this._grantTokens = grantTokens;
        this._ddbClient = ddbClient;
        this._kmsClient = kmsClient;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        KeyStoreConfig o = (KeyStoreConfig)other;
        return Objects.equals(this._ddbTableName, o._ddbTableName) && Objects.equals(this._kmsConfiguration, o._kmsConfiguration) && Objects.equals(this._logicalKeyStoreName, o._logicalKeyStoreName) && Objects.equals(this._id, o._id) && Objects.equals(this._grantTokens, o._grantTokens) && Objects.equals(this._ddbClient, o._ddbClient) && Objects.equals(this._kmsClient, o._kmsClient);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._ddbTableName);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._kmsConfiguration);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._logicalKeyStoreName);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._id);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._grantTokens);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._ddbClient);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._kmsClient);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyKeyStoreTypes.KeyStoreConfig.KeyStoreConfig");
        s.append("(");
        s.append(Helpers.toString(this._ddbTableName));
        s.append(", ");
        s.append(Helpers.toString((Object)this._kmsConfiguration));
        s.append(", ");
        s.append(Helpers.toString(this._logicalKeyStoreName));
        s.append(", ");
        s.append(Helpers.toString(this._id));
        s.append(", ");
        s.append(Helpers.toString(this._grantTokens));
        s.append(", ");
        s.append(Helpers.toString(this._ddbClient));
        s.append(", ");
        s.append(Helpers.toString(this._kmsClient));
        s.append(")");
        return s.toString();
    }

    public static KeyStoreConfig Default() {
        return theDefault;
    }

    public static TypeDescriptor<KeyStoreConfig> _typeDescriptor() {
        return _TYPE;
    }

    public static KeyStoreConfig create(DafnySequence<? extends Character> ddbTableName, KMSConfiguration kmsConfiguration, DafnySequence<? extends Character> logicalKeyStoreName, Option<DafnySequence<? extends Character>> id, Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens, Option<IDynamoDBClient> ddbClient, Option<IKMSClient> kmsClient) {
        return new KeyStoreConfig(ddbTableName, kmsConfiguration, logicalKeyStoreName, id, grantTokens, ddbClient, kmsClient);
    }

    public static KeyStoreConfig create_KeyStoreConfig(DafnySequence<? extends Character> ddbTableName, KMSConfiguration kmsConfiguration, DafnySequence<? extends Character> logicalKeyStoreName, Option<DafnySequence<? extends Character>> id, Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens, Option<IDynamoDBClient> ddbClient, Option<IKMSClient> kmsClient) {
        return KeyStoreConfig.create(ddbTableName, kmsConfiguration, logicalKeyStoreName, id, grantTokens, ddbClient, kmsClient);
    }

    public boolean is_KeyStoreConfig() {
        return true;
    }

    public DafnySequence<? extends Character> dtor_ddbTableName() {
        return this._ddbTableName;
    }

    public KMSConfiguration dtor_kmsConfiguration() {
        return this._kmsConfiguration;
    }

    public DafnySequence<? extends Character> dtor_logicalKeyStoreName() {
        return this._logicalKeyStoreName;
    }

    public Option<DafnySequence<? extends Character>> dtor_id() {
        return this._id;
    }

    public Option<DafnySequence<? extends DafnySequence<? extends Character>>> dtor_grantTokens() {
        return this._grantTokens;
    }

    public Option<IDynamoDBClient> dtor_ddbClient() {
        return this._ddbClient;
    }

    public Option<IKMSClient> dtor_kmsClient() {
        return this._kmsClient;
    }
}

