/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives;

import Wrappers_Compile.Option;
import dafny.DafnySequence;
import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.AtomicPrimitives;
import software.amazon.cryptography.primitives.internaldafny.types.AESDecryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.AESEncryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.AES__CTR;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;
import software.amazon.cryptography.primitives.internaldafny.types.CryptoConfig;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSAVerifyInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.Error_AwsCryptographicPrimitivesError;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateRSAKeyPairInput;
import software.amazon.cryptography.primitives.internaldafny.types.HMacInput;
import software.amazon.cryptography.primitives.internaldafny.types.HkdfExtractInput;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.RSADecryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode;
import software.amazon.cryptography.primitives.model.AESEncryptOutput;
import software.amazon.cryptography.primitives.model.AES_CTR;
import software.amazon.cryptography.primitives.model.AES_GCM;
import software.amazon.cryptography.primitives.model.AesKdfCtrInput;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;
import software.amazon.cryptography.primitives.model.CollectionOfErrors;
import software.amazon.cryptography.primitives.model.ECDSASignInput;
import software.amazon.cryptography.primitives.model.GenerateECDSASignatureKeyInput;
import software.amazon.cryptography.primitives.model.GenerateRSAKeyPairOutput;
import software.amazon.cryptography.primitives.model.GenerateRandomBytesInput;
import software.amazon.cryptography.primitives.model.GetRSAKeyModulusLengthInput;
import software.amazon.cryptography.primitives.model.GetRSAKeyModulusLengthOutput;
import software.amazon.cryptography.primitives.model.HkdfExpandInput;
import software.amazon.cryptography.primitives.model.HkdfInput;
import software.amazon.cryptography.primitives.model.KdfCtrInput;
import software.amazon.cryptography.primitives.model.OpaqueError;
import software.amazon.cryptography.primitives.model.RSAEncryptInput;
import software.amazon.cryptography.primitives.model.RSAPrivateKey;
import software.amazon.cryptography.primitives.model.RSAPublicKey;
import software.amazon.smithy.dafny.conversion.ToDafny;

public class ToDafny {
    public static Error Error(RuntimeException nativeValue) {
        if (nativeValue instanceof AwsCryptographicPrimitivesError) {
            return ToDafny.Error((AwsCryptographicPrimitivesError)nativeValue);
        }
        if (nativeValue instanceof OpaqueError) {
            return ToDafny.Error((OpaqueError)nativeValue);
        }
        if (nativeValue instanceof CollectionOfErrors) {
            return ToDafny.Error((CollectionOfErrors)nativeValue);
        }
        return Error.create_Opaque(nativeValue);
    }

    public static Error Error(OpaqueError nativeValue) {
        return Error.create_Opaque(nativeValue.obj());
    }

    public static Error Error(CollectionOfErrors nativeValue) {
        DafnySequence list = ToDafny.Aggregate.GenericToSequence(nativeValue.list(), ToDafny::Error, Error._typeDescriptor());
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.getMessage());
        return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)list, (DafnySequence<? extends Character>)message);
    }

    public static AES__CTR AES_CTR(AES_CTR nativeValue) {
        Integer keyLength = nativeValue.keyLength();
        Integer nonceLength = nativeValue.nonceLength();
        return new AES__CTR(keyLength, nonceLength);
    }

    public static AES__GCM AES_GCM(AES_GCM nativeValue) {
        Integer keyLength = nativeValue.keyLength();
        Integer tagLength = nativeValue.tagLength();
        Integer ivLength = nativeValue.ivLength();
        return new AES__GCM(keyLength, tagLength, ivLength);
    }

    public static AESDecryptInput AESDecryptInput(software.amazon.cryptography.primitives.model.AESDecryptInput nativeValue) {
        AES__GCM encAlg = ToDafny.AES_GCM(nativeValue.encAlg());
        DafnySequence key = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.key());
        DafnySequence cipherTxt = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.cipherTxt());
        DafnySequence authTag = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.authTag());
        DafnySequence iv = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.iv());
        DafnySequence aad = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.aad());
        return new AESDecryptInput(encAlg, (DafnySequence<? extends Byte>)key, (DafnySequence<? extends Byte>)cipherTxt, (DafnySequence<? extends Byte>)authTag, (DafnySequence<? extends Byte>)iv, (DafnySequence<? extends Byte>)aad);
    }

    public static DafnySequence<? extends Byte> AESDecryptOutput(ByteBuffer nativeValue) {
        DafnySequence plaintext = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return plaintext;
    }

    public static AESEncryptInput AESEncryptInput(software.amazon.cryptography.primitives.model.AESEncryptInput nativeValue) {
        AES__GCM encAlg = ToDafny.AES_GCM(nativeValue.encAlg());
        DafnySequence iv = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.iv());
        DafnySequence key = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.key());
        DafnySequence msg = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.msg());
        DafnySequence aad = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.aad());
        return new AESEncryptInput(encAlg, (DafnySequence<? extends Byte>)iv, (DafnySequence<? extends Byte>)key, (DafnySequence<? extends Byte>)msg, (DafnySequence<? extends Byte>)aad);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput AESEncryptOutput(AESEncryptOutput nativeValue) {
        DafnySequence cipherText = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.cipherText());
        DafnySequence authTag = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.authTag());
        return new software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput((DafnySequence<? extends Byte>)cipherText, (DafnySequence<? extends Byte>)authTag);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.AesKdfCtrInput AesKdfCtrInput(AesKdfCtrInput nativeValue) {
        DafnySequence ikm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.ikm());
        Integer expectedLength = nativeValue.expectedLength();
        Option<DafnySequence<? extends Byte>> nonce = Objects.nonNull(nativeValue.nonce()) ? Option.create_Some(ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.nonce())) : Option.create_None();
        return new software.amazon.cryptography.primitives.internaldafny.types.AesKdfCtrInput((DafnySequence<? extends Byte>)ikm, expectedLength, nonce);
    }

    public static DafnySequence<? extends Byte> AesKdfCtrOutput(ByteBuffer nativeValue) {
        DafnySequence okm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return okm;
    }

    public static CryptoConfig CryptoConfig(software.amazon.cryptography.primitives.model.CryptoConfig nativeValue) {
        return new CryptoConfig();
    }

    public static DigestInput DigestInput(software.amazon.cryptography.primitives.model.DigestInput nativeValue) {
        DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        DafnySequence message = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.message());
        return new DigestInput(digestAlgorithm, (DafnySequence<? extends Byte>)message);
    }

    public static DafnySequence<? extends Byte> DigestOutput(ByteBuffer nativeValue) {
        DafnySequence digest = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return digest;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.ECDSASignInput ECDSASignInput(ECDSASignInput nativeValue) {
        ECDSASignatureAlgorithm signatureAlgorithm = ToDafny.ECDSASignatureAlgorithm(nativeValue.signatureAlgorithm());
        DafnySequence signingKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.signingKey());
        DafnySequence message = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.message());
        return new software.amazon.cryptography.primitives.internaldafny.types.ECDSASignInput(signatureAlgorithm, (DafnySequence<? extends Byte>)signingKey, (DafnySequence<? extends Byte>)message);
    }

    public static DafnySequence<? extends Byte> ECDSASignOutput(ByteBuffer nativeValue) {
        DafnySequence signature = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return signature;
    }

    public static ECDSAVerifyInput ECDSAVerifyInput(software.amazon.cryptography.primitives.model.ECDSAVerifyInput nativeValue) {
        ECDSASignatureAlgorithm signatureAlgorithm = ToDafny.ECDSASignatureAlgorithm(nativeValue.signatureAlgorithm());
        DafnySequence verificationKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.verificationKey());
        DafnySequence message = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.message());
        DafnySequence signature = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.signature());
        return new ECDSAVerifyInput(signatureAlgorithm, (DafnySequence<? extends Byte>)verificationKey, (DafnySequence<? extends Byte>)message, (DafnySequence<? extends Byte>)signature);
    }

    public static Boolean ECDSAVerifyOutput(Boolean nativeValue) {
        Boolean success = nativeValue;
        return success;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyInput GenerateECDSASignatureKeyInput(GenerateECDSASignatureKeyInput nativeValue) {
        ECDSASignatureAlgorithm signatureAlgorithm = ToDafny.ECDSASignatureAlgorithm(nativeValue.signatureAlgorithm());
        return new software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyInput(signatureAlgorithm);
    }

    public static GenerateECDSASignatureKeyOutput GenerateECDSASignatureKeyOutput(software.amazon.cryptography.primitives.model.GenerateECDSASignatureKeyOutput nativeValue) {
        ECDSASignatureAlgorithm signatureAlgorithm = ToDafny.ECDSASignatureAlgorithm(nativeValue.signatureAlgorithm());
        DafnySequence verificationKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.verificationKey());
        DafnySequence signingKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.signingKey());
        return new GenerateECDSASignatureKeyOutput(signatureAlgorithm, (DafnySequence<? extends Byte>)verificationKey, (DafnySequence<? extends Byte>)signingKey);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GenerateRandomBytesInput GenerateRandomBytesInput(GenerateRandomBytesInput nativeValue) {
        Integer length = nativeValue.length();
        return new software.amazon.cryptography.primitives.internaldafny.types.GenerateRandomBytesInput(length);
    }

    public static DafnySequence<? extends Byte> GenerateRandomBytesOutput(ByteBuffer nativeValue) {
        DafnySequence data = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return data;
    }

    public static GenerateRSAKeyPairInput GenerateRSAKeyPairInput(software.amazon.cryptography.primitives.model.GenerateRSAKeyPairInput nativeValue) {
        Integer lengthBits = nativeValue.lengthBits();
        return new GenerateRSAKeyPairInput(lengthBits);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GenerateRSAKeyPairOutput GenerateRSAKeyPairOutput(GenerateRSAKeyPairOutput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.RSAPublicKey publicKey = ToDafny.RSAPublicKey(nativeValue.publicKey());
        software.amazon.cryptography.primitives.internaldafny.types.RSAPrivateKey privateKey = ToDafny.RSAPrivateKey(nativeValue.privateKey());
        return new software.amazon.cryptography.primitives.internaldafny.types.GenerateRSAKeyPairOutput(publicKey, privateKey);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthInput GetRSAKeyModulusLengthInput(GetRSAKeyModulusLengthInput nativeValue) {
        DafnySequence publicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.publicKey());
        return new software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthInput((DafnySequence<? extends Byte>)publicKey);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthOutput GetRSAKeyModulusLengthOutput(GetRSAKeyModulusLengthOutput nativeValue) {
        Integer length = nativeValue.length();
        return new software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthOutput(length);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.HkdfExpandInput HkdfExpandInput(HkdfExpandInput nativeValue) {
        DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        DafnySequence prk = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.prk());
        DafnySequence info = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.info());
        Integer expectedLength = nativeValue.expectedLength();
        return new software.amazon.cryptography.primitives.internaldafny.types.HkdfExpandInput(digestAlgorithm, (DafnySequence<? extends Byte>)prk, (DafnySequence<? extends Byte>)info, expectedLength);
    }

    public static DafnySequence<? extends Byte> HkdfExpandOutput(ByteBuffer nativeValue) {
        DafnySequence okm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return okm;
    }

    public static HkdfExtractInput HkdfExtractInput(software.amazon.cryptography.primitives.model.HkdfExtractInput nativeValue) {
        DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        Option<DafnySequence<? extends Byte>> salt = Objects.nonNull(nativeValue.salt()) ? Option.create_Some(ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.salt())) : Option.create_None();
        DafnySequence ikm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.ikm());
        return new HkdfExtractInput(digestAlgorithm, salt, (DafnySequence<? extends Byte>)ikm);
    }

    public static DafnySequence<? extends Byte> HkdfExtractOutput(ByteBuffer nativeValue) {
        DafnySequence prk = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return prk;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.HkdfInput HkdfInput(HkdfInput nativeValue) {
        DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        Option<DafnySequence<? extends Byte>> salt = Objects.nonNull(nativeValue.salt()) ? Option.create_Some(ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.salt())) : Option.create_None();
        DafnySequence ikm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.ikm());
        DafnySequence info = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.info());
        Integer expectedLength = nativeValue.expectedLength();
        return new software.amazon.cryptography.primitives.internaldafny.types.HkdfInput(digestAlgorithm, salt, (DafnySequence<? extends Byte>)ikm, (DafnySequence<? extends Byte>)info, expectedLength);
    }

    public static DafnySequence<? extends Byte> HkdfOutput(ByteBuffer nativeValue) {
        DafnySequence okm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return okm;
    }

    public static HMacInput HMacInput(software.amazon.cryptography.primitives.model.HMacInput nativeValue) {
        DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        DafnySequence key = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.key());
        DafnySequence message = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.message());
        return new HMacInput(digestAlgorithm, (DafnySequence<? extends Byte>)key, (DafnySequence<? extends Byte>)message);
    }

    public static DafnySequence<? extends Byte> HMacOutput(ByteBuffer nativeValue) {
        DafnySequence digest = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return digest;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.KdfCtrInput KdfCtrInput(KdfCtrInput nativeValue) {
        DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        DafnySequence ikm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.ikm());
        Integer expectedLength = nativeValue.expectedLength();
        Option<DafnySequence<? extends Byte>> purpose = Objects.nonNull(nativeValue.purpose()) ? Option.create_Some(ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.purpose())) : Option.create_None();
        Option<DafnySequence<? extends Byte>> nonce = Objects.nonNull(nativeValue.nonce()) ? Option.create_Some(ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.nonce())) : Option.create_None();
        return new software.amazon.cryptography.primitives.internaldafny.types.KdfCtrInput(digestAlgorithm, (DafnySequence<? extends Byte>)ikm, expectedLength, purpose, nonce);
    }

    public static DafnySequence<? extends Byte> KdfCtrOutput(ByteBuffer nativeValue) {
        DafnySequence okm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return okm;
    }

    public static RSADecryptInput RSADecryptInput(software.amazon.cryptography.primitives.model.RSADecryptInput nativeValue) {
        RSAPaddingMode padding = ToDafny.RSAPaddingMode(nativeValue.padding());
        DafnySequence privateKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.privateKey());
        DafnySequence cipherText = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.cipherText());
        return new RSADecryptInput(padding, (DafnySequence<? extends Byte>)privateKey, (DafnySequence<? extends Byte>)cipherText);
    }

    public static DafnySequence<? extends Byte> RSADecryptOutput(ByteBuffer nativeValue) {
        DafnySequence plaintext = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return plaintext;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.RSAEncryptInput RSAEncryptInput(RSAEncryptInput nativeValue) {
        RSAPaddingMode padding = ToDafny.RSAPaddingMode(nativeValue.padding());
        DafnySequence publicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.publicKey());
        DafnySequence plaintext = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.plaintext());
        return new software.amazon.cryptography.primitives.internaldafny.types.RSAEncryptInput(padding, (DafnySequence<? extends Byte>)publicKey, (DafnySequence<? extends Byte>)plaintext);
    }

    public static DafnySequence<? extends Byte> RSAEncryptOutput(ByteBuffer nativeValue) {
        DafnySequence cipherText = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return cipherText;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.RSAPrivateKey RSAPrivateKey(RSAPrivateKey nativeValue) {
        Integer lengthBits = nativeValue.lengthBits();
        DafnySequence pem = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.pem());
        return new software.amazon.cryptography.primitives.internaldafny.types.RSAPrivateKey(lengthBits, (DafnySequence<? extends Byte>)pem);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.RSAPublicKey RSAPublicKey(RSAPublicKey nativeValue) {
        Integer lengthBits = nativeValue.lengthBits();
        DafnySequence pem = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.pem());
        return new software.amazon.cryptography.primitives.internaldafny.types.RSAPublicKey(lengthBits, (DafnySequence<? extends Byte>)pem);
    }

    public static Error Error(AwsCryptographicPrimitivesError nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)message);
    }

    public static DigestAlgorithm DigestAlgorithm(software.amazon.cryptography.primitives.model.DigestAlgorithm nativeValue) {
        switch (nativeValue) {
            case SHA_512: {
                return DigestAlgorithm.create_SHA__512();
            }
            case SHA_384: {
                return DigestAlgorithm.create_SHA__384();
            }
            case SHA_256: {
                return DigestAlgorithm.create_SHA__256();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.");
    }

    public static ECDSASignatureAlgorithm ECDSASignatureAlgorithm(software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm nativeValue) {
        switch (nativeValue) {
            case ECDSA_P384: {
                return ECDSASignatureAlgorithm.create_ECDSA__P384();
            }
            case ECDSA_P256: {
                return ECDSASignatureAlgorithm.create_ECDSA__P256();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.");
    }

    public static RSAPaddingMode RSAPaddingMode(software.amazon.cryptography.primitives.model.RSAPaddingMode nativeValue) {
        switch (nativeValue) {
            case PKCS1: {
                return RSAPaddingMode.create_PKCS1();
            }
            case OAEP_SHA1: {
                return RSAPaddingMode.create_OAEP__SHA1();
            }
            case OAEP_SHA256: {
                return RSAPaddingMode.create_OAEP__SHA256();
            }
            case OAEP_SHA384: {
                return RSAPaddingMode.create_OAEP__SHA384();
            }
            case OAEP_SHA512: {
                return RSAPaddingMode.create_OAEP__SHA512();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode.");
    }

    public static IAwsCryptographicPrimitivesClient AwsCryptographicPrimitives(AtomicPrimitives nativeValue) {
        return nativeValue.impl();
    }
}

