/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsMrkDiscoveryKeyring_Compile;

import Actions_Compile.__default;
import AwsKmsMrkDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyDecryptor;
import AwsKmsMrkDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyFilterTransform;
import Constants_Compile.AwsKmsEdkHelper;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.Result_Failure;
import Wrappers_Compile.Result_Success;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsMrkDiscoveryKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _region = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public Option<DiscoveryFilter> _discoveryFilter = Option.Default(DiscoveryFilter._typeDescriptor());
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsMrkDiscoveryKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsMrkDiscoveryKeyring.class, () -> null);

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out4 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out4;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out4 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out4;
    }

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> region, Option<DiscoveryFilter> discoveryFilter, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._region = region;
        this._discoveryFilter = discoveryFilter;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        output = Result.create_Failure(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption is not supported with a Discovery Keyring.")));
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out1;
        Result<DecryptionMaterials, DafnySequence<Error>> _10_outcome;
        Result<OnDecryptOutput, Error> output = null;
        DecryptionMaterials _0_materials = input.dtor_materials();
        DafnySequence<? extends EncryptedDataKey> _1_encryptedDataKeys = input.dtor_encryptedDataKeys();
        AlgorithmSuiteInfo _2_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Error> _3_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _3_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_0_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_3_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _3_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        AwsKmsEncryptedDataKeyFilterTransform _nw0 = new AwsKmsEncryptedDataKeyFilterTransform();
        _nw0.__ctor(this.region(), this.discoveryFilter());
        AwsKmsEncryptedDataKeyFilterTransform _4_edkFilterTransform = _nw0;
        Result<DafnySequence, Error> _5_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(AwsKmsEdkHelper._typeDescriptor()));
        Result<DafnySequence<? extends AwsKmsEdkHelper>, Error> _out0 = __default.DeterministicFlatMapWithResult(EncryptedDataKey._typeDescriptor(), AwsKmsEdkHelper._typeDescriptor(), Error._typeDescriptor(), _4_edkFilterTransform, _1_encryptedDataKeys);
        _5_valueOrError1 = _out0;
        if (_5_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor())) {
            output = _5_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _6_edksToAttempt = _5_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_6_edksToAttempt.length()).signum() == 0) {
            Result<DafnySequence, Error> _7_valueOrError2 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _7_valueOrError2 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_7_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                output = _7_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return output;
            }
            DafnySequence _8_errorMessage = _7_valueOrError2.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            output = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_8_errorMessage));
            return output;
        }
        AwsKmsEncryptedDataKeyDecryptor _nw1 = new AwsKmsEncryptedDataKeyDecryptor();
        _nw1.__ctor(_0_materials, this.client(), this.region(), this.grantTokens());
        AwsKmsEncryptedDataKeyDecryptor _9_decryptAction = _nw1;
        Result<DecryptionMaterials, DafnySequence<Error>> _source0 = _10_outcome = (_out1 = __default.ReduceToSuccess(AwsKmsEdkHelper._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _9_decryptAction, _6_edksToAttempt));
        if (_source0.is_Success()) {
            DecryptionMaterials _11___mcc_h0;
            DecryptionMaterials _12_mat = _11___mcc_h0 = (DecryptionMaterials)((Result_Success)_source0)._value;
            output = Result.create_Success(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput.create(_12_mat));
        } else {
            DafnySequence _13___mcc_h1;
            DafnySequence _14_errors = _13___mcc_h1 = (DafnySequence)((Result_Failure)_source0)._error;
            output = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_14_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`.")));
        }
        return output;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> region() {
        return this._region;
    }

    public Option<DiscoveryFilter> discoveryFilter() {
        return this._discoveryFilter;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsMrkDiscoveryKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsMrkDiscoveryKeyring.AwsKmsMrkDiscoveryKeyring";
    }
}

