/*
 * Decompiled with CFR 0.152.
 */
package Signature;

import BoundedInts_Compile.uint8;
import Signature.ECDSA;
import Signature.SignatureKeyPair;
import Signature.__default;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput;

public abstract class _ExternBase___default {
    public static short SignatureLength(ECDSASignatureAlgorithm signatureAlgorithm) {
        ECDSASignatureAlgorithm _source0 = signatureAlgorithm;
        if (_source0.is_ECDSA__P384()) {
            return 103;
        }
        return 71;
    }

    public static BigInteger FieldSize(ECDSASignatureAlgorithm signatureAlgorithm) {
        ECDSASignatureAlgorithm _source0 = signatureAlgorithm;
        if (_source0.is_ECDSA__P384()) {
            return BigInteger.valueOf(49L);
        }
        return BigInteger.valueOf(33L);
    }

    public static Result<GenerateECDSASignatureKeyOutput, Error> KeyGen(GenerateECDSASignatureKeyInput input) {
        Result<GenerateECDSASignatureKeyOutput, Error> res = Result.Default(GenerateECDSASignatureKeyOutput._typeDescriptor(), Error._typeDescriptor(), GenerateECDSASignatureKeyOutput.Default());
        Result<SignatureKeyPair, Error> _0_valueOrError0 = Result.Default(SignatureKeyPair._typeDescriptor(), Error._typeDescriptor(), SignatureKeyPair.Default());
        Result<SignatureKeyPair, Error> _out0 = ECDSA.ExternKeyGen(input.dtor_signatureAlgorithm());
        _0_valueOrError0 = _out0;
        if (_0_valueOrError0.IsFailure(SignatureKeyPair._typeDescriptor(), Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(SignatureKeyPair._typeDescriptor(), Error._typeDescriptor(), GenerateECDSASignatureKeyOutput._typeDescriptor());
            return res;
        }
        SignatureKeyPair _1_sigKeyPair = _0_valueOrError0.Extract(SignatureKeyPair._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _2_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _2_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_1_sigKeyPair.dtor_verificationKey().length()), __default.FieldSize(input.dtor_signatureAlgorithm())), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Incorrect verification-key length from ExternKeyGen.")));
        if (_2_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _2_valueOrError1.PropagateFailure(Error._typeDescriptor(), GenerateECDSASignatureKeyOutput._typeDescriptor());
            return res;
        }
        res = Result.create_Success(GenerateECDSASignatureKeyOutput._typeDescriptor(), Error._typeDescriptor(), GenerateECDSASignatureKeyOutput.create(input.dtor_signatureAlgorithm(), _1_sigKeyPair.dtor_verificationKey(), _1_sigKeyPair.dtor_signingKey()));
        return res;
    }

    public static Result<SignatureKeyPair, Error> CreateExternKeyGenSuccess(SignatureKeyPair output) {
        return Result.create_Success(SignatureKeyPair._typeDescriptor(), Error._typeDescriptor(), output);
    }

    public static Result<SignatureKeyPair, Error> CreateExternKeyGenFailure(Error error) {
        return Result.create_Failure(SignatureKeyPair._typeDescriptor(), Error._typeDescriptor(), error);
    }

    public static Result<DafnySequence<? extends Byte>, Error> CreateSignSuccess(DafnySequence<? extends Byte> bytes) {
        return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), bytes);
    }

    public static Result<DafnySequence<? extends Byte>, Error> CreateSignFailure(Error error) {
        return Result.create_Failure(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), error);
    }

    public static Result<Boolean, Error> CreateVerifySuccess(boolean b) {
        return Result.create_Success(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), b);
    }

    public static Result<Boolean, Error> CreateVerifyFailure(Error error) {
        return Result.create_Failure(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), error);
    }

    public String toString() {
        return "Signature._default";
    }
}

