/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsKeyring_Compile.KmsWrapInfo;
import MaterialWrapping_Compile.GenerateAndWrapInput;
import MaterialWrapping_Compile.GenerateAndWrapMaterial;
import MaterialWrapping_Compile.GenerateAndWrapOutput;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class KmsGenerateAndWrapKeyMaterial
implements GenerateAndWrapMaterial<KmsWrapInfo>,
ActionWithResult<GenerateAndWrapInput, GenerateAndWrapOutput<KmsWrapInfo>, Error>,
Action<GenerateAndWrapInput, Result<GenerateAndWrapOutput<KmsWrapInfo>, Error>> {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<KmsGenerateAndWrapKeyMaterial> _TYPE = TypeDescriptor.referenceWithInitializer(KmsGenerateAndWrapKeyMaterial.class, () -> null);

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<GenerateAndWrapOutput<KmsWrapInfo>, Error> Invoke(GenerateAndWrapInput input) {
        Result<GenerateDataKeyResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out91;
        Result<GenerateAndWrapOutput<KmsWrapInfo>, Error> res = Result.Default(GenerateAndWrapOutput.Default(KmsWrapInfo.Default()));
        AlgorithmSuiteInfo _650_suite = input.dtor_algorithmSuite();
        Result<Object, Object> _652_valueOrError0 = Result.Default(DafnyMap.empty());
        _652_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_encryptionContext());
        if (_652_valueOrError0.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _652_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        DafnyMap _651_stringifiedEncCtx = (DafnyMap)_652_valueOrError0.Extract((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        GenerateDataKeyRequest _653_generatorRequest = GenerateDataKeyRequest.create(this.awsKmsKey(), Option.create_Some(_651_stringifiedEncCtx), Option.create_Some(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_650_suite)), Option.create_None(), Option.create_Some(this.grantTokens()), Option.create_None(), Option.create_None());
        Result<GenerateDataKeyResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _654_maybeGenerateResponse = _out91 = this.client().GenerateDataKey(_653_generatorRequest);
        Result<GenerateDataKeyResponse, Object> _656_valueOrError1 = Result.Default(GenerateDataKeyResponse.Default());
        _656_valueOrError1 = _654_maybeGenerateResponse.MapFailure(GenerateDataKeyResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _657_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _657_e = _657_e_boxed0;
            return Error.create_ComAmazonawsKms(_657_e);
        });
        if (_656_valueOrError1.IsFailure(GenerateDataKeyResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _656_valueOrError1.PropagateFailure(GenerateDataKeyResponse._typeDescriptor(), Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        GenerateDataKeyResponse _655_generateResponse = _656_valueOrError1.Extract(GenerateDataKeyResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _658_valueOrError2 = Outcome.Default();
        _658_valueOrError2 = __default.Need(Error._typeDescriptor(), _655_generateResponse.dtor_KeyId().is_Some() && AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(_655_generateResponse.dtor_KeyId().dtor_value()).is_Success(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS GenerateDataKey:: Invalid Key Id")));
        if (_658_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _658_valueOrError2.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Object> _659_valueOrError3 = Outcome.Default();
        _659_valueOrError3 = __default.Need(Error._typeDescriptor(), _655_generateResponse.dtor_Plaintext().is_Some() && Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_650_suite)), BigInteger.valueOf(_655_generateResponse.dtor_Plaintext().dtor_value().length())), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Invalid data key")));
        if (_659_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _659_valueOrError3.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Object> _660_valueOrError4 = Outcome.Default();
        _660_valueOrError4 = __default.Need(Error._typeDescriptor(), _655_generateResponse.dtor_CiphertextBlob().is_Some() && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(_655_generateResponse.dtor_CiphertextBlob().dtor_value()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GeneratedDataKey: Invalid ciphertext")));
        if (_660_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _660_valueOrError4.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Object> _661_valueOrError5 = Outcome.Default();
        _661_valueOrError5 = __default.Need(Error._typeDescriptor(), _655_generateResponse.dtor_CiphertextForRecipient().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GeneratedDataKey: Invalid CiphertextForRecipient")));
        if (_661_valueOrError5.IsFailure(Error._typeDescriptor())) {
            res = _661_valueOrError5.PropagateFailure(Error._typeDescriptor(), GenerateAndWrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        GenerateAndWrapOutput<KmsWrapInfo> _662_output = GenerateAndWrapOutput.create(_655_generateResponse.dtor_Plaintext().dtor_value(), _655_generateResponse.dtor_CiphertextBlob().dtor_value(), KmsWrapInfo.create(_655_generateResponse.dtor_KeyId().dtor_value()));
        res = Result.create_Success(_662_output);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<KmsGenerateAndWrapKeyMaterial> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.KmsGenerateAndWrapKeyMaterial";
    }
}

