/*
 * Decompiled with CFR 0.152.
 */
package Base64_Compile;

import Base64_Compile.index;
import BoundedInts_Compile.uint8;
import Wrappers_Compile.Result;
import dafny.DafnyEuclidean;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;

public class __default {
    public static boolean IsBase64Char(char c) {
        return c == '+' || c == '/' || '0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    public static boolean IsUnpaddedBase64String(DafnySequence<? extends Character> s) {
        return DafnyEuclidean.EuclideanModulus((BigInteger)BigInteger.valueOf(s.length()), (BigInteger)BigInteger.valueOf(4L)).signum() == 0 && ((Function<DafnySequence, Boolean>)_374_s -> Helpers.Quantifier((Iterable)_374_s.UniqueElements(), (boolean)true, _forall_var_5_boxed0 -> {
            char _forall_var_5 = _forall_var_5_boxed0.charValue();
            char _375_k = _forall_var_5;
            return !_374_s.contains((Object)Character.valueOf(_375_k)) || __default.IsBase64Char(_375_k);
        })).apply(s) != false;
    }

    public static char IndexToChar(byte i) {
        if (i == 63) {
            return '/';
        }
        if (i == 62) {
            return '+';
        }
        if (Integer.compareUnsigned(52, i) <= 0 && Integer.compareUnsigned(i, 61) <= 0) {
            return (char)Byte.toUnsignedInt((byte)(i - 4));
        }
        if (Integer.compareUnsigned(26, i) <= 0 && Integer.compareUnsigned(i, 51) <= 0) {
            return (char)((char)Byte.toUnsignedInt(i) + (char)Helpers.toInt((BigInteger)BigInteger.valueOf(71L)));
        }
        return (char)((char)Byte.toUnsignedInt(i) + (char)Helpers.toInt((BigInteger)BigInteger.valueOf(65L)));
    }

    public static byte CharToIndex(char c) {
        if (c == '/') {
            return 63;
        }
        if (c == '+') {
            return 62;
        }
        if ('0' <= c && c <= '9') {
            return (byte)(c + (char)Helpers.toInt((BigInteger)BigInteger.valueOf(4L)));
        }
        if ('a' <= c && c <= 'z') {
            return (byte)(c - (char)Helpers.toInt((BigInteger)BigInteger.valueOf(71L)));
        }
        return (byte)(c - (char)Helpers.toInt((BigInteger)BigInteger.valueOf(65L)));
    }

    public static DafnySequence<? extends Byte> UInt24ToSeq(int x) {
        byte _376_b0 = (byte)Integer.divideUnsigned(x, 65536);
        int _377_x0 = x - Byte.toUnsignedInt(_376_b0) * 65536;
        byte _378_b1 = (byte)Integer.divideUnsigned(_377_x0, 256);
        byte _379_b2 = (byte)Integer.remainderUnsigned(_377_x0, 256);
        return DafnySequence.of((byte[])new byte[]{_376_b0, _378_b1, _379_b2});
    }

    public static int SeqToUInt24(DafnySequence<? extends Byte> s) {
        return Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))) * 65536 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))) * 256 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L))));
    }

    public static DafnySequence<? extends Byte> UInt24ToIndexSeq(int x) {
        byte _380_b0 = (byte)Integer.divideUnsigned(x, 262144);
        int _381_x0 = x - Byte.toUnsignedInt(_380_b0) * 262144;
        byte _382_b1 = (byte)Integer.divideUnsigned(_381_x0, 4096);
        int _383_x1 = _381_x0 - Byte.toUnsignedInt(_382_b1) * 4096;
        byte _384_b2 = (byte)Integer.divideUnsigned(_383_x1, 64);
        byte _385_b3 = (byte)Integer.remainderUnsigned(_383_x1, 64);
        return DafnySequence.of((byte[])new byte[]{_380_b0, _382_b1, _384_b2, _385_b3});
    }

    public static int IndexSeqToUInt24(DafnySequence<? extends Byte> s) {
        return Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))) * 262144 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))) * 4096 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))) * 64 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L))));
    }

    public static DafnySequence<? extends Byte> DecodeBlock(DafnySequence<? extends Byte> s) {
        return __default.UInt24ToSeq(__default.IndexSeqToUInt24(s));
    }

    public static DafnySequence<? extends Byte> EncodeBlock(DafnySequence<? extends Byte> s) {
        return __default.UInt24ToIndexSeq(__default.SeqToUInt24(s));
    }

    public static DafnySequence<? extends Byte> DecodeRecursively(DafnySequence<? extends Byte> s) {
        DafnySequence _386___accumulator = DafnySequence.empty(uint8._typeDescriptor());
        while (BigInteger.valueOf(s.length()).signum() != 0) {
            DafnySequence _in182;
            _386___accumulator = DafnySequence.concatenate((DafnySequence)_386___accumulator, __default.DecodeBlock((DafnySequence<? extends Byte>)s.take(BigInteger.valueOf(4L))));
            s = _in182 = s.drop(BigInteger.valueOf(4L));
        }
        return DafnySequence.concatenate((DafnySequence)_386___accumulator, (DafnySequence)DafnySequence.empty(uint8._typeDescriptor()));
    }

    public static DafnySequence<? extends Byte> EncodeRecursively(DafnySequence<? extends Byte> b) {
        DafnySequence _387___accumulator = DafnySequence.empty(index._typeDescriptor());
        while (BigInteger.valueOf(b.length()).signum() != 0) {
            DafnySequence _in183;
            _387___accumulator = DafnySequence.concatenate((DafnySequence)_387___accumulator, __default.EncodeBlock((DafnySequence<? extends Byte>)b.take(BigInteger.valueOf(3L))));
            b = _in183 = b.drop(BigInteger.valueOf(3L));
        }
        return DafnySequence.concatenate((DafnySequence)_387___accumulator, (DafnySequence)DafnySequence.empty(index._typeDescriptor()));
    }

    public static DafnySequence<? extends Byte> FromCharsToIndices(DafnySequence<? extends Character> s) {
        return DafnySequence.Create(index._typeDescriptor(), (BigInteger)BigInteger.valueOf(s.length()), (Function)((Function<DafnySequence, Function>)_388_s -> _389_i_boxed0 -> {
            BigInteger _389_i = _389_i_boxed0;
            return __default.CharToIndex(((Character)_388_s.select(Helpers.toInt((BigInteger)_389_i))).charValue());
        }).apply(s));
    }

    public static DafnySequence<? extends Character> FromIndicesToChars(DafnySequence<? extends Byte> b) {
        return DafnySequence.Create((TypeDescriptor)TypeDescriptor.CHAR, (BigInteger)BigInteger.valueOf(b.length()), (Function)((Function<DafnySequence, Function>)_390_b -> _391_i_boxed0 -> {
            BigInteger _391_i = _391_i_boxed0;
            return Character.valueOf(__default.IndexToChar((Byte)_390_b.select(Helpers.toInt((BigInteger)_391_i))));
        }).apply(b));
    }

    public static DafnySequence<? extends Byte> DecodeUnpadded(DafnySequence<? extends Character> s) {
        return __default.DecodeRecursively(__default.FromCharsToIndices(s));
    }

    public static DafnySequence<? extends Character> EncodeUnpadded(DafnySequence<? extends Byte> b) {
        return __default.FromIndicesToChars(__default.EncodeRecursively(b));
    }

    public static boolean Is1Padding(DafnySequence<? extends Character> s) {
        return Objects.equals(BigInteger.valueOf(s.length()), BigInteger.valueOf(4L)) && __default.IsBase64Char(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue()) && __default.IsBase64Char(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))).charValue()) && __default.IsBase64Char(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))).charValue()) && !(Helpers.remainderUnsignedByte((byte)__default.CharToIndex(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))).charValue()), (byte)4) != 0) && ((Character)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)))).charValue() == '=';
    }

    public static DafnySequence<? extends Byte> Decode1Padding(DafnySequence<? extends Character> s) {
        DafnySequence<? extends Byte> _392_d = __default.DecodeBlock((DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{__default.CharToIndex(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue()), __default.CharToIndex(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))).charValue()), __default.CharToIndex(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))).charValue()), 0}));
        return DafnySequence.of((byte[])new byte[]{(Byte)_392_d.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), (Byte)_392_d.select(Helpers.toInt((BigInteger)BigInteger.ONE))});
    }

    public static DafnySequence<? extends Character> Encode1Padding(DafnySequence<? extends Byte> b) {
        DafnySequence<? extends Byte> _393_e = __default.EncodeBlock((DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{(Byte)b.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), (Byte)b.select(Helpers.toInt((BigInteger)BigInteger.ONE)), 0}));
        return DafnySequence.of((char[])new char[]{__default.IndexToChar((Byte)_393_e.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), __default.IndexToChar((Byte)_393_e.select(Helpers.toInt((BigInteger)BigInteger.ONE))), __default.IndexToChar((Byte)_393_e.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))), '='});
    }

    public static boolean Is2Padding(DafnySequence<? extends Character> s) {
        return Objects.equals(BigInteger.valueOf(s.length()), BigInteger.valueOf(4L)) && __default.IsBase64Char(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue()) && __default.IsBase64Char(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))).charValue()) && !(Helpers.remainderUnsignedByte((byte)__default.CharToIndex(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))).charValue()), (byte)16) != 0) && ((Character)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))).charValue() == '=' && ((Character)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)))).charValue() == '=';
    }

    public static DafnySequence<? extends Byte> Decode2Padding(DafnySequence<? extends Character> s) {
        DafnySequence<? extends Byte> _394_d = __default.DecodeBlock((DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{__default.CharToIndex(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).charValue()), __default.CharToIndex(((Character)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))).charValue()), 0, 0}));
        return DafnySequence.of((byte[])new byte[]{(Byte)_394_d.select(Helpers.toInt((BigInteger)BigInteger.ZERO))});
    }

    public static DafnySequence<? extends Character> Encode2Padding(DafnySequence<? extends Byte> b) {
        DafnySequence<? extends Byte> _395_e = __default.EncodeBlock((DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{(Byte)b.select(Helpers.toInt((BigInteger)BigInteger.ZERO)), 0, 0}));
        return DafnySequence.of((char[])new char[]{__default.IndexToChar((Byte)_395_e.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), __default.IndexToChar((Byte)_395_e.select(Helpers.toInt((BigInteger)BigInteger.ONE))), '=', '='});
    }

    public static boolean IsBase64String(DafnySequence<? extends Character> s) {
        BigInteger _396_finalBlockStart = BigInteger.valueOf(s.length()).subtract(BigInteger.valueOf(4L));
        return DafnyEuclidean.EuclideanModulus((BigInteger)BigInteger.valueOf(s.length()), (BigInteger)BigInteger.valueOf(4L)).signum() == 0 && (__default.IsUnpaddedBase64String(s) || __default.IsUnpaddedBase64String((DafnySequence<? extends Character>)s.take(_396_finalBlockStart)) && (__default.Is1Padding((DafnySequence<? extends Character>)s.drop(_396_finalBlockStart)) || __default.Is2Padding((DafnySequence<? extends Character>)s.drop(_396_finalBlockStart))));
    }

    public static DafnySequence<? extends Byte> DecodeValid(DafnySequence<? extends Character> s) {
        if (s.equals((Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR))) {
            return DafnySequence.empty(uint8._typeDescriptor());
        }
        BigInteger _397_finalBlockStart = BigInteger.valueOf(s.length()).subtract(BigInteger.valueOf(4L));
        DafnySequence _398_prefix = s.take(_397_finalBlockStart);
        DafnySequence _399_suffix = s.drop(_397_finalBlockStart);
        if (__default.Is1Padding((DafnySequence<? extends Character>)_399_suffix)) {
            return DafnySequence.concatenate(__default.DecodeUnpadded((DafnySequence<? extends Character>)_398_prefix), __default.Decode1Padding((DafnySequence<? extends Character>)_399_suffix));
        }
        if (__default.Is2Padding((DafnySequence<? extends Character>)_399_suffix)) {
            return DafnySequence.concatenate(__default.DecodeUnpadded((DafnySequence<? extends Character>)_398_prefix), __default.Decode2Padding((DafnySequence<? extends Character>)_399_suffix));
        }
        return __default.DecodeUnpadded(s);
    }

    public static Result<DafnySequence<? extends Byte>, DafnySequence<? extends Character>> Decode(DafnySequence<? extends Character> s) {
        if (__default.IsBase64String(s)) {
            return Result.create_Success(__default.DecodeValid(s));
        }
        return Result.create_Failure(DafnySequence.asString((String)"The encoding is malformed"));
    }

    public static DafnySequence<? extends Character> Encode(DafnySequence<? extends Byte> b) {
        if (DafnyEuclidean.EuclideanModulus((BigInteger)BigInteger.valueOf(b.length()), (BigInteger)BigInteger.valueOf(3L)).signum() == 0) {
            DafnySequence<? extends Character> _400_s = __default.EncodeUnpadded(b);
            return _400_s;
        }
        if (Objects.equals(DafnyEuclidean.EuclideanModulus((BigInteger)BigInteger.valueOf(b.length()), (BigInteger)BigInteger.valueOf(3L)), BigInteger.ONE)) {
            DafnySequence<? extends Character> _401_s1 = __default.EncodeUnpadded((DafnySequence<? extends Byte>)b.take(BigInteger.valueOf(b.length()).subtract(BigInteger.ONE)));
            DafnySequence<? extends Character> _402_s2 = __default.Encode2Padding((DafnySequence<? extends Byte>)b.drop(BigInteger.valueOf(b.length()).subtract(BigInteger.ONE)));
            DafnySequence _403_s = DafnySequence.concatenate(_401_s1, _402_s2);
            return _403_s;
        }
        DafnySequence<? extends Character> _404_s1 = __default.EncodeUnpadded((DafnySequence<? extends Byte>)b.take(BigInteger.valueOf(b.length()).subtract(BigInteger.valueOf(2L))));
        DafnySequence<? extends Character> _405_s2 = __default.Encode1Padding((DafnySequence<? extends Byte>)b.drop(BigInteger.valueOf(b.length()).subtract(BigInteger.valueOf(2L))));
        DafnySequence _406_s = DafnySequence.concatenate(_404_s1, _405_s2);
        return _406_s;
    }

    public String toString() {
        return "Base64._default";
    }
}

