/*
 * Decompiled with CFR 0.152.
 */
package EcdhEdkWrapping_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhUnwrapInfo;
import EcdhEdkWrapping_Compile.__default;
import MaterialWrapping_Compile.UnwrapInput;
import MaterialWrapping_Compile.UnwrapMaterial;
import MaterialWrapping_Compile.UnwrapOutput;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.AESDecryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.Error;

public class EcdhUnwrap
implements UnwrapMaterial<EcdhUnwrapInfo>,
ActionWithResult<UnwrapInput, UnwrapOutput<EcdhUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>,
Action<UnwrapInput, Result<UnwrapOutput<EcdhUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>> {
    public DafnySequence<? extends Byte> _senderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _recipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _sharedSecret = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _keyringVersion = DafnySequence.empty(uint8._typeDescriptor());
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    public AtomicPrimitivesClient _crypto = null;
    private static final TypeDescriptor<EcdhUnwrap> _TYPE = TypeDescriptor.referenceWithInitializer(EcdhUnwrap.class, () -> null);

    public void __ctor(DafnySequence<? extends Byte> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey, DafnySequence<? extends Byte> sharedSecret, DafnySequence<? extends Byte> keyringVersion, ECDHCurveSpec curveSpec, AtomicPrimitivesClient crypto) {
        this._senderPublicKey = senderPublicKey;
        this._recipientPublicKey = recipientPublicKey;
        this._sharedSecret = sharedSecret;
        this._keyringVersion = keyringVersion;
        this._curveSpec = curveSpec;
        this._crypto = crypto;
    }

    @Override
    public Result<UnwrapOutput<EcdhUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> Invoke(UnwrapInput input) {
        Result<DafnySequence<? extends Byte>, Error> _out199;
        boolean _out198;
        Result<UnwrapOutput<EcdhUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(UnwrapOutput.Default(EcdhUnwrapInfo.Default()));
        AlgorithmSuiteInfo _1148_suite = input.dtor_algorithmSuite();
        DafnySequence<? extends Byte> _1149_wrappedMaterial = input.dtor_wrappedMaterial();
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> _1150_aad = input.dtor_encryptionContext();
        Outcome<Object> _1151_valueOrError0 = Outcome.Default();
        _1151_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_1149_wrappedMaterial.length()).compareTo(Constants_Compile.__default.CIPHERTEXT__WRAPPED__MATERIAL__INDEX()) > 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Recieved ciphertext is shorter than expected.")));
        if (_1151_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1151_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        BigInteger _1152_KeyLength = BigInteger.ZERO;
        _1152_KeyLength = BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_1148_suite));
        Outcome<Object> _1153_valueOrError1 = Outcome.Default();
        _1153_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_1149_wrappedMaterial.length()).compareTo(Constants_Compile.__default.ECDH__WRAPPED__KEY__MATERIAL__INDEX().add(_1152_KeyLength)) > 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received EDK Ciphertext of incorrect length.")));
        if (_1153_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1153_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnySequence _1154_kdfNonce = _1149_wrappedMaterial.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)Constants_Compile.__default.ECDH__COMMITMENT__KEY__INDEX()));
        DafnySequence _1155_iv = DafnySequence.Create(uint8._typeDescriptor(), (BigInteger)BigInteger.valueOf(Constants_Compile.__default.ECDH__AES__256__ENC__ALG().dtor_ivLength()), _1156___v0_boxed0 -> {
            BigInteger _1156___v0 = _1156___v0_boxed0;
            return (byte)0;
        });
        DafnySequence _1157_commitmentKey = _1149_wrappedMaterial.subsequence(Helpers.toInt((BigInteger)Constants_Compile.__default.ECDH__COMMITMENT__KEY__INDEX()), Helpers.toInt((BigInteger)Constants_Compile.__default.ECDH__WRAPPED__KEY__MATERIAL__INDEX()));
        DafnySequence _1158_wrappedKey = _1149_wrappedMaterial.subsequence(Helpers.toInt((BigInteger)Constants_Compile.__default.ECDH__WRAPPED__KEY__MATERIAL__INDEX()), Helpers.toInt((BigInteger)Constants_Compile.__default.ECDH__WRAPPED__KEY__MATERIAL__INDEX().add(_1152_KeyLength)));
        DafnySequence _1159_authTag = _1149_wrappedMaterial.drop(Constants_Compile.__default.ECDH__WRAPPED__KEY__MATERIAL__INDEX().add(_1152_KeyLength));
        Result<DafnySequence<? extends Byte>, Object> _1161_valueOrError2 = Result.Default(ValidUTF8Bytes.defaultValue());
        _1161_valueOrError2 = UTF8.__default.Encode(__default.CurveSpecTypeToString(this.curveSpec())).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), __default::E);
        if (_1161_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1161_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnySequence<? extends Byte> _1160_curveSpecUtf8 = _1161_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _1163_valueOrError3 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _1163_valueOrError3 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(input.dtor_encryptionContext());
        if (_1163_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1163_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnySequence _1162_canonicalizedEC = (DafnySequence)_1163_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _1164_fixedInfo = __default.SerializeFixedInfo(Constants_Compile.__default.ECDH__KDF__UTF8(), _1160_curveSpecUtf8, this.senderPublicKey(), this.recipientPublicKey(), (DafnySequence<? extends Byte>)_1162_canonicalizedEC, this.keyringVersion());
        Result<Object, Object> _1166_valueOrError4 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out197 = __default.DeriveSharedKeyingMaterial(this.sharedSecret(), _1164_fixedInfo, (DafnySequence<? extends Byte>)_1154_kdfNonce, this.crypto());
        _1166_valueOrError4 = _out197;
        if (_1166_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1166_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnySequence _1165_derivedKeyingMaterial = (DafnySequence)_1166_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence _1167_calculatedCommitmentKey = _1165_derivedKeyingMaterial.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(32L)));
        DafnySequence _1168_sharedKeyingMaterial = _1165_derivedKeyingMaterial.drop(BigInteger.valueOf(32L));
        Outcome<Object> _1169_valueOrError5 = Outcome.Default();
        _1169_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_1167_calculatedCommitmentKey.length()), BigInteger.valueOf(_1157_commitmentKey.length())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Calculated commitment key length does NOT match expected commitment key length")));
        if (_1169_valueOrError5.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1169_valueOrError5.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        boolean _1170_check_q = _out198 = this.commitmentKeyCheck((DafnySequence<? extends Byte>)_1167_calculatedCommitmentKey, (DafnySequence<? extends Byte>)_1157_commitmentKey);
        Outcome<Object> _1171_valueOrError6 = Outcome.Default();
        _1171_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1170_check_q, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Commitment keys do not match")));
        if (_1171_valueOrError6.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1171_valueOrError6.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        Result<DafnySequence<? extends Byte>, Error> _1172_maybeUnwrappedPdk = _out199 = this.crypto().AESDecrypt(AESDecryptInput.create(Constants_Compile.__default.ECDH__AES__256__ENC__ALG(), (DafnySequence<? extends Byte>)_1168_sharedKeyingMaterial, (DafnySequence<? extends Byte>)_1158_wrappedKey, (DafnySequence<? extends Byte>)_1159_authTag, (DafnySequence<? extends Byte>)_1155_iv, _1164_fixedInfo));
        Result<Object, Object> _1174_valueOrError7 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _1174_valueOrError7 = _1172_maybeUnwrappedPdk.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1175_e_boxed0 -> {
            Error _1175_e = _1175_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_1175_e);
        });
        if (_1174_valueOrError7.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1174_valueOrError7.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnySequence _1173_unwrappedPdk = (DafnySequence)_1174_valueOrError7.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _1176_valueOrError8 = Outcome.Default();
        _1176_valueOrError8 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_1173_unwrappedPdk.length()), BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(input.dtor_algorithmSuite()))), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Key Length")));
        if (_1176_valueOrError8.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1176_valueOrError8.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        UnwrapOutput<EcdhUnwrapInfo> _1177_output = UnwrapOutput.create((DafnySequence<? extends Byte>)_1173_unwrappedPdk, EcdhUnwrapInfo.create());
        res = Result.create_Success(_1177_output);
        return res;
    }

    public boolean commitmentKeyCheck(DafnySequence<? extends Byte> calculatedCommitmentKey, DafnySequence<? extends Byte> serializedCommitmentKey) {
        boolean res = false;
        byte _1178_diff_q = 0;
        BigInteger _hi8 = BigInteger.valueOf(serializedCommitmentKey.length());
        BigInteger _1179_i = BigInteger.ZERO;
        while (_1179_i.compareTo(_hi8) < 0) {
            _1178_diff_q = (byte)(_1178_diff_q | (byte)((Byte)calculatedCommitmentKey.select(Helpers.toInt((BigInteger)_1179_i)) ^ (Byte)serializedCommitmentKey.select(Helpers.toInt((BigInteger)_1179_i))));
            _1179_i = _1179_i.add(BigInteger.ONE);
        }
        res = !(_1178_diff_q != 0);
        return res;
    }

    public DafnySequence<? extends Byte> senderPublicKey() {
        return this._senderPublicKey;
    }

    public DafnySequence<? extends Byte> recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public DafnySequence<? extends Byte> sharedSecret() {
        return this._sharedSecret;
    }

    public DafnySequence<? extends Byte> keyringVersion() {
        return this._keyringVersion;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public AtomicPrimitivesClient crypto() {
        return this._crypto;
    }

    public static TypeDescriptor<EcdhUnwrap> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "EcdhEdkWrapping.EcdhUnwrap";
    }
}

