/*
 * Decompiled with CFR 0.152.
 */
package RawECDHKeyring_Compile;

import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhGenerateAndWrapKeyMaterial;
import EcdhEdkWrapping_Compile.EcdhWrapInfo;
import EcdhEdkWrapping_Compile.EcdhWrapKeyMaterial;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import RawECDHKeyring_Compile.DecryptSingleEncryptedDataKey;
import RawECDHKeyring_Compile.OnDecryptEcdhDataKeyFilter;
import RawECDHKeyring_Compile.__default;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairOutput;

public class RawEcdhKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public RawEcdhStaticConfigurations _keyAgreementScheme = RawEcdhStaticConfigurations.Default();
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    public ECCPublicKey _recipientPublicKey = ECCPublicKey.Default();
    public DafnySequence<? extends Byte> _compressedRecipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public ECCPublicKey _senderPublicKey = ECCPublicKey.Default();
    public ECCPrivateKey _senderPrivateKey = ECCPrivateKey.Default();
    public DafnySequence<? extends Byte> _compressedSenderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    private static final TypeDescriptor<RawEcdhKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(RawEcdhKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out210 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out210;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out211 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out211;
    }

    public void __ctor(RawEcdhStaticConfigurations keyAgreementScheme, ECDHCurveSpec curveSpec, Option<DafnySequence<? extends Byte>> senderPrivateKey, Option<DafnySequence<? extends Byte>> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey, Option<DafnySequence<? extends Byte>> compressedSenderPublicKey, DafnySequence<? extends Byte> compressedRecipientPublicKey, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyAgreementScheme = keyAgreementScheme;
        this._curveSpec = curveSpec;
        this._cryptoPrimitives = cryptoPrimitives;
        this._recipientPublicKey = ECCPublicKey.create(recipientPublicKey);
        this._compressedRecipientPublicKey = compressedRecipientPublicKey;
        if (senderPublicKey.is_Some() && senderPrivateKey.is_Some() && compressedSenderPublicKey.is_Some()) {
            this._senderPublicKey = ECCPublicKey.create(senderPublicKey.dtor_value());
            this._senderPrivateKey = ECCPrivateKey.create(senderPrivateKey.dtor_value());
            this._compressedSenderPublicKey = compressedSenderPublicKey.dtor_value();
        } else {
            this._senderPublicKey = ECCPublicKey.create((DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
            this._senderPrivateKey = ECCPrivateKey.create((DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
            this._compressedSenderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
        }
        this._cryptoPrimitives = cryptoPrimitives;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        if (this.keyAgreementScheme().is_PublicKeyDiscovery()) {
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"PublicKeyDiscovery Key Agreement Scheme is forbidden on encrypt.")));
            return res;
        }
        ECCPrivateKey _1227_operationSenderPrivateKey = ECCPrivateKey.Default();
        ECCPublicKey _1228_operationSenderPublicKey = ECCPublicKey.Default();
        DafnySequence _1229_operationCompressedSenderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
        if (this.keyAgreementScheme().is_EphemeralPrivateKeyToStaticPublicKey()) {
            DafnySequence _1232_operationCompressedSenderPublicKey_q;
            Result<GenerateECCKeyPairOutput, Object> _1231_valueOrError0 = Result.Default(GenerateECCKeyPairOutput.Default());
            Result<GenerateECCKeyPairOutput, Error> _out212 = __default.GenerateEphemeralEccKeyPair(this.curveSpec(), this.cryptoPrimitives());
            _1231_valueOrError0 = _out212;
            if (_1231_valueOrError0.IsFailure(GenerateECCKeyPairOutput._typeDescriptor(), Error._typeDescriptor())) {
                res = _1231_valueOrError0.PropagateFailure(GenerateECCKeyPairOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            GenerateECCKeyPairOutput _1230_ephemeralKeyPair = _1231_valueOrError0.Extract(GenerateECCKeyPairOutput._typeDescriptor(), Error._typeDescriptor());
            _1227_operationSenderPrivateKey = _1230_ephemeralKeyPair.dtor_privateKey();
            _1228_operationSenderPublicKey = _1230_ephemeralKeyPair.dtor_publicKey();
            Result<Object, Object> _1233_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
            Result<DafnySequence<? extends Byte>, Error> _out213 = __default.CompressPublicKey(ECCPublicKey.create(_1228_operationSenderPublicKey.dtor_der()), this.curveSpec(), this.cryptoPrimitives());
            _1233_valueOrError1 = _out213;
            if (_1233_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
                res = _1233_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _1229_operationCompressedSenderPublicKey = _1232_operationCompressedSenderPublicKey_q = (DafnySequence)_1233_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        } else {
            _1227_operationSenderPrivateKey = this.senderPrivateKey();
            _1228_operationSenderPublicKey = this.senderPublicKey();
            _1229_operationCompressedSenderPublicKey = this.compressedSenderPublicKey();
        }
        EncryptionMaterials _1234_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1235_suite = input.dtor_materials().dtor_algorithmSuite();
        Result<Object, Object> _1237_valueOrError2 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out214 = __default.LocalDeriveSharedSecret(_1227_operationSenderPrivateKey, this.recipientPublicKey(), this.curveSpec(), this.cryptoPrimitives());
        _1237_valueOrError2 = _out214;
        if (_1237_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1237_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _1236_sharedSecret = (DafnySequence)_1237_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _1239_valueOrError3 = Result.Default(ValidUTF8Bytes.defaultValue());
        _1239_valueOrError3 = UTF8.__default.Encode(__default.CurveSpecTypeToString(this.curveSpec())).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::E);
        if (_1239_valueOrError3.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            res = _1239_valueOrError3.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _1238_curveSpecUtf8 = _1239_valueOrError3.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Result<Object, Object> _1241_valueOrError4 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _1241_valueOrError4 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(input.dtor_materials().dtor_encryptionContext());
        if (_1241_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _1241_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _1240_canonicalizedEC = (DafnySequence)_1241_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Byte> _1242_fixedInfo = EcdhEdkWrapping_Compile.__default.SerializeFixedInfo(Constants_Compile.__default.ECDH__KDF__UTF8(), _1238_curveSpecUtf8, (DafnySequence<? extends Byte>)_1229_operationCompressedSenderPublicKey, this.compressedRecipientPublicKey(), (DafnySequence<? extends Byte>)_1240_canonicalizedEC, __default.RAW__ECDH__KEYRING__VERSION());
        EcdhGenerateAndWrapKeyMaterial _nw46 = new EcdhGenerateAndWrapKeyMaterial();
        _nw46.__ctor((DafnySequence<? extends Byte>)_1236_sharedSecret, _1242_fixedInfo, this.cryptoPrimitives());
        EcdhGenerateAndWrapKeyMaterial _1243_ecdhGenerateAndWrap = _nw46;
        EcdhWrapKeyMaterial _nw47 = new EcdhWrapKeyMaterial();
        _nw47.__ctor((DafnySequence<? extends Byte>)_1236_sharedSecret, _1242_fixedInfo, this.cryptoPrimitives());
        EcdhWrapKeyMaterial _1244_ecdhWrap = _nw47;
        Result<WrapEdkMaterialOutput<EcdhWrapInfo>, Object> _1246_valueOrError5 = Result.Default(WrapEdkMaterialOutput.Default(EcdhWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<EcdhWrapInfo>, Error> _out215 = EdkWrapping_Compile.__default.WrapEdkMaterial(EcdhWrapInfo._typeDescriptor(), _1234_materials, _1244_ecdhWrap, _1243_ecdhGenerateAndWrap);
        _1246_valueOrError5 = _out215;
        if (_1246_valueOrError5.IsFailure(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _1246_valueOrError5.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<EcdhWrapInfo> _1245_wrapOutput = _1246_valueOrError5.Extract(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _1247_symmetricSigningKeyList = _1245_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_1245_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        Outcome<Object> _1248_valueOrError6 = Outcome.Default();
        _1248_valueOrError6 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidCompressedPublicKeyLength((DafnySequence<? extends Byte>)_1229_operationCompressedSenderPublicKey) && __default.ValidCompressedPublicKeyLength(this.compressedRecipientPublicKey()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid compressed public key length.")));
        if (_1248_valueOrError6.IsFailure(Error._typeDescriptor())) {
            res = _1248_valueOrError6.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        EncryptedDataKey _1249_edk = EncryptedDataKey.create(Constants_Compile.__default.RAW__ECDH__PROVIDER__ID(), __default.SerializeProviderInfo((DafnySequence<? extends Byte>)_1229_operationCompressedSenderPublicKey, this.compressedRecipientPublicKey()), _1245_wrapOutput.dtor_wrappedMaterial());
        if (_1245_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1251_valueOrError7 = null;
            _1251_valueOrError7 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_1234_materials, _1245_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1249_edk}), _1247_symmetricSigningKeyList);
            if (_1251_valueOrError7.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _1251_valueOrError7.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _1250_result = _1251_valueOrError7.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_1250_result));
            return res;
        }
        if (_1245_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1253_valueOrError8 = null;
            _1253_valueOrError8 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_1234_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1249_edk}), _1247_symmetricSigningKeyList);
            if (_1253_valueOrError8.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _1253_valueOrError8.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _1252_result = _1253_valueOrError8.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_1252_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out217;
        Result<OnDecryptOutput, Error> res = null;
        if (this.keyAgreementScheme().is_EphemeralPrivateKeyToStaticPublicKey()) {
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"EphemeralPrivateKeyToStaticPublicKey Key Agreement Scheme is forbidden on decrypt.")));
            return res;
        }
        DecryptionMaterials _1254_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1255_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _1256_valueOrError0 = Outcome.Default();
        _1256_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1254_materials), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_1256_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1256_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Option<DafnySequence<? extends Byte>> _1257_operationCompressedSenderPublicKey = this.compressedSenderPublicKey().equals((Object)DafnySequence.empty(uint8._typeDescriptor())) ? Option.create_None() : Option.create_Some(this.compressedSenderPublicKey());
        OnDecryptEcdhDataKeyFilter _nw48 = new OnDecryptEcdhDataKeyFilter();
        _nw48.__ctor(this.keyAgreementScheme(), this.compressedRecipientPublicKey(), _1257_operationCompressedSenderPublicKey);
        OnDecryptEcdhDataKeyFilter _1258_filter = _nw48;
        Result<Object, Object> _1260_valueOrError1 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out216 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _1258_filter, input.dtor_encryptedDataKeys());
        _1260_valueOrError1 = _out216;
        if (_1260_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _1260_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _1259_edksToAttempt = (DafnySequence)_1260_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_1259_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _1262_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _1262_valueOrError2 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_1262_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _1262_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _1261_errorMessage = (DafnySequence)_1262_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(__default.E((DafnySequence<? extends Character>)_1261_errorMessage));
            return res;
        }
        DecryptSingleEncryptedDataKey _nw49 = new DecryptSingleEncryptedDataKey();
        _nw49.__ctor(_1254_materials, this.cryptoPrimitives(), this.compressedSenderPublicKey(), this.compressedRecipientPublicKey(), this.keyAgreementScheme(), this.curveSpec());
        DecryptSingleEncryptedDataKey _1263_decryptClosure = _nw49;
        Result<DecryptionMaterials, DafnySequence<Error>> _1264_outcome = _out217 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _1263_decryptClosure, _1259_edksToAttempt);
        Result<DecryptionMaterials, Error> _1266_valueOrError3 = null;
        _1266_valueOrError3 = _1264_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _1267_errors_boxed0 -> {
            DafnySequence _1267_errors = _1267_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_1267_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_1266_valueOrError3.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _1266_valueOrError3.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _1265_SealedDecryptionMaterials = _1266_valueOrError3.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_1265_SealedDecryptionMaterials));
        return res;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public RawEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public ECCPublicKey recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public DafnySequence<? extends Byte> compressedRecipientPublicKey() {
        return this._compressedRecipientPublicKey;
    }

    public ECCPublicKey senderPublicKey() {
        return this._senderPublicKey;
    }

    public ECCPrivateKey senderPrivateKey() {
        return this._senderPrivateKey;
    }

    public DafnySequence<? extends Byte> compressedSenderPublicKey() {
        return this._compressedSenderPublicKey;
    }

    public static TypeDescriptor<RawEcdhKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawECDHKeyring.RawEcdhKeyring";
    }
}

