/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class StaticDiscoveryRecipientInput {
    private final ByteBuffer senderStaticPrivateKey;

    protected StaticDiscoveryRecipientInput(BuilderImpl builder) {
        this.senderStaticPrivateKey = builder.senderStaticPrivateKey();
    }

    public ByteBuffer senderStaticPrivateKey() {
        return this.senderStaticPrivateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer senderStaticPrivateKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(StaticDiscoveryRecipientInput model) {
            this.senderStaticPrivateKey = model.senderStaticPrivateKey();
        }

        @Override
        public Builder senderStaticPrivateKey(ByteBuffer senderStaticPrivateKey) {
            this.senderStaticPrivateKey = senderStaticPrivateKey;
            return this;
        }

        @Override
        public ByteBuffer senderStaticPrivateKey() {
            return this.senderStaticPrivateKey;
        }

        @Override
        public StaticDiscoveryRecipientInput build() {
            if (Objects.isNull(this.senderStaticPrivateKey())) {
                throw new IllegalArgumentException("Missing value for required field `senderStaticPrivateKey`");
            }
            return new StaticDiscoveryRecipientInput(this);
        }
    }

    public static interface Builder {
        public Builder senderStaticPrivateKey(ByteBuffer var1);

        public ByteBuffer senderStaticPrivateKey();

        public StaticDiscoveryRecipientInput build();
    }
}

