/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsDiscoveryKeyring_Compile;

import Actions_Compile.__default;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyDecryptor;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyFilter;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyTransformer;
import Constants_Compile.AwsKmsEdkHelper;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.Result_Failure;
import Wrappers_Compile.Result_Success;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsDiscoveryKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public Option<DiscoveryFilter> _discoveryFilter = Option.Default(DiscoveryFilter._typeDescriptor());
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsDiscoveryKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsDiscoveryKeyring.class, () -> null);

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out3 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out3;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out3 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out3;
    }

    public void __ctor(IKMSClient client, Option<DiscoveryFilter> discoveryFilter, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._discoveryFilter = discoveryFilter;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        output = Result.create_Failure(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption is not supported with a Discovery Keyring.")));
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out2;
        Result<DecryptionMaterials, DafnySequence<Error>> _13_outcome;
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _0_materials = input.dtor_materials();
        DafnySequence<? extends EncryptedDataKey> _1_encryptedDataKeys = input.dtor_encryptedDataKeys();
        AlgorithmSuiteInfo _2_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Error> _3_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _3_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_0_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_3_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _3_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        AwsKmsEncryptedDataKeyFilter _nw0 = new AwsKmsEncryptedDataKeyFilter();
        _nw0.__ctor(this.discoveryFilter());
        AwsKmsEncryptedDataKeyFilter _4_edkFilter = _nw0;
        Result<DafnySequence, Error> _5_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out0 = __default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _4_edkFilter, _1_encryptedDataKeys);
        _5_valueOrError1 = _out0;
        if (_5_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _5_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _6_matchingEdks = _5_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        AwsKmsEncryptedDataKeyTransformer _nw1 = new AwsKmsEncryptedDataKeyTransformer();
        _nw1.__ctor();
        AwsKmsEncryptedDataKeyTransformer _7_edkTransform = _nw1;
        Result<DafnySequence, Error> _8_valueOrError2 = Result.Default(DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(AwsKmsEdkHelper._typeDescriptor()));
        Result<DafnySequence<? extends AwsKmsEdkHelper>, Error> _out1 = __default.DeterministicFlatMapWithResult(EncryptedDataKey._typeDescriptor(), AwsKmsEdkHelper._typeDescriptor(), Error._typeDescriptor(), _7_edkTransform, _6_matchingEdks);
        _8_valueOrError2 = _out1;
        if (_8_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor())) {
            res = _8_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _9_edksToAttempt = _8_valueOrError2.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_9_edksToAttempt.length()).signum() == 0) {
            Result<DafnySequence, Error> _10_valueOrError3 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _10_valueOrError3 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_10_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _10_valueOrError3.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _11_errorMessage = _10_valueOrError3.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_11_errorMessage));
            return res;
        }
        AwsKmsEncryptedDataKeyDecryptor _nw2 = new AwsKmsEncryptedDataKeyDecryptor();
        _nw2.__ctor(_0_materials, this.client(), this.grantTokens());
        AwsKmsEncryptedDataKeyDecryptor _12_decryptAction = _nw2;
        Result<DecryptionMaterials, DafnySequence<Error>> _source0 = _13_outcome = (_out2 = __default.ReduceToSuccess(AwsKmsEdkHelper._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _12_decryptAction, _9_edksToAttempt));
        if (_source0.is_Success()) {
            DecryptionMaterials _14___mcc_h0;
            DecryptionMaterials _15_mat = _14___mcc_h0 = (DecryptionMaterials)((Result_Success)_source0)._value;
            res = Result.create_Success(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput.create(_15_mat));
        } else {
            DafnySequence _16___mcc_h1;
            DafnySequence _17_errors = _16___mcc_h1 = (DafnySequence)((Result_Failure)_source0)._error;
            res = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_17_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`.")));
        }
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public Option<DiscoveryFilter> discoveryFilter() {
        return this._discoveryFilter;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsDiscoveryKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsDiscoveryKeyring.AwsKmsDiscoveryKeyring";
    }
}

