/*
 * Decompiled with CFR 0.152.
 */
package CompoundBeacon_Compile;

import BaseBeacon_Compile.BeaconBase;
import BaseBeacon_Compile.StandardBeacon;
import CompoundBeacon_Compile.BeaconPart;
import CompoundBeacon_Compile.BeaconPart_Encrypted;
import CompoundBeacon_Compile.BeaconPart_Signed;
import CompoundBeacon_Compile.Constructor;
import CompoundBeacon_Compile.ConstructorPart;
import DdbVirtualFields_Compile.VirtField;
import DynamoDbEncryptionUtil_Compile.MaybeKeyMap;
import TermLoc_Compile.Selector;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import _System.nat;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue;

public class CompoundBeacon {
    public BeaconBase _base;
    public char _split;
    public DafnySequence<? extends BeaconPart> _parts;
    public BigInteger _numSigned;
    public DafnySequence<? extends Constructor> _construct;
    private static final TypeDescriptor<CompoundBeacon> _TYPE = TypeDescriptor.referenceWithInitializer(CompoundBeacon.class, () -> CompoundBeacon.Default());
    private static final CompoundBeacon theDefault = CompoundBeacon.create(BeaconBase.Default(), 'D', (DafnySequence<? extends BeaconPart>)DafnySequence.empty(BeaconPart._typeDescriptor()), BigInteger.ZERO, (DafnySequence<? extends Constructor>)DafnySequence.empty(Constructor._typeDescriptor()));

    public CompoundBeacon(BeaconBase base, char split, DafnySequence<? extends BeaconPart> parts, BigInteger numSigned, DafnySequence<? extends Constructor> construct) {
        this._base = base;
        this._split = split;
        this._parts = parts;
        this._numSigned = numSigned;
        this._construct = construct;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CompoundBeacon o = (CompoundBeacon)other;
        return Objects.equals(this._base, o._base) && this._split == o._split && Objects.equals(this._parts, o._parts) && Objects.equals(this._numSigned, o._numSigned) && Objects.equals(this._construct, o._construct);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._base);
        hash = (hash << 5) + hash + (long)Character.hashCode(this._split);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._parts);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._numSigned);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._construct);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("CompoundBeacon.CompoundBeacon.CompoundBeacon");
        s.append("(");
        s.append(Helpers.toString((Object)this._base));
        s.append(", ");
        s.append(this._split);
        s.append(", ");
        s.append(Helpers.toString(this._parts));
        s.append(", ");
        s.append(Helpers.toString((Object)this._numSigned));
        s.append(", ");
        s.append(Helpers.toString(this._construct));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<CompoundBeacon> _typeDescriptor() {
        return _TYPE;
    }

    public static CompoundBeacon Default() {
        return theDefault;
    }

    public static CompoundBeacon create(BeaconBase base, char split, DafnySequence<? extends BeaconPart> parts, BigInteger numSigned, DafnySequence<? extends Constructor> construct) {
        return new CompoundBeacon(base, split, parts, numSigned, construct);
    }

    public static CompoundBeacon create_CompoundBeacon(BeaconBase base, char split, DafnySequence<? extends BeaconPart> parts, BigInteger numSigned, DafnySequence<? extends Constructor> construct) {
        return CompoundBeacon.create(base, split, parts, numSigned, construct);
    }

    public boolean is_CompoundBeacon() {
        return true;
    }

    public BeaconBase dtor_base() {
        return this._base;
    }

    public char dtor_split() {
        return this._split;
    }

    public DafnySequence<? extends BeaconPart> dtor_parts() {
        return this._parts;
    }

    public BigInteger dtor_numSigned() {
        return this._numSigned;
    }

    public DafnySequence<? extends Constructor> dtor_construct() {
        return this._construct;
    }

    public boolean HasBeacon2(DafnySequence<? extends BeaconPart> parts, DafnySequence<? extends Character> name) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(parts.length()).signum() != 0) {
            if (((BeaconPart)parts.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).getName().equals(name)) {
                return true;
            }
            CompoundBeacon _in0 = _this;
            DafnySequence _in1 = parts.drop(BigInteger.ONE);
            DafnySequence<? extends Character> _in2 = name;
            _this = _in0;
            parts = _in1;
            name = _in2;
        }
        return false;
    }

    public boolean HasBeacon(DafnySequence<? extends Character> name) {
        return this.HasBeacon2(this.dtor_parts(), name);
    }

    public boolean isEncrypted() {
        return this.dtor_numSigned().compareTo(BigInteger.valueOf(this.dtor_parts().length())) < 0;
    }

    public Result<BeaconPart, Error> getPartFromPrefix(DafnySequence<? extends Character> value) {
        return this.partFromPrefix(this.dtor_parts(), value);
    }

    public DafnySequence<? extends Character> PartsToString(DafnySequence<? extends BeaconPart> p) {
        DafnySequence _0_beaconParts = Seq_Compile.__default.Map(BeaconPart._typeDescriptor(), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _1_s_boxed0 -> {
            BeaconPart _1_s = _1_s_boxed0;
            return _1_s.getPrefix();
        }, p);
        if (BigInteger.valueOf(_0_beaconParts.length()).signum() == 0) {
            return DafnySequence.asString((String)"");
        }
        return StandardLibrary_Compile.__default.Join((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)_0_beaconParts, (DafnySequence)DafnySequence.asString((String)""));
    }

    public DafnySequence<? extends Character> CPartToString(ConstructorPart s) {
        if (s.dtor_required()) {
            return s.dtor_part().getPrefix();
        }
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"["), s.dtor_part().getPrefix()), (DafnySequence)DafnySequence.asString((String)"]"));
    }

    public DafnySequence<? extends Character> CPartsToString(DafnySequence<? extends ConstructorPart> p) {
        DafnySequence _0_beaconParts = Seq_Compile.__default.Map(ConstructorPart._typeDescriptor(), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _1_s_boxed0 -> {
            ConstructorPart _1_s = _1_s_boxed0;
            return this.CPartToString(_1_s);
        }, p);
        if (BigInteger.valueOf(_0_beaconParts.length()).signum() == 0) {
            return DafnySequence.asString((String)"");
        }
        return StandardLibrary_Compile.__default.Join((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)_0_beaconParts, (DafnySequence)DafnySequence.asString((String)""));
    }

    public DafnySequence<? extends Character> CListToString(DafnySequence<? extends Constructor> p) {
        DafnySequence _0_beaconParts = Seq_Compile.__default.Map(Constructor._typeDescriptor(), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), _1_s_boxed0 -> {
            Constructor _1_s = _1_s_boxed0;
            return this.CPartsToString(_1_s.dtor_parts());
        }, p);
        return StandardLibrary_Compile.__default.Join((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)_0_beaconParts, (DafnySequence)DafnySequence.asString((String)", "));
    }

    public boolean CanConstruct(DafnySequence<? extends ConstructorPart> con, DafnySequence<? extends BeaconPart> inParts, boolean matched) {
        CompoundBeacon _this = this;
        while (true) {
            if (BigInteger.valueOf(inParts.length()).signum() == 0) {
                return true;
            }
            if (BigInteger.valueOf(con.length()).signum() == 0) {
                return false;
            }
            if (Objects.equals(((ConstructorPart)con.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_part(), (BeaconPart)inParts.select(Helpers.toInt((BigInteger)BigInteger.ZERO)))) {
                CompoundBeacon _in0 = _this;
                DafnySequence _in1 = con.drop(BigInteger.ONE);
                DafnySequence _in2 = inParts.drop(BigInteger.ONE);
                boolean _in3 = true;
                _this = _in0;
                con = _in1;
                inParts = _in2;
                matched = _in3;
                continue;
            }
            if (((ConstructorPart)con.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_required() && matched) break;
            CompoundBeacon _in4 = _this;
            DafnySequence _in5 = con.drop(BigInteger.ONE);
            DafnySequence _in6 = inParts;
            boolean _in7 = matched;
            _this = _in4;
            con = _in5;
            inParts = _in6;
            matched = _in7;
        }
        return false;
    }

    public boolean IsValidPartOrder(DafnySequence<? extends Constructor> candidates, DafnySequence<? extends BeaconPart> inParts) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(candidates.length()).signum() != 0) {
            if (_this.CanConstruct(((Constructor)candidates.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_parts(), inParts, false)) {
                return true;
            }
            CompoundBeacon _in0 = _this;
            DafnySequence _in1 = candidates.drop(BigInteger.ONE);
            DafnySequence<? extends BeaconPart> _in2 = inParts;
            _this = _in0;
            candidates = _in1;
            inParts = _in2;
        }
        return false;
    }

    public Result<Boolean, Error> ValidatePartOrder(DafnySequence<? extends BeaconPart> inParts, DafnySequence<? extends Character> orig) {
        if (this.IsValidPartOrder(this.dtor_construct(), inParts)) {
            return Result.create_Success((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)true);
        }
        DafnySequence _0_msg = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Compound Beacon value '"), orig), (DafnySequence)DafnySequence.asString((String)"' cannot be constructed from any available constructor for ")), this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" value parsed as ")), this.PartsToString(inParts)), (DafnySequence)DafnySequence.asString((String)" available constructors are ")), this.CListToString(this.dtor_construct())), (DafnySequence)DafnySequence.asString((String)"."));
        return Result.create_Failure((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)_0_msg));
    }

    public Result<BeaconPart, Error> partFromPrefix(DafnySequence<? extends BeaconPart> p, DafnySequence<? extends Character> value) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(p.length()).signum() != 0) {
            if (((BeaconPart)p.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_prefix().isPrefixOf(value)) {
                return Result.create_Success(BeaconPart._typeDescriptor(), Error._typeDescriptor(), (Object)((BeaconPart)p.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
            }
            CompoundBeacon _in0 = _this;
            DafnySequence _in1 = p.drop(BigInteger.ONE);
            DafnySequence<? extends Character> _in2 = value;
            _this = _in0;
            p = _in1;
            value = _in2;
        }
        return Result.create_Failure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Value "), value), (DafnySequence)DafnySequence.asString((String)" for beacon ")), _this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" does not match the prefix of any configured part."))));
    }

    public Result<DafnySequence<? extends DafnySequence<? extends Character>>, Error> SkipSignedPieces(DafnySequence<? extends DafnySequence<? extends Character>> pieces) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(pieces.length()).signum() != 0) {
            Result<BeaconPart, Error> _0_valueOrError0 = _this.partFromPrefix(_this.dtor_parts(), (DafnySequence<? extends Character>)((DafnySequence)pieces.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
            if (_0_valueOrError0.IsFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor())) {
                return _0_valueOrError0.PropagateFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
            }
            BeaconPart _1_p = (BeaconPart)_0_valueOrError0.Extract(BeaconPart._typeDescriptor(), Error._typeDescriptor());
            if (_1_p.is_Encrypted()) {
                return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), pieces);
            }
            CompoundBeacon _in0 = _this;
            DafnySequence _in1 = pieces.drop(BigInteger.ONE);
            _this = _in0;
            pieces = _in1;
        }
        return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), pieces);
    }

    public Result<Boolean, Error> IsLessThanComparable(DafnySequence<? extends DafnySequence<? extends Character>> pieces) {
        Result<DafnySequence<? extends DafnySequence<? extends Character>>, Error> _0_valueOrError0 = this.SkipSignedPieces(pieces);
        if (_0_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        DafnySequence _1_rest = (DafnySequence)_0_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        if (BigInteger.valueOf(_1_rest.length()).signum() == 0) {
            return Result.create_Success((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)true);
        }
        if (!Objects.equals(BigInteger.valueOf(_1_rest.length()), BigInteger.ONE)) {
            return Result.create_Success((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)false);
        }
        Result<BeaconPart, Error> _2_valueOrError1 = this.partFromPrefix(this.dtor_parts(), (DafnySequence<? extends Character>)((DafnySequence)_1_rest.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
        if (_2_valueOrError1.IsFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        BeaconPart _3_p = (BeaconPart)_2_valueOrError1.Extract(BeaconPart._typeDescriptor(), Error._typeDescriptor());
        return Result.create_Success((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)_3_p.dtor_prefix().equals((Object)((DafnySequence)_1_rest.select(Helpers.toInt((BigInteger)BigInteger.ZERO)))));
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> GetFields(DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> virtualFields) {
        return Seq_Compile.__default.Flatten((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (DafnySequence)Seq_Compile.__default.Map(BeaconPart._typeDescriptor(), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), (Function)((Function<DafnyMap, Function>)_0_virtualFields -> _1_p_boxed0 -> {
            BeaconPart _1_p = _1_p_boxed0;
            return _1_p.GetFields((DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField>)_0_virtualFields);
        }).apply(virtualFields), this.dtor_parts()));
    }

    public Result<DafnySequence<? extends Character>, Error> FindAndCalcPart(DafnySequence<? extends Character> value, MaybeKeyMap keys) {
        Result<BeaconPart, Error> _0_valueOrError0 = this.partFromPrefix(this.dtor_parts(), value);
        if (_0_valueOrError0.IsFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        BeaconPart _1_part = (BeaconPart)_0_valueOrError0.Extract(BeaconPart._typeDescriptor(), Error._typeDescriptor());
        return this.PartValueCalc((DafnySequence<? extends Character>)value.drop(BigInteger.valueOf(_1_part.dtor_prefix().length())), keys, _1_part);
    }

    public Result<Boolean, Error> justPrefix(DafnySequence<? extends Character> value) {
        Result<BeaconPart, Error> _0_valueOrError0 = this.partFromPrefix(this.dtor_parts(), value);
        if (_0_valueOrError0.IsFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        BeaconPart _1_part = (BeaconPart)_0_valueOrError0.Extract(BeaconPart._typeDescriptor(), Error._typeDescriptor());
        return Result.create_Success((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)value.equals(_1_part.dtor_prefix()));
    }

    public Result<AttributeValue, Error> GetBeaconValue(AttributeValue value, MaybeKeyMap keys, boolean forEquality) {
        if (!value.is_S()) {
            return Result.create_Failure((TypeDescriptor)AttributeValue._typeDescriptor(), Error._typeDescriptor(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"CompoundBeacon "), this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" can only be queried as a string, not as ")), DynamoDbEncryptionUtil_Compile.__default.AttrTypeToStr(value))));
        }
        DafnySequence _0_parts = StandardLibrary_Compile.__default.Split((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)value.dtor_S(), (Object)Character.valueOf(this.dtor_split()));
        Result _1_valueOrError0 = Seq_Compile.__default.MapWithResult((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), BeaconPart._typeDescriptor(), Error._typeDescriptor(), _2_s_boxed0 -> {
            DafnySequence _2_s = _2_s_boxed0;
            return this.getPartFromPrefix((DafnySequence<? extends Character>)_2_s);
        }, (DafnySequence)_0_parts);
        if (_1_valueOrError0.IsFailure(DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()), Error._typeDescriptor())) {
            return _1_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()), Error._typeDescriptor(), AttributeValue._typeDescriptor());
        }
        DafnySequence _3_partsUsed = (DafnySequence)_1_valueOrError0.Extract(DafnySequence._typeDescriptor(BeaconPart._typeDescriptor()), Error._typeDescriptor());
        Result<Boolean, Error> _4_valueOrError1 = this.ValidatePartOrder((DafnySequence<? extends BeaconPart>)_3_partsUsed, (DafnySequence<? extends Character>)value.dtor_S());
        if (_4_valueOrError1.IsFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            return _4_valueOrError1.PropagateFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), AttributeValue._typeDescriptor());
        }
        boolean _5___v1 = (Boolean)_4_valueOrError1.Extract(TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Result _6_valueOrError2 = Seq_Compile.__default.MapWithResult((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), (Function)((Function<MaybeKeyMap, Function>)_7_keys -> _8_s_boxed0 -> {
            DafnySequence _8_s = _8_s_boxed0;
            return this.FindAndCalcPart((DafnySequence<? extends Character>)_8_s, (MaybeKeyMap)_7_keys);
        }).apply(keys), (DafnySequence)_0_parts);
        if (_6_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            return _6_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), AttributeValue._typeDescriptor());
        }
        DafnySequence _9_beaconParts = (DafnySequence)_6_valueOrError2.Extract(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        Result<Boolean, Error> _10_valueOrError3 = this.justPrefix((DafnySequence<? extends Character>)((DafnySequence)Seq_Compile.__default.Last((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (DafnySequence)_0_parts)));
        if (_10_valueOrError3.IsFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            return _10_valueOrError3.PropagateFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), AttributeValue._typeDescriptor());
        }
        boolean _11_lastIsPrefix = (Boolean)_10_valueOrError3.Extract(TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        if (!forEquality && _11_lastIsPrefix) {
            DafnySequence _12_result = StandardLibrary_Compile.__default.Join((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)DafnySequence.concatenate((DafnySequence)_9_beaconParts.take(BigInteger.valueOf(_0_parts.length()).subtract(BigInteger.ONE)), (DafnySequence)DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object[])new DafnySequence[]{(DafnySequence)Seq_Compile.__default.Last((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (DafnySequence)_0_parts)})), (DafnySequence)DafnySequence.of((char[])new char[]{this.dtor_split()}));
            return Result.create_Success((TypeDescriptor)AttributeValue._typeDescriptor(), Error._typeDescriptor(), (Object)AttributeValue.create_S((DafnySequence)_12_result));
        }
        DafnySequence _13_result = StandardLibrary_Compile.__default.Join((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)_9_beaconParts, (DafnySequence)DafnySequence.of((char[])new char[]{this.dtor_split()}));
        return Result.create_Success((TypeDescriptor)AttributeValue._typeDescriptor(), Error._typeDescriptor(), (Object)AttributeValue.create_S((DafnySequence)_13_result));
    }

    public Result<Option<DafnySequence<? extends Character>>, Error> TryConstructor(DafnySequence<? extends ConstructorPart> consFields, DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf, MaybeKeyMap keys, DafnySequence<? extends Character> acc) {
        CompoundBeacon _this = this;
        while (true) {
            if (BigInteger.valueOf(consFields.length()).signum() == 0) {
                if (BigInteger.valueOf(acc.length()).signum() == 0) {
                    return Result.create_Failure((TypeDescriptor)Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Internal Error : Empty beacon created.")));
                }
                return Result.create_Success((TypeDescriptor)Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), (Object)Option.create_Some((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), acc));
            }
            BeaconPart _0_part = ((ConstructorPart)consFields.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_part();
            Result<Option<DafnySequence<? extends Character>>, Error> _1_valueOrError0 = _0_part.getString(item, vf);
            if (_1_valueOrError0.IsFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
                return _1_valueOrError0.PropagateFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
            }
            Option _2_strValue = (Option)_1_valueOrError0.Extract(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
            if (_2_strValue.is_Some()) {
                Result _4_valueOrError2;
                Outcome _3_valueOrError1 = __default.Need(Error._typeDescriptor(), (!((DafnySequence)_2_strValue.dtor_value()).contains((Object)Character.valueOf(_this.dtor_split())) ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Part "), _0_part.getName()), (DafnySequence)DafnySequence.asString((String)" for beacon ")), _this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" has value '")), (DafnySequence)((DafnySequence)_2_strValue.dtor_value())), (DafnySequence)DafnySequence.asString((String)"' which contains the split character ")), (DafnySequence)DafnySequence.of((char[])new char[]{_this.dtor_split()})), (DafnySequence)DafnySequence.asString((String)"'."))));
                if (_3_valueOrError1.IsFailure(Error._typeDescriptor())) {
                    return _3_valueOrError1.PropagateFailure(Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
                }
                Result result = _4_valueOrError2 = keys.is_DontUseKeys() ? Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), (Object)DafnySequence.concatenate(_0_part.dtor_prefix(), (DafnySequence)((DafnySequence)_2_strValue.dtor_value()))) : _this.PartValueCalc((DafnySequence<? extends Character>)((DafnySequence)_2_strValue.dtor_value()), keys, _0_part);
                if (_4_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                    return _4_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
                }
                DafnySequence _5_val = (DafnySequence)_4_valueOrError2.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
                if (BigInteger.valueOf(acc.length()).signum() == 0) {
                    CompoundBeacon _in0 = _this;
                    DafnySequence _in1 = consFields.drop(BigInteger.ONE);
                    DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> _in2 = item;
                    DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> _in3 = vf;
                    MaybeKeyMap _in4 = keys;
                    DafnySequence _in5 = _5_val;
                    _this = _in0;
                    consFields = _in1;
                    item = _in2;
                    vf = _in3;
                    keys = _in4;
                    acc = _in5;
                    continue;
                }
                CompoundBeacon _in6 = _this;
                DafnySequence _in7 = consFields.drop(BigInteger.ONE);
                DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> _in8 = item;
                DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> _in9 = vf;
                MaybeKeyMap _in10 = keys;
                DafnySequence _in11 = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(acc, (DafnySequence)DafnySequence.of((char[])new char[]{_this.dtor_split()})), (DafnySequence)_5_val);
                _this = _in6;
                consFields = _in7;
                item = _in8;
                vf = _in9;
                keys = _in10;
                acc = _in11;
                continue;
            }
            if (((ConstructorPart)consFields.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_required()) {
                return Result.create_Success((TypeDescriptor)Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), (Object)Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
            }
            CompoundBeacon _in12 = _this;
            DafnySequence _in13 = consFields.drop(BigInteger.ONE);
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> _in14 = item;
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> _in15 = vf;
            MaybeKeyMap _in16 = keys;
            DafnySequence _in17 = acc;
            _this = _in12;
            consFields = _in13;
            item = _in14;
            vf = _in15;
            keys = _in16;
            acc = _in17;
        }
    }

    public Result<Option<DafnySequence<? extends Character>>, Error> TryConstructors(DafnySequence<? extends Constructor> construct, DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf, MaybeKeyMap keys) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(construct.length()).signum() != 0) {
            Result<Option<DafnySequence<? extends Character>>, Error> _0_valueOrError0 = _this.TryConstructor(((Constructor)construct.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_parts(), item, vf, keys, (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_0_valueOrError0.IsFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
                return _0_valueOrError0.PropagateFailure(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
            }
            Option _1_x = (Option)_0_valueOrError0.Extract(Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
            if (_1_x.is_Some()) {
                return Result.create_Success((TypeDescriptor)Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), (Object)_1_x);
            }
            CompoundBeacon _in0 = _this;
            DafnySequence _in1 = construct.drop(BigInteger.ONE);
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> _in2 = item;
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> _in3 = vf;
            MaybeKeyMap _in4 = keys;
            _this = _in0;
            construct = _in1;
            item = _in2;
            vf = _in3;
            keys = _in4;
        }
        return Result.create_Success((TypeDescriptor)Option._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), (Object)Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
    }

    public Result<Option<DafnySequence<? extends Character>>, Error> hash(DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf, MaybeKeyMap keys) {
        return this.TryConstructors(this.dtor_construct(), item, vf, keys);
    }

    public Result<Option<DafnySequence<? extends Character>>, Error> getNaked(DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, DafnyMap<? extends DafnySequence<? extends Character>, ? extends VirtField> vf) {
        return this.TryConstructors(this.dtor_construct(), item, vf, MaybeKeyMap.create_DontUseKeys());
    }

    public Result<BeaconPart, Error> findPart(DafnySequence<? extends Character> val) {
        DafnySequence _0_thePart = Seq_Compile.__default.Filter(BeaconPart._typeDescriptor(), (Function)((Function<DafnySequence, Function>)_1_val -> _2_x_boxed0 -> {
            BeaconPart _2_x = _2_x_boxed0;
            return _2_x.dtor_prefix().isPrefixOf(_1_val);
        }).apply(val), this.dtor_parts());
        if (BigInteger.valueOf(_0_thePart.length()).signum() == 0) {
            return Result.create_Failure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"No part found in beacon "), this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" match prefix ")), val)));
        }
        if (BigInteger.valueOf(_0_thePart.length()).compareTo(BigInteger.ONE) > 0) {
            return Result.create_Failure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Internal error. Multiple parts for beacon "), this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" matched prefix of ")), val)));
        }
        return Result.create_Success(BeaconPart._typeDescriptor(), Error._typeDescriptor(), (Object)((BeaconPart)_0_thePart.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
    }

    public Result<DafnySequence<? extends Character>, Error> getPart(DafnySequence<? extends Character> val, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> keys) {
        DafnySequence _0_pieces = StandardLibrary_Compile.__default.Split((TypeDescriptor)TypeDescriptor.CHAR, val, (Object)Character.valueOf(this.dtor_split()));
        return this.calcParts((DafnySequence<? extends DafnySequence<? extends Character>>)_0_pieces, keys, (DafnySequence<? extends Character>)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
    }

    public Result<DafnySequence<? extends Character>, Error> calcPart(DafnySequence<? extends Character> piece, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> keys) {
        Result<BeaconPart, Error> _0_valueOrError0 = this.findPart(piece);
        if (_0_valueOrError0.IsFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(BeaconPart._typeDescriptor(), Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        BeaconPart _1_thePart = (BeaconPart)_0_valueOrError0.Extract(BeaconPart._typeDescriptor(), Error._typeDescriptor());
        return this.PartValueCalc(piece, MaybeKeyMap.create_Keys(keys), _1_thePart);
    }

    public Result<DafnySequence<? extends Character>, Error> calcParts(DafnySequence<? extends DafnySequence<? extends Character>> pieces, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> keys, DafnySequence<? extends Character> acc) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(pieces.length()).signum() != 0) {
            Result<DafnySequence<? extends Character>, Error> _0_valueOrError0 = _this.calcPart((DafnySequence<? extends Character>)((DafnySequence)pieces.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), keys);
            if (_0_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                return _0_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            }
            DafnySequence _1_theBeacon = (DafnySequence)_0_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            if (BigInteger.valueOf(acc.length()).signum() == 0) {
                CompoundBeacon _in0 = _this;
                DafnySequence _in1 = pieces.drop(BigInteger.ONE);
                DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> _in2 = keys;
                DafnySequence _in3 = _1_theBeacon;
                _this = _in0;
                pieces = _in1;
                keys = _in2;
                acc = _in3;
                continue;
            }
            CompoundBeacon _in4 = _this;
            DafnySequence _in5 = pieces.drop(BigInteger.ONE);
            DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>> _in6 = keys;
            DafnySequence _in7 = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)acc, (DafnySequence)DafnySequence.of((char[])new char[]{_this.dtor_split()})), (DafnySequence)_1_theBeacon);
            _this = _in4;
            pieces = _in5;
            keys = _in6;
            acc = _in7;
        }
        return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), acc);
    }

    public static boolean OkPrefixStringPair(DafnySequence<? extends Character> x, DafnySequence<? extends Character> y) {
        return !x.isPrefixOf(y) && !y.isPrefixOf(x);
    }

    public boolean OkPrefixPair(BigInteger pos1, BigInteger pos2) {
        return Objects.equals(pos1, pos2) || CompoundBeacon.OkPrefixStringPair(((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos1))).dtor_prefix(), ((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos2))).dtor_prefix());
    }

    public Result<Boolean, Error> CheckOnePrefixPart(BigInteger pos1, BigInteger pos2) {
        if (!this.OkPrefixPair(pos1, pos2)) {
            return Result.create_Failure((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Compound beacon "), this.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" defines part ")), ((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos1))).getName()), (DafnySequence)DafnySequence.asString((String)" with prefix ")), ((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos1))).dtor_prefix()), (DafnySequence)DafnySequence.asString((String)" which is incompatible with part ")), ((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos2))).getName()), (DafnySequence)DafnySequence.asString((String)" which has a prefix of ")), ((BeaconPart)this.dtor_parts().select(Helpers.toInt((BigInteger)pos2))).dtor_prefix()), (DafnySequence)DafnySequence.asString((String)"."))));
        }
        return Result.create_Success((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)true);
    }

    public Result<Boolean, Error> CheckOnePrefix(BigInteger pos) {
        DafnySequence _0_partNumbers = DafnySequence.Create((TypeDescriptor)TypeDescriptor.BIG_INTEGER, (BigInteger)BigInteger.valueOf(this.dtor_parts().length()), _1_i_boxed0 -> {
            BigInteger _1_i = _1_i_boxed0;
            return _1_i;
        });
        Result _2_valueOrError0 = Seq_Compile.__default.MapWithResult((TypeDescriptor)TypeDescriptor.BIG_INTEGER, (TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Function)((Function<BigInteger, Function>)_3_pos -> _4_p_boxed0 -> {
            BigInteger _4_p = _4_p_boxed0;
            return this.CheckOnePrefixPart((BigInteger)_3_pos, _4_p);
        }).apply(pos), (DafnySequence)DafnySequence.Create((TypeDescriptor)TypeDescriptor.BIG_INTEGER, (BigInteger)BigInteger.valueOf(this.dtor_parts().length()), _5_i_boxed0 -> {
            BigInteger _5_i = _5_i_boxed0;
            return _5_i;
        }));
        if (_2_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BOOLEAN), Error._typeDescriptor())) {
            return _2_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BOOLEAN), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        DafnySequence _6___v2 = (DafnySequence)_2_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BOOLEAN), Error._typeDescriptor());
        return Result.create_Success((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)true);
    }

    public Result<Boolean, Error> ValidPrefixSetResultPos(BigInteger index) {
        CompoundBeacon _this = this;
        while (BigInteger.valueOf(_this.dtor_parts().length()).compareTo(index) > 0) {
            Result<Boolean, Error> _0_valueOrError0 = _this.CheckOnePrefix(index);
            if (_0_valueOrError0.IsFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
                return _0_valueOrError0.PropagateFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            }
            boolean _1___v3 = (Boolean)_0_valueOrError0.Extract(TypeDescriptor.BOOLEAN, Error._typeDescriptor());
            CompoundBeacon _in0 = _this;
            BigInteger _in1 = index.add(BigInteger.ONE);
            _this = _in0;
            index = _in1;
        }
        return Result.create_Success((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)true);
    }

    public Result<Boolean, Error> ValidPrefixSetResult() {
        Result<Boolean, Error> _0_valueOrError0 = this.ValidPrefixSetResultPos(BigInteger.ZERO);
        if (_0_valueOrError0.IsFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
        }
        boolean _1___v4 = (Boolean)_0_valueOrError0.Extract(TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        if (Helpers.Quantifier((Iterable)Helpers.IntegerRange((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.valueOf(this.dtor_parts().length())), (boolean)true, _forall_var_0_boxed0 -> {
            BigInteger _forall_var_0 = _forall_var_0_boxed0;
            BigInteger _2_x = _forall_var_0;
            if (nat._Is((BigInteger)_2_x)) {
                return Helpers.Quantifier((Iterable)Helpers.IntegerRange((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.valueOf(this.dtor_parts().length())), (boolean)true, _forall_var_1_boxed0 -> {
                    BigInteger _forall_var_1 = _forall_var_1_boxed0;
                    BigInteger _3_y = _forall_var_1;
                    if (nat._Is((BigInteger)_3_y)) {
                        return _2_x.signum() == -1 || _2_x.compareTo(BigInteger.valueOf(this.dtor_parts().length())) >= 0 || _2_x.compareTo(_3_y) >= 0 || _3_y.compareTo(BigInteger.valueOf(this.dtor_parts().length())) >= 0 || this.OkPrefixPair(_2_x, _3_y);
                    }
                    return true;
                });
            }
            return true;
        })) {
            return Result.create_Success((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)true);
        }
        return Result.create_Failure((TypeDescriptor)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Internal Error")));
    }

    public Result<DafnySequence<? extends Character>, Error> PartValueCalc(DafnySequence<? extends Character> data, MaybeKeyMap keys, BeaconPart part) {
        Outcome _0_valueOrError0 = __default.Need(Error._typeDescriptor(), (!data.contains((Object)Character.valueOf(this.dtor_split())) ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Value '"), data), (DafnySequence)DafnySequence.asString((String)"' for beacon part ")), part.getName()), (DafnySequence)DafnySequence.asString((String)" contains the split character '")), (DafnySequence)DafnySequence.of((char[])new char[]{this.dtor_split()})), (DafnySequence)DafnySequence.asString((String)"'."))));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        }
        BeaconPart _source0 = part;
        if (_source0.is_Encrypted()) {
            StandardBeacon _2___mcc_h1;
            DafnySequence<? extends Character> _1___mcc_h0 = ((BeaconPart_Encrypted)_source0)._prefix;
            StandardBeacon _3_b = _2___mcc_h1 = ((BeaconPart_Encrypted)_source0)._beacon;
            DafnySequence<? extends Character> _4_p = _1___mcc_h0;
            Outcome _5_valueOrError1 = __default.Need(Error._typeDescriptor(), (boolean)keys.is_Keys(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Need KeyId for beacon "), _3_b.dtor_base().dtor_name()), (DafnySequence)DafnySequence.asString((String)" but no KeyId found in query."))));
            if (_5_valueOrError1.IsFailure(Error._typeDescriptor())) {
                return _5_valueOrError1.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            }
            Result<DafnySequence<? extends Character>, Error> _6_valueOrError2 = _3_b.hashStr(data, keys.dtor_value());
            if (_6_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                return _6_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            }
            DafnySequence _7_hash = (DafnySequence)_6_valueOrError2.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), (Object)DafnySequence.concatenate(part.dtor_prefix(), (DafnySequence)_7_hash));
        }
        DafnySequence<? extends Character> _8___mcc_h4 = ((BeaconPart_Signed)_source0)._prefix;
        DafnySequence<? extends Character> _9___mcc_h5 = ((BeaconPart_Signed)_source0)._name;
        DafnySequence<? extends Selector> _10___mcc_h6 = ((BeaconPart_Signed)_source0)._loc;
        BeaconPart _11_Signed = part;
        return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), (Object)DafnySequence.concatenate(part.dtor_prefix(), data));
    }
}

