/*
 * Decompiled with CFR 0.152.
 */
package SearchableEncryptionInfo_Compile;

import BoundedInts_Compile.int64;
import BoundedInts_Compile.uint8;
import DynamoDbEncryptionUtil_Compile.MaybeKeyId;
import DynamoDbEncryptionUtil_Compile.MaybeKeyId_KeyId;
import DynamoDbEncryptionUtil_Compile.MaybeKeyMap;
import SearchableEncryptionInfo_Compile.KeyLocation;
import SearchableEncryptionInfo_Compile.__default;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.PositiveInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;

public class KeySource {
    public AtomicPrimitivesClient _client;
    public IKeyStoreClient _store;
    public KeyLocation _keyLoc;
    public ICryptographicMaterialsCache _cache;
    public int _cacheTTL;
    private static final TypeDescriptor<KeySource> _TYPE = TypeDescriptor.referenceWithInitializer(KeySource.class, () -> KeySource.Default());
    private static final KeySource theDefault = KeySource.create(null, null, KeyLocation.Default(), null, 0);

    public KeySource(AtomicPrimitivesClient client, IKeyStoreClient store, KeyLocation keyLoc, ICryptographicMaterialsCache cache, int cacheTTL) {
        this._client = client;
        this._store = store;
        this._keyLoc = keyLoc;
        this._cache = cache;
        this._cacheTTL = cacheTTL;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        KeySource o = (KeySource)other;
        return this._client == o._client && this._store == o._store && Objects.equals(this._keyLoc, o._keyLoc) && this._cache == o._cache && this._cacheTTL == o._cacheTTL;
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._client);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._store);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._keyLoc);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._cache);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._cacheTTL);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("SearchableEncryptionInfo.KeySource.KeySource");
        s.append("(");
        s.append(Helpers.toString((Object)this._client));
        s.append(", ");
        s.append(Helpers.toString((Object)this._store));
        s.append(", ");
        s.append(Helpers.toString((Object)this._keyLoc));
        s.append(", ");
        s.append(Helpers.toString((Object)this._cache));
        s.append(", ");
        s.append(this._cacheTTL);
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<KeySource> _typeDescriptor() {
        return _TYPE;
    }

    public static KeySource Default() {
        return theDefault;
    }

    public static KeySource create(AtomicPrimitivesClient client, IKeyStoreClient store, KeyLocation keyLoc, ICryptographicMaterialsCache cache, int cacheTTL) {
        return new KeySource(client, store, keyLoc, cache, cacheTTL);
    }

    public static KeySource create_KeySource(AtomicPrimitivesClient client, IKeyStoreClient store, KeyLocation keyLoc, ICryptographicMaterialsCache cache, int cacheTTL) {
        return KeySource.create(client, store, keyLoc, cache, cacheTTL);
    }

    public boolean is_KeySource() {
        return true;
    }

    public AtomicPrimitivesClient dtor_client() {
        return this._client;
    }

    public IKeyStoreClient dtor_store() {
        return this._store;
    }

    public KeyLocation dtor_keyLoc() {
        return this._keyLoc;
    }

    public ICryptographicMaterialsCache dtor_cache() {
        return this._cache;
    }

    public int dtor_cacheTTL() {
        return this._cacheTTL;
    }

    public Result<MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeyMap(DafnySequence<? extends DafnySequence<? extends Character>> stdNames, MaybeKeyId keyId) {
        DafnySequence<? extends Character> _6___mcc_h0;
        Result output = Result.Default(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)MaybeKeyMap.Default());
        if (this.dtor_keyLoc().is_SingleLoc()) {
            Outcome _0_valueOrError0 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)keyId.is_DontUseKeyId(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"KeyID should not be supplied with a SingleKeyStore")));
            if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _1_valueOrError1 = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out0 = this.getKeysCache(stdNames, this.dtor_keyLoc().dtor_keyId());
            _1_valueOrError1 = _out0;
            if (_1_valueOrError1.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _1_valueOrError1.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            DafnyMap _2_theMap = (DafnyMap)_1_valueOrError1.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            output = Result.create_Success(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)MaybeKeyMap.create_Keys((DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>)_2_theMap));
            return output;
        }
        if (this.dtor_keyLoc().is_LiteralLoc()) {
            Outcome _3_valueOrError2 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            _3_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)keyId.is_DontUseKeyId(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"KeyID should not be supplied with a LiteralKeyStore")));
            if (_3_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _3_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _4_valueOrError3 = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out1 = this.getKeysLiteral();
            _4_valueOrError3 = _out1;
            if (_4_valueOrError3.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _4_valueOrError3.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            DafnyMap _5_theMap = (DafnyMap)_4_valueOrError3.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            output = Result.create_Success(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)MaybeKeyMap.create_Keys((DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>)_5_theMap));
            return output;
        }
        MaybeKeyId _source0 = keyId;
        if (_source0.is_DontUseKeyId()) {
            output = Result.create_Failure(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"KeyID must not be supplied with a MultiKeyStore")));
            return output;
        }
        if (_source0.is_ShouldHaveKeyId()) {
            output = Result.create_Success(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)MaybeKeyMap.create_ShouldHaveKeys());
            return output;
        }
        DafnySequence<? extends Character> _7_id = _6___mcc_h0 = ((MaybeKeyId_KeyId)_source0)._value;
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _8_valueOrError4 = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out2 = this.getKeysCache(stdNames, _7_id);
        _8_valueOrError4 = _out2;
        if (_8_valueOrError4.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _8_valueOrError4.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
            return output;
        }
        DafnyMap _9_theMap = (DafnyMap)_8_valueOrError4.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        output = Result.create_Success(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)MaybeKeyMap.create_Keys((DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>)_9_theMap));
        return output;
    }

    public Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeysLiteral() {
        Result output = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
        output = Result.create_Success((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), this.dtor_keyLoc().dtor_keys());
        return output;
    }

    public Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeysCache(DafnySequence<? extends DafnySequence<? extends Character>> stdNames, DafnySequence<? extends Character> keyId) {
        Result output = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
        Result _0_keyIdBytesR = UTF8.__default.Encode(keyId);
        Result _1_valueOrError0 = Result.Default((TypeDescriptor)ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)ValidUTF8Bytes.defaultValue());
        _1_valueOrError0 = _0_keyIdBytesR.MapFailure(ValidUTF8Bytes._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), _2_e_boxed0 -> {
            DafnySequence _2_e = _2_e_boxed0;
            return DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)_2_e);
        });
        if (_1_valueOrError0.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _1_valueOrError0.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
            return output;
        }
        DafnySequence _3_keyIdBytes = (DafnySequence)_1_valueOrError0.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        GetCacheEntryInput _4_getCacheInput = GetCacheEntryInput.create((DafnySequence)_3_keyIdBytes, (Option)Option.create_None((TypeDescriptor)int64._typeDescriptor()));
        Result _out0 = this.dtor_cache().GetCacheEntry(_4_getCacheInput);
        Result _5_getCacheOutput = _out0;
        if (_5_getCacheOutput.is_Failure()) {
            Result _out4;
            long _out3;
            Result _out1;
            Result _6_maybeRawBeaconKeyMaterials = _out1 = this.dtor_store().GetBeaconKey(GetBeaconKeyInput.create(keyId));
            Result _7_valueOrError1 = Result.Default((TypeDescriptor)GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)GetBeaconKeyOutput.Default());
            _7_valueOrError1 = _6_maybeRawBeaconKeyMaterials.MapFailure(GetBeaconKeyOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), _8_e_boxed0 -> {
                Error _8_e = _8_e_boxed0;
                return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error.create_AwsCryptographyKeyStore(_8_e);
            });
            if (_7_valueOrError1.IsFailure(GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _7_valueOrError1.PropagateFailure(GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
                return output;
            }
            GetBeaconKeyOutput _9_rawBeaconKeyMaterials = (GetBeaconKeyOutput)_7_valueOrError1.Extract(GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            Option _10_key = _9_rawBeaconKeyMaterials.dtor_beaconKeyMaterials().dtor_beaconKey();
            Outcome _11_valueOrError2 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            _11_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)_10_key.is_Some(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"beacon key unexpectedly empty")));
            if (_11_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _11_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
                return output;
            }
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _12_valueOrError3 = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out2 = this.getAllKeys(stdNames, (DafnySequence<? extends Byte>)((DafnySequence)_10_key.dtor_value()));
            _12_valueOrError3 = _out2;
            if (_12_valueOrError3.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _12_valueOrError3.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
                return output;
            }
            DafnyMap _13_keyMap = (DafnyMap)_12_valueOrError3.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            BeaconKeyMaterials _15_dt__update__tmp_h0 = _9_rawBeaconKeyMaterials.dtor_beaconKeyMaterials();
            Option _16_dt__update_hhmacKeys_h0 = Option.create_Some((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), (Object)_13_keyMap);
            Option _17_dt__update_hbeaconKey_h0 = Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()));
            BeaconKeyMaterials _14_beaconKeyMaterials = BeaconKeyMaterials.create((DafnySequence)_15_dt__update__tmp_h0.dtor_beaconKeyIdentifier(), (DafnyMap)_15_dt__update__tmp_h0.dtor_encryptionContext(), (Option)_17_dt__update_hbeaconKey_h0, (Option)_16_dt__update_hhmacKeys_h0);
            long _18_now = _out3 = Time.__default.CurrentRelativeTime().longValue();
            PutCacheEntryInput _19_putCacheEntryInput = PutCacheEntryInput.create((DafnySequence)_3_keyIdBytes, (Materials)Materials.create_BeaconKey((BeaconKeyMaterials)_14_beaconKeyMaterials), (long)_18_now, (long)(_18_now + Integer.toUnsignedLong(this.dtor_cacheTTL())), (Option)Option.create_None((TypeDescriptor)PositiveInteger._typeDescriptor()), (Option)Option.create_None((TypeDescriptor)PositiveInteger._typeDescriptor()));
            Result _20___v0 = _out4 = this.dtor_cache().PutCacheEntry(_19_putCacheEntryInput);
            output = Result.create_Success((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)_13_keyMap);
            return output;
        }
        Outcome _21_valueOrError4 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        _21_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (((GetCacheEntryOutput)_5_getCacheOutput.dtor_value()).dtor_materials().is_BeaconKey() && ((GetCacheEntryOutput)_5_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_hmacKeys().is_Some() && ((GetCacheEntryOutput)_5_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_beaconKeyIdentifier().equals(keyId) && ((GetCacheEntryOutput)_5_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_hmacKeys().is_Some() ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_21_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _21_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
            return output;
        }
        output = Result.create_Success((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)((GetCacheEntryOutput)_5_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_hmacKeys().dtor_value());
        return output;
    }

    public Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getAllKeys(DafnySequence<? extends DafnySequence<? extends Character>> stdNames, DafnySequence<? extends Byte> key) {
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out0;
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
        output = _out0 = __default.GetAllKeys(this.dtor_client(), stdNames, key);
        return output;
    }
}

