/*
 * Decompiled with CFR 0.152.
 */
package StructuredEncryptionHeader_Compile;

import BoundedInts_Compile.uint16;
import BoundedInts_Compile.uint8;
import StructuredEncryptionHeader_Compile.CMPEncryptedDataKey;
import StructuredEncryptionHeader_Compile.CMPEncryptedDataKeyList;
import StructuredEncryptionHeader_Compile.CMPEncryptedDataKeyListEmptyOK;
import StructuredEncryptionHeader_Compile.CMPEncryptionContext;
import StructuredEncryptionHeader_Compile.CMPUtf8Bytes;
import StructuredEncryptionHeader_Compile.Legend;
import StructuredEncryptionHeader_Compile.LegendByte;
import StructuredEncryptionHeader_Compile.PartialHeader;
import StructuredEncryptionUtil_Compile.CanonCryptoItem;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import _System.nat;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Function0;
import dafny.Function2;
import dafny.Helpers;
import dafny.Tuple2;
import dafny.Tuple3;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.HMacInput;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;

public class __default {
    public static boolean ValidVersion(byte x) {
        return x == 1 || x == 2;
    }

    public static boolean IsVersion2Schema(DafnySequence<? extends CanonCryptoItem> data) {
        return ((Function<DafnySequence, Boolean>)_0_data -> Helpers.Quantifier((Iterable)_0_data.UniqueElements(), (boolean)false, _exists_var_0_boxed0 -> {
            CanonCryptoItem _exists_var_0 = _exists_var_0_boxed0;
            CanonCryptoItem _1_x = _exists_var_0;
            return _0_data.contains((Object)_1_x) && Objects.equals(_1_x.dtor_action(), CryptoAction.create_SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT());
        })).apply(data);
    }

    public static byte VersionFromSchema(DafnySequence<? extends CanonCryptoItem> data) {
        if (__default.IsVersion2Schema(data)) {
            return 2;
        }
        return 1;
    }

    public static boolean ValidFlavor(byte x) {
        return DafnySequence.of((byte[])new byte[]{0, 1}).contains((Object)x);
    }

    public static boolean ValidLegendByte(byte x) {
        return DafnySequence.of((byte[])new byte[]{__default.ENCRYPT__AND__SIGN__LEGEND(), __default.SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT__LEGEND(), __default.SIGN__ONLY__LEGEND()}).contains((Object)x);
    }

    public static boolean ValidEncryptionContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> x) {
        return BigInteger.valueOf(x.size()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 && ((Function<DafnyMap, Boolean>)_0_x -> Helpers.Quantifier((Iterable)_0_x.keySet().Elements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0 = _forall_var_0_boxed0;
            DafnySequence _1_k = _forall_var_0;
            return !_0_x.contains((Object)_1_k) || BigInteger.valueOf(_1_k.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 && BigInteger.valueOf(((DafnySequence)_0_x.get((Object)_1_k)).length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0;
        })).apply(x) != false;
    }

    public static boolean ValidEncryptedDataKey(EncryptedDataKey x) {
        return BigInteger.valueOf(x.dtor_keyProviderId().length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 && BigInteger.valueOf(x.dtor_keyProviderInfo().length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 && BigInteger.valueOf(x.dtor_ciphertext().length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0;
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> Serialize(IAwsCryptographicPrimitivesClient client, AlgorithmSuiteInfo alg, DafnySequence<? extends Byte> commitKey, PartialHeader PartialHeader2) {
        DafnySequence<? extends Byte> _0_body = PartialHeader2.serialize();
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _1_valueOrError0 = __default.CalculateHeaderCommitment(client, alg, commitKey, _0_body);
        if (_1_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _1_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()));
        }
        DafnySequence _2_commitment = (DafnySequence)_1_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)DafnySequence.concatenate(_0_body, (DafnySequence)_2_commitment));
    }

    public static Result<PartialHeader, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> Create(DafnySequence<? extends Character> tableName, DafnySequence<? extends CanonCryptoItem> schema, DafnySequence<? extends Byte> msgID, EncryptionMaterials mat) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidEncryptionContext((DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)mat.dtor_encryptionContext()), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Encryption Context")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _1_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(mat.dtor_encryptedDataKeys().length()).signum() == 1 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"There must be at least one data key")));
        if (_1_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _1_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _2_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(mat.dtor_encryptedDataKeys().length()).compareTo(__default.UINT8__LIMIT()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Too many data keys.")));
        if (_2_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _3_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)((Function<EncryptionMaterials, Boolean>)_4_mat -> Helpers.Quantifier((Iterable)_4_mat.dtor_encryptedDataKeys().UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            EncryptedDataKey _forall_var_0;
            EncryptedDataKey _5_x = _forall_var_0 = _forall_var_0_boxed0;
            return !_4_mat.dtor_encryptedDataKeys().contains((Object)_5_x) || __default.ValidEncryptedDataKey(_5_x);
        })).apply(mat), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Data Key")));
        if (_3_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _3_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _6_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)Objects.equals(BigInteger.valueOf(mat.dtor_algorithmSuite().dtor_binaryId().length()), BigInteger.valueOf(2L)), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Algorithm Suite Binary ID")));
        if (_6_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _6_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _7_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((Byte)mat.dtor_algorithmSuite().dtor_binaryId().select(Helpers.toInt((BigInteger)BigInteger.ZERO)) == StructuredEncryptionUtil_Compile.__default.DbeAlgorithmFamily() ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Algorithm Suite not suitable for structured encryption.")));
        if (_7_valueOrError5.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _7_valueOrError5.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _8_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidFlavor((Byte)mat.dtor_algorithmSuite().dtor_binaryId().select(Helpers.toInt((BigInteger)BigInteger.ONE))), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Algorithm Suite has unexpected flavor.")));
        if (_8_valueOrError6.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _8_valueOrError6.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _9_valueOrError7 = __default.MakeLegend(schema);
        if (_9_valueOrError7.IsFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _9_valueOrError7.PropagateFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        DafnySequence _10_legend = (DafnySequence)_9_valueOrError7.Extract(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnyMap _11_storedEC = ((Function<EncryptionMaterials, DafnyMap>)_12_mat -> (DafnyMap)((Function0)() -> {
            HashMap<DafnySequence, DafnySequence> _coll0 = new HashMap<DafnySequence, DafnySequence>();
            for (DafnySequence _compr_0_boxed0 : _12_mat.dtor_encryptionContext().keySet().Elements()) {
                DafnySequence _compr_0 = _compr_0_boxed0;
                DafnySequence _13_k = _compr_0;
                if (!ValidUTF8Bytes._Is((DafnySequence)_13_k) || !_12_mat.dtor_encryptionContext().contains((Object)_13_k) || _12_mat.dtor_requiredEncryptionContextKeys().contains((Object)_13_k)) continue;
                _coll0.put(_13_k, (DafnySequence)_12_mat.dtor_encryptionContext().get((Object)_13_k));
            }
            return new DafnyMap(_coll0);
        }).apply()).apply(mat);
        Outcome _14_valueOrError8 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidEncryptionContext((DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_11_storedEC), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Encryption Context")));
        if (_14_valueOrError8.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _14_valueOrError8.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        return Result.create_Success(PartialHeader._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)PartialHeader.create(__default.VersionFromSchema(schema), (Byte)mat.dtor_algorithmSuite().dtor_binaryId().select(Helpers.toInt((BigInteger)BigInteger.ONE)), msgID, (DafnySequence<? extends Byte>)_10_legend, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_11_storedEC, (DafnySequence<? extends EncryptedDataKey>)mat.dtor_encryptedDataKeys()));
    }

    public static Result<PartialHeader, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> PartialDeserialize(DafnySequence<? extends Byte> data) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (__default.PREFIX__LEN().compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Serialized PartialHeader too short.")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        byte _1_version = (Byte)data.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        Outcome _2_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidVersion(_1_version), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Version Number")));
        if (_2_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        byte _3_flavor = (Byte)data.select(Helpers.toInt((BigInteger)BigInteger.ONE));
        Outcome _4_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidFlavor(_3_flavor), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Flavor")));
        if (_4_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _4_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        DafnySequence _5_msgID = data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)__default.PREFIX__LEN()));
        DafnySequence _6_legendData = data.drop(__default.PREFIX__LEN());
        Result<Tuple2<DafnySequence<? extends Byte>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _7_valueOrError3 = __default.GetLegend((DafnySequence<? extends Byte>)_6_legendData);
        if (_7_valueOrError3.IsFailure(Tuple2._typeDescriptor(Legend._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _7_valueOrError3.PropagateFailure(Tuple2._typeDescriptor(Legend._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Tuple2 _8_legendAndLen = (Tuple2)_7_valueOrError3.Extract(Tuple2._typeDescriptor(Legend._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnySequence _9_legend = (DafnySequence)_8_legendAndLen.dtor__0();
        DafnySequence _10_contextData = _6_legendData.drop((BigInteger)_8_legendAndLen.dtor__1());
        Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _11_valueOrError4 = __default.GetContext((DafnySequence<? extends Byte>)_10_contextData);
        if (_11_valueOrError4.IsFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _11_valueOrError4.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Tuple2 _12_contextAndLen = (Tuple2)_11_valueOrError4.Extract(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnyMap _13_encContext = (DafnyMap)_12_contextAndLen.dtor__0();
        DafnySequence _14_keysData = _10_contextData.drop((BigInteger)_12_contextAndLen.dtor__1());
        Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _15_valueOrError5 = __default.GetDataKeys((DafnySequence<? extends Byte>)_14_keysData);
        if (_15_valueOrError5.IsFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _15_valueOrError5.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Tuple2 _16_keysAndLen = (Tuple2)_15_valueOrError5.Extract(Tuple2._typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnySequence _17_dataKeys = (DafnySequence)_16_keysAndLen.dtor__0();
        DafnySequence _18_trailingData = _14_keysData.drop((BigInteger)_16_keysAndLen.dtor__1());
        Outcome _19_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(_18_trailingData.length()).compareTo(__default.COMMITMENT__LEN()) >= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid header serialization: unexpected end of data.")));
        if (_19_valueOrError6.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _19_valueOrError6.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _20_valueOrError7 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(_18_trailingData.length()).compareTo(__default.COMMITMENT__LEN()) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid header serialization: unexpected bytes.")));
        if (_20_valueOrError7.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _20_valueOrError7.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        return Result.create_Success(PartialHeader._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)PartialHeader.create(_1_version, _3_flavor, (DafnySequence<? extends Byte>)_5_msgID, (DafnySequence<? extends Byte>)_9_legend, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_13_encContext, (DafnySequence<? extends EncryptedDataKey>)_17_dataKeys));
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> CalculateHeaderCommitment(IAwsCryptographicPrimitivesClient client, AlgorithmSuiteInfo alg, DafnySequence<? extends Byte> commitKey, DafnySequence<? extends Byte> data) {
        HMacInput _0_input = HMacInput.create((DigestAlgorithm)alg.dtor_commitment().dtor_HKDF().dtor_hmac(), commitKey, data);
        Result _1_outputR = client.HMac(_0_input);
        Result _2_valueOrError0 = _1_outputR.MapFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), _3_e_boxed0 -> {
            Error _3_e = _3_e_boxed0;
            return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyPrimitives(_3_e);
        });
        if (_2_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()));
        }
        DafnySequence _4_output = (DafnySequence)_2_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        if (BigInteger.valueOf(_4_output.length()).compareTo(__default.COMMITMENT__LEN()) < 0) {
            return Result.create_Failure((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"HMAC did not produce enough bits")));
        }
        return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)_4_output.take(__default.COMMITMENT__LEN()));
    }

    public static Result<Short, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> ToUInt16(BigInteger x) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (x.compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Value too big for 16 bits")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), uint16._typeDescriptor());
        }
        return Result.create_Success((TypeDescriptor)uint16._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)x.shortValue());
    }

    public static <__X, __Y, __Z> DafnyMap<? extends __Y, ? extends __Z> MyMap(TypeDescriptor<__X> _td___X, TypeDescriptor<__Y> _td___Y, TypeDescriptor<__Z> _td___Z, Function<__X, __Y> f, DafnyMap<? extends __X, ? extends __Z> m) {
        return (DafnyMap)((Function2)(_0_m, _1_f) -> (DafnyMap)((Function0)() -> {
            HashMap _coll0 = new HashMap();
            for (Object _compr_0_boxed0 : _0_m.keySet().Elements()) {
                Object _compr_0 = _compr_0_boxed0;
                Object _2_k = _compr_0;
                if (!_0_m.contains(_2_k)) continue;
                _coll0.put(_1_f.apply(_2_k), _0_m.get(_2_k));
            }
            return new DafnyMap(_coll0);
        }).apply()).apply(m, f);
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> MakeLegend(DafnySequence<? extends CanonCryptoItem> schema) {
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _0_valueOrError0 = __default.MakeLegend2(schema, __default.EmptyLegend());
        if (_0_valueOrError0.IsFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
        }
        DafnySequence _1_legend = (DafnySequence)_0_valueOrError0.Extract(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        BigInteger _2_authCount = __default.CountAuthAttrs(schema);
        Outcome _3_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)Objects.equals(_2_authCount, BigInteger.valueOf(_1_legend.length())), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Internal Error : bad legend calculation.")));
        if (_3_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _3_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
        }
        return Result.create_Success(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)_1_legend);
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> MakeLegend2(DafnySequence<? extends CanonCryptoItem> data, DafnySequence<? extends Byte> serialized) {
        while (BigInteger.valueOf(data.length()).signum() != 0) {
            if (StructuredEncryptionUtil_Compile.__default.IsAuthAttr(((CanonCryptoItem)data.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_action())) {
                Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(serialized.length()).add(BigInteger.ONE).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Legend Too Long.")));
                if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                    return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
                }
                byte _1_legendChar = __default.GetActionLegend(((CanonCryptoItem)data.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_action());
                DafnySequence _in0 = data.drop(BigInteger.ONE);
                DafnySequence _in1 = DafnySequence.concatenate(serialized, (DafnySequence)DafnySequence.of((byte[])new byte[]{_1_legendChar}));
                data = _in0;
                serialized = _in1;
                continue;
            }
            DafnySequence _in2 = data.drop(BigInteger.ONE);
            DafnySequence _in3 = serialized;
            data = _in2;
            serialized = _in3;
        }
        return Result.create_Success(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), serialized);
    }

    public static byte GetActionLegend(CryptoAction x) {
        CryptoAction _source0 = x;
        if (_source0.is_ENCRYPT__AND__SIGN()) {
            return __default.ENCRYPT__AND__SIGN__LEGEND();
        }
        if (_source0.is_SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT()) {
            return __default.SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT__LEGEND();
        }
        return __default.SIGN__ONLY__LEGEND();
    }

    public static BigInteger CountAuthAttrs(DafnySequence<? extends CanonCryptoItem> data) {
        BigInteger _0___accumulator = BigInteger.ZERO;
        while (BigInteger.valueOf(data.length()).signum() != 0) {
            DafnySequence _in1;
            if (StructuredEncryptionUtil_Compile.__default.IsAuthAttr(((CanonCryptoItem)data.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).dtor_action())) {
                DafnySequence _in0;
                _0___accumulator = _0___accumulator.add(BigInteger.ONE);
                data = _in0 = data.drop(BigInteger.ONE);
                continue;
            }
            data = _in1 = data.drop(BigInteger.ONE);
        }
        return BigInteger.ZERO.add(_0___accumulator);
    }

    public static DafnySequence<? extends Byte> SerializeLegend(DafnySequence<? extends Byte> x) {
        return DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)x.cardinalityInt())), x);
    }

    public static Result<Tuple2<DafnySequence<? extends Byte>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetLegend(DafnySequence<? extends Byte> data) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(2L).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        short _1_len = StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(2L))));
        BigInteger _2_size = Helpers.unsignedToBigInteger((short)_1_len).add(BigInteger.valueOf(2L));
        Outcome _3_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_2_size.compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_3_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _3_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        Outcome _4_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)((Boolean)((Function2)(_5_data, _6_size) -> Helpers.Quantifier((Iterable)_5_data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)_6_size)).UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            byte _forall_var_0;
            byte _7_x = _forall_var_0 = _forall_var_0_boxed0.byteValue();
            return !_5_data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)_6_size)).contains((Object)_7_x) || __default.ValidLegendByte(_7_x);
        })).apply(data, (Object)_2_size)), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid byte in stored legend")));
        if (_4_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _4_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)Tuple2.create((Object)data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)_2_size)), (Object)_2_size));
    }

    public static Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetContext(DafnySequence<? extends Byte> data) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(2L).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()));
        }
        BigInteger _1_count = Helpers.unsignedToBigInteger((short)StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))));
        Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _2_valueOrError1 = __default.GetContext2(_1_count, data, (DafnySequence<? extends Byte>)data.drop(BigInteger.valueOf(2L)), (Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger>)Tuple2.create((Object)DafnyMap.fromElements((Tuple2[])new Tuple2[0]), (Object)BigInteger.valueOf(2L)), (DafnySequence<? extends Byte>)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
        if (_2_valueOrError1.IsFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()));
        }
        Tuple2 _3_context = (Tuple2)_2_valueOrError1.Extract(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)_3_context);
    }

    public static Result<Tuple3<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetOneKVPair(DafnySequence<? extends Byte> data) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(2L).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _1_keyLen = Helpers.unsignedToBigInteger((short)StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))));
        Outcome _2_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_1_keyLen.add(BigInteger.valueOf(4L)).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_2_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        DafnySequence _3_key = data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)_1_keyLen.add(BigInteger.valueOf(2L))));
        Outcome _4_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)UTF8.__default.ValidUTF8Seq((DafnySequence)_3_key), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid UTF8 found in header.")));
        if (_4_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _4_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _5_valueLen = Helpers.unsignedToBigInteger((short)StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)_1_keyLen.add(BigInteger.valueOf(2L))), Helpers.toInt((BigInteger)_1_keyLen.add(BigInteger.valueOf(4L))))));
        BigInteger _6_kvLen = BigInteger.valueOf(2L).add(_1_keyLen).add(BigInteger.valueOf(2L)).add(_5_valueLen);
        Outcome _7_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_6_kvLen.compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_7_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _7_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        DafnySequence _8_value = data.subsequence(Helpers.toInt((BigInteger)_1_keyLen.add(BigInteger.valueOf(4L))), Helpers.toInt((BigInteger)_6_kvLen));
        Outcome _9_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)UTF8.__default.ValidUTF8Seq((DafnySequence)_8_value), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid UTF8 found in header.")));
        if (_9_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _9_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        return Result.create_Success((TypeDescriptor)Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)Tuple3.create((Object)_3_key, (Object)_8_value, (Object)_6_kvLen));
    }

    public static boolean BytesLess(DafnySequence<? extends Byte> a, DafnySequence<? extends Byte> b) {
        while (!a.equals(b)) {
            if (BigInteger.valueOf(a.length()).signum() == 0) {
                return true;
            }
            if (BigInteger.valueOf(b.length()).signum() == 0) {
                return false;
            }
            if (((Byte)a.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue() != ((Byte)b.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue()) {
                return Integer.compareUnsigned(((Byte)a.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue(), ((Byte)b.select(Helpers.toInt((BigInteger)BigInteger.ZERO))).byteValue()) < 0;
            }
            DafnySequence _in0 = a.drop(BigInteger.ONE);
            DafnySequence _in1 = b.drop(BigInteger.ONE);
            a = _in0;
            b = _in1;
        }
        return false;
    }

    public static Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetContext2(BigInteger count, DafnySequence<? extends Byte> origData, DafnySequence<? extends Byte> data, Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, BigInteger> deserialized, DafnySequence<? extends Byte> prevKey) {
        while (count.signum() != 0) {
            Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(((DafnyMap)deserialized.dtor__0()).size()).add(BigInteger.ONE).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Too much context")));
            if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()));
            }
            Result<Tuple3<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _1_valueOrError1 = __default.GetOneKVPair(data);
            if (_1_valueOrError1.IsFailure(Tuple3._typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _1_valueOrError1.PropagateFailure(Tuple3._typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()));
            }
            Tuple3 _2_kv = (Tuple3)_1_valueOrError1.Extract(Tuple3._typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            Outcome _3_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.BytesLess(prevKey, (DafnySequence<? extends Byte>)((DafnySequence)_2_kv.dtor__0())), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Context keys out of order.")));
            if (_3_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _3_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()));
            }
            BigInteger _in0 = count.subtract(BigInteger.ONE);
            DafnySequence<? extends Byte> _in1 = origData;
            DafnySequence _in2 = data.drop(BigInteger.valueOf(2L).add(BigInteger.valueOf(((DafnySequence)_2_kv.dtor__0()).length())).add(BigInteger.valueOf(2L)).add(BigInteger.valueOf(((DafnySequence)_2_kv.dtor__1()).length())));
            Tuple2 _in3 = Tuple2.create((Object)DafnyMap.update((DafnyMap)((DafnyMap)deserialized.dtor__0()), (Object)_2_kv.dtor__0(), (Object)_2_kv.dtor__1()), (Object)((BigInteger)deserialized.dtor__1()).add((BigInteger)_2_kv.dtor__2()));
            DafnySequence _in4 = (DafnySequence)_2_kv.dtor__0();
            count = _in0;
            origData = _in1;
            data = _in2;
            deserialized = _in3;
            prevKey = _in4;
        }
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), deserialized);
    }

    public static DafnySequence<? extends Byte> SerializeContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> x) {
        DafnySequence _0_keys = SortedSets.__default.SetToOrderedSequence2((TypeDescriptor)uint8._typeDescriptor(), (DafnySet)x.keySet(), StructuredEncryptionUtil_Compile.__default::ByteLess);
        return DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)x.cardinalityInt())), __default.SerializeContext2((DafnySequence<? extends DafnySequence<? extends Byte>>)_0_keys, x));
    }

    public static DafnySequence<? extends Byte> SerializeOneKVPair(DafnySequence<? extends Byte> key, DafnySequence<? extends Byte> value) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)key.cardinalityInt())), key), (DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)value.cardinalityInt()))), value);
    }

    public static DafnySequence<? extends Byte> SerializeOneDataKey(EncryptedDataKey k) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)k.dtor_keyProviderId().cardinalityInt())), (DafnySequence)k.dtor_keyProviderId()), (DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)k.dtor_keyProviderInfo().cardinalityInt()))), (DafnySequence)k.dtor_keyProviderInfo()), (DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)k.dtor_ciphertext().cardinalityInt()))), (DafnySequence)k.dtor_ciphertext());
    }

    public static Result<Tuple2<EncryptedDataKey, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetOneDataKey(DafnySequence<? extends Byte> data) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.valueOf(2L).compareTo(BigInteger.valueOf(data.length())) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _1_provIdSize = Helpers.unsignedToBigInteger((short)StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))));
        Outcome _2_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_1_provIdSize.add(BigInteger.valueOf(2L)).compareTo(BigInteger.valueOf(data.length())) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_2_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        DafnySequence _3_provId = data.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)), Helpers.toInt((BigInteger)BigInteger.valueOf(2L).add(_1_provIdSize)));
        Outcome _4_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)UTF8.__default.ValidUTF8Seq((DafnySequence)_3_provId), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid UTF8 found in header.")));
        if (_4_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _4_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _5_part1Size = BigInteger.valueOf(2L).add(_1_provIdSize);
        Outcome _6_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_5_part1Size.add(BigInteger.valueOf(2L)).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_6_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _6_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _7_provInfoSize = Helpers.unsignedToBigInteger((short)StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)_5_part1Size), Helpers.toInt((BigInteger)_5_part1Size.add(BigInteger.valueOf(2L))))));
        Outcome _8_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_5_part1Size.add(_7_provInfoSize).add(BigInteger.valueOf(2L)).compareTo(BigInteger.valueOf(data.length())) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_8_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _8_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        DafnySequence _9_provInfo = data.subsequence(Helpers.toInt((BigInteger)_5_part1Size.add(BigInteger.valueOf(2L))), Helpers.toInt((BigInteger)_5_part1Size.add(BigInteger.valueOf(2L)).add(_7_provInfoSize)));
        BigInteger _10_part2Size = _5_part1Size.add(BigInteger.valueOf(2L)).add(_7_provInfoSize);
        Outcome _11_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_10_part2Size.add(BigInteger.valueOf(2L)).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_11_valueOrError5.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _11_valueOrError5.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        BigInteger _12_cipherSize = Helpers.unsignedToBigInteger((short)StandardLibrary_mUInt_Compile.__default.SeqToUInt16((DafnySequence)data.subsequence(Helpers.toInt((BigInteger)_10_part2Size), Helpers.toInt((BigInteger)_10_part2Size.add(BigInteger.valueOf(2L))))));
        Outcome _13_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_10_part2Size.add(_12_cipherSize).add(BigInteger.valueOf(2L)).compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_13_valueOrError6.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _13_valueOrError6.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER));
        }
        DafnySequence _14_cipher = data.subsequence(Helpers.toInt((BigInteger)_10_part2Size.add(BigInteger.valueOf(2L))), Helpers.toInt((BigInteger)_10_part2Size.add(BigInteger.valueOf(2L)).add(_12_cipherSize)));
        BigInteger _15_part3Size = _10_part2Size.add(BigInteger.valueOf(2L)).add(_12_cipherSize);
        EncryptedDataKey _16_edk = EncryptedDataKey.create((DafnySequence)_3_provId, (DafnySequence)_9_provInfo, (DafnySequence)_14_cipher);
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor((TypeDescriptor)EncryptedDataKey._typeDescriptor(), (TypeDescriptor)TypeDescriptor.BIG_INTEGER), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)Tuple2.create((Object)_16_edk, (Object)_15_part3Size));
    }

    public static DafnySequence<? extends Byte> SerializeContext2(DafnySequence<? extends DafnySequence<? extends Byte>> keys, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> x) {
        DafnySequence _0___accumulator = DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor());
        while (BigInteger.valueOf(keys.length()).signum() != 0) {
            _0___accumulator = DafnySequence.concatenate((DafnySequence)_0___accumulator, __default.SerializeOneKVPair((DafnySequence<? extends Byte>)((DafnySequence)keys.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (DafnySequence<? extends Byte>)((DafnySequence)x.get((Object)((DafnySequence)keys.select(Helpers.toInt((BigInteger)BigInteger.ZERO)))))));
            DafnySequence _in0 = keys.drop(BigInteger.ONE);
            DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> _in1 = x;
            keys = _in0;
            x = _in1;
        }
        return DafnySequence.concatenate((DafnySequence)_0___accumulator, (DafnySequence)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
    }

    public static DafnySequence<? extends Byte> SerializeDataKeys(DafnySequence<? extends EncryptedDataKey> x) {
        DafnySequence<? extends Byte> _0_body = __default.SerializeDataKeys2(x);
        return DafnySequence.concatenate((DafnySequence)DafnySequence.of((byte[])new byte[]{(byte)x.cardinalityInt()}), _0_body);
    }

    public static DafnySequence<? extends Byte> SerializeDataKeys2(DafnySequence<? extends EncryptedDataKey> x) {
        DafnySequence _0___accumulator = DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor());
        while (BigInteger.valueOf(x.length()).signum() != 0) {
            DafnySequence _in0;
            _0___accumulator = DafnySequence.concatenate((DafnySequence)_0___accumulator, __default.SerializeOneDataKey((EncryptedDataKey)x.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
            x = _in0 = x.drop(BigInteger.ONE);
        }
        return DafnySequence.concatenate((DafnySequence)_0___accumulator, (DafnySequence)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
    }

    public static Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetDataKeys(DafnySequence<? extends Byte> data) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (BigInteger.ONE.compareTo(BigInteger.valueOf(data.length())) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()));
        }
        BigInteger _1_count = Helpers.unsignedToBigInteger((byte)((Byte)data.select(Helpers.toInt((BigInteger)BigInteger.ZERO))));
        Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _2_valueOrError1 = __default.GetDataKeys2(_1_count, _1_count, data, (DafnySequence<? extends Byte>)data.drop(BigInteger.ONE), (Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger>)Tuple2.create((Object)DafnySequence.empty(CMPEncryptedDataKey._typeDescriptor()), (Object)BigInteger.ONE));
        if (_2_valueOrError1.IsFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()));
        }
        Tuple2 _3_keys = (Tuple2)_2_valueOrError1.Extract(Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        if (BigInteger.valueOf(((DafnySequence)_3_keys.dtor__0()).length()).signum() == 0) {
            return Result.create_Failure((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"At least one Data Key required")));
        }
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)_3_keys);
    }

    public static Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetDataKeys2(BigInteger count, BigInteger origCount, DafnySequence<? extends Byte> origData, DafnySequence<? extends Byte> data, Tuple2<DafnySequence<? extends EncryptedDataKey>, BigInteger> deserialized) {
        while (count.signum() != 0) {
            if (BigInteger.valueOf(((DafnySequence)deserialized.dtor__0()).length()).compareTo(BigInteger.valueOf(255L)) >= 0) {
                return Result.create_Failure((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Too Many Data Keys")));
            }
            Result<Tuple2<EncryptedDataKey, BigInteger>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _0_valueOrError0 = __default.GetOneDataKey(data);
            if (_0_valueOrError0.IsFailure(Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _0_valueOrError0.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()));
            }
            Tuple2 _1_edk = (Tuple2)_0_valueOrError0.Extract(Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            BigInteger _in0 = count.subtract(BigInteger.ONE);
            BigInteger _in1 = origCount;
            DafnySequence<? extends Byte> _in2 = origData;
            DafnySequence _in3 = data.drop((BigInteger)_1_edk.dtor__1());
            Tuple2 _in4 = Tuple2.create((Object)DafnySequence.concatenate((DafnySequence)((DafnySequence)deserialized.dtor__0()), (DafnySequence)DafnySequence.of(CMPEncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{(EncryptedDataKey)_1_edk.dtor__0()})), (Object)((BigInteger)deserialized.dtor__1()).add((BigInteger)_1_edk.dtor__1()));
            count = _in0;
            origCount = _in1;
            origData = _in2;
            data = _in3;
            deserialized = _in4;
        }
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)nat._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), deserialized);
    }

    public static BigInteger VERSION__LEN() {
        return BigInteger.ONE;
    }

    public static BigInteger FLAVOR__LEN() {
        return BigInteger.ONE;
    }

    public static BigInteger PREFIX__LEN() {
        return __default.VERSION__LEN().add(__default.FLAVOR__LEN()).add(StructuredEncryptionUtil_Compile.__default.MSGID__LEN());
    }

    public static byte ENCRYPT__AND__SIGN__LEGEND() {
        return 101;
    }

    public static byte SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT__LEGEND() {
        return 99;
    }

    public static byte SIGN__ONLY__LEGEND() {
        return 115;
    }

    public static BigInteger UINT8__LIMIT() {
        return BigInteger.valueOf(256L);
    }

    public static BigInteger COMMITMENT__LEN() {
        return BigInteger.valueOf(32L);
    }

    public static DafnySequence<? extends Byte> EmptyLegend() {
        return DafnySequence.empty(LegendByte._typeDescriptor());
    }

    public String toString() {
        return "StructuredEncryptionHeader._default";
    }
}

