/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.CacheType;

public class MultiKeyStore {
    private final String keyFieldName;
    private final Integer cacheTTL;
    private final CacheType cache;

    protected MultiKeyStore(BuilderImpl builder) {
        this.keyFieldName = builder.keyFieldName();
        this.cacheTTL = builder.cacheTTL();
        this.cache = builder.cache();
    }

    public String keyFieldName() {
        return this.keyFieldName;
    }

    public Integer cacheTTL() {
        return this.cacheTTL;
    }

    public CacheType cache() {
        return this.cache;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String keyFieldName;
        protected Integer cacheTTL;
        protected CacheType cache;

        protected BuilderImpl() {
        }

        protected BuilderImpl(MultiKeyStore model) {
            this.keyFieldName = model.keyFieldName();
            this.cacheTTL = model.cacheTTL();
            this.cache = model.cache();
        }

        @Override
        public Builder keyFieldName(String keyFieldName) {
            this.keyFieldName = keyFieldName;
            return this;
        }

        @Override
        public String keyFieldName() {
            return this.keyFieldName;
        }

        @Override
        public Builder cacheTTL(Integer cacheTTL) {
            this.cacheTTL = cacheTTL;
            return this;
        }

        @Override
        public Integer cacheTTL() {
            return this.cacheTTL;
        }

        @Override
        public Builder cache(CacheType cache) {
            this.cache = cache;
            return this;
        }

        @Override
        public CacheType cache() {
            return this.cache;
        }

        @Override
        public MultiKeyStore build() {
            if (Objects.isNull(this.keyFieldName())) {
                throw new IllegalArgumentException("Missing value for required field `keyFieldName`");
            }
            if (Objects.isNull(this.cacheTTL())) {
                throw new IllegalArgumentException("Missing value for required field `cacheTTL`");
            }
            return new MultiKeyStore(this);
        }
    }

    public static interface Builder {
        public Builder keyFieldName(String var1);

        public String keyFieldName();

        public Builder cacheTTL(Integer var1);

        public Integer cacheTTL();

        public Builder cache(CacheType var1);

        public CacheType cache();

        public MultiKeyStore build();
    }
}

