/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetPrefix;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetSegment;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetSegments;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetSubstring;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.GetSuffix;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.Insert;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.Lower;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.Upper;

public class VirtualTransform {
    private final Upper upper;
    private final Lower lower;
    private final Insert insert;
    private final GetPrefix prefix;
    private final GetSuffix suffix;
    private final GetSubstring substring;
    private final GetSegment segment;
    private final GetSegments segments;

    protected VirtualTransform(BuilderImpl builder) {
        this.upper = builder.upper();
        this.lower = builder.lower();
        this.insert = builder.insert();
        this.prefix = builder.prefix();
        this.suffix = builder.suffix();
        this.substring = builder.substring();
        this.segment = builder.segment();
        this.segments = builder.segments();
    }

    public Upper upper() {
        return this.upper;
    }

    public Lower lower() {
        return this.lower;
    }

    public Insert insert() {
        return this.insert;
    }

    public GetPrefix prefix() {
        return this.prefix;
    }

    public GetSuffix suffix() {
        return this.suffix;
    }

    public GetSubstring substring() {
        return this.substring;
    }

    public GetSegment segment() {
        return this.segment;
    }

    public GetSegments segments() {
        return this.segments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected Upper upper;
        protected Lower lower;
        protected Insert insert;
        protected GetPrefix prefix;
        protected GetSuffix suffix;
        protected GetSubstring substring;
        protected GetSegment segment;
        protected GetSegments segments;

        protected BuilderImpl() {
        }

        protected BuilderImpl(VirtualTransform model) {
            this.upper = model.upper();
            this.lower = model.lower();
            this.insert = model.insert();
            this.prefix = model.prefix();
            this.suffix = model.suffix();
            this.substring = model.substring();
            this.segment = model.segment();
            this.segments = model.segments();
        }

        @Override
        public Builder upper(Upper upper) {
            this.upper = upper;
            return this;
        }

        @Override
        public Upper upper() {
            return this.upper;
        }

        @Override
        public Builder lower(Lower lower) {
            this.lower = lower;
            return this;
        }

        @Override
        public Lower lower() {
            return this.lower;
        }

        @Override
        public Builder insert(Insert insert) {
            this.insert = insert;
            return this;
        }

        @Override
        public Insert insert() {
            return this.insert;
        }

        @Override
        public Builder prefix(GetPrefix prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public GetPrefix prefix() {
            return this.prefix;
        }

        @Override
        public Builder suffix(GetSuffix suffix) {
            this.suffix = suffix;
            return this;
        }

        @Override
        public GetSuffix suffix() {
            return this.suffix;
        }

        @Override
        public Builder substring(GetSubstring substring) {
            this.substring = substring;
            return this;
        }

        @Override
        public GetSubstring substring() {
            return this.substring;
        }

        @Override
        public Builder segment(GetSegment segment) {
            this.segment = segment;
            return this;
        }

        @Override
        public GetSegment segment() {
            return this.segment;
        }

        @Override
        public Builder segments(GetSegments segments) {
            this.segments = segments;
            return this;
        }

        @Override
        public GetSegments segments() {
            return this.segments;
        }

        @Override
        public VirtualTransform build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`VirtualTransform` is a Union. A Union MUST have one and only one value set.");
            }
            return new VirtualTransform(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.upper, this.lower, this.insert, this.prefix, this.suffix, this.substring, this.segment, this.segments};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder upper(Upper var1);

        public Upper upper();

        public Builder lower(Lower var1);

        public Lower lower();

        public Builder insert(Insert var1);

        public Insert insert();

        public Builder prefix(GetPrefix var1);

        public GetPrefix prefix();

        public Builder suffix(GetSuffix var1);

        public GetSuffix suffix();

        public Builder substring(GetSubstring var1);

        public GetSubstring substring();

        public Builder segment(GetSegment var1);

        public GetSegment segment();

        public Builder segments(GetSegments var1);

        public GetSegments segments();

        public VirtualTransform build();
    }
}

