/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption;

import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.StructuredEncryption;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.AuthItem;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.AuthenticateAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoItem;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.DecryptPathStructureOutput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.DecryptStructureOutput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.EncryptPathStructureInput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error_StructuredEncryptionException;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.IStructuredEncryptionClient;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.ParsedHeader;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.PathSegment;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.ResolveAuthActionsInput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.ResolveAuthActionsOutput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CollectionOfErrors;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.DecryptPathStructureInput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.DecryptStructureInput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.EncryptPathStructureOutput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.EncryptStructureInput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.EncryptStructureOutput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.OpaqueError;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructureSegment;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredDataTerminal;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredEncryptionException;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.model.DBEAlgorithmSuiteId;
import software.amazon.smithy.dafny.conversion.ToDafny;

public class ToDafny {
    public static Error Error(RuntimeException nativeValue) {
        if (nativeValue instanceof StructuredEncryptionException) {
            return ToDafny.Error((StructuredEncryptionException)nativeValue);
        }
        if (nativeValue instanceof OpaqueError) {
            return ToDafny.Error((OpaqueError)nativeValue);
        }
        if (nativeValue instanceof CollectionOfErrors) {
            return ToDafny.Error((CollectionOfErrors)nativeValue);
        }
        return Error.create_Opaque(nativeValue);
    }

    public static Error Error(OpaqueError nativeValue) {
        return Error.create_Opaque(nativeValue.obj());
    }

    public static Error Error(CollectionOfErrors nativeValue) {
        DafnySequence list = ToDafny.Aggregate.GenericToSequence(nativeValue.list(), ToDafny::Error, Error._typeDescriptor());
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.getMessage());
        return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)list, (DafnySequence<? extends Character>)message);
    }

    public static AuthItem AuthItem(software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.AuthItem nativeValue) {
        DafnySequence<? extends PathSegment> key = ToDafny.Path(nativeValue.key());
        software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal data = ToDafny.StructuredDataTerminal(nativeValue.data());
        AuthenticateAction action = ToDafny.AuthenticateAction(nativeValue.action());
        return new AuthItem(key, data, action);
    }

    public static CryptoItem CryptoItem(software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoItem nativeValue) {
        DafnySequence<? extends PathSegment> key = ToDafny.Path(nativeValue.key());
        software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal data = ToDafny.StructuredDataTerminal(nativeValue.data());
        software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction action = ToDafny.CryptoAction(nativeValue.action());
        return new CryptoItem(key, data, action);
    }

    public static software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.DecryptPathStructureInput DecryptPathStructureInput(DecryptPathStructureInput nativeValue) {
        DafnySequence tableName = ToDafny.Simple.CharacterSequence((String)nativeValue.tableName());
        DafnySequence<? extends AuthItem> encryptedStructure = ToDafny.AuthList(nativeValue.encryptedStructure());
        software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager cmm = software.amazon.cryptography.materialproviders.ToDafny.CryptographicMaterialsManager((ICryptographicMaterialsManager)nativeValue.cmm());
        Option encryptionContext = Objects.nonNull(nativeValue.encryptionContext()) && nativeValue.encryptionContext().size() > 0 ? Option.create_Some((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)), (Object)software.amazon.cryptography.materialproviders.ToDafny.EncryptionContext(nativeValue.encryptionContext())) : Option.create_None((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)));
        return new software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.DecryptPathStructureInput((DafnySequence<? extends Character>)tableName, encryptedStructure, cmm, (Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>>)encryptionContext);
    }

    public static DecryptPathStructureOutput DecryptPathStructureOutput(software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.DecryptPathStructureOutput nativeValue) {
        DafnySequence<? extends CryptoItem> plaintextStructure = ToDafny.CryptoList(nativeValue.plaintextStructure());
        ParsedHeader parsedHeader = ToDafny.ParsedHeader(nativeValue.parsedHeader());
        return new DecryptPathStructureOutput(plaintextStructure, parsedHeader);
    }

    public static software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.DecryptStructureInput DecryptStructureInput(DecryptStructureInput nativeValue) {
        DafnySequence tableName = ToDafny.Simple.CharacterSequence((String)nativeValue.tableName());
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal> encryptedStructure = ToDafny.StructuredDataMap(nativeValue.encryptedStructure());
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends AuthenticateAction> authenticateSchema = ToDafny.AuthenticateSchemaMap(nativeValue.authenticateSchema());
        software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager cmm = software.amazon.cryptography.materialproviders.ToDafny.CryptographicMaterialsManager((ICryptographicMaterialsManager)nativeValue.cmm());
        Option encryptionContext = Objects.nonNull(nativeValue.encryptionContext()) && nativeValue.encryptionContext().size() > 0 ? Option.create_Some((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)), (Object)software.amazon.cryptography.materialproviders.ToDafny.EncryptionContext(nativeValue.encryptionContext())) : Option.create_None((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)));
        return new software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.DecryptStructureInput((DafnySequence<? extends Character>)tableName, encryptedStructure, authenticateSchema, cmm, (Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>>)encryptionContext);
    }

    public static DecryptStructureOutput DecryptStructureOutput(software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.DecryptStructureOutput nativeValue) {
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal> plaintextStructure = ToDafny.StructuredDataMap(nativeValue.plaintextStructure());
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> cryptoSchema = ToDafny.CryptoSchemaMap(nativeValue.cryptoSchema());
        ParsedHeader parsedHeader = ToDafny.ParsedHeader(nativeValue.parsedHeader());
        return new DecryptStructureOutput(plaintextStructure, cryptoSchema, parsedHeader);
    }

    public static EncryptPathStructureInput EncryptPathStructureInput(software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.EncryptPathStructureInput nativeValue) {
        DafnySequence tableName = ToDafny.Simple.CharacterSequence((String)nativeValue.tableName());
        DafnySequence<? extends CryptoItem> plaintextStructure = ToDafny.CryptoList(nativeValue.plaintextStructure());
        software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager cmm = software.amazon.cryptography.materialproviders.ToDafny.CryptographicMaterialsManager((ICryptographicMaterialsManager)nativeValue.cmm());
        Option algorithmSuiteId = Objects.nonNull(nativeValue.algorithmSuiteId()) ? Option.create_Some((TypeDescriptor)software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId._typeDescriptor(), (Object)software.amazon.cryptography.materialproviders.ToDafny.DBEAlgorithmSuiteId((DBEAlgorithmSuiteId)nativeValue.algorithmSuiteId())) : Option.create_None((TypeDescriptor)software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId._typeDescriptor());
        Option encryptionContext = Objects.nonNull(nativeValue.encryptionContext()) && nativeValue.encryptionContext().size() > 0 ? Option.create_Some((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)), (Object)software.amazon.cryptography.materialproviders.ToDafny.EncryptionContext(nativeValue.encryptionContext())) : Option.create_None((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)));
        return new EncryptPathStructureInput((DafnySequence<? extends Character>)tableName, plaintextStructure, cmm, (Option<software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId>)algorithmSuiteId, (Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>>)encryptionContext);
    }

    public static software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.EncryptPathStructureOutput EncryptPathStructureOutput(EncryptPathStructureOutput nativeValue) {
        DafnySequence<? extends CryptoItem> encryptedStructure = ToDafny.CryptoList(nativeValue.encryptedStructure());
        ParsedHeader parsedHeader = ToDafny.ParsedHeader(nativeValue.parsedHeader());
        return new software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.EncryptPathStructureOutput(encryptedStructure, parsedHeader);
    }

    public static software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.EncryptStructureInput EncryptStructureInput(EncryptStructureInput nativeValue) {
        DafnySequence tableName = ToDafny.Simple.CharacterSequence((String)nativeValue.tableName());
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal> plaintextStructure = ToDafny.StructuredDataMap(nativeValue.plaintextStructure());
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> cryptoSchema = ToDafny.CryptoSchemaMap(nativeValue.cryptoSchema());
        software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsManager cmm = software.amazon.cryptography.materialproviders.ToDafny.CryptographicMaterialsManager((ICryptographicMaterialsManager)nativeValue.cmm());
        Option algorithmSuiteId = Objects.nonNull(nativeValue.algorithmSuiteId()) ? Option.create_Some((TypeDescriptor)software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId._typeDescriptor(), (Object)software.amazon.cryptography.materialproviders.ToDafny.DBEAlgorithmSuiteId((DBEAlgorithmSuiteId)nativeValue.algorithmSuiteId())) : Option.create_None((TypeDescriptor)software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId._typeDescriptor());
        Option encryptionContext = Objects.nonNull(nativeValue.encryptionContext()) && nativeValue.encryptionContext().size() > 0 ? Option.create_Some((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)), (Object)software.amazon.cryptography.materialproviders.ToDafny.EncryptionContext(nativeValue.encryptionContext())) : Option.create_None((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE)));
        return new software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.EncryptStructureInput((DafnySequence<? extends Character>)tableName, plaintextStructure, cryptoSchema, cmm, (Option<software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId>)algorithmSuiteId, (Option<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>>)encryptionContext);
    }

    public static software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.EncryptStructureOutput EncryptStructureOutput(EncryptStructureOutput nativeValue) {
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal> encryptedStructure = ToDafny.StructuredDataMap(nativeValue.encryptedStructure());
        DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> cryptoSchema = ToDafny.CryptoSchemaMap(nativeValue.cryptoSchema());
        ParsedHeader parsedHeader = ToDafny.ParsedHeader(nativeValue.parsedHeader());
        return new software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.EncryptStructureOutput(encryptedStructure, cryptoSchema, parsedHeader);
    }

    public static ParsedHeader ParsedHeader(software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.ParsedHeader nativeValue) {
        software.amazon.cryptography.materialproviders.internaldafny.types.DBEAlgorithmSuiteId algorithmSuiteId = software.amazon.cryptography.materialproviders.ToDafny.DBEAlgorithmSuiteId((DBEAlgorithmSuiteId)nativeValue.algorithmSuiteId());
        DafnySequence encryptedDataKeys = software.amazon.cryptography.materialproviders.ToDafny.EncryptedDataKeyList(nativeValue.encryptedDataKeys());
        DafnyMap storedEncryptionContext = software.amazon.cryptography.materialproviders.ToDafny.EncryptionContext(nativeValue.storedEncryptionContext());
        DafnyMap encryptionContext = software.amazon.cryptography.materialproviders.ToDafny.EncryptionContext(nativeValue.encryptionContext());
        return new ParsedHeader(algorithmSuiteId, (DafnySequence<? extends EncryptedDataKey>)encryptedDataKeys, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)storedEncryptionContext, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)encryptionContext);
    }

    public static ResolveAuthActionsInput ResolveAuthActionsInput(software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.ResolveAuthActionsInput nativeValue) {
        DafnySequence tableName = ToDafny.Simple.CharacterSequence((String)nativeValue.tableName());
        DafnySequence<? extends AuthItem> authActions = ToDafny.AuthList(nativeValue.authActions());
        DafnySequence headerBytes = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.headerBytes());
        return new ResolveAuthActionsInput((DafnySequence<? extends Character>)tableName, authActions, (DafnySequence<? extends Byte>)headerBytes);
    }

    public static ResolveAuthActionsOutput ResolveAuthActionsOutput(software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.ResolveAuthActionsOutput nativeValue) {
        DafnySequence<? extends CryptoItem> cryptoActions = ToDafny.CryptoList(nativeValue.cryptoActions());
        return new ResolveAuthActionsOutput(cryptoActions);
    }

    public static software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal StructuredDataTerminal(StructuredDataTerminal nativeValue) {
        DafnySequence value = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.value());
        DafnySequence typeId = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.typeId());
        return new software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal((DafnySequence<? extends Byte>)value, (DafnySequence<? extends Byte>)typeId);
    }

    public static software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredEncryptionConfig StructuredEncryptionConfig(StructuredEncryptionConfig nativeValue) {
        return new software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredEncryptionConfig();
    }

    public static software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructureSegment StructureSegment(StructureSegment nativeValue) {
        DafnySequence key = ToDafny.Simple.CharacterSequence((String)nativeValue.key());
        return new software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructureSegment((DafnySequence<? extends Character>)key);
    }

    public static Error Error(StructuredEncryptionException nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_StructuredEncryptionException((DafnySequence<? extends Character>)message);
    }

    public static AuthenticateAction AuthenticateAction(software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.AuthenticateAction nativeValue) {
        switch (nativeValue) {
            case SIGN: {
                return AuthenticateAction.create_SIGN();
            }
            case DO_NOT_SIGN: {
                return AuthenticateAction.create_DO__NOT__SIGN();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.AuthenticateAction.");
    }

    public static software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction CryptoAction(CryptoAction nativeValue) {
        switch (nativeValue) {
            case ENCRYPT_AND_SIGN: {
                return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction.create_ENCRYPT__AND__SIGN();
            }
            case SIGN_AND_INCLUDE_IN_ENCRYPTION_CONTEXT: {
                return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction.create_SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT();
            }
            case SIGN_ONLY: {
                return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction.create_SIGN__ONLY();
            }
            case DO_NOTHING: {
                return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction.create_DO__NOTHING();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction.");
    }

    public static PathSegment PathSegment(software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.PathSegment nativeValue) {
        if (Objects.nonNull(nativeValue.member())) {
            return PathSegment.create(ToDafny.StructureSegment(nativeValue.member()));
        }
        throw new IllegalArgumentException("Cannot convert " + nativeValue + " to software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.PathSegment.");
    }

    public static DafnySequence<? extends AuthItem> AuthList(List<software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.AuthItem> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::AuthItem, AuthItem._typeDescriptor());
    }

    public static DafnySequence<? extends CryptoItem> CryptoList(List<software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoItem> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::CryptoItem, CryptoItem._typeDescriptor());
    }

    public static DafnySequence<? extends PathSegment> Path(List<software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.PathSegment> nativeValue) {
        return ToDafny.Aggregate.GenericToSequence(nativeValue, ToDafny::PathSegment, PathSegment._typeDescriptor());
    }

    public static DafnyMap<? extends DafnySequence<? extends Character>, ? extends AuthenticateAction> AuthenticateSchemaMap(Map<String, software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.AuthenticateAction> nativeValue) {
        return ToDafny.Aggregate.GenericToMap(nativeValue, ToDafny.Simple::CharacterSequence, ToDafny::AuthenticateAction);
    }

    public static DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction> CryptoSchemaMap(Map<String, CryptoAction> nativeValue) {
        return ToDafny.Aggregate.GenericToMap(nativeValue, ToDafny.Simple::CharacterSequence, ToDafny::CryptoAction);
    }

    public static DafnyMap<? extends DafnySequence<? extends Character>, ? extends software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal> StructuredDataMap(Map<String, StructuredDataTerminal> nativeValue) {
        return ToDafny.Aggregate.GenericToMap(nativeValue, ToDafny.Simple::CharacterSequence, ToDafny::StructuredDataTerminal);
    }

    public static IStructuredEncryptionClient StructuredEncryption(StructuredEncryption nativeValue) {
        return nativeValue.impl();
    }
}

