/*
 * Decompiled with CFR 0.152.
 */
package SearchableEncryptionInfo_Compile;

import BoundedInts_Compile.int64;
import BoundedInts_Compile.uint8;
import DynamoDbEncryptionUtil_Compile.MaybeKeyId;
import DynamoDbEncryptionUtil_Compile.MaybeKeyId_KeyId;
import DynamoDbEncryptionUtil_Compile.MaybeKeyMap;
import SearchableEncryptionInfo_Compile.KeyLocation;
import SearchableEncryptionInfo_Compile.__default;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyHaltException;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.PositiveInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;

public class KeySource {
    public AtomicPrimitivesClient _client;
    public IKeyStoreClient _store;
    public KeyLocation _keyLoc;
    public ICryptographicMaterialsCache _cache;
    public int _cacheTTL;
    public DafnySequence<? extends Byte> _partitionIdBytes;
    public DafnySequence<? extends Byte> _logicalKeyStoreNameBytes;
    private static final TypeDescriptor<KeySource> _TYPE = TypeDescriptor.referenceWithInitializer(KeySource.class, () -> KeySource.Default());
    private static final KeySource theDefault = KeySource.create(null, null, KeyLocation.Default(), null, 0, (DafnySequence<? extends Byte>)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));

    public KeySource(AtomicPrimitivesClient client, IKeyStoreClient store, KeyLocation keyLoc, ICryptographicMaterialsCache cache, int cacheTTL, DafnySequence<? extends Byte> partitionIdBytes, DafnySequence<? extends Byte> logicalKeyStoreNameBytes) {
        this._client = client;
        this._store = store;
        this._keyLoc = keyLoc;
        this._cache = cache;
        this._cacheTTL = cacheTTL;
        this._partitionIdBytes = partitionIdBytes;
        this._logicalKeyStoreNameBytes = logicalKeyStoreNameBytes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        KeySource o = (KeySource)other;
        return this._client == o._client && this._store == o._store && Objects.equals(this._keyLoc, o._keyLoc) && this._cache == o._cache && this._cacheTTL == o._cacheTTL && Objects.equals(this._partitionIdBytes, o._partitionIdBytes) && Objects.equals(this._logicalKeyStoreNameBytes, o._logicalKeyStoreNameBytes);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._client);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._store);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._keyLoc);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._cache);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._cacheTTL);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._partitionIdBytes);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._logicalKeyStoreNameBytes);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("SearchableEncryptionInfo.KeySource.KeySource");
        s.append("(");
        s.append(Helpers.toString((Object)this._client));
        s.append(", ");
        s.append(Helpers.toString((Object)this._store));
        s.append(", ");
        s.append(Helpers.toString((Object)this._keyLoc));
        s.append(", ");
        s.append(Helpers.toString((Object)this._cache));
        s.append(", ");
        s.append(this._cacheTTL);
        s.append(", ");
        s.append(Helpers.toString(this._partitionIdBytes));
        s.append(", ");
        s.append(Helpers.toString(this._logicalKeyStoreNameBytes));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<KeySource> _typeDescriptor() {
        return _TYPE;
    }

    public static KeySource Default() {
        return theDefault;
    }

    public static KeySource create(AtomicPrimitivesClient client, IKeyStoreClient store, KeyLocation keyLoc, ICryptographicMaterialsCache cache, int cacheTTL, DafnySequence<? extends Byte> partitionIdBytes, DafnySequence<? extends Byte> logicalKeyStoreNameBytes) {
        return new KeySource(client, store, keyLoc, cache, cacheTTL, partitionIdBytes, logicalKeyStoreNameBytes);
    }

    public static KeySource create_KeySource(AtomicPrimitivesClient client, IKeyStoreClient store, KeyLocation keyLoc, ICryptographicMaterialsCache cache, int cacheTTL, DafnySequence<? extends Byte> partitionIdBytes, DafnySequence<? extends Byte> logicalKeyStoreNameBytes) {
        return KeySource.create(client, store, keyLoc, cache, cacheTTL, partitionIdBytes, logicalKeyStoreNameBytes);
    }

    public boolean is_KeySource() {
        return true;
    }

    public AtomicPrimitivesClient dtor_client() {
        return this._client;
    }

    public IKeyStoreClient dtor_store() {
        return this._store;
    }

    public KeyLocation dtor_keyLoc() {
        return this._keyLoc;
    }

    public ICryptographicMaterialsCache dtor_cache() {
        return this._cache;
    }

    public int dtor_cacheTTL() {
        return this._cacheTTL;
    }

    public DafnySequence<? extends Byte> dtor_partitionIdBytes() {
        return this._partitionIdBytes;
    }

    public DafnySequence<? extends Byte> dtor_logicalKeyStoreNameBytes() {
        return this._logicalKeyStoreNameBytes;
    }

    public Result<MaybeKeyMap, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeyMap(DafnySequence<? extends DafnySequence<? extends Character>> stdNames, MaybeKeyId keyId) {
        long _out3;
        DafnySequence<? extends Character> _7___mcc_h0;
        Result output = Result.Default(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)MaybeKeyMap.Default());
        if (this.dtor_keyLoc().is_SingleLoc()) {
            long _out0;
            Outcome _0_valueOrError0 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)keyId.is_DontUseKeyId(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"KeyID should not be supplied with a SingleKeyStore")));
            if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            long _1_now = _out0 = Time.__default.CurrentRelativeTime().longValue();
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _2_valueOrError1 = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out1 = this.getKeysCache(this.dtor_client(), stdNames, this.dtor_keyLoc().dtor_keyId(), Integer.toUnsignedLong(this.dtor_cacheTTL()), this.dtor_partitionIdBytes(), this.dtor_logicalKeyStoreNameBytes(), _1_now);
            _2_valueOrError1 = _out1;
            if (_2_valueOrError1.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _2_valueOrError1.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            DafnyMap _3_theMap = (DafnyMap)_2_valueOrError1.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            output = Result.create_Success(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)MaybeKeyMap.create_Keys((DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>)_3_theMap));
            return output;
        }
        if (this.dtor_keyLoc().is_LiteralLoc()) {
            Outcome _4_valueOrError2 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            _4_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)keyId.is_DontUseKeyId(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"KeyID should not be supplied with a LiteralKeyStore")));
            if (_4_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _4_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _5_valueOrError3 = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out2 = this.getKeysLiteral();
            _5_valueOrError3 = _out2;
            if (_5_valueOrError3.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _5_valueOrError3.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
                return output;
            }
            DafnyMap _6_theMap = (DafnyMap)_5_valueOrError3.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            output = Result.create_Success(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)MaybeKeyMap.create_Keys((DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>)_6_theMap));
            return output;
        }
        MaybeKeyId _source0 = keyId;
        if (_source0.is_DontUseKeyId()) {
            output = Result.create_Failure(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Fixed KeyID must not be supplied with a MultiKeyStore")));
            return output;
        }
        if (_source0.is_ShouldHaveKeyId()) {
            output = Result.create_Success(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)MaybeKeyMap.create_ShouldHaveKeys());
            return output;
        }
        DafnySequence<? extends Character> _8_id = _7___mcc_h0 = ((MaybeKeyId_KeyId)_source0)._value;
        long _9_now = _out3 = Time.__default.CurrentRelativeTime().longValue();
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _10_valueOrError4 = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out4 = this.getKeysCache(this.dtor_client(), stdNames, _8_id, Integer.toUnsignedLong(this.dtor_cacheTTL()), this.dtor_partitionIdBytes(), this.dtor_logicalKeyStoreNameBytes(), _9_now);
        _10_valueOrError4 = _out4;
        if (_10_valueOrError4.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _10_valueOrError4.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), MaybeKeyMap._typeDescriptor());
            return output;
        }
        DafnyMap _11_theMap = (DafnyMap)_10_valueOrError4.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        output = Result.create_Success(MaybeKeyMap._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)MaybeKeyMap.create_Keys((DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>)_11_theMap));
        return output;
    }

    public Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeysLiteral() {
        Result output = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
        output = Result.create_Success((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), this.dtor_keyLoc().dtor_keys());
        return output;
    }

    public boolean cacheEntryWithinLimits(long creationTime, long now, long ttlSeconds) {
        return now - creationTime <= ttlSeconds;
    }

    public Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getKeysCache(AtomicPrimitivesClient client, DafnySequence<? extends DafnySequence<? extends Character>> stdNames, DafnySequence<? extends Character> keyId, long cacheTTL, DafnySequence<? extends Byte> partitionIdBytes, DafnySequence<? extends Byte> logicalKeyStoreNameBytes, long now) {
        Result _out0;
        Result output = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
        DafnySequence _0_resourceId = CacheConstants_Compile.__default.RESOURCE__ID__HIERARCHICAL__KEYRING();
        DafnySequence _1_scopeId = CacheConstants_Compile.__default.SCOPE__ID__SEARCHABLE__ENCRYPTION();
        Result _2_keyIdBytesR = UTF8.__default.Encode(keyId);
        Result _3_valueOrError0 = Result.Default((TypeDescriptor)ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)ValidUTF8Bytes.defaultValue());
        _3_valueOrError0 = _2_keyIdBytesR.MapFailure(ValidUTF8Bytes._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), _4_e_boxed0 -> {
            DafnySequence _4_e = _4_e_boxed0;
            return DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)_4_e);
        });
        if (_3_valueOrError0.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _3_valueOrError0.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
            return output;
        }
        DafnySequence _5_keyIdBytes = (DafnySequence)_3_valueOrError0.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        DafnySequence _6_suffix = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(logicalKeyStoreNameBytes, (DafnySequence)CacheConstants_Compile.__default.NULL__BYTE()), (DafnySequence)_5_keyIdBytes);
        DafnySequence _7_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)_0_resourceId, (DafnySequence)CacheConstants_Compile.__default.NULL__BYTE()), (DafnySequence)_1_scopeId), (DafnySequence)CacheConstants_Compile.__default.NULL__BYTE()), partitionIdBytes), (DafnySequence)CacheConstants_Compile.__default.NULL__BYTE()), (DafnySequence)_6_suffix);
        DigestAlgorithm _8_hashAlgorithm = DigestAlgorithm.create_SHA__384();
        DigestInput _9_identifierDigestInput = DigestInput.create((DigestAlgorithm)_8_hashAlgorithm, (DafnySequence)_7_identifier);
        Result _10_maybeCacheDigest = _out0 = client.Digest(_9_identifierDigestInput);
        Result _11_valueOrError1 = Result.Default((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
        _11_valueOrError1 = _10_maybeCacheDigest.MapFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.primitives.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), _12_e_boxed0 -> {
            software.amazon.cryptography.primitives.internaldafny.types.Error _12_e = _12_e_boxed0;
            return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error.create_AwsCryptographyPrimitives(_12_e);
        });
        if (_11_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _11_valueOrError1.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
            return output;
        }
        DafnySequence _13_cacheDigest = (DafnySequence)_11_valueOrError1.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        GetCacheEntryInput _14_getCacheInput = GetCacheEntryInput.create((DafnySequence)_13_cacheDigest, (Option)Option.create_None((TypeDescriptor)int64._typeDescriptor()));
        Result _out1 = this.dtor_cache().GetCacheEntry(_14_getCacheInput);
        Result _15_getCacheOutput = _out1;
        if (_15_getCacheOutput.is_Failure() && !((software.amazon.cryptography.materialproviders.internaldafny.types.Error)_15_getCacheOutput.dtor_error()).is_EntryDoesNotExist()) {
            output = Result.create_Failure((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error.create_AwsCryptographyMaterialProviders((software.amazon.cryptography.materialproviders.internaldafny.types.Error)_15_getCacheOutput.dtor_error()));
            return output;
        }
        if (_15_getCacheOutput.is_Failure() || !this.cacheEntryWithinLimits(((GetCacheEntryOutput)_15_getCacheOutput.dtor_value()).dtor_creationTime(), now, cacheTTL)) {
            Result _out2;
            Result _16_maybeRawBeaconKeyMaterials = _out2 = this.dtor_store().GetBeaconKey(GetBeaconKeyInput.create(keyId));
            Result _17_valueOrError2 = Result.Default((TypeDescriptor)GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)GetBeaconKeyOutput.Default());
            _17_valueOrError2 = _16_maybeRawBeaconKeyMaterials.MapFailure(GetBeaconKeyOutput._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), _18_e_boxed0 -> {
                Error _18_e = _18_e_boxed0;
                return software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error.create_AwsCryptographyKeyStore(_18_e);
            });
            if (_17_valueOrError2.IsFailure(GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _17_valueOrError2.PropagateFailure(GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
                return output;
            }
            GetBeaconKeyOutput _19_rawBeaconKeyMaterials = (GetBeaconKeyOutput)_17_valueOrError2.Extract(GetBeaconKeyOutput._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            Option _20_key = _19_rawBeaconKeyMaterials.dtor_beaconKeyMaterials().dtor_beaconKey();
            Outcome _21_valueOrError3 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            _21_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (boolean)_20_key.is_Some(), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"beacon key unexpectedly empty")));
            if (_21_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _21_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
                return output;
            }
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _22_valueOrError4 = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
            Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out3 = this.getAllKeys(stdNames, (DafnySequence<? extends Byte>)((DafnySequence)_20_key.dtor_value()));
            _22_valueOrError4 = _out3;
            if (_22_valueOrError4.IsFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
                output = _22_valueOrError4.PropagateFailure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
                return output;
            }
            DafnyMap _23_keyMap = (DafnyMap)_22_valueOrError4.Extract(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
            BeaconKeyMaterials _25_dt__update__tmp_h0 = _19_rawBeaconKeyMaterials.dtor_beaconKeyMaterials();
            Option _26_dt__update_hhmacKeys_h0 = Option.create_Some((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), (Object)_23_keyMap);
            Option _27_dt__update_hbeaconKey_h0 = Option.create_None((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()));
            BeaconKeyMaterials _24_beaconKeyMaterials = BeaconKeyMaterials.create((DafnySequence)_25_dt__update__tmp_h0.dtor_beaconKeyIdentifier(), (DafnyMap)_25_dt__update__tmp_h0.dtor_encryptionContext(), (Option)_27_dt__update_hbeaconKey_h0, (Option)_26_dt__update_hhmacKeys_h0);
            if (now >= BoundedInts_Compile.__default.INT64__MAX() - cacheTTL) {
                throw new DafnyHaltException("dafny/DynamoDbEncryption/src/SearchInfo.dfy(409,8): " + DafnySequence.asString((String)"expectation violation").verbatimString());
            }
            PutCacheEntryInput _28_putCacheEntryInput = PutCacheEntryInput.create((DafnySequence)_13_cacheDigest, (Materials)Materials.create_BeaconKey((BeaconKeyMaterials)_24_beaconKeyMaterials), (long)now, (long)(now + cacheTTL), (Option)Option.create_None((TypeDescriptor)PositiveInteger._typeDescriptor()), (Option)Option.create_None((TypeDescriptor)PositiveInteger._typeDescriptor()));
            Result _out4 = this.dtor_cache().PutCacheEntry(_28_putCacheEntryInput);
            Result _29_putResult = _out4;
            if (_29_putResult.is_Failure() && !((software.amazon.cryptography.materialproviders.internaldafny.types.Error)_29_putResult.dtor_error()).is_EntryAlreadyExists()) {
                output = Result.create_Failure((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error.create_AwsCryptographyMaterialProviders((software.amazon.cryptography.materialproviders.internaldafny.types.Error)_29_putResult.dtor_error()));
                return output;
            }
            output = Result.create_Success((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)_23_keyMap);
            return output;
        }
        Outcome _30_valueOrError5 = Outcome.Default(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor());
        _30_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (((GetCacheEntryOutput)_15_getCacheOutput.dtor_value()).dtor_materials().is_BeaconKey() && ((GetCacheEntryOutput)_15_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_hmacKeys().is_Some() && ((GetCacheEntryOutput)_15_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_beaconKeyIdentifier().equals(keyId) && ((GetCacheEntryOutput)_15_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_hmacKeys().is_Some() ? 1 : 0) != 0, (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_30_valueOrError5.IsFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor())) {
            output = _30_valueOrError5.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())));
            return output;
        }
        output = Result.create_Success((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)((GetCacheEntryOutput)_15_getCacheOutput.dtor_value()).dtor_materials().dtor_BeaconKey().dtor_hmacKeys().dtor_value());
        return output;
    }

    public Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> getAllKeys(DafnySequence<? extends DafnySequence<? extends Character>> stdNames, DafnySequence<? extends Byte> key) {
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> _out0;
        Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Byte>>, software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error> output = Result.Default((TypeDescriptor)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor())), software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error._typeDescriptor(), (Object)DafnyMap.empty());
        output = _out0 = __default.GetAllKeys(this.dtor_client(), stdNames, key);
        return output;
    }
}

