/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.QueryPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ScanPublisher;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;
import software.amazon.dax.Configuration;
import software.amazon.dax.DaxAsyncClient;
import software.amazon.dax.retry.DaxBackoffStrategy;
import software.amazon.dax.retry.RetryHandler;

abstract class MetricAsyncClient
implements DynamoDbAsyncClient {
    private final RetryHandler retryHandler;
    private final List<MetricPublisher> metricPublishers;

    MetricAsyncClient(Configuration configuration) {
        this.metricPublishers = configuration.metricPublishers();
        this.retryHandler = new RetryHandler(new DaxBackoffStrategy(), Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().threadNamePrefix("dax-ScheduledExecutor").build()), (Executor)configuration.eventLoopGroup(), this::clientFactory, configuration.readRetries() + 1, configuration.writeRetries() + 1);
    }

    abstract DaxAsyncClient clientFactory(DaxAsyncClient var1) throws IOException;

    private <T extends DynamoDbRequest, R> CompletableFuture<R> emitMetrics(String api, T request, Supplier<CompletableFuture<R>> task) {
        List<MetricPublisher> metricPublishers = MetricAsyncClient.resolveMetricPublishers(this.metricPublishers, request.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Dax");
        apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)api);
        long callStart = System.nanoTime();
        return task.get().whenComplete((arg_0, arg_1) -> MetricAsyncClient.lambda$emitMetrics$1(callStart, (MetricCollector)apiCallMetricCollector, metricPublishers, arg_0, arg_1));
    }

    private static List<MetricPublisher> resolveMetricPublishers(List<MetricPublisher> metricPublishers, RequestOverrideConfiguration reqConfig) {
        List<Object> publishers = null;
        if (reqConfig != null) {
            publishers = reqConfig.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = metricPublishers;
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    public String serviceName() {
        return "dax";
    }

    public CompletableFuture<BatchGetItemResponse> batchGetItem(BatchGetItemRequest request) {
        return this.emitMetrics("BatchGetItem", request, () -> this.retryHandler.makeReadRequestWithRetries(client -> client.batchGetItem(request)));
    }

    public CompletableFuture<BatchWriteItemResponse> batchWriteItem(BatchWriteItemRequest request) {
        return this.emitMetrics("BatchWriteItem", request, () -> this.retryHandler.makeWriteRequestWithRetries(client -> client.batchWriteItem(request)));
    }

    public CompletableFuture<DeleteItemResponse> deleteItem(DeleteItemRequest request) {
        return this.emitMetrics("DeleteItem", request, () -> this.retryHandler.makeWriteRequestWithRetries(client -> client.deleteItem(request)));
    }

    public CompletableFuture<GetItemResponse> getItem(GetItemRequest request) {
        return this.emitMetrics("GetItem", request, () -> this.retryHandler.makeReadRequestWithRetries(client -> client.getItem(request)));
    }

    public CompletableFuture<PutItemResponse> putItem(PutItemRequest request) {
        return this.emitMetrics("PutItem", request, () -> this.retryHandler.makeWriteRequestWithRetries(client -> client.putItem(request)));
    }

    public CompletableFuture<QueryResponse> query(QueryRequest request) {
        return this.emitMetrics("Query", request, () -> this.retryHandler.makeReadRequestWithRetries(client -> client.query(request)));
    }

    public CompletableFuture<ScanResponse> scan(ScanRequest request) {
        return this.emitMetrics("Scan", request, () -> this.retryHandler.makeReadRequestWithRetries(client -> client.scan(request)));
    }

    public CompletableFuture<TransactGetItemsResponse> transactGetItems(TransactGetItemsRequest request) {
        return this.emitMetrics("TransactGetItems", request, () -> this.retryHandler.makeReadRequestWithRetries(client -> client.transactGetItems(request)));
    }

    public CompletableFuture<TransactWriteItemsResponse> transactWriteItems(TransactWriteItemsRequest request) {
        return this.emitMetrics("TransactWriteItems", request, () -> this.retryHandler.makeWriteRequestWithRetries(client -> client.transactWriteItems(request)));
    }

    public CompletableFuture<UpdateItemResponse> updateItem(UpdateItemRequest request) {
        return this.emitMetrics("UpdateItem", request, () -> this.retryHandler.makeWriteRequestWithRetries(client -> client.updateItem(request)));
    }

    public BatchGetItemPublisher batchGetItemPaginator(BatchGetItemRequest request) {
        return new BatchGetItemPublisher((DynamoDbAsyncClient)this, request);
    }

    public QueryPublisher queryPaginator(QueryRequest request) {
        return new QueryPublisher((DynamoDbAsyncClient)this, request);
    }

    public ScanPublisher scanPaginator(ScanRequest request) {
        return new ScanPublisher((DynamoDbAsyncClient)this, request);
    }

    private static /* synthetic */ void lambda$emitMetrics$1(long callStart, MetricCollector apiCallMetricCollector, List metricPublishers, Object r, Throwable e) {
        long d = System.nanoTime() - callStart;
        apiCallMetricCollector.reportMetric(CoreMetric.API_CALL_DURATION, (Object)Duration.ofNanos(d));
        apiCallMetricCollector.reportMetric(CoreMetric.API_CALL_SUCCESSFUL, (Object)(e == null ? 1 : 0));
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

