/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public abstract class SimpleCache<K, V> {
    private final CacheMap<K, CompletableFuture<V>> mCache;

    public SimpleCache(int size) {
        this.mCache = new CacheMap(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompletableFuture<V> get(K key) {
        CompletableFuture f = (CompletableFuture)this.mCache.get(key);
        if (f != null && !f.isCompletedExceptionally()) {
            return f;
        }
        SimpleCache simpleCache = this;
        synchronized (simpleCache) {
            f = (CompletableFuture)this.mCache.get(key);
            if (f != null) {
                if (!f.isCompletedExceptionally()) {
                    return f;
                }
                this.mCache.remove(key);
            }
            f = new CompletableFuture();
            this.mCache.put(key, f);
        }
        CompletableFuture future = f;
        this.fetch(key).whenComplete((r, e) -> {
            if (e != null) {
                future.completeExceptionally((Throwable)e);
            } else {
                future.complete(r);
            }
        });
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        SimpleCache simpleCache = this;
        synchronized (simpleCache) {
            CompletableFuture<V> v = this.mCache.put(key, CompletableFuture.completedFuture(value));
            if (v == null) {
                return null;
            }
            if (!v.isDone()) {
                v.complete(value);
                return null;
            }
            return v.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(K key) {
        SimpleCache simpleCache = this;
        synchronized (simpleCache) {
            CompletableFuture v = (CompletableFuture)this.mCache.remove(key);
            if (v != null && !v.isDone()) {
                v.completeExceptionally(new IOException("timeout fetching metadata"));
            }
        }
    }

    protected abstract CompletableFuture<V> fetch(K var1);

    protected int size() {
        return this.mCache.size();
    }

    private static final class CacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxEntries;

        CacheMap(int maxSize) {
            super(maxSize, 0.75f, true);
            this.maxEntries = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxEntries;
        }
    }
}

