/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.io.OutputStream;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.dax.channel.ChannelAttributeKey;
import software.amazon.dax.com.amazon.cbor.CborOutputStream;
import software.amazon.dax.com.amazon.cbor.Encoder;
import software.amazon.dax.exceptions.DaxServiceException;
import software.amazon.dax.utils.LazyClock;
import software.amazon.dax.utils.SigV4Gen;
import software.amazon.dax.utils.Validate;

@ChannelHandler.Sharable
public class AuthHandler
extends ChannelDuplexHandler {
    private String accessKeyId;
    private final AwsCredentialsProvider credentialsProvider;
    private final String region;
    private final String userAgent;
    private final LazyClock clock;
    private volatile long poolWindow = 150000L;
    private volatile long channelWindow = 30000L;
    private volatile long lastPoolAuth;
    private static final String DAX_ADDR = "https://dax.amazonaws.com";
    private static final int AUTH_TTL_MS = 300000;
    protected static final double WINDOW_SCALAR = 0.1;

    AuthHandler(AwsCredentialsProvider credentialsProvider, String region, String userAgent) {
        this(credentialsProvider, region, userAgent, LazyClock.instance());
    }

    AuthHandler(AwsCredentialsProvider credentialsProvider, String region, String userAgent, LazyClock clock) {
        this.credentialsProvider = credentialsProvider;
        this.region = region;
        this.userAgent = userAgent;
        this.clock = clock;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        long currTime = this.clock.getCurrentTime();
        AwsCredentials creds = this.credentialsProvider.resolveCredentials();
        if (!this.checkAndUpdateAccessKeyId(creds.accessKeyId()) || this.getChannelAuthExpiry(ctx.channel()) - currTime <= this.channelWindow || currTime - this.lastPoolAuth >= this.poolWindow) {
            SigV4Gen.SigAndStringToSign sigHead = SigV4Gen.generateSigAndStringToSign(creds, DAX_ADDR, this.region, "");
            ByteBuf byteBuf = ctx.alloc().buffer();
            this.prepareAuthRequest(byteBuf, this.accessKeyId, sigHead.mSignature, Encoder.encodeUtf8(sigHead.mStringToSign), sigHead.mSessionToken, this.userAgent);
            ctx.write((Object)byteBuf);
            this.lastPoolAuth = currTime;
            this.setChannelAuthExpiry(ctx.channel(), currTime + 300000L);
        }
        super.write(ctx, msg, promise);
    }

    private void prepareAuthRequest(ByteBuf byteBuf, String accessKeyId, String signature, byte[] stringToSign, String sessionToken, String userAgent) throws IOException {
        Validate.notNull(accessKeyId, "accessKeyId");
        Validate.notNull(signature, "signature");
        Validate.notNull(stringToSign, "stringToSign");
        try (CborOutputStream out = new CborOutputStream((OutputStream)new ByteBufOutputStream(byteBuf), 0);){
            out.writeInt(1);
            out.writeInt(1489122155);
            out.writeString(accessKeyId);
            out.writeString(signature);
            out.writeBytes(stringToSign);
            if (sessionToken == null) {
                out.writeNull();
            } else {
                out.writeString(sessionToken);
            }
            if (userAgent == null) {
                out.writeNull();
            } else {
                out.writeString(userAgent);
            }
            out.flush();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof DaxServiceException && ((DaxServiceException)((Object)cause)).isAuthenticationException()) {
            this.setChannelAuthExpiry(ctx.channel(), 0L);
        }
        super.exceptionCaught(ctx, cause);
    }

    long getChannelAuthExpiry(Channel channel) {
        Long expiry = (Long)channel.attr(ChannelAttributeKey.AUTH_EXPIRY).get();
        return expiry == null ? 0L : expiry;
    }

    private void setChannelAuthExpiry(Channel channel, long expiry) {
        channel.attr(ChannelAttributeKey.AUTH_EXPIRY).set((Object)expiry);
    }

    private boolean checkAndUpdateAccessKeyId(String other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("AWSCredentialsProvider provided null AWSAccessKeyId");
        }
        boolean equality = other.equals(this.accessKeyId);
        if (!equality) {
            this.accessKeyId = other;
        }
        return equality;
    }
}

