/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.cluster;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.dax.Configuration;
import software.amazon.dax.DaxAsyncClient;
import software.amazon.dax.InternalConfiguration;
import software.amazon.dax.com.amazon.dax.client.HostPort;
import software.amazon.dax.exceptions.ClientCreationException;

public class Backend {
    private static final Log LOG = LogFactory.getLog(Backend.class);
    private static final long HEALTH_CHECK_TIMEOUT_MS = 1000L;
    private static final long HEALTH_CHECK_INTERVAL_MS = 5000L;
    private final InetAddress addr;
    private final int port;
    private final InternalConfiguration internalConfiguration;
    private final Configuration configuration;
    private DaxAsyncClient client;
    private final ScheduledFuture<?> healthChecker;
    private final ScheduledExecutorService scheduledExecutorService;
    private final OnHealthCheckFailure onHealthCheckFailure;

    public Backend(InetAddress addr, int port, Configuration configuration, InternalConfiguration internalConfiguration, OnHealthCheckFailure onHealthCheckFailure, ScheduledExecutorService scheduledExecutorService, DaxAsyncClient client) throws ClientCreationException {
        this.addr = addr;
        this.port = port;
        this.configuration = configuration;
        this.internalConfiguration = internalConfiguration;
        this.client = client;
        this.onHealthCheckFailure = onHealthCheckFailure;
        this.scheduledExecutorService = scheduledExecutorService;
        this.healthChecker = this.scheduledExecutorService.scheduleWithFixedDelay(this::healthCheck, 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    public Backend(InetAddress addr, int port, Configuration configuration, InternalConfiguration internalConfiguration, OnHealthCheckFailure onHealthCheckFailure) throws ClientCreationException {
        this.addr = addr;
        this.port = port;
        this.configuration = configuration;
        this.internalConfiguration = internalConfiguration;
        this.client = this.newClient();
        this.onHealthCheckFailure = onHealthCheckFailure;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(0, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("DaxBackend-" + t.getId());
            return t;
        });
        if (this.scheduledExecutorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)((Object)this.scheduledExecutorService);
            tpe.setKeepAliveTime(10000L, TimeUnit.MILLISECONDS);
            tpe.allowCoreThreadTimeOut(true);
        }
        if (this.scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor stpe = (ScheduledThreadPoolExecutor)this.scheduledExecutorService;
            stpe.setRemoveOnCancelPolicy(true);
        }
        this.healthChecker = this.scheduledExecutorService.scheduleWithFixedDelay(this::healthCheck, 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    public DaxAsyncClient getClient() {
        return this.client;
    }

    private DaxAsyncClient newClient() throws ClientCreationException {
        try {
            return new DaxAsyncClient((Configuration)this.configuration.copy(c -> c.url(HostPort.url(this.configuration.ssl(), this.addr.getHostAddress(), this.port))), this.internalConfiguration);
        }
        catch (IOException ex) {
            LOG.warn((Object)("DaxAsyncClient creation failed. Exception: " + ex.getMessage()));
            throw new ClientCreationException(ex.getMessage(), ex);
        }
    }

    void purgeClient() {
        try (DaxAsyncClient oldClient = this.client;){
            this.client = this.newClient();
        }
    }

    public void close() {
        try {
            this.client.close();
        }
        finally {
            this.healthChecker.cancel(false);
            this.scheduledExecutorService.shutdown();
            try {
                if (!this.scheduledExecutorService.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    this.scheduledExecutorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.scheduledExecutorService.shutdownNow();
            }
        }
    }

    void healthCheck() {
        try {
            this.client.endpoints().get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            int maxRetries = 2;
            for (int retries = 0; retries < maxRetries; ++retries) {
                try {
                    this.purgeClient();
                    this.onHealthCheckFailure.onHealthCheckFailure();
                    break;
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex.getMessage());
                    continue;
                }
            }
        }
    }

    @FunctionalInterface
    public static interface OnHealthCheckFailure {
        public void onHealthCheckFailure();
    }
}

