/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.com.amazon.cbor.CborInputStream;
import software.amazon.dax.com.amazon.cbor.NonInputStream;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.dynamodb.AttributeValueDecoder;
import software.amazon.dax.dynamodb.DaxResponseDecoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.SimpleCache;

public class BatchWriteItemResponseHandler
extends ResponseHandler<BatchWriteItemResponse> {
    private final SimpleCache<Long, List<String>> attrListCache;
    private final AtomicReference<Map<String, Map<Integer, DocumentPath>>> tableProjOrdinals;
    private final AtomicReference<Map<String, List<AttributeDefinition>>> keysPerTable;
    private final BatchWriteItemRequest request;

    public BatchWriteItemResponseHandler(CompletableFuture<BatchWriteItemResponse> completableFuture, SimpleCache<Long, List<String>> attrListCache, AtomicReference<Map<String, Map<Integer, DocumentPath>>> tableProjOrdinals, AtomicReference<Map<String, List<AttributeDefinition>>> keysPerTable, BatchWriteItemRequest request) {
        super(completableFuture);
        this.attrListCache = attrListCache;
        this.tableProjOrdinals = tableProjOrdinals;
        this.keysPerTable = keysPerTable;
        this.request = request;
    }

    @Override
    public void decode(DaxCborInputStream in, CompletableFuture<BatchWriteItemResponse> completableFuture) throws Exception {
        int itemCollectionMetricsMapLength;
        int numTables = in.readMapLength();
        CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
        List[] attributeListIds = new List[numTables];
        List[] anonymousItems = new List[numTables];
        List[] tableItems = new List[numTables];
        String[] tableNames = new String[numTables];
        for (int idx = 0; idx < numTables; ++idx) {
            ArrayList<HashMap<String, AttributeValue>> tableItem;
            ArrayList<List<AttributeValue>> anonymousItem;
            ArrayList<Long> attrListIds;
            String tableName = (String)in.readObject();
            List<AttributeDefinition> tableKeys = this.keysPerTable.get().get(tableName);
            int numItems = in.readArrayLength() / 2;
            tableNames[idx] = tableName;
            attributeListIds[idx] = attrListIds = new ArrayList<Long>(numItems);
            anonymousItems[idx] = anonymousItem = new ArrayList<List<AttributeValue>>(numItems);
            tableItems[idx] = tableItem = new ArrayList<HashMap<String, AttributeValue>>(numItems);
            while (numItems-- > 0) {
                HashMap<String, AttributeValue> attrs = new HashMap<String, AttributeValue>();
                AttributeValueDecoder.decodeKey(in, tableKeys, attrs);
                tableItem.add(attrs);
                if (in.tryReadNull()) {
                    attrListIds.add(null);
                    anonymousItem.add(null);
                    continue;
                }
                in.beginStream();
                wrapper.init(in);
                attrListIds.add(wrapper.readLong());
                anonymousItem.add(AttributeValueDecoder.decodeAnonymousStreamedItem(wrapper, null));
                in.endStream();
            }
        }
        int consumedCapacityArrayLen = in.readArrayLength();
        ArrayList<ConsumedCapacity> consumedCapacities = null;
        if (consumedCapacityArrayLen > 0) {
            consumedCapacities = new ArrayList<ConsumedCapacity>(consumedCapacityArrayLen);
            while (consumedCapacityArrayLen-- > 0) {
                consumedCapacities.add(DaxResponseDecoder.decodeConsumedCapacity(in));
            }
        }
        HashMap batchWriteItemCollectionMetrics = (itemCollectionMetricsMapLength = in.readMapLength()) == 0 ? null : new HashMap();
        for (int i = 0; i < itemCollectionMetricsMapLength; ++i) {
            String tableName = (String)in.readObject();
            List<AttributeDefinition> tableKeys = this.keysPerTable.get().get(tableName);
            int numberOfMetrics = in.readArrayLength();
            ArrayList<ItemCollectionMetrics> metricsList = new ArrayList<ItemCollectionMetrics>(numberOfMetrics);
            for (int j = 0; j < numberOfMetrics; ++j) {
                metricsList.add(DaxResponseDecoder.decodeItemCollectionMetrics(in, tableKeys));
            }
            batchWriteItemCollectionMetrics.put(tableName, metricsList);
        }
        HashMap unprocessedItemsByTable = new HashMap(numTables);
        CompletableFuture[] futures = new CompletableFuture[numTables];
        for (int idx = 0; idx < numTables; ++idx) {
            String tableName = tableNames[idx];
            List attrListIds = attributeListIds[idx];
            List anonymousItem = anonymousItems[idx];
            List tableItem = tableItems[idx];
            int numItems = attrListIds.size();
            ArrayList<WriteRequest> writeRequests = new ArrayList<WriteRequest>(numItems);
            CompletableFuture[] writeReqFutures = new CompletableFuture[numItems];
            for (int i = 0; i < numItems; ++i) {
                Long attrListId = (Long)attrListIds.get(i);
                List attrValues = (List)anonymousItem.get(i);
                Map attrs = (Map)tableItem.get(i);
                if (null == attrListId || null == attrValues) {
                    writeRequests.add((WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(attrs).build()).build());
                    writeReqFutures[i] = null;
                    continue;
                }
                int index = i;
                writeReqFutures[i] = this.attrListCache.get((Long)attrListIds.get(i)).thenApply(attrNames -> {
                    try {
                        AttributeValueDecoder.deanonymizeAttributeValues(attrs, attrNames, (List)anonymousItem.get(index));
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                    writeRequests.add((WriteRequest)WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(attrs).build()).build());
                    return null;
                });
            }
            futures[idx] = CompletableFuture.allOf(writeReqFutures).thenApply(placeholder -> {
                unprocessedItemsByTable.put(tableName, writeRequests);
                return null;
            });
        }
        if (DynamoNumerals.ReturnItemCollectionMetrics.fromName(this.request.returnItemCollectionMetricsAsString()) != DynamoNumerals.ReturnItemCollectionMetrics.NONE && batchWriteItemCollectionMetrics == null) {
            batchWriteItemCollectionMetrics = new HashMap();
        }
        BatchWriteItemResponse.Builder response = BatchWriteItemResponse.builder().consumedCapacity(consumedCapacities).itemCollectionMetrics(batchWriteItemCollectionMetrics);
        if (DynamoNumerals.ReturnConsumedCapacity.fromName(this.request.returnConsumedCapacityAsString()) != DynamoNumerals.ReturnConsumedCapacity.NONE) {
            response.consumedCapacity(DaxResponseDecoder.verifyBatchConsumedCapacity(consumedCapacities, this.request.requestItems().keySet()));
        }
        CompletableFuture.allOf(futures).whenComplete((placeholder, ex) -> {
            if (ex != null) {
                completableFuture.completeExceptionally((Throwable)ex);
            } else {
                completableFuture.complete((BatchWriteItemResponse)response.unprocessedItems(unprocessedItemsByTable).build());
            }
        });
    }
}

