/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.PathElement;

final class ItemBuilder {
    private Map<PathElement, ItemBuilder> mChildren;
    private AttributeValue mValue;

    public static ItemBuilder create() {
        return new ItemBuilder();
    }

    private ItemBuilder() {
    }

    public ItemBuilder with(DocumentPath path, AttributeValue value) {
        AttributeValue prev = this.at(path).putIfAbsent(value);
        if (prev != null) {
            throw new IllegalArgumentException("Invalid ProjectionExpression: Two document paths overlap with each other; Duplicate field: " + path);
        }
        return this;
    }

    public Map<String, AttributeValue> toItem() {
        return this.toItem(null);
    }

    public Map<String, AttributeValue> toItem(Map<String, AttributeValue> item) {
        if (item == null) {
            item = new HashMap<String, AttributeValue>();
        }
        if (this.mChildren == null) {
            return item;
        }
        for (Map.Entry<PathElement, ItemBuilder> child : this.mChildren.entrySet()) {
            item.put(child.getKey().fieldName(), child.getValue().toAttribute());
        }
        return item;
    }

    public void reset() {
        if (this.mChildren != null) {
            this.mChildren.clear();
        }
    }

    private ItemBuilder at(DocumentPath path) {
        ItemBuilder d = this;
        for (PathElement el : path) {
            d = d.child(el);
        }
        return d;
    }

    private ItemBuilder child(PathElement loc) {
        ItemBuilder c;
        if (this.mChildren == null) {
            this.mChildren = new TreeMap<PathElement, ItemBuilder>();
        }
        if ((c = this.mChildren.get(loc)) == null) {
            c = new ItemBuilder();
            this.mChildren.put(loc, c);
        }
        return c;
    }

    private AttributeValue putIfAbsent(AttributeValue val) {
        AttributeValue prev = this.mValue;
        if (prev != null) {
            return prev;
        }
        this.mValue = val;
        return prev;
    }

    private AttributeValue toAttribute() {
        if (this.mChildren == null) {
            return this.mValue;
        }
        ArrayList<AttributeValue> lAttributeValues = new ArrayList<AttributeValue>();
        HashMap<String, AttributeValue> mAttributeValues = new HashMap<String, AttributeValue>();
        for (Map.Entry<PathElement, ItemBuilder> child : this.mChildren.entrySet()) {
            PathElement path = child.getKey();
            path.append(lAttributeValues, mAttributeValues, child.getValue().toAttribute());
        }
        if (lAttributeValues.size() > 0 && mAttributeValues.size() > 0) {
            return (AttributeValue)AttributeValue.builder().l(lAttributeValues).m(mAttributeValues).build();
        }
        if (lAttributeValues.size() > 0) {
            return (AttributeValue)AttributeValue.builder().l(lAttributeValues).build();
        }
        if (mAttributeValues.size() > 0) {
            return (AttributeValue)AttributeValue.builder().m(mAttributeValues).build();
        }
        return null;
    }
}

