/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.OutputStream;
import software.amazon.dax.InternalConfiguration;
import software.amazon.dax.channel.ChannelAttributeKey;
import software.amazon.dax.com.amazon.cbor.CborOutputStream;

@ChannelHandler.Sharable
public class ChannelInitHandler
extends ChannelDuplexHandler {
    static final ChannelInitHandler THE = new ChannelInitHandler();
    private static final String MAGIC_STRING = "J7yne5G";
    public static final String USER_AGENT_STRING = "UserAgent";
    private static final String USER_AGENT = InternalConfiguration.USER_AGENT;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Channel channel = ctx.channel();
        Boolean isInit = (Boolean)channel.attr(ChannelAttributeKey.INIT).get();
        if (isInit == null || !isInit.booleanValue()) {
            ByteBuf byteBuf = channel.alloc().buffer();
            try (CborOutputStream out = new CborOutputStream((OutputStream)new ByteBufOutputStream(byteBuf), 0);){
                out.writeString(MAGIC_STRING);
                out.write(1);
                out.writeNull();
                out.writeMapHeader(1);
                out.writeString(USER_AGENT_STRING);
                out.writeString(USER_AGENT);
                out.write(0);
                out.flush();
                ctx.writeAndFlush((Object)byteBuf).addListener(wireCall -> {
                    if (!wireCall.isSuccess()) {
                        promise.setFailure(wireCall.cause());
                    }
                });
            }
            channel.attr(ChannelAttributeKey.INIT).set((Object)true);
        }
        super.write(ctx, msg, promise);
    }
}

