/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.dax.com.amazon.dax.Frame;

public class FrameHandler
extends ChannelInboundHandlerAdapter {
    private Frame frame;
    private ByteBuf headerBytes;
    private ByteBuf buf;
    private int remaining;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            ByteBuf in = (ByteBuf)msg;
            this.consume(in, () -> ((ByteBufAllocator)ctx.alloc()).buffer(), arg_0 -> ((ChannelHandlerContext)ctx).fireChannelRead(arg_0));
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.allocBuf(() -> ctx.alloc().buffer(8));
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.headerBytes.release();
        if (this.buf != null) {
            this.buf.release();
            this.buf = null;
        }
    }

    void allocBuf(Supplier<ByteBuf> headerBuf) {
        this.headerBytes = headerBuf.get();
    }

    void consume(ByteBuf in, Supplier<ByteBuf> dataBuf, Consumer<ByteBuf> callback) {
        if (this.buf == null) {
            this.buf = dataBuf.get();
        }
        while (in.readableBytes() > 0) {
            if (this.frame == null) {
                int headerRemaining = 8 - this.headerBytes.readableBytes();
                in.readBytes(this.headerBytes, Math.min(in.readableBytes(), headerRemaining));
                if (this.headerBytes.readableBytes() == 8) {
                    byte[] header = new byte[8];
                    this.headerBytes.readBytes(header);
                    this.frame = Frame.createFrameHeader(header, 0);
                    this.remaining = this.frame.length() - 8;
                    this.headerBytes.clear();
                }
            }
            if (this.frame == null) continue;
            int read = Math.min(in.readableBytes(), this.remaining);
            this.buf.writeBytes(in, read);
            this.remaining -= read;
            if (this.remaining != 0) continue;
            if (this.frame.endOfMessage() && this.buf.readableBytes() > 0) {
                ByteBuf b = this.buf;
                callback.accept(b);
                this.buf = null;
            }
            this.frame = null;
        }
    }

    ByteBuf getBuf() {
        return this.buf;
    }
}

