/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.cbor;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import software.amazon.dax.com.amazon.cbor.CborInputStream;
import software.amazon.dax.com.amazon.cbor.Decoder;
import software.amazon.dax.com.amazon.cbor.Encoder;
import software.amazon.dax.com.amazon.cbor.EndOfStreamException;
import software.amazon.dax.com.amazon.cbor.IntRef;
import software.amazon.dax.com.amazon.cbor.SegmentPool;

public class CborDiagnostics {
    public static final String NOT_CBOR = "<not cbor>";

    public static String toDebuggerDiagnosticNotation(byte[] cbor) {
        try {
            return CborDiagnostics.toDiagnosticNotation(cbor);
        }
        catch (Exception e) {
            if (Decoder.verifyUtf8(cbor, 0, cbor.length)) {
                return Decoder.decodeUtf8(cbor);
            }
            return NOT_CBOR;
        }
    }

    public static String toDiagnosticNotation(byte[] cbor) throws IOException {
        CborInputStream input = new CborInputStream(cbor);
        StringBuilder s = new StringBuilder();
        while (true) {
            try {
                CborDiagnostics.printObject(s, input);
            }
            catch (EndOfStreamException eof) {
                break;
            }
            s.append(" ");
        }
        s.delete(s.length() - 1, s.length());
        return s.toString();
    }

    private static void printObject(StringBuilder s, CborInputStream input) throws IOException {
        int type = input.fieldType();
        block0 : switch (type >> 5) {
            case 6: {
                int tag = (int)input.getFieldValue();
                switch (tag) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        Object number = input.readObject();
                        s.append(CborDiagnostics.formatCborObject(number, false));
                        break block0;
                    }
                }
                s.append(tag);
                s.append("(");
                input.consumeField();
                CborDiagnostics.printObject(s, input);
                s.append(")");
                break;
            }
            case 7: {
                int simple = type & 0x1F;
                switch (simple) {
                    case 25: 
                    case 26: 
                    case 27: {
                        Object number = input.readObject();
                        s.append(CborDiagnostics.formatCborObject(number, false));
                        break block0;
                    }
                    case 22: {
                        s.append("null");
                        input.consumeField();
                        break block0;
                    }
                    case 21: {
                        s.append("true");
                        input.consumeField();
                        break block0;
                    }
                    case 20: {
                        s.append("false");
                        input.consumeField();
                        break block0;
                    }
                    case 23: {
                        s.append("undefined");
                        input.consumeField();
                        break block0;
                    }
                }
                s.append("simple(");
                s.append(input.getFieldValue());
                s.append(")");
                input.consumeField();
                break;
            }
            case 4: {
                CborDiagnostics.printArray(s, input);
                break;
            }
            case 5: {
                CborDiagnostics.printMap(s, input);
                break;
            }
            default: {
                if (type == 95 || type == 127) {
                    CborDiagnostics.printStringStream(s, input);
                    break;
                }
                Object obj = input.readObject();
                s.append(CborDiagnostics.formatCborObject(obj, false));
                break;
            }
        }
    }

    private static void printStringStream(StringBuilder s, CborInputStream input) throws IOException {
        s.append("(_ ");
        input.consumeField();
        boolean first = true;
        while (input.fieldType() != 255) {
            if (!first) {
                s.append(", ");
            }
            CborDiagnostics.printObject(s, input);
            first = false;
        }
        input.consumeField();
        s.append(")");
    }

    private static void printArray(StringBuilder s, CborInputStream input) throws IOException {
        int type = input.fieldType();
        boolean stream = type == 159;
        long size = !stream ? input.getFieldValue() : -1L;
        s.append('[');
        if (stream) {
            s.append("_ ");
        }
        input.consumeField();
        int items = 0;
        while (stream || (long)items < size) {
            type = input.fieldType();
            if (stream && type == 255) {
                input.consumeField();
                break;
            }
            if (items > 0) {
                s.append(", ");
            }
            CborDiagnostics.printObject(s, input);
            ++items;
            input.consumeField();
        }
        s.append("]");
    }

    private static void printMap(StringBuilder s, CborInputStream input) throws IOException {
        int type = input.fieldType();
        boolean stream = type == 191;
        long size = !stream ? input.getFieldValue() : -1L;
        s.append('{');
        if (stream) {
            s.append("_ ");
        }
        input.consumeField();
        int items = 0;
        while (stream || (long)items < size) {
            type = input.fieldType();
            if (stream && type == 255) {
                input.consumeField();
                break;
            }
            if (items > 0) {
                s.append(", ");
            }
            CborDiagnostics.printObject(s, input);
            s.append(": ");
            CborDiagnostics.printObject(s, input);
            ++items;
            input.consumeField();
        }
        s.append("}");
    }

    private static String formatCborObject(Object next, boolean isStream) {
        if (next == null) {
            return "null";
        }
        if (next instanceof Boolean) {
            return (Boolean)next != false ? "true" : "false";
        }
        if (next instanceof Long || next instanceof Integer || next instanceof BigInteger) {
            return next.toString();
        }
        if (next instanceof Float || next instanceof Double || next instanceof BigDecimal) {
            return next.toString();
        }
        if (next instanceof String) {
            return '\"' + next.toString() + '\"';
        }
        if (next instanceof byte[]) {
            return CborDiagnostics.formatByteArray((byte[])next);
        }
        if (next instanceof List) {
            return CborDiagnostics.formatArray((List)next, isStream);
        }
        if (next instanceof Map) {
            Map map = (Map)next;
            return CborDiagnostics.formatMap(map, isStream);
        }
        return next.toString();
    }

    private static String formatArray(List<?> next, boolean isStream) {
        StringBuilder s = new StringBuilder();
        s.append("[");
        if (isStream) {
            s.append("_ ");
        }
        List<?> list = next;
        for (Object o : list) {
            s.append(CborDiagnostics.formatCborObject(o, false));
            s.append(", ");
        }
        if (list.size() > 1) {
            s.delete(s.length() - 2, s.length());
        }
        s.append("]");
        return s.toString();
    }

    private static String formatMap(Map<?, ?> map, boolean isStream) {
        StringBuilder s = new StringBuilder();
        s.append("{");
        if (isStream) {
            s.append("_ ");
        }
        for (Map.Entry<?, ?> o : map.entrySet()) {
            s.append(CborDiagnostics.formatCborObject(o.getKey(), false));
            s.append(": ");
            s.append(CborDiagnostics.formatCborObject(o.getValue(), false));
            s.append(", ");
        }
        if (map.size() > 0) {
            s.delete(s.length() - 2, s.length());
        }
        s.append("}");
        return s.toString();
    }

    private static String formatByteArray(byte[] next) {
        StringBuilder s = new StringBuilder();
        byte[] data = next;
        if (data.length == 0) {
            return "h''";
        }
        String possibleCbor = null;
        try {
            possibleCbor = CborDiagnostics.toDiagnosticNotation(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (possibleCbor != null) {
            s.append('<');
            s.append(possibleCbor);
            s.append('>');
        } else if (Decoder.verifyUtf8(data, 0, data.length)) {
            s.append("bs'");
            s.append(Decoder.decodeUtf8(data));
            s.append('\'');
        } else {
            s.append("h'");
            for (byte b : data) {
                s.append(String.format("%02x", b));
            }
            s.append("'");
        }
        return s.toString();
    }

    public static byte[] fromDiagnosticNotation(String diag) {
        SegmentPool pool = new SegmentPool(100);
        SegmentPool.Segment head = pool.alloc();
        SegmentPool.Segment tail = CborDiagnostics.parseDiagnostics(pool, head, diag);
        return SegmentPool.chainCopy(head, 0);
    }

    private static SegmentPool.Segment parseDiagnostics(SegmentPool pool, SegmentPool.Segment tail, String diag) {
        IntRef pos = new IntRef(0);
        while (pos.value < diag.length()) {
            char c = diag.charAt(pos.value);
            if (c != ' ') {
                tail = CborDiagnostics.parseTerm(pool, tail, diag, pos);
            }
            ++pos.value;
        }
        return tail;
    }

    private static SegmentPool.Segment parseTerm(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        if (pos.value < diag.length()) {
            char c = diag.charAt(pos.value);
            switch (c) {
                case '\"': {
                    return CborDiagnostics.parseStringLiteral(pool, tail, diag, pos);
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'I': 
                case 'N': {
                    return CborDiagnostics.parseNumberOrTag(pool, tail, diag, pos);
                }
                case 'b': 
                case 'h': {
                    return CborDiagnostics.parseByteLiteral(pool, tail, diag, pos);
                }
                case '[': {
                    return CborDiagnostics.parseArray(pool, tail, diag, pos);
                }
                case '{': {
                    return CborDiagnostics.parseMap(pool, tail, diag, pos);
                }
                case '(': {
                    return CborDiagnostics.parseStringStream(pool, tail, diag, pos);
                }
                case '<': {
                    return CborDiagnostics.parseEmbeddedCbor(pool, tail, diag, pos);
                }
            }
            return CborDiagnostics.parseTokenOrSimple(pool, tail, diag, pos);
        }
        return tail;
    }

    private static SegmentPool.Segment parseStringLiteral(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        int start = pos.value;
        if (diag.charAt(start) != '\"') {
            throw new IllegalArgumentException("String literal does not start with \" at " + start);
        }
        while (diag.charAt(++pos.value) != '\"') {
            if (pos.value < diag.length()) continue;
            throw new IllegalArgumentException("Unbalanced \" from " + start);
        }
        String str = diag.substring(start + 1, pos.value);
        tail = pool.chainAppendCborString(tail, str);
        ++pos.value;
        return tail;
    }

    private static SegmentPool.Segment parseNumberOrTag(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        boolean isFloat = false;
        int start = pos.value;
        block14: while (pos.value < diag.length()) {
            char c = diag.charAt(pos.value);
            switch (c) {
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': 
                case 'e': {
                    isFloat = true;
                    break;
                }
                case 'I': 
                case 'N': {
                    while (pos.value < diag.length() && Character.isLetter(diag.charAt(pos.value++))) {
                    }
                    String special = diag.substring(start, pos.value);
                    try {
                        double n = Double.parseDouble(special);
                        return pool.chainAppendCborDouble(tail, n);
                    }
                    catch (NumberFormatException n) {
                        // empty catch block
                    }
                }
                case '(': {
                    String tagStr = diag.substring(start, pos.value);
                    long tag = Long.parseLong(tagStr);
                    tail = pool.chainAppendCborTypePrefix(tail, 192, tag);
                    int parenStart = pos.value++;
                    CborDiagnostics.eatWhitespace(diag, pos);
                    tail = CborDiagnostics.parseTerm(pool, tail, diag, pos);
                    CborDiagnostics.eatWhitespace(diag, pos);
                    if (pos.value >= diag.length() || diag.charAt(pos.value++) != ')') {
                        throw new IllegalArgumentException("Mismatched '(' starting at " + parenStart);
                    }
                    return tail;
                }
                default: {
                    break block14;
                }
            }
            ++pos.value;
        }
        String num = diag.substring(start, pos.value);
        if (!isFloat) {
            try {
                long n = Long.parseLong(num);
                tail = pool.chainAppendCborInteger(tail, n);
                return tail;
            }
            catch (NumberFormatException n) {
                try {
                    BigInteger n2 = new BigInteger(num);
                    tail = pool.chainAppendCborInteger(tail, n2);
                    return tail;
                }
                catch (NumberFormatException n2) {}
            }
        } else {
            try {
                double n = Double.parseDouble(num);
                tail = pool.chainAppendCborDouble(tail, n);
                return tail;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return tail;
    }

    private static SegmentPool.Segment parseMap(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        SegmentPool.Segment subhead;
        int start;
        if (diag.charAt(start = pos.value++) != '{') {
            throw new IllegalArgumentException("Map does not start with { at " + start);
        }
        boolean isStream = false;
        if (diag.charAt(pos.value) == '_') {
            isStream = true;
            ++pos.value;
        }
        boolean complete = false;
        int terms = 0;
        SegmentPool.Segment subtail = subhead = pool.alloc();
        block4: while (pos.value < diag.length()) {
            CborDiagnostics.eatWhitespace(diag, pos);
            if (diag.charAt(pos.value) == '}') {
                ++pos.value;
                complete = true;
                break;
            }
            subtail = CborDiagnostics.parseTerm(pool, subtail, diag, pos);
            CborDiagnostics.eatWhitespace(diag, pos);
            if (diag.charAt(pos.value) != ':') {
                throw new IllegalArgumentException("Expected ':' at " + pos.value);
            }
            ++pos.value;
            CborDiagnostics.eatWhitespace(diag, pos);
            subtail = CborDiagnostics.parseTerm(pool, subtail, diag, pos);
            CborDiagnostics.eatWhitespace(diag, pos);
            char c = diag.charAt(pos.value);
            switch (c) {
                case ',': {
                    ++terms;
                    ++pos.value;
                    continue block4;
                }
                case '}': {
                    ++terms;
                    ++pos.value;
                    complete = true;
                    break block4;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected '" + c + "' at " + pos.value);
                }
            }
        }
        if (!complete) {
            throw new IllegalArgumentException("Incomplete map starting at " + start);
        }
        tail = isStream ? pool.chainAppendCborMapStreamPrefix(tail) : pool.chainAppendCborMapPrefix(tail, terms);
        tail = pool.chainAppend(tail, pool.chainCopyAndRecycle(subhead, 0));
        if (isStream) {
            tail = pool.chainAppend(tail, (byte)-1);
        }
        return tail;
    }

    private static SegmentPool.Segment parseArray(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        SegmentPool.Segment subhead;
        int start;
        if (diag.charAt(start = pos.value++) != '[') {
            throw new IllegalArgumentException("Array does not start with [ at " + start);
        }
        boolean isStream = false;
        if (diag.charAt(pos.value) == '_') {
            isStream = true;
            ++pos.value;
        }
        boolean complete = false;
        int terms = 0;
        SegmentPool.Segment subtail = subhead = pool.alloc();
        block4: while (pos.value < diag.length()) {
            CborDiagnostics.eatWhitespace(diag, pos);
            if (diag.charAt(pos.value) == ']') {
                ++pos.value;
                complete = true;
                break;
            }
            subtail = CborDiagnostics.parseTerm(pool, subtail, diag, pos);
            CborDiagnostics.eatWhitespace(diag, pos);
            char c = diag.charAt(pos.value);
            switch (c) {
                case ',': {
                    ++terms;
                    ++pos.value;
                    continue block4;
                }
                case ']': {
                    ++terms;
                    ++pos.value;
                    complete = true;
                    break block4;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected '" + c + "' at " + pos.value);
                }
            }
        }
        if (!complete) {
            throw new IllegalArgumentException("Incomplete array starting at " + start);
        }
        tail = isStream ? pool.chainAppendCborArrayStreamPrefix(tail) : pool.chainAppendCborArrayPrefix(tail, terms);
        tail = pool.chainAppend(tail, pool.chainCopyAndRecycle(subhead, 0));
        if (isStream) {
            tail = pool.chainAppend(tail, (byte)-1);
        }
        return tail;
    }

    private static SegmentPool.Segment parseTokenOrSimple(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        int type;
        String token;
        int start = pos.value;
        while (pos.value < diag.length()) {
            char c = diag.charAt(pos.value);
            switch (c) {
                case '(': {
                    if (!"simple".equals(diag.substring(start, pos.value))) {
                        throw new IllegalArgumentException("Expected simple() at " + start);
                    }
                    int simpleStart = pos.value;
                    while (diag.charAt(++pos.value) != ')') {
                        if (pos.value < diag.length()) continue;
                        throw new IllegalArgumentException("Unbalanced ( from " + start);
                    }
                    String simple = diag.substring(simpleStart + 1, pos.value);
                    int value = Integer.parseInt(simple);
                    return pool.chainAppendCborSimple(tail, (byte)value);
                }
            }
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) break;
            ++pos.value;
        }
        switch (token = diag.substring(start, pos.value)) {
            case "null": {
                type = 246;
                break;
            }
            case "true": {
                type = 245;
                break;
            }
            case "false": {
                type = 244;
                break;
            }
            case "undefined": {
                type = 247;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized token '" + token + "' at " + start);
            }
        }
        tail = pool.chainAppend(tail, (byte)type);
        return tail;
    }

    private static SegmentPool.Segment parseByteLiteral(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        int start = pos.value;
        switch (diag.charAt(start)) {
            case 'h': {
                return CborDiagnostics.parseByteLiteralHex(pool, tail, diag, pos);
            }
            case 'b': {
                return CborDiagnostics.parseByteLiteralBytes(pool, tail, diag, pos);
            }
        }
        throw new IllegalArgumentException("Byte literal does not begin with b or h starting at " + start);
    }

    private static SegmentPool.Segment parseByteLiteralBytes(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        String encoding;
        int start = pos.value;
        if (start + 3 >= diag.length()) {
            throw new IllegalArgumentException("Unexpected end of literal");
        }
        if (diag.charAt(start) != 'b') {
            throw new IllegalArgumentException("Byte literal does not begin with b at " + start);
        }
        int q = start;
        while (diag.charAt(q++) != '\'') {
            if (q < diag.length()) continue;
            throw new IllegalArgumentException("Unknown byte encoding starting at " + start);
        }
        switch (encoding = diag.substring(start, q - 1)) {
            case "bs": {
                return CborDiagnostics.parseByteLiteralByteString(pool, tail, diag, pos);
            }
            case "b32": {
                throw new IllegalArgumentException("b32 encoding is not supported.");
            }
            case "b64": {
                throw new IllegalArgumentException("b64 encoding is not supported.");
            }
        }
        throw new IllegalArgumentException("Unknown encoding '" + encoding + "'.");
    }

    private static SegmentPool.Segment parseByteLiteralByteString(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        int start = pos.value;
        if (start + 3 >= diag.length()) {
            throw new IllegalArgumentException("Unexpected end of literal");
        }
        if (diag.charAt(start) != 'b' || diag.charAt(start + 1) != 's' || diag.charAt(start + 2) != '\'') {
            throw new IllegalArgumentException("Byte string literal does not begin with bs' at " + start);
        }
        pos.value += 2;
        while (diag.charAt(++pos.value) != '\'') {
            if (pos.value < diag.length()) continue;
            throw new IllegalArgumentException("Unbalanced ' from " + start);
        }
        String bytestr = diag.substring(start + 3, pos.value);
        byte[] bytes = Encoder.encodeUtf8(bytestr);
        tail = pool.chainAppendCborBytes(tail, bytes);
        ++pos.value;
        return tail;
    }

    private static SegmentPool.Segment parseByteLiteralHex(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        int start;
        if ((start = pos.value++) + 2 >= diag.length()) {
            throw new IllegalArgumentException("Unexpected end of literal");
        }
        if (diag.charAt(start) != 'h' || diag.charAt(start + 1) != '\'') {
            throw new IllegalArgumentException("Byte literal does not begin with h' at " + start);
        }
        while (diag.charAt(++pos.value) != '\'') {
            if (pos.value < diag.length()) continue;
            throw new IllegalArgumentException("Unbalanced ' from " + start);
        }
        String bytestr = diag.substring(start + 2, pos.value);
        byte[] bytes = CborDiagnostics.parseRawBytes(bytestr, 0);
        tail = pool.chainAppendCborBytes(tail, bytes);
        ++pos.value;
        return tail;
    }

    private static SegmentPool.Segment parseStringStream(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        SegmentPool.Segment subhead;
        int start = pos.value;
        if (start + 2 >= diag.length()) {
            throw new IllegalArgumentException("Unexpected end of stream");
        }
        if (diag.charAt(start) != '(' || diag.charAt(start + 1) != '_') {
            throw new IllegalArgumentException("String stream does not start with (_ at " + start);
        }
        pos.value += 2;
        boolean complete = false;
        boolean started = false;
        boolean strings = true;
        SegmentPool.Segment subtail = subhead = pool.alloc();
        block4: while (pos.value < diag.length()) {
            CborDiagnostics.eatWhitespace(diag, pos);
            char c = diag.charAt(pos.value);
            if (c == ')') {
                ++pos.value;
                complete = true;
                break;
            }
            if (c != 'h' && c != '\"') {
                throw new IllegalArgumentException("String streams can only contain byte (h'...') or string (\"...\") literals");
            }
            if (!started) {
                strings = diag.charAt(pos.value) == '\"';
                started = true;
            } else {
                if (strings && c != '\"') {
                    throw new IllegalArgumentException("Cannot mix string types in string streams (got byte, expected string)");
                }
                if (!strings && c != 'h') {
                    throw new IllegalArgumentException("Cannot mix string types in string streams (got string, expected byte)");
                }
            }
            subtail = CborDiagnostics.parseTerm(pool, subtail, diag, pos);
            CborDiagnostics.eatWhitespace(diag, pos);
            c = diag.charAt(pos.value);
            switch (c) {
                case ',': {
                    ++pos.value;
                    continue block4;
                }
                case ')': {
                    ++pos.value;
                    complete = true;
                    break block4;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected '" + c + "' at " + pos.value);
                }
            }
        }
        if (!complete) {
            throw new IllegalArgumentException("Incomplete string stream starting at " + start);
        }
        tail = strings ? pool.chainAppendCborStringStreamPrefix(tail) : pool.chainAppendCborBytesStreamPrefix(tail);
        tail = pool.chainAppend(tail, pool.chainCopyAndRecycle(subhead, 0));
        tail = pool.chainAppend(tail, (byte)-1);
        return tail;
    }

    private static SegmentPool.Segment parseEmbeddedCbor(SegmentPool pool, SegmentPool.Segment tail, String diag, IntRef pos) {
        SegmentPool.Segment subhead;
        int start;
        if (diag.charAt(start = pos.value++) != '<') {
            throw new IllegalArgumentException("Embedded CBOR does not start with < at " + start);
        }
        boolean complete = false;
        SegmentPool.Segment subtail = subhead = pool.alloc();
        while (pos.value < diag.length()) {
            CborDiagnostics.eatWhitespace(diag, pos);
            if (diag.charAt(pos.value) == '>') {
                ++pos.value;
                complete = true;
                break;
            }
            subtail = CborDiagnostics.parseTerm(pool, subtail, diag, pos);
            CborDiagnostics.eatWhitespace(diag, pos);
            char c = diag.charAt(pos.value);
            if (c != '>') continue;
            ++pos.value;
            complete = true;
            break;
        }
        if (!complete) {
            throw new IllegalArgumentException("Incomplete embedded CBOR starting at " + start);
        }
        tail = pool.chainAppendCborBytes(tail, pool.chainCopyAndRecycle(subhead, 0));
        return tail;
    }

    private static void eatWhitespace(String diag, IntRef pos) {
        int i = pos.value;
        while (diag.charAt(i) == ' ') {
            i = ++pos.value;
        }
    }

    static byte[] parseRawBytes(String str, int offset) {
        byte[] bytes = new byte[(str.length() - offset) / 2];
        int i = 0;
        int j = offset;
        while (i < bytes.length) {
            int b = Integer.parseInt(str.substring(j, j + 2), 16);
            bytes[i++] = (byte)b;
            j += 2;
        }
        return bytes;
    }
}

