/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.dax.dynamodb.PathElement;

public final class DocumentPath
implements Iterable<PathElement> {
    private final List<PathElement> mElements;

    private DocumentPath(List<PathElement> elements) {
        this.mElements = elements;
    }

    public int size() {
        return this.mElements.size();
    }

    @Override
    public Iterator<PathElement> iterator() {
        return this.mElements.iterator();
    }

    public int hashCode() {
        return Objects.hashCode(this.mElements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DocumentPath)) {
            return false;
        }
        DocumentPath other = (DocumentPath)obj;
        return Objects.equals(this.mElements, other.mElements);
    }

    public String toString() {
        if (this.mElements == null) {
            return "[]";
        }
        return this.mElements.toString();
    }

    static DocumentPath from(String path) {
        return DocumentPath.from(path, Collections.emptyMap());
    }

    static DocumentPath from(String path, Map<String, String> attrNames) {
        if (attrNames == null) {
            attrNames = Collections.emptyMap();
        }
        String[] split = path.split("\\.");
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        for (String element : split) {
            int index = element.indexOf(91);
            if (index == -1) {
                elements.add(PathElement.from(DocumentPath.mapGetOrDefault(attrNames, element, element)));
                continue;
            }
            if (index == 0) {
                throw new IllegalArgumentException("Invalid path: " + path);
            }
            String initial = element.substring(0, index);
            elements.add(PathElement.from(DocumentPath.mapGetOrDefault(attrNames, initial, initial)));
            do {
                if ((index = (element = element.substring(index + 1)).indexOf(93)) == -1) {
                    throw new IllegalArgumentException("Invalid path: " + path);
                }
                int arrayIndex = Integer.parseInt(element.substring(0, index));
                elements.add(PathElement.from(arrayIndex));
                element = element.substring(index + 1);
                index = element.indexOf(91);
                if (index <= 0) continue;
                throw new IllegalArgumentException("Invalid path: " + path);
            } while (index != -1);
            if (element.isEmpty()) continue;
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        return new DocumentPath(Collections.unmodifiableList(elements));
    }

    public static <K, V> V mapGetOrDefault(Map<K, V> map, K key, V defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }
}

