/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.awsv2;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpHeaders;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.disco.agent.event.AwsServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.AwsServiceDownstreamRequestEventImpl;
import software.amazon.disco.agent.event.AwsServiceDownstreamResponseEventImpl;
import software.amazon.disco.agent.event.Event;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.reflect.concurrent.TransactionContext;
import software.amazon.disco.agent.reflect.event.EventBus;

public class DiscoExecutionInterceptor
implements ExecutionInterceptor {
    private static final Logger log = LogManager.getLogger(DiscoExecutionInterceptor.class);
    private static final List<String> REQUEST_ID_KEYS = Arrays.asList("x-amz-request-id", "x-amzn-requestid");
    static final String AWS_SDK_V2_CLIENT_ORIGIN = "AWSv2";
    private static ExecutionAttribute<Object> regionExecutionAttribute;
    static final String TX_REQUEST_EVENT_KEY = "AWSv2RequestEvent";
    static final String TX_RETRY_COUNT_KEY = "AWSv2RetryCount";

    public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        String serviceName = (String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String operationName = (String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        String region = null;
        if (regionExecutionAttribute != null) {
            region = executionAttributes.getAttribute(regionExecutionAttribute).toString();
        }
        AwsServiceDownstreamRequestEvent awsEvent = new AwsServiceDownstreamRequestEventImpl(AWS_SDK_V2_CLIENT_ORIGIN, serviceName, operationName).withRegion(region);
        awsEvent.withRequest(context.request());
        TransactionContext.putMetadata((String)TX_REQUEST_EVENT_KEY, (Object)awsEvent);
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        AwsServiceDownstreamRequestEventImpl requestEvent = (AwsServiceDownstreamRequestEventImpl)TransactionContext.getMetadata((String)TX_REQUEST_EVENT_KEY);
        SdkHttpRequest sdkHttpRequest = context.httpRequest();
        requestEvent.withSdkHttpRequest(sdkHttpRequest).withHeaderMap(context.httpRequest().headers());
        EventBus.publish((Event)requestEvent);
        return requestEvent.getSdkHttpRequest() != null ? requestEvent.getSdkHttpRequest() : context.httpRequest();
    }

    public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
        Object retryCountObj = TransactionContext.getMetadata((String)TX_RETRY_COUNT_KEY);
        int retryCount = retryCountObj == null ? 0 : (Integer)retryCountObj + 1;
        TransactionContext.putMetadata((String)TX_RETRY_COUNT_KEY, (Object)retryCount);
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        AwsServiceDownstreamRequestEvent requestEvent = (AwsServiceDownstreamRequestEvent)TransactionContext.getMetadata((String)TX_REQUEST_EVENT_KEY);
        Object txRetryCount = TransactionContext.getMetadata((String)TX_RETRY_COUNT_KEY);
        TransactionContext.removeMetadata((String)TX_RETRY_COUNT_KEY);
        int retryCount = txRetryCount == null ? 0 : (Integer)txRetryCount;
        SdkHttpResponse httpResponse = context.httpResponse();
        AwsServiceDownstreamResponseEventImpl awsEvent = new AwsServiceDownstreamResponseEventImpl(requestEvent).withSdkHttpResponse(httpResponse).withHeaderMap(httpResponse.headers()).withRequestId(this.extractRequestId(httpResponse)).withRetryCount(retryCount);
        awsEvent.withResponse((Object)context.response());
        EventBus.publish((Event)awsEvent);
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        AwsServiceDownstreamRequestEvent requestEvent = (AwsServiceDownstreamRequestEvent)TransactionContext.getMetadata((String)TX_REQUEST_EVENT_KEY);
        Object txRetryCount = TransactionContext.getMetadata((String)TX_RETRY_COUNT_KEY);
        TransactionContext.removeMetadata((String)TX_RETRY_COUNT_KEY);
        int retryCount = txRetryCount == null ? 0 : (Integer)txRetryCount;
        AwsServiceDownstreamResponseEventImpl awsEvent = new AwsServiceDownstreamResponseEventImpl(requestEvent).withSdkHttpResponse((SdkHttpResponse)context.httpResponse().orElse(null)).withHeaderMap(context.httpResponse().map(SdkHttpHeaders::headers).orElse(CollectionUtils.unmodifiableMapOfLists(new HashMap()))).withRequestId((String)context.httpResponse().map(arg_0 -> this.extractRequestId(arg_0)).orElse(null)).withRetryCount(retryCount);
        awsEvent.withThrown(context.exception());
        EventBus.publish((Event)awsEvent);
    }

    private String extractRequestId(SdkHttpResponse httpResponse) {
        Map headerMap = httpResponse.headers();
        if (headerMap == null) {
            return null;
        }
        for (String request_id_key : REQUEST_ID_KEYS) {
            List requestIdList = (List)headerMap.get(request_id_key);
            if (requestIdList == null || requestIdList.size() <= 0) continue;
            return (String)requestIdList.get(0);
        }
        return null;
    }

    static {
        try {
            Class<?> clazz = Class.forName("software.amazon.awssdk.awscore.AwsExecutionAttribute");
            Field field = clazz.getField("AWS_REGION");
            regionExecutionAttribute = (ExecutionAttribute)field.get(null);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            log.debug("Failed to access AwsExecutionAttribute.AWS_REGION field, region will not be recorded in AwsServiceEvents");
        }
    }
}

