/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.event.AbstractServiceRequestEvent;
import software.amazon.disco.agent.event.AbstractServiceResponseEvent;
import software.amazon.disco.agent.event.Event;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.ServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.ServiceDownstreamResponseEvent;
import software.amazon.disco.agent.event.ServiceRequestEvent;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class ConnectionInterceptor
implements Installable {
    public static final Logger log = LogManager.getLogger(ConnectionInterceptor.class);
    public static final String SQL_PREPARE_ORIGIN = "SqlPrepare";

    @Advice.OnMethodEnter
    public static ServiceRequestEvent enter(@Advice.Argument(value=0) String queryString, @Advice.Origin String origin, @Advice.This Connection conn) {
        if (LogManager.isDebugEnabled()) {
            log.debug("DiSCo(Sql) interception of " + origin);
        }
        String db = null;
        try {
            db = conn.getCatalog();
        }
        catch (Exception e) {
            log.warn("Disco(Sql) failed to retrieve Database name for SQL Downstream Service event", (Throwable)e);
        }
        AbstractServiceRequestEvent requestEvent = new ServiceDownstreamRequestEvent(SQL_PREPARE_ORIGIN, db, queryString).withRequest((Object)conn);
        EventBus.publish((Event)requestEvent);
        return requestEvent;
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class)
    public static void exit(@Advice.Enter ServiceRequestEvent requestEvent, @Advice.Return PreparedStatement response, @Advice.Thrown Throwable thrown) {
        AbstractServiceResponseEvent responseEvent = new ServiceDownstreamResponseEvent(SQL_PREPARE_ORIGIN, requestEvent.getService(), requestEvent.getOperation(), requestEvent).withResponse((Object)response).withThrown(thrown);
        EventBus.publish((Event)responseEvent);
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(ConnectionInterceptor.buildClassMatcher()).transform((AgentBuilder.Transformer)new AgentBuilder.Transformer.ForAdvice().include(new ClassLoader[]{this.getClass().getClassLoader()}).advice(ConnectionInterceptor.buildMethodMatcher(), ConnectionInterceptor.class.getName()));
    }

    static ElementMatcher<? super TypeDescription> buildClassMatcher() {
        return ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"java.sql.Connection")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()));
    }

    static ElementMatcher<? super MethodDescription> buildMethodMatcher() {
        return ElementMatchers.nameStartsWith((String)"prepare").and((ElementMatcher)ElementMatchers.takesArgument((int)0, String.class)).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"java.sql.PreparedStatement"))));
    }
}

