/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.web.apache.event;

import java.util.List;
import java.util.Map;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import software.amazon.disco.agent.event.DownstreamRequestHeaderRetrievable;
import software.amazon.disco.agent.event.HeaderReplaceable;
import software.amazon.disco.agent.event.HttpServiceDownstreamRequestEvent;
import software.amazon.disco.agent.web.apache.event.ApacheHttpClientRetrievableHeaders;

class ApacheHttpServiceDownstreamRequestEvent
extends HttpServiceDownstreamRequestEvent
implements HeaderReplaceable,
DownstreamRequestHeaderRetrievable {
    private final HttpRequest request;
    private final ApacheHttpClientRetrievableHeaders headers;

    public ApacheHttpServiceDownstreamRequestEvent(String origin, String service, String operation, HttpRequest request) {
        super(origin, service, operation);
        this.request = request;
        this.headers = new ApacheHttpClientRetrievableHeaders((HttpMessage)request);
    }

    public boolean replaceHeader(String name, String value) {
        this.request.removeHeaders(name);
        this.request.addHeader(name, value);
        return true;
    }

    public String getFirstHeader(String key) {
        return this.headers.getFirstHeader(key);
    }

    public List<String> getHeaders(String key) {
        return this.headers.getHeaders(key);
    }

    public Map<String, List<String>> getAllHeaders() {
        return this.headers.getAllHeaders();
    }
}

