/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent;

import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import software.amazon.disco.agent.DiscoAgentTemplate;
import software.amazon.disco.agent.concurrent.ConcurrencySupport;
import software.amazon.disco.agent.config.AgentConfig;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.plugin.PluginOutcome;

public class DiscoAgent {
    private static Logger log = LogManager.getLogger(DiscoAgent.class);

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        DiscoAgent.impl(agentArgs, instrumentation);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        DiscoAgent.impl(agentArgs, instrumentation);
    }

    private static void impl(String agentArgs, Instrumentation instrumentation) {
        log.info("DiSCo(Agent) starting agent");
        DiscoAgentTemplate agent = new DiscoAgentTemplate(agentArgs);
        AgentConfig config = agent.getConfig();
        if (config.getPluginPath() == null) {
            log.warn("DiSCo(Agent) no pluginPath configured, agent is effectively inert. Are you sure that's what you intended?");
        }
        Collection<PluginOutcome> outcomes = agent.install(instrumentation, new HashSet<Installable>(new ConcurrencySupport().get()));
        DiscoAgent.dump(outcomes);
        log.info("DiSCo(Agent) agent startup complete");
    }

    private static void dump(Collection<PluginOutcome> outcomes) {
        for (PluginOutcome outcome : outcomes) {
            StringBuilder builder = new StringBuilder();
            builder.append("DiSCo(Agent) Plugin name: ").append(outcome.name).append("\n");
            builder.append("\tBootstrap: ").append(outcome.bootstrap ? "yes" : "no").append("\n");
            if (outcome.initClass != null) {
                builder.append("\tInit: ").append(outcome.initClass.getName()).append("\n");
            }
            if (outcome.installables != null && !outcome.installables.isEmpty()) {
                ArrayList installableStrings = new ArrayList(outcome.installables.size());
                outcome.installables.forEach(i -> installableStrings.add(i.getClass().getName()));
                builder.append("\tInstallables: ").append(String.join((CharSequence)", ", installableStrings.toArray(new String[0]))).append("\n");
            }
            if (outcome.listeners != null && !outcome.listeners.isEmpty()) {
                ArrayList listenerStrings = new ArrayList(outcome.listeners.size());
                outcome.listeners.forEach(l -> listenerStrings.add(l.getClass().getName()));
                builder.append("\tListeners: ").append(String.join((CharSequence)", ", listenerStrings.toArray(new String[0]))).append("\n");
            }
            log.info(builder.toString());
        }
    }
}

