/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRel;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRules;

public class DocumentDbSort
extends Sort
implements DocumentDbRel {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentDbSort.class.getName());

    public DocumentDbSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, collation, offset, fetch);
        assert (this.getConvention() == DocumentDbRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost relOptCost = super.computeSelfCost(planner, mq);
        return relOptCost != null ? relOptCost.multiplyBy(0.05) : null;
    }

    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new DocumentDbSort(this.getCluster(), traitSet, input, this.collation, offset, fetch);
    }

    @Override
    public void implement(DocumentDbRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        if (!this.collation.getFieldCollations().isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>();
            for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                List<String> names = DocumentDbRules.mongoFieldNames(this.getRowType(), implementor.getMetadataTable());
                String name = names.get(fieldCollation.getFieldIndex());
                keys.add(DocumentDbRules.maybeQuote(name) + ": " + DocumentDbSort.direction(fieldCollation));
            }
            implementor.add(null, "{$sort: " + Util.toString(keys, (String)"{", (String)", ", (String)"}") + "}");
        }
        if (this.offset != null) {
            implementor.add(null, "{$skip: " + ((RexLiteral)this.offset).getValue() + "}");
        }
        if (this.fetch != null) {
            implementor.add(null, "{$limit: {$numberLong: \"" + ((RexLiteral)this.fetch).getValue() + "\"}}");
        }
        LOGGER.info("Created sort and row limit stages of pipeline.");
        LOGGER.debug("Pipeline stages added: {}", implementor.getList().stream().map(c -> (String)c.right).toArray());
    }

    private static int direction(RelFieldCollation fieldCollation) {
        switch (fieldCollation.getDirection()) {
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return -1;
            }
        }
        return 1;
    }
}

