/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import org.bson.BsonType;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonProperty;
import software.amazon.documentdb.jdbc.common.utilities.JdbcType;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

@JsonSerialize(as=DocumentDbSchemaColumn.class)
public class DocumentDbSchemaColumn {
    public static final String SQL_TYPE_PROPERTY = "sqlType";
    public static final String DB_TYPE_PROPERTY = "dbType";
    public static final String IS_INDEX_PROPERTY = "isIndex";
    public static final String IS_PRIMARY_KEY_PROPERTY = "isPrimaryKey";
    public static final String FOREIGN_KEY_TABLE_NAME_PROPERTY = "foreignKeyTableName";
    public static final String FOREIGN_KEY_COLUMN_NAME_PROPERTY = "foreignKeyColumnName";
    public static final String FIELD_PATH_PROPERTY = "fieldPath";
    @BsonProperty(value="fieldPath")
    @JsonProperty(value="fieldPath")
    @NonNull
    private final String fieldPath;
    @BsonProperty(value="sqlName")
    @JsonProperty(value="sqlName")
    @NonNull
    private String sqlName;
    @BsonProperty(value="sqlType")
    @JsonProperty(value="sqlType")
    private JdbcType sqlType;
    @BsonProperty(value="dbType")
    @JsonProperty(value="dbType")
    private final BsonType dbType;
    @BsonProperty(value="isIndex")
    @JsonProperty(value="isIndex")
    private final boolean index;
    @BsonProperty(value="isPrimaryKey")
    @JsonProperty(value="isPrimaryKey")
    private final boolean primaryKey;
    @BsonProperty(value="foreignKeyTableName")
    @JsonProperty(value="foreignKeyTableName")
    private String foreignKeyTableName;
    @BsonProperty(value="foreignKeyColumnName")
    @JsonProperty(value="foreignKeyColumnName")
    private String foreignKeyColumnName;

    @BsonCreator
    public DocumentDbSchemaColumn(@JsonProperty(value="fieldPath") @BsonProperty(value="fieldPath") String fieldPath, @JsonProperty(value="sqlName") @BsonProperty(value="sqlName") String sqlName, @JsonProperty(value="sqlType") @BsonProperty(value="sqlType") JdbcType sqlType, @JsonProperty(value="dbType") @BsonProperty(value="dbType") BsonType dbType, @JsonProperty(value="isIndex") @BsonProperty(value="isIndex") boolean index, @JsonProperty(value="isPrimaryKey") @BsonProperty(value="isPrimaryKey") boolean primaryKey, @JsonProperty(value="foreignKeyTableName") @BsonProperty(value="foreignKeyTableName") String foreignKeyTableName, @JsonProperty(value="foreignKeyColumnName") @BsonProperty(value="foreignKeyColumnName") String foreignKeyColumnName) {
        this.fieldPath = fieldPath;
        this.sqlName = sqlName;
        this.sqlType = sqlType;
        this.dbType = dbType;
        this.index = index;
        this.primaryKey = primaryKey;
        this.foreignKeyTableName = foreignKeyTableName;
        this.foreignKeyColumnName = foreignKeyColumnName;
    }

    public Optional<Integer> getIndex(DocumentDbSchemaTable table) {
        Integer colIndex = 0;
        for (DocumentDbSchemaColumn column : table.getColumnMap().values()) {
            Integer n = colIndex;
            Integer n2 = colIndex = Integer.valueOf(colIndex + 1);
            if (!column.getSqlName().equals(this.getSqlName())) continue;
            return Optional.of(colIndex);
        }
        return Optional.empty();
    }

    public Optional<Integer> getPrimaryKeyIndex(DocumentDbSchemaTable table) {
        Integer keyIndex = 0;
        for (DocumentDbSchemaColumn column : table.getColumnMap().values()) {
            if (column.isPrimaryKey()) {
                Integer n = keyIndex;
                Integer n2 = keyIndex = Integer.valueOf(keyIndex + 1);
                if (!column.getSqlName().equals(this.getSqlName())) continue;
                return Optional.of(keyIndex);
            }
            if (!column.getSqlName().equals(this.getSqlName())) continue;
            return Optional.of(0);
        }
        return Optional.empty();
    }

    public Optional<Integer> getForeignKeyIndex(DocumentDbSchemaTable table) {
        if (table.getSqlName().equals(this.getForeignKeyTableName())) {
            Integer keyIndex = 0;
            for (DocumentDbSchemaColumn column : table.getColumnMap().values()) {
                if (!column.isPrimaryKey()) continue;
                Integer n = keyIndex;
                Integer n2 = keyIndex = Integer.valueOf(keyIndex + 1);
                if (!column.getSqlName().equals(this.getForeignKeyColumnName())) continue;
                return Optional.of(keyIndex);
            }
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDbSchemaColumn)) {
            return false;
        }
        DocumentDbSchemaColumn that = (DocumentDbSchemaColumn)o;
        return this.index == that.index && this.primaryKey == that.primaryKey && this.fieldPath.equals(that.fieldPath) && this.sqlName.equals(that.sqlName) && this.sqlType == that.sqlType && this.dbType == that.dbType && Objects.equals(this.foreignKeyTableName, that.foreignKeyTableName) && Objects.equals(this.foreignKeyColumnName, that.foreignKeyColumnName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldPath, this.sqlName, this.sqlType, this.dbType, this.index, this.primaryKey, this.foreignKeyTableName, this.foreignKeyColumnName});
    }

    public String toString() {
        return "DocumentDbSchemaColumn{fieldPath='" + this.fieldPath + '\'' + ", sqlName='" + this.sqlName + '\'' + ", sqlType=" + (Object)((Object)this.sqlType) + ", dbType=" + this.dbType + ", index=" + this.index + ", primaryKey=" + this.primaryKey + ", foreignKeyTableName='" + this.foreignKeyTableName + '\'' + ", foreignKeyColumnName='" + this.foreignKeyColumnName + '\'' + '}';
    }

    @NonNull
    public String getFieldPath() {
        return this.fieldPath;
    }

    @NonNull
    public String getSqlName() {
        return this.sqlName;
    }

    public JdbcType getSqlType() {
        return this.sqlType;
    }

    public BsonType getDbType() {
        return this.dbType;
    }

    public boolean isIndex() {
        return this.index;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String getForeignKeyTableName() {
        return this.foreignKeyTableName;
    }

    public String getForeignKeyColumnName() {
        return this.foreignKeyColumnName;
    }

    @JsonProperty(value="sqlName")
    public void setSqlName(@NonNull String sqlName) {
        if (sqlName == null) {
            throw new NullPointerException("sqlName is marked non-null but is null");
        }
        this.sqlName = sqlName;
    }

    @JsonProperty(value="sqlType")
    public void setSqlType(JdbcType sqlType) {
        this.sqlType = sqlType;
    }

    @JsonProperty(value="foreignKeyTableName")
    public void setForeignKeyTableName(String foreignKeyTableName) {
        this.foreignKeyTableName = foreignKeyTableName;
    }

    @JsonProperty(value="foreignKeyColumnName")
    public void setForeignKeyColumnName(String foreignKeyColumnName) {
        this.foreignKeyColumnName = foreignKeyColumnName;
    }
}

