/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.encryption.s3.S3EncryptionClientSecurityException;
import software.amazon.encryption.s3.materials.CryptographicMaterials;

public class CipherSubscriber
implements Subscriber<ByteBuffer> {
    private final AtomicLong contentRead = new AtomicLong(0L);
    private final Subscriber<? super ByteBuffer> wrappedSubscriber;
    private Cipher cipher;
    private final Long contentLength;
    private boolean isLastPart;
    private byte[] outputBuffer;

    CipherSubscriber(Subscriber<? super ByteBuffer> wrappedSubscriber, Long contentLength, CryptographicMaterials materials, byte[] iv, boolean isLastPart) {
        this.wrappedSubscriber = wrappedSubscriber;
        this.contentLength = contentLength;
        this.cipher = materials.getCipher(iv);
        this.isLastPart = isLastPart;
    }

    CipherSubscriber(Subscriber<? super ByteBuffer> wrappedSubscriber, Long contentLength, CryptographicMaterials materials, byte[] iv) {
        this(wrappedSubscriber, contentLength, materials, iv, true);
    }

    public void onSubscribe(Subscription s) {
        this.wrappedSubscriber.onSubscribe(s);
    }

    public void onNext(ByteBuffer byteBuffer) {
        int amountToReadFromByteBuffer = this.getAmountToReadFromByteBuffer(byteBuffer);
        if (amountToReadFromByteBuffer > 0) {
            byte[] buf = BinaryUtils.copyBytesFrom((ByteBuffer)byteBuffer, (int)amountToReadFromByteBuffer);
            this.outputBuffer = this.cipher.update(buf, 0, amountToReadFromByteBuffer);
            if (this.outputBuffer == null || this.outputBuffer.length == 0) {
                if (this.contentRead.get() == this.contentLength.longValue()) {
                    this.onComplete();
                }
                this.wrappedSubscriber.onNext((Object)ByteBuffer.allocate(0));
            } else {
                this.wrappedSubscriber.onNext((Object)ByteBuffer.wrap(this.outputBuffer));
            }
        } else {
            this.wrappedSubscriber.onNext((Object)byteBuffer);
        }
    }

    private int getAmountToReadFromByteBuffer(ByteBuffer byteBuffer) {
        if (this.contentLength == null) {
            return byteBuffer.remaining();
        }
        long amountReadSoFar = this.contentRead.getAndAdd(byteBuffer.remaining());
        long amountRemaining = Math.max(0L, this.contentLength - amountReadSoFar);
        if (amountRemaining > (long)byteBuffer.remaining()) {
            return byteBuffer.remaining();
        }
        return Math.toIntExact(amountRemaining);
    }

    public void onError(Throwable t) {
        this.wrappedSubscriber.onError(t);
    }

    public void onComplete() {
        if (!this.isLastPart) {
            this.wrappedSubscriber.onComplete();
            return;
        }
        try {
            this.outputBuffer = this.cipher.doFinal();
            this.wrappedSubscriber.onNext((Object)ByteBuffer.wrap(this.outputBuffer));
        }
        catch (GeneralSecurityException exception) {
            this.wrappedSubscriber.onError((Throwable)exception);
            throw new S3EncryptionClientSecurityException(exception.getMessage(), exception);
        }
        this.wrappedSubscriber.onComplete();
    }
}

