/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.flink.avro;

import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializationFacade;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.flink.formats.avro.utils.MutableByteArrayInputStream;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

public class GlueSchemaRegistryInputStreamDeserializer {
    private final GlueSchemaRegistryDeserializationFacade glueSchemaRegistryDeserializationFacade;

    public GlueSchemaRegistryInputStreamDeserializer(Map<String, Object> configs) {
        GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(configs);
        glueSchemaRegistryConfiguration.setUserAgentApp("flink");
        this.glueSchemaRegistryDeserializationFacade = new GlueSchemaRegistryDeserializationFacade(glueSchemaRegistryConfiguration, (AwsCredentialsProvider)DefaultCredentialsProvider.builder().build());
    }

    public GlueSchemaRegistryInputStreamDeserializer(GlueSchemaRegistryDeserializationFacade glueSchemaRegistryDeserializationFacade) {
        this.glueSchemaRegistryDeserializationFacade = glueSchemaRegistryDeserializationFacade;
    }

    public Schema getSchemaAndDeserializedStream(InputStream in) throws IOException {
        Schema schema;
        byte[] inputBytes = new byte[in.available()];
        in.read(inputBytes);
        in.reset();
        MutableByteArrayInputStream mutableByteArrayInputStream = (MutableByteArrayInputStream)in;
        String schemaDefinition = this.glueSchemaRegistryDeserializationFacade.getSchema(inputBytes).getSchemaDefinition();
        byte[] deserializedBytes = this.glueSchemaRegistryDeserializationFacade.getActualData(inputBytes);
        mutableByteArrayInputStream.setBuffer(deserializedBytes);
        try {
            schema = new Schema.Parser().parse(schemaDefinition);
        }
        catch (SchemaParseException e) {
            String message = "Error occurred while parsing schema, see inner exception for details.";
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
        return schema;
    }
}

