/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers.avro;

import com.amazonaws.services.schemaregistry.common.AWSDeserializerInput;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializer;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializerDataParser;
import com.amazonaws.services.schemaregistry.deserializers.avro.SecondaryDeserializer;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import java.nio.ByteBuffer;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

public class AWSKafkaAvroDeserializer
implements Deserializer<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSKafkaAvroDeserializer.class);
    private final AwsCredentialsProvider credentialProvider;
    private AWSDeserializer awsDeserializer;

    public AWSKafkaAvroDeserializer() {
        this((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build(), null);
    }

    public AWSKafkaAvroDeserializer(@NonNull Map<String, ?> configs) {
        this((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build(), configs);
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked @NonNull but is null");
        }
    }

    public AWSKafkaAvroDeserializer(AwsCredentialsProvider credentialProvider, Map<String, ?> configs) {
        this.credentialProvider = credentialProvider;
        if (configs != null) {
            this.configure(configs, false);
        }
    }

    public void configure(@NonNull Map<String, ?> configs, boolean isKey) {
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked @NonNull but is null");
        }
        log.info("Configuring Amazon Schema Registry Service using these properties: {}", (Object)configs.toString());
        this.awsDeserializer = AWSDeserializer.builder().credentialProvider(this.credentialProvider).configs(configs).build();
        if (configs.containsKey("secondaryDeserializer")) {
            this.configureSecondaryDeser(configs, isKey);
        }
    }

    public Object deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        Byte headerVersionByte = this.getHeaderVersionByte(data);
        Object result = this.deserializeByHeaderVersionByte(topic, data, headerVersionByte);
        return result;
    }

    public void close() {
        this.awsDeserializer.close();
    }

    private AWSDeserializerInput prepareInput(byte[] data, String topic) {
        return AWSDeserializerInput.builder().buffer(ByteBuffer.wrap(data)).transportName(topic).build();
    }

    private void configureSecondaryDeser(Map<String, ?> configs, boolean isKey) {
        if (!SecondaryDeserializer.getInstance().validate(configs)) {
            throw new AWSSchemaRegistryException("The secondary deserializer is not from Kafka");
        }
        SecondaryDeserializer.getInstance().configure(configs, isKey);
    }

    private Object deserializeByHeaderVersionByte(String topic, byte[] data, Byte headerVersionByte) {
        return headerVersionByte.equals((byte)3) ? this.awsDeserializer.deserialize(this.prepareInput(data, topic)) : SecondaryDeserializer.getInstance().deserialize(topic, data);
    }

    private Byte getHeaderVersionByte(byte[] data) {
        AWSDeserializerDataParser dataParser = AWSDeserializerDataParser.getInstance();
        return dataParser.getHeaderVersionByte(ByteBuffer.wrap(data));
    }

    @Generated
    public AwsCredentialsProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    @Generated
    public AWSDeserializer getAwsDeserializer() {
        return this.awsDeserializer;
    }

    @Generated
    public void setAwsDeserializer(AWSDeserializer awsDeserializer) {
        this.awsDeserializer = awsDeserializer;
    }
}

