/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers;

import com.amazonaws.services.schemaregistry.caching.AWSCache;
import com.amazonaws.services.schemaregistry.caching.AWSSchemaRegistrySerializerCache;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryGlueClientRetryPolicyHelper;
import com.amazonaws.services.schemaregistry.common.AWSSerializerInput;
import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.SerializationDataEncoder;
import com.amazonaws.services.schemaregistry.serializers.avro.AvroSerializer;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.google.common.cache.CacheStats;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;

public class GlueSchemaRegistrySerializationFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistrySerializationFacade.class);
    private AWSSchemaRegistryClient awsSchemaRegistryClient;
    private static final String AVRO_SCHEMA_TYPE = DataFormat.AVRO.name();
    private SerializationDataEncoder serializationDataEncoder;
    private GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration;
    private AWSCache<Schema, UUID, CacheStats> cache;

    public GlueSchemaRegistrySerializationFacade(@NonNull AwsCredentialsProvider credentialProvider, AWSSchemaRegistryClient schemaRegistryClient, @NonNull GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration) {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("credentialProvider is marked @NonNull but is null");
        }
        if (glueSchemaRegistryConfiguration == null) {
            throw new IllegalArgumentException("glueSchemaRegistryConfiguration is marked @NonNull but is null");
        }
        this.glueSchemaRegistryConfiguration = glueSchemaRegistryConfiguration;
        this.awsSchemaRegistryClient = schemaRegistryClient != null ? schemaRegistryClient : new AWSSchemaRegistryClient(credentialProvider, glueSchemaRegistryConfiguration, AWSSchemaRegistryGlueClientRetryPolicyHelper.getRetryPolicy());
        this.serializationDataEncoder = new SerializationDataEncoder(glueSchemaRegistryConfiguration);
        this.cache = AWSSchemaRegistrySerializerCache.getInstance((GlueSchemaRegistryConfiguration)glueSchemaRegistryConfiguration);
    }

    public UUID getOrRegisterSchemaVersion(@NonNull AWSSerializerInput serializerInput) {
        if (serializerInput == null) {
            throw new IllegalArgumentException("serializerInput is marked @NonNull but is null");
        }
        String schemaDefinition = serializerInput.getSchemaDefinition();
        String schemaName = serializerInput.getSchemaName();
        String transportName = serializerInput.getTransportName();
        Schema key = new Schema(schemaDefinition, AVRO_SCHEMA_TYPE, schemaName);
        Map<String, String> metadata = this.constructSchemaVersionMetadata(transportName);
        UUID schemaVersionId = (UUID)this.cache.get((Object)key);
        if (schemaVersionId == null) {
            schemaVersionId = this.awsSchemaRegistryClient.getORRegisterSchemaVersionId(schemaDefinition, schemaName, AVRO_SCHEMA_TYPE, metadata);
            this.cache.put((Object)key, (Object)schemaVersionId);
            log.debug("Cache stats {}", this.cache.getCacheStats());
        }
        return schemaVersionId;
    }

    private Map<String, String> constructSchemaVersionMetadata(String transportName) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("x-amz-meta-transport", transportName);
        if (this.glueSchemaRegistryConfiguration.getMetadata() != null) {
            metadata.putAll(this.glueSchemaRegistryConfiguration.getMetadata());
        }
        return metadata;
    }

    public byte[] serialize(DataFormat dataFormat, @NonNull Object data, @NonNull UUID schemaVersionId) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked @NonNull but is null");
        }
        if (schemaVersionId == null) {
            throw new IllegalArgumentException("schemaVersionId is marked @NonNull but is null");
        }
        if (!DataFormat.AVRO.equals((Object)dataFormat)) {
            throw new AWSSchemaRegistryException("Unsupported data format: " + dataFormat);
        }
        byte[] avroSerializedBytes = new AvroSerializer(AVROUtils.getInstance().getSchema(data)).serialize(data);
        return this.serializationDataEncoder.write(avroSerializedBytes, schemaVersionId);
    }

    public byte[] encode(String transportName, Schema schema, byte[] data) {
        UUID schemaVersionId = this.getOrRegisterSchemaVersion(AWSSerializerInput.builder().schemaDefinition(schema.getSchemaDefinition()).schemaName(schema.getSchemaName()).transportName(transportName).build());
        return this.serializationDataEncoder.write(data, schemaVersionId);
    }

    @Generated
    public static GlueSchemaRegistrySerializationFacadeBuilder builder() {
        return new GlueSchemaRegistrySerializationFacadeBuilder();
    }

    @Generated
    public void setCache(AWSCache<Schema, UUID, CacheStats> cache) {
        this.cache = cache;
    }

    @Generated
    public AWSCache<Schema, UUID, CacheStats> getCache() {
        return this.cache;
    }

    @Generated
    public static class GlueSchemaRegistrySerializationFacadeBuilder {
        @Generated
        private AwsCredentialsProvider credentialProvider;
        @Generated
        private AWSSchemaRegistryClient schemaRegistryClient;
        @Generated
        private GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration;

        @Generated
        GlueSchemaRegistrySerializationFacadeBuilder() {
        }

        @Generated
        public GlueSchemaRegistrySerializationFacadeBuilder credentialProvider(AwsCredentialsProvider credentialProvider) {
            this.credentialProvider = credentialProvider;
            return this;
        }

        @Generated
        public GlueSchemaRegistrySerializationFacadeBuilder schemaRegistryClient(AWSSchemaRegistryClient schemaRegistryClient) {
            this.schemaRegistryClient = schemaRegistryClient;
            return this;
        }

        @Generated
        public GlueSchemaRegistrySerializationFacadeBuilder glueSchemaRegistryConfiguration(GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration) {
            this.glueSchemaRegistryConfiguration = glueSchemaRegistryConfiguration;
            return this;
        }

        @Generated
        public GlueSchemaRegistrySerializationFacade build() {
            return new GlueSchemaRegistrySerializationFacade(this.credentialProvider, this.schemaRegistryClient, this.glueSchemaRegistryConfiguration);
        }

        @Generated
        public String toString() {
            return "GlueSchemaRegistrySerializationFacade.GlueSchemaRegistrySerializationFacadeBuilder(credentialProvider=" + this.credentialProvider + ", schemaRegistryClient=" + this.schemaRegistryClient + ", glueSchemaRegistryConfiguration=" + this.glueSchemaRegistryConfiguration + ")";
        }
    }
}

