/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializerDataParser;
import com.amazonaws.services.schemaregistry.exception.AWSIncompatibleDataException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AWSDeserializerDataParserTest {
    private byte[] constructSerializedData(byte headerVersionByte, byte compressionByte, UUID uuid) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[18]);
        byteBuffer.put(headerVersionByte);
        byteBuffer.put(compressionByte);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return byteBuffer.array();
    }

    @Test
    public void test_InvalidHeader_ThrowsAWSIncompatibleDataException() {
        byte[] serializedData = this.constructSerializedData((byte)99, (byte)5, UUID.randomUUID());
        Exception exception = (Exception)Assertions.assertThrows(AWSIncompatibleDataException.class, () -> AWSDeserializerDataParser.getInstance().getSchemaVersionId(ByteBuffer.wrap(serializedData)));
        Assertions.assertEquals((Object)"Invalid schema registry header version byte in data", (Object)exception.getMessage());
    }

    @Test
    public void test_Invalid_Compression_Byte() {
        byte[] serializedData = this.constructSerializedData((byte)3, (byte)99, UUID.randomUUID());
        StringBuilder errorBuilder = new StringBuilder();
        Assertions.assertFalse((boolean)AWSDeserializerDataParser.getInstance().isDataCompatible(ByteBuffer.wrap(serializedData), errorBuilder));
        Assertions.assertEquals((Object)"Invalid schema registry compression byte in data", (Object)errorBuilder.toString());
    }

    @Test
    public void test_Invalid_Length() {
        StringBuilder errorBuilder = new StringBuilder();
        Assertions.assertFalse((boolean)AWSDeserializerDataParser.getInstance().isDataCompatible(ByteBuffer.wrap(new byte[2]), errorBuilder));
        Assertions.assertTrue((boolean)errorBuilder.toString().contains("Data is not compatible with schema registry"));
    }

    @Test
    public void test_Success() {
        StringBuilder errorBuilder = new StringBuilder();
        byte[] serializedData = this.constructSerializedData((byte)3, (byte)5, UUID.randomUUID());
        Assertions.assertTrue((boolean)AWSDeserializerDataParser.getInstance().isDataCompatible(ByteBuffer.wrap(serializedData), errorBuilder));
    }
}

