/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.common.AWSDataFormatDeserializer;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializerFactory;
import com.amazonaws.services.schemaregistry.deserializers.avro.AWSAvroDeserializer;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import software.amazon.awssdk.services.glue.model.DataFormat;

@ExtendWith(value={MockitoExtension.class})
public class AWSDeserializerFactoryTest {
    private Map<String, Object> getTestConfigMap() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("avroRecordType", AvroRecordType.GENERIC_RECORD.getName());
        configMap.put("compression", AWSSchemaRegistryConstants.COMPRESSION.NONE.name());
        configMap.put("endpoint", "https://test");
        configMap.put("region", "US-West-1");
        return configMap;
    }

    @Test
    public void testGetInstance_Avro_createObject_succeeds() {
        Map<String, Object> configMap = this.getTestConfigMap();
        GlueSchemaRegistryConfiguration configs = new GlueSchemaRegistryConfiguration(configMap);
        AWSDeserializerFactory awsDeserializerFactory = new AWSDeserializerFactory();
        AWSDataFormatDeserializer deserializer = awsDeserializerFactory.getInstance(DataFormat.AVRO, configs);
        Assertions.assertEquals(AWSAvroDeserializer.class, deserializer.getClass());
    }

    @Test
    public void testGetInstance_UnsupportedDataFormat_throwsException() {
        AWSDeserializerFactory awsDeserializerFactory = new AWSDeserializerFactory();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> awsDeserializerFactory.getInstance(DataFormat.UNKNOWN_TO_SDK_VERSION, new GlueSchemaRegistryConfiguration(this.getTestConfigMap())));
    }

    @Test
    public void testGetInstance_nullDataFormat_throwsException() {
        AWSDeserializerFactory awsDeserializerFactory = new AWSDeserializerFactory();
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsDeserializerFactory.getInstance(null, new GlueSchemaRegistryConfiguration(this.getTestConfigMap())));
    }

    @Test
    public void testGetInstance_nullConfigs_throwsException() {
        AWSDeserializerFactory awsDeserializerFactory = new AWSDeserializerFactory();
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsDeserializerFactory.getInstance(DataFormat.AVRO, null));
    }
}

