/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.caching.AWSCache;
import com.amazonaws.services.schemaregistry.caching.AWSSchemaRegistryDeserializerCache;
import com.amazonaws.services.schemaregistry.common.AWSDataFormatDeserializer;
import com.amazonaws.services.schemaregistry.common.AWSDeserializerInput;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.AWSSerializerInput;
import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializer;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializerFactory;
import com.amazonaws.services.schemaregistry.exception.AWSIncompatibleDataException;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSAvroSerializer;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;
import com.amazonaws.services.schemaregistry.utils.RecordGenerator;
import com.amazonaws.services.schemaregistry.utils.SchemaLoader;
import com.amazonaws.services.schemaregistry.utils.SerializedByteArrayGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.services.glue.model.Compatibility;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public class AWSDeserializerTest {
    @Mock
    private AWSSchemaRegistryClient mockDefaultRegistryClient;
    @Mock
    private AWSSchemaRegistryClient mockClientThatThrowsException;
    @Mock
    private AWSSchemaRegistryClient mockSchemaRegistryClient;
    @Mock
    private AwsCredentialsProvider mockDefaultCredProvider;
    @Mock
    private AWSDataFormatDeserializer mockDataFormatDeserializer;
    @Mock
    private AWSDeserializerFactory mockDeserializerFactory;
    private final Map<String, Object> configs = new HashMap<String, Object>();
    public static final String AVRO_USER_SCHEMA_FILE = "src/test/java/resources/avro/user.avsc";
    public static final String AVRO_EMP_RECORD_SCHEMA_FILE_PATH = "src/test/java/resources/avro/emp_record.avsc";
    private static final String USER_SCHEMA_NAME = "User";
    private static final UUID USER_SCHEMA_VERSION_ID = UUID.randomUUID();
    private static final String USER_SCHEMA_ARN = "arn:aws:glue:ca-central-1:111111111111:schema/registry_name/user_schema";
    private static GenericRecord genericUserAvroRecord;
    private static org.apache.avro.Schema userAvroSchema;
    private static String userSchemaDefinition;
    private static GetSchemaVersionResponse userSchemaVersionResponse;
    private static final String EMPLOYEE_SCHEMA_NAME = "Employee";
    private static final UUID EMPLOYEE_SCHEMA_VERSION_ID;
    private static final String EMPLOYEE_SCHEMA_ARN = "arn:aws:glue:ca-central-1:111111111111:schema/registry_name/user_schema";
    private static GenericRecord genericEmployeeAvroRecord;
    private static org.apache.avro.Schema employeeAvroSchema;
    private static String employeeSchemaDefinition;
    private static GetSchemaVersionResponse employeeSchemaVersionResponse;
    private static AWSAvroSerializer awsAvroSerializer;
    private static AWSAvroSerializer compressingAwsAvroSerializer;

    @BeforeEach
    public void setup() {
        this.configs.put("region", "us-west-2");
        this.configs.put("schemaAutoRegistrationEnabled", true);
        Mockito.when((Object)this.mockClientThatThrowsException.getSchemaVersionResponse(Mockito.anyString())).thenThrow(new Throwable[]{new AWSSchemaRegistryException("some runtime exception")});
        awsAvroSerializer = AWSAvroSerializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(this.configs).schemaRegistryClient(this.mockDefaultRegistryClient).build();
        HashMap<String, Object> compressionConfig = new HashMap<String, Object>();
        compressionConfig.putAll(this.configs);
        compressionConfig.put("compression", AWSSchemaRegistryConstants.COMPRESSION.ZLIB.toString());
        compressingAwsAvroSerializer = AWSAvroSerializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(compressionConfig).schemaRegistryClient(this.mockDefaultRegistryClient).build();
        genericUserAvroRecord = RecordGenerator.createGenericAvroRecord();
        userAvroSchema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        userSchemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)genericUserAvroRecord);
        userSchemaVersionResponse = (GetSchemaVersionResponse)GetSchemaVersionResponse.builder().schemaDefinition(userAvroSchema.toString()).dataFormat(DataFormat.AVRO).schemaArn("arn:aws:glue:ca-central-1:111111111111:schema/registry_name/user_schema").build();
        genericEmployeeAvroRecord = RecordGenerator.createGenericEmpRecord();
        employeeAvroSchema = SchemaLoader.loadSchema(AVRO_EMP_RECORD_SCHEMA_FILE_PATH);
        employeeSchemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)genericEmployeeAvroRecord);
        employeeSchemaVersionResponse = (GetSchemaVersionResponse)GetSchemaVersionResponse.builder().schemaDefinition(employeeAvroSchema.toString()).dataFormat(DataFormat.AVRO).schemaArn("arn:aws:glue:ca-central-1:111111111111:schema/registry_name/user_schema").build();
        Mockito.when((Object)this.mockSchemaRegistryClient.getSchemaVersionResponse((String)Mockito.eq((Object)USER_SCHEMA_VERSION_ID.toString()))).thenReturn((Object)userSchemaVersionResponse);
        Mockito.when((Object)this.mockSchemaRegistryClient.getSchemaVersionResponse((String)Mockito.eq((Object)EMPLOYEE_SCHEMA_VERSION_ID.toString()))).thenReturn((Object)employeeSchemaVersionResponse);
        Mockito.when((Object)this.mockDataFormatDeserializer.deserialize((UUID)Mockito.eq((Object)EMPLOYEE_SCHEMA_VERSION_ID), (ByteBuffer)Mockito.any(ByteBuffer.class), (String)Mockito.eq((Object)employeeAvroSchema.toString()))).thenReturn((Object)genericEmployeeAvroRecord);
        Mockito.when((Object)this.mockDataFormatDeserializer.deserialize((UUID)Mockito.eq((Object)USER_SCHEMA_VERSION_ID), (ByteBuffer)Mockito.any(ByteBuffer.class), (String)Mockito.eq((Object)userAvroSchema.toString()))).thenReturn((Object)genericUserAvroRecord);
        Mockito.when((Object)this.mockDeserializerFactory.getInstance((DataFormat)Mockito.any(DataFormat.class), (GlueSchemaRegistryConfiguration)Mockito.any(GlueSchemaRegistryConfiguration.class))).thenReturn((Object)this.mockDataFormatDeserializer);
        Mockito.when((Object)this.mockDefaultRegistryClient.getORRegisterSchemaVersionId((String)Mockito.eq((Object)userSchemaDefinition), (String)Mockito.eq((Object)USER_SCHEMA_NAME), (String)Mockito.eq((Object)DataFormat.AVRO.name()), Mockito.anyMap())).thenReturn((Object)USER_SCHEMA_VERSION_ID);
        Mockito.when((Object)this.mockDefaultRegistryClient.getORRegisterSchemaVersionId((String)Mockito.eq((Object)employeeSchemaDefinition), (String)Mockito.eq((Object)EMPLOYEE_SCHEMA_NAME), (String)Mockito.eq((Object)DataFormat.AVRO.name()), Mockito.anyMap())).thenReturn((Object)EMPLOYEE_SCHEMA_VERSION_ID);
    }

    @Test
    public void testBuildDeserializer_withNoArguments_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AWSDeserializer.builder().build());
    }

    @Test
    public void testBuildDeserializer_withNullConfig_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AWSDeserializer(null, (AwsCredentialsProvider)DefaultCredentialsProvider.create()));
    }

    @Test
    public void testBuildDeserializer_withConfigs_buildsSuccessfully() {
        AWSDeserializer awsDeserializer = AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).schemaRegistryClient(this.mockDefaultRegistryClient).configs(this.configs).build();
        Assertions.assertEquals((Object)this.mockDefaultCredProvider, (Object)awsDeserializer.getCredentialsProvider());
        Assertions.assertEquals((Object)new GlueSchemaRegistryConfiguration(this.configs), (Object)awsDeserializer.getGlueSchemaRegistryConfiguration());
    }

    @Test
    public void testBuildDeserializer_withProperties_buildsSuccessfully() {
        Properties props = new Properties();
        props.put("region", "US-West-1");
        AWSDeserializer awsDeserializer = AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).schemaRegistryClient(this.mockDefaultRegistryClient).properties(props).build();
        Assertions.assertEquals((Object)this.mockDefaultCredProvider, (Object)awsDeserializer.getCredentialsProvider());
        Assertions.assertEquals((Object)this.mockDefaultRegistryClient, (Object)awsDeserializer.getSchemaRegistryClient());
        Assertions.assertEquals((Object)new GlueSchemaRegistryConfiguration(props), (Object)awsDeserializer.getGlueSchemaRegistryConfiguration());
    }

    @Test
    public void testBuildDeserializer_emptyConfig_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(new HashMap()).build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).properties(new Properties()).build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(new HashMap()).schemaRegistryClient(this.mockDefaultRegistryClient).build());
    }

    @Test
    public void testBuildDeserializer_badConfig_throwsException() {
        HashMap<String, String> badConfig = new HashMap<String, String>(){
            {
                this.put("compatibility", Compatibility.UNKNOWN_TO_SDK_VERSION.toString());
            }
        };
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(badConfig).build());
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(badConfig).schemaRegistryClient(this.mockDefaultRegistryClient).build());
    }

    @Test
    public void testBuildDeserializer_nullConfig_throwsException() {
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(null).build());
        Exception exception = (Exception)Assertions.assertThrows(AWSSchemaRegistryException.class, () -> AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(null).schemaRegistryClient(this.mockDefaultRegistryClient).build());
        Assertions.assertEquals((Object)"Either properties or configuration has to be provided", (Object)exception.getMessage());
    }

    @Test
    public void testGetSchemaDefinition_getSchemaVersionFromClientSucceeds_schemaDefinitionMatches() {
        byte[] serializedData = this.createSerializedUserData(genericUserAvroRecord);
        AWSDeserializer awsDeserializer = this.createAwsDeserializer(this.mockSchemaRegistryClient);
        String schemaDefinition = awsDeserializer.getSchemaDefinition(serializedData);
        Assertions.assertEquals((Object)userAvroSchema.toString(), (Object)schemaDefinition);
    }

    @Test
    public void testGetSchemaDefinition_getSchemaVersionFromClientFails_throwsException() {
        GenericRecord genericRecord = RecordGenerator.createGenericAvroRecord();
        AWSSchemaRegistryDeserializerCache deserializerCache = this.invalidateAndGetCache();
        AWSDeserializer awsDeserializer = this.createAwsDeserializer(deserializerCache, this.mockClientThatThrowsException);
        byte[] serializedData = this.createSerializedUserData(genericRecord);
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsDeserializer.getSchemaDefinition(serializedData));
    }

    @Test
    public void testGetSchemaDefinition_invalidDataLength_throwsException() {
        AWSDeserializer awsDeserializer = this.createAwsDeserializer();
        byte[] serializedData = new byte[]{3, 5};
        Assertions.assertThrows(AWSIncompatibleDataException.class, () -> awsDeserializer.getSchemaDefinition(serializedData));
    }

    @Test
    public void testGetSchemaDefinition_invalidHeaderVersionByte_throwsException() {
        AWSDeserializer awsDeserializer = this.createAwsDeserializer();
        byte[] serializedData = SerializedByteArrayGenerator.constructBasicSerializedData((byte)99, (byte)5, UUID.randomUUID());
        Assertions.assertThrows(AWSIncompatibleDataException.class, () -> awsDeserializer.getSchemaDefinition(serializedData));
    }

    @Test
    public void testGetSchemaDefinition_invalidCompressionByte_throwsException() {
        AWSDeserializer awsDeserializer = this.createAwsDeserializer();
        byte[] serializedData = SerializedByteArrayGenerator.constructBasicSerializedData((byte)3, (byte)99, UUID.randomUUID());
        Assertions.assertThrows(AWSIncompatibleDataException.class, () -> awsDeserializer.getSchemaDefinition(serializedData));
    }

    @Test
    public void testGetSchemaDefinition_nullBuffer_throwsException() {
        AWSDeserializer awsDeserializer = this.createAwsDeserializer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsDeserializer.getSchemaDefinition((ByteBuffer)null));
    }

    @Test
    public void testGetSchemaDefinition_nullByte_throwsException() {
        AWSDeserializer awsDeserializer = this.createAwsDeserializer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsDeserializer.getSchemaDefinition((byte[])null));
    }

    @Test
    public void testDeserialize_withValidAVROSchemaResponse_recordMatches() {
        byte[] serializedUserData = this.createSerializedUserData(genericUserAvroRecord);
        AWSDeserializer awsDeserializer = this.createAwsDeserializer(this.mockDeserializerFactory);
        Object deserializedUserObject = awsDeserializer.deserialize(this.prepareDeserializerInput(serializedUserData));
        Assertions.assertEquals((Object)genericUserAvroRecord, (Object)deserializedUserObject);
    }

    @Test
    public void testDeserialize_withMultipleRecords_recordsMatch() {
        byte[] serializedUserData = this.createSerializedUserData(genericUserAvroRecord);
        byte[] serializedEmployeeData = this.createSerializedEmployeeData(genericEmployeeAvroRecord);
        AWSDeserializer awsDeserializer = this.createAwsDeserializer(this.mockDeserializerFactory);
        Object deserializedUserObject = awsDeserializer.deserialize(this.prepareDeserializerInput(serializedUserData));
        Object deserializedEmployeeObject = awsDeserializer.deserialize(this.prepareDeserializerInput(serializedEmployeeData));
        Assertions.assertEquals((Object)deserializedUserObject, (Object)deserializedUserObject);
        Assertions.assertEquals((Object)genericEmployeeAvroRecord, (Object)deserializedEmployeeObject);
    }

    @Test
    public void testDeserialize_invalidData_throwsException() {
        AWSDeserializer awsDeserializer = this.createAwsDeserializer();
        byte[] serializedData = new byte[]{3, 5};
        Assertions.assertThrows(AWSIncompatibleDataException.class, () -> awsDeserializer.deserialize(this.prepareDeserializerInput(serializedData)));
    }

    @Test
    public void testGetActualData_withValidBytes_ReturnsActualBytes() throws IOException {
        byte[] serializedUserData = this.createSerializedUserData(genericUserAvroRecord);
        AWSDeserializer awsDeserializer = this.createAwsDeserializer(this.mockDeserializerFactory);
        ByteArrayOutputStream expectedBytes = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(userAvroSchema);
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)expectedBytes, null);
        writer.write((Object)genericUserAvroRecord, (Encoder)encoder);
        encoder.flush();
        byte[] actualBytes = awsDeserializer.getActualData(serializedUserData);
        Assertions.assertEquals((Object)ByteBuffer.wrap(expectedBytes.toByteArray()), (Object)ByteBuffer.wrap(actualBytes));
    }

    @Test
    public void testGetActualData_withValidCompressedBytes_ReturnsActualBytes() throws IOException {
        byte[] serializedCompressedEmployeeData = this.createSerializedCompressedEmployeeData(genericEmployeeAvroRecord);
        AWSDeserializer awsDeserializer = this.createAwsDeserializer(this.mockDeserializerFactory);
        ByteArrayOutputStream expectedBytes = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(employeeAvroSchema);
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)expectedBytes, null);
        writer.write((Object)genericEmployeeAvroRecord, (Encoder)encoder);
        encoder.flush();
        byte[] actualBytes = awsDeserializer.getActualData(serializedCompressedEmployeeData);
        Assertions.assertEquals((Object)ByteBuffer.wrap(expectedBytes.toByteArray()), (Object)ByteBuffer.wrap(actualBytes));
    }

    @Test
    public void testDeserialize_nullDeserializerInput_throwsException() {
        AWSDeserializer awsDeserializer = this.createAwsDeserializer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsDeserializer.deserialize(null));
    }

    @Test
    public void testDeserializer_retrieveSchemaRegistryMetadata_MetadataIsCached() {
        byte[] serializedUserData = this.createSerializedUserData(genericUserAvroRecord);
        AWSDeserializer awsDeserializer = this.createAwsDeserializer(this.mockDeserializerFactory);
        AWSSchemaRegistryDeserializerCache deserializerCache = this.invalidateAndGetCache();
        awsDeserializer.setCache((AWSCache)deserializerCache);
        Assertions.assertNull((Object)deserializerCache.get(USER_SCHEMA_VERSION_ID));
        awsDeserializer.deserialize(this.prepareDeserializerInput(serializedUserData));
        Assertions.assertNotNull((Object)deserializerCache.get(USER_SCHEMA_VERSION_ID));
        Mockito.when((Object)this.mockSchemaRegistryClient.getSchemaVersionResponse((String)Mockito.eq((Object)USER_SCHEMA_VERSION_ID.toString()))).thenReturn(null);
        Assertions.assertDoesNotThrow(() -> awsDeserializer.deserialize(this.prepareDeserializerInput(serializedUserData)));
    }

    @Test
    public void testGetDataFormat_nullSchemaVersionId_returnsNull() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AWSDeserializer awsDeserializer = this.createAwsDeserializer();
        Method method = AWSDeserializer.class.getDeclaredMethod("getDataFormat", UUID.class);
        method.setAccessible(true);
        Assertions.assertNull((Object)method.invoke((Object)awsDeserializer, new Object[]{null}));
    }

    @Test
    public void testGetDataFormat_validSchemaVersionId_returnsDataFormat() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AWSDeserializer awsDeserializer = this.createAwsDeserializer(this.mockDeserializerFactory);
        AWSSchemaRegistryDeserializerCache deserializerCache = this.invalidateAndGetCache();
        deserializerCache.put(USER_SCHEMA_VERSION_ID, new Schema(userSchemaDefinition, DataFormat.AVRO.name(), USER_SCHEMA_NAME));
        awsDeserializer.setCache((AWSCache)deserializerCache);
        Method method = AWSDeserializer.class.getDeclaredMethod("getDataFormat", UUID.class);
        method.setAccessible(true);
        Assertions.assertEquals((Object)DataFormat.AVRO, (Object)method.invoke((Object)awsDeserializer, USER_SCHEMA_VERSION_ID));
    }

    @Test
    public void testClose_succeeds() {
        AWSDeserializer awsDeserializer = this.createAwsDeserializer();
        Assertions.assertDoesNotThrow(() -> awsDeserializer.close());
    }

    @Test
    public void testCanDeserialize_WhenValidBytesArePassed_ReturnsTrue() {
        byte[] validSchemaRegistryBytes = this.createSerializedCompressedEmployeeData(genericEmployeeAvroRecord);
        Assertions.assertTrue((boolean)this.createAwsDeserializer().canDeserialize(validSchemaRegistryBytes));
    }

    @Test
    public void testCanDeserialize_WhenNullBytesArePassed_ReturnsFalse() {
        Assertions.assertFalse((boolean)this.createAwsDeserializer().canDeserialize(null));
    }

    @Test
    public void testCanDeserialize_WhenInvalidBytesArePassed_ReturnsFalse() {
        Assertions.assertFalse((boolean)this.createAwsDeserializer().canDeserialize(new byte[]{9, 2, 1}));
    }

    private AWSSchemaRegistryDeserializerCache invalidateAndGetCache() {
        GlueSchemaRegistryConfiguration mockConfig = (GlueSchemaRegistryConfiguration)Mockito.mock(GlueSchemaRegistryConfiguration.class);
        AWSSchemaRegistryDeserializerCache deserializerCache = AWSSchemaRegistryDeserializerCache.getInstance((GlueSchemaRegistryConfiguration)mockConfig);
        deserializerCache.flushCache();
        return deserializerCache;
    }

    private byte[] createSerializedUserData(Object objectToSerialize) {
        UUID schemaVersionId = awsAvroSerializer.registerSchema(this.prepareSerializerInput(userSchemaDefinition, USER_SCHEMA_NAME));
        return awsAvroSerializer.serialize(objectToSerialize, schemaVersionId);
    }

    private byte[] createSerializedEmployeeData(Object objectToSerialize) {
        UUID schemaVersionId = awsAvroSerializer.registerSchema(this.prepareSerializerInput(employeeSchemaDefinition, EMPLOYEE_SCHEMA_NAME));
        return awsAvroSerializer.serialize(objectToSerialize, schemaVersionId);
    }

    private byte[] createSerializedCompressedEmployeeData(Object objectToSerialize) {
        UUID schemaVersionId = compressingAwsAvroSerializer.registerSchema(this.prepareSerializerInput(employeeSchemaDefinition, EMPLOYEE_SCHEMA_NAME));
        return compressingAwsAvroSerializer.serialize(objectToSerialize, schemaVersionId);
    }

    private AWSDeserializer createAwsDeserializer() {
        AWSDeserializer awsDeserializer = AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(this.configs).schemaRegistryClient(this.mockDefaultRegistryClient).build();
        return awsDeserializer;
    }

    private AWSDeserializer createAwsDeserializer(AWSSchemaRegistryDeserializerCache cache, AWSSchemaRegistryClient mockClient) {
        AWSDeserializer awsDeserializer = AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(this.configs).schemaRegistryClient(mockClient).build();
        awsDeserializer.setCache((AWSCache)cache);
        return awsDeserializer;
    }

    private AWSDeserializer createAwsDeserializer(AWSSchemaRegistryClient mockClient) {
        AWSDeserializer awsDeserializer = AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(this.configs).schemaRegistryClient(mockClient).build();
        awsDeserializer.setCache((AWSCache)this.invalidateAndGetCache());
        return awsDeserializer;
    }

    private AWSDeserializer createAwsDeserializer(AWSDeserializerFactory awsDeserializerFactory) {
        AWSDeserializer awsDeserializer = AWSDeserializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(this.configs).schemaRegistryClient(this.mockSchemaRegistryClient).build();
        awsDeserializer.setDeserializerFactory(awsDeserializerFactory);
        awsDeserializer.setCache((AWSCache)this.invalidateAndGetCache());
        return awsDeserializer;
    }

    private AWSSerializerInput prepareSerializerInput(String schemaDefinition, String schemaName) {
        return AWSSerializerInput.builder().schemaDefinition(schemaDefinition).schemaName(schemaName).build();
    }

    private AWSDeserializerInput prepareDeserializerInput(byte[] data) {
        return AWSDeserializerInput.builder().buffer(ByteBuffer.wrap(data)).build();
    }

    static {
        EMPLOYEE_SCHEMA_VERSION_ID = UUID.randomUUID();
    }
}

