/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializer;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializer;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializerImpl;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@ExtendWith(value={MockitoExtension.class})
public class GlueSchemaRegistryDeserializerImplTest {
    @Mock
    private AwsCredentialsProvider credentialsProvider;
    @Mock
    private AWSDeserializer awsDeserializer;
    private static final String REGION = "us-west-2";
    private static final byte[] ENCODED_DATA = new byte[]{8, 9, 12, 83, 82};
    private static final Schema SCHEMA_REGISTRY_SCHEMA = new Schema("{}", "AVRO", "schemaFoo");
    private final Map<String, Object> config = ImmutableMap.of((Object)"region", (Object)"us-west-2");
    private GlueSchemaRegistryDeserializer glueSchemaRegistryDeserializer;

    @BeforeEach
    void setUp() {
        this.glueSchemaRegistryDeserializer = new GlueSchemaRegistryDeserializerImpl(this.awsDeserializer);
    }

    @Test
    public void instantiate_WithConfig_CreatesInstance() {
        GlueSchemaRegistryConfiguration configuration = new GlueSchemaRegistryConfiguration(REGION);
        GlueSchemaRegistryDeserializerImpl glueSchemaRegistryDeserializer = new GlueSchemaRegistryDeserializerImpl(this.credentialsProvider, configuration);
        Assertions.assertNotNull((Object)glueSchemaRegistryDeserializer);
    }

    @Test
    public void getData_WhenValidSchemaRegistryEncodedBytesAreSent_ReturnsActualData() {
        byte[] expected = new byte[]{12, 83, 82};
        ((AWSDeserializer)Mockito.doReturn((Object)expected).when((Object)this.awsDeserializer)).getActualData(ENCODED_DATA);
        byte[] actual = this.glueSchemaRegistryDeserializer.getData(ENCODED_DATA);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void getSchema_WhenValidSchemaRegistryEncodedBytesAreSent_ReturnsSchema() {
        ((AWSDeserializer)Mockito.doReturn((Object)SCHEMA_REGISTRY_SCHEMA).when((Object)this.awsDeserializer)).getSchema(ENCODED_DATA);
        Schema actual = this.glueSchemaRegistryDeserializer.getSchema(ENCODED_DATA);
        Assertions.assertEquals((Object)SCHEMA_REGISTRY_SCHEMA, (Object)actual);
    }

    @Test
    public void canDeserialize_WhenInvalidSchemaRegistryEncodedDataIsSent_ReturnsFalse() {
        Assertions.assertFalse((boolean)this.glueSchemaRegistryDeserializer.canDeserialize(ENCODED_DATA));
    }

    @Test
    public void canDeserialize_WhenValidSchemaRegistryEncodedDataIsSent_ReturnsTrue() {
        byte[] encodedMessage = this.constructValidSerializedData();
        ((AWSDeserializer)Mockito.doReturn((Object)true).when((Object)this.awsDeserializer)).canDeserialize(ENCODED_DATA);
        Assertions.assertTrue((boolean)this.glueSchemaRegistryDeserializer.canDeserialize(ENCODED_DATA));
    }

    private byte[] constructValidSerializedData() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[18]);
        UUID uuid = UUID.randomUUID();
        byteBuffer.put((byte)3);
        byteBuffer.put((byte)0);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return byteBuffer.array();
    }
}

