/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers.avro;

import com.amazonaws.services.schemaregistry.caching.AWSSchemaRegistryDeserializerCache;
import com.amazonaws.services.schemaregistry.common.AWSCompressionFactory;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.avro.AWSAvroDeserializer;
import com.amazonaws.services.schemaregistry.exception.AWSIncompatibleDataException;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSAvroSerializer;
import com.amazonaws.services.schemaregistry.serializers.avro.User;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import com.amazonaws.services.schemaregistry.utils.RecordGenerator;
import com.amazonaws.services.schemaregistry.utils.SchemaLoader;
import com.amazonaws.services.schemaregistry.utils.SerializedByteArrayGenerator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.opentest4j.MultipleFailuresError;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public class AWSAvroDeserializerTest {
    public static final String AVRO_USER_SCHEMA_FILE = "src/test/java/resources/avro/user.avsc";
    public static final String AVRO_USER_ENUM_SCHEMA_FILE = "src/test/java/resources/avro/user_enum.avsc";
    public static final String AVRO_USER_ARRAY_SCHEMA_FILE = "src/test/java/resources/avro/user_array.avsc";
    public static final String AVRO_USER_UNION_SCHEMA_FILE = "src/test/java/resources/avro/user_union.avsc";
    public static final String AVRO_USER_FIXED_SCHEMA_FILE = "src/test/java/resources/avro/user_fixed.avsc";
    public static final String AVRO_USER_ARRAY_STRING_SCHEMA_FILE = "src/test/java/resources/avro/user_array_String.avsc";
    public static final String AVRO_USER_MAP_SCHEMA_FILE = "src/test/java/resources/avro/user_map.avsc";
    public static final String AVRO_USER_MIXED_TYPE_SCHEMA_FILE = "src/test/java/resources/avro/user3.avsc";
    private static final UUID TEST_GENERIC_SCHEMA_VERSION_ID = UUID.fromString("b7b4a7f0-9c96-4e4a-a687-fb5de9ef0c63");
    private final Map<String, Object> configs = new HashMap<String, Object>();
    @Mock
    public AwsCredentialsProvider mockDefaultCredProvider;
    @Mock
    private AWSSchemaRegistryClient mockDefaultRegistryClient;
    private GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs;

    @BeforeEach
    public void setup() {
        this.configs.put("endpoint", "https://test");
        this.configs.put("region", "us-west-2");
        this.schemaRegistrySerDeConfigs = new GlueSchemaRegistryConfiguration(this.configs);
        MockitoAnnotations.initMocks((Object)this);
        this.invalidateAndGetCache();
    }

    public ByteBuffer createBasicSerializedData(Object objectToSerialize, String compressionType) {
        this.configs.put("compression", compressionType);
        AWSAvroSerializer awsAvroSerializer = AWSAvroSerializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(this.configs).schemaRegistryClient(this.mockDefaultRegistryClient).build();
        return this.getByteBuffer(objectToSerialize, awsAvroSerializer);
    }

    private ByteBuffer getByteBuffer(Object objectToSerialize, AWSAvroSerializer awsAvroSerializer) {
        byte[] serializedData = awsAvroSerializer.serialize(objectToSerialize, TEST_GENERIC_SCHEMA_VERSION_ID);
        return ByteBuffer.wrap(serializedData);
    }

    private AWSAvroSerializer createAvroSerializer(String compressionType) {
        this.configs.put("compression", compressionType);
        return AWSAvroSerializer.builder().credentialProvider(this.mockDefaultCredProvider).configs(this.configs).schemaRegistryClient(this.mockDefaultRegistryClient).build();
    }

    private Object createDeserializedObjectForGenericRecord(Schema schema, byte[] serializedData) {
        AWSAvroDeserializer awsAvroDeserializer = AWSAvroDeserializer.builder().configs(this.schemaRegistrySerDeConfigs).build();
        awsAvroDeserializer.setAvroRecordType(AvroRecordType.GENERIC_RECORD);
        return awsAvroDeserializer.deserialize(serializedData, schema.toString());
    }

    private void deserializeAndAssertGenericRecord(Schema schema, Object serializedObject, byte[] serializedData) {
        Object deserializedObject = this.createDeserializedObjectForGenericRecord(schema, serializedData);
        Assertions.assertTrue((boolean)serializedObject.equals(deserializedObject));
    }

    public AWSAvroDeserializer createAvroDeserializer(AvroRecordType recordType) {
        AWSAvroDeserializer awsAvroDeserializer = AWSAvroDeserializer.builder().configs(this.schemaRegistrySerDeConfigs).build();
        awsAvroDeserializer.setAvroRecordType(recordType);
        awsAvroDeserializer.setCompressionFactory(new AWSCompressionFactory());
        return awsAvroDeserializer;
    }

    private AWSSchemaRegistryDeserializerCache invalidateAndGetCache() {
        GlueSchemaRegistryConfiguration mockConfig = (GlueSchemaRegistryConfiguration)Mockito.mock(GlueSchemaRegistryConfiguration.class);
        AWSSchemaRegistryDeserializerCache deserializerCache = AWSSchemaRegistryDeserializerCache.getInstance((GlueSchemaRegistryConfiguration)mockConfig);
        deserializerCache.flushCache();
        return deserializerCache;
    }

    @Test
    public void testCreateAvroDeserializer_withOnlyConfigs_configsMatch() {
        AWSAvroDeserializer awsAvroDeserializer = AWSAvroDeserializer.builder().configs(this.schemaRegistrySerDeConfigs).build();
        Assertions.assertEquals((Object)this.schemaRegistrySerDeConfigs, (Object)awsAvroDeserializer.getSchemaRegistrySerDeConfigs());
    }

    @Test
    public void testDeserialize_incompleteData_throwsException() {
        byte[] serializedData = new byte[]{3, 5};
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.SPECIFIC_RECORD);
        Assertions.assertThrows(AWSIncompatibleDataException.class, () -> awsAvroDeserializer.deserialize(UUID.randomUUID(), ByteBuffer.wrap(serializedData), schema.toString()));
    }

    @Test
    public void testDeserialize_invalidHeaderVersionByte_throwsException() {
        ByteBuffer serializedData = SerializedByteArrayGenerator.constructBasicSerializedByteBuffer((byte)99, (byte)5, UUID.randomUUID());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.SPECIFIC_RECORD);
        Assertions.assertThrows(AWSIncompatibleDataException.class, () -> awsAvroDeserializer.deserialize(UUID.randomUUID(), serializedData, schema.toString()));
    }

    @Test
    public void testDeserialize_invalidCompressionByte_throwsException() {
        ByteBuffer serializedData = SerializedByteArrayGenerator.constructBasicSerializedByteBuffer((byte)3, (byte)99, UUID.randomUUID());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.SPECIFIC_RECORD);
        Assertions.assertThrows(AWSIncompatibleDataException.class, () -> awsAvroDeserializer.deserialize(UUID.randomUUID(), serializedData, schema.toString()));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_genericRecord_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        GenericRecord genericRecord = RecordGenerator.createGenericAvroRecord();
        ByteBuffer serializedData = this.createBasicSerializedData(genericRecord, compressionType.name());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Object deserializedObject = awsAvroDeserializer.deserialize(UUID.randomUUID(), serializedData, schema.toString());
        this.assertGenericRecord(genericRecord, deserializedObject);
    }

    public void assertGenericRecord(GenericRecord genericRecord, Object deserializedObject) {
        Assertions.assertTrue((boolean)(deserializedObject instanceof GenericRecord));
        Assertions.assertTrue((boolean)deserializedObject.equals(genericRecord));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_genericRecordWithSpecificMode_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        GenericRecord genericRecord = RecordGenerator.createGenericAvroRecord();
        ByteBuffer serializedData = this.createBasicSerializedData(genericRecord, compressionType.name());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.SPECIFIC_RECORD);
        Object deserializedObject = awsAvroDeserializer.deserialize(UUID.randomUUID(), serializedData, schema.toString());
        this.assertGenericRecordWithSpecificRecordMode(genericRecord, deserializedObject);
    }

    private void assertGenericRecordWithSpecificRecordMode(GenericRecord genericRecord, Object deserializedObject) throws MultipleFailuresError {
        User deserializedUserObject = (User)((Object)deserializedObject);
        Assertions.assertAll((String)"Deserialization is successful!", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)deserializedObject), () -> Assertions.assertEquals((Object)genericRecord.get("name"), (Object)deserializedUserObject.getName().toString()), () -> Assertions.assertEquals((Object)genericRecord.get("favorite_number"), (Object)deserializedUserObject.getFavoriteNumber()), () -> Assertions.assertEquals((Object)genericRecord.get("favorite_color"), (Object)deserializedUserObject.getFavoriteColor().toString())});
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_specificRecord_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        User userDefinedObject = RecordGenerator.createSpecificAvroRecord();
        ByteBuffer serializedData = this.createBasicSerializedData((Object)userDefinedObject, compressionType.name());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.SPECIFIC_RECORD);
        Object deserializedObject = awsAvroDeserializer.deserialize(UUID.randomUUID(), serializedData, schema.toString());
        Assertions.assertAll((String)"De-serialized object is User type and equals the serialized object", (Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)(deserializedObject instanceof User)), () -> Assertions.assertTrue((boolean)deserializedObject.equals((Object)userDefinedObject))});
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_genericRecordWithoutSchemaVersionId_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        GenericRecord genericRecord = RecordGenerator.createGenericAvroRecord();
        ByteBuffer serializedData = this.createBasicSerializedData(genericRecord, compressionType.name());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Object deserializedObject = awsAvroDeserializer.deserialize(serializedData, schema.toString());
        this.assertGenericRecord(genericRecord, deserializedObject);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_genericRecordWithByteArray_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        GenericRecord genericRecord = RecordGenerator.createGenericAvroRecord();
        ByteBuffer serializedData = this.createBasicSerializedData(genericRecord, compressionType.name());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Object deserializedObject = awsAvroDeserializer.deserialize(serializedData.array(), schema.toString());
        this.assertGenericRecord(genericRecord, deserializedObject);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_specificRecordInGenericMode_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        User userDefinedObject = RecordGenerator.createSpecificAvroRecord();
        ByteBuffer serializedData = this.createBasicSerializedData((Object)userDefinedObject, compressionType.name());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Object deserializedObject = awsAvroDeserializer.deserialize(UUID.randomUUID(), serializedData, schema.toString());
        this.assertSpecificRecordInGenericRecordMode(userDefinedObject, deserializedObject);
    }

    private void assertSpecificRecordInGenericRecordMode(User userDefinedObject, Object deserializedObject) throws MultipleFailuresError {
        GenericRecord deserializedGenericRecord = (GenericRecord)deserializedObject;
        Assertions.assertAll((String)"Deserialization is successful!", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)deserializedObject), () -> Assertions.assertEquals((Object)userDefinedObject.getName(), (Object)deserializedGenericRecord.get("name").toString()), () -> Assertions.assertEquals((Object)userDefinedObject.getFavoriteNumber(), (Object)userDefinedObject.get("favorite_number")), () -> Assertions.assertEquals((Object)userDefinedObject.getFavoriteColor(), (Object)userDefinedObject.get("favorite_color").toString())});
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_enumSchema_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Schema schemaForEnum = SchemaLoader.loadSchema(AVRO_USER_ENUM_SCHEMA_FILE);
        GenericData.EnumSymbol enumSymbol = new GenericData.EnumSymbol(schemaForEnum, "ONE");
        AWSAvroSerializer awsAvroSerializer = this.createAvroSerializer(compressionType.name());
        byte[] serializedData = awsAvroSerializer.serialize((Object)enumSymbol, UUID.randomUUID());
        this.deserializeAndAssertGenericRecord(schemaForEnum, enumSymbol, serializedData);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_integerArrays_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Schema schemaForArray = SchemaLoader.loadSchema(AVRO_USER_ARRAY_SCHEMA_FILE);
        GenericData.Array array = new GenericData.Array(1, schemaForArray);
        array.add((Object)1);
        AWSAvroSerializer awsAvroSerializer = this.createAvroSerializer(compressionType.name());
        byte[] serializedData = awsAvroSerializer.serialize((Object)array, UUID.randomUUID());
        this.deserializeAndAssertGenericRecord(schemaForArray, array, serializedData);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_objectArrays_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Schema schemaForArray = SchemaLoader.loadSchema(AVRO_USER_ARRAY_SCHEMA_FILE);
        GenericData.Array array = new GenericData.Array(1, schemaForArray);
        array.add((Object)1);
        AWSAvroSerializer awsAvroSerializer = this.createAvroSerializer(compressionType.name());
        byte[] serializedData = awsAvroSerializer.serialize((Object)array, UUID.randomUUID());
        this.deserializeAndAssertGenericRecord(schemaForArray, array, serializedData);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_unions_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Schema schemaForUnion = SchemaLoader.loadSchema(AVRO_USER_UNION_SCHEMA_FILE);
        GenericData.Record unionRecord = new GenericData.Record(schemaForUnion);
        unionRecord.put("experience", (Object)1);
        unionRecord.put("age", (Object)30);
        AWSAvroSerializer awsAvroSerializer = this.createAvroSerializer(compressionType.name());
        byte[] serializedData = awsAvroSerializer.serialize((Object)unionRecord, UUID.randomUUID());
        this.deserializeAndAssertGenericRecord(schemaForUnion, unionRecord, serializedData);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_unionsWithNull_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Schema schemaForUnion = SchemaLoader.loadSchema(AVRO_USER_UNION_SCHEMA_FILE);
        GenericData.Record unionRecord = new GenericData.Record(schemaForUnion);
        unionRecord.put("experience", null);
        unionRecord.put("age", (Object)30);
        AWSAvroSerializer awsAvroSerializer = this.createAvroSerializer(compressionType.name());
        byte[] serializedData = awsAvroSerializer.serialize((Object)unionRecord, UUID.randomUUID());
        this.deserializeAndAssertGenericRecord(schemaForUnion, unionRecord, serializedData);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_fixedArray_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Schema schemaForFixedByteArray = SchemaLoader.loadSchema(AVRO_USER_FIXED_SCHEMA_FILE);
        GenericData.Fixed fixedRecord = new GenericData.Fixed(schemaForFixedByteArray);
        byte[] bytes = "byte array".getBytes();
        fixedRecord.bytes(bytes);
        AWSAvroSerializer awsAvroSerializer = this.createAvroSerializer(compressionType.name());
        byte[] serializedData = awsAvroSerializer.serialize((Object)fixedRecord, UUID.randomUUID());
        this.deserializeAndAssertGenericRecord(schemaForFixedByteArray, fixedRecord, serializedData);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_stringArrays_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Schema schemaForArray = SchemaLoader.loadSchema(AVRO_USER_ARRAY_STRING_SCHEMA_FILE);
        GenericData.Array array = new GenericData.Array(1, schemaForArray);
        array.add((Object)"TestValue");
        AWSAvroSerializer awsAvroSerializer = this.createAvroSerializer(compressionType.name());
        byte[] serializedData = awsAvroSerializer.serialize((Object)array, UUID.randomUUID());
        Object deserializedObject = this.createDeserializedObjectForGenericRecord(schemaForArray, serializedData);
        this.validateStringRecords((GenericData.Array<String>)array, deserializedObject);
    }

    private void validateStringRecords(GenericData.Array<String> array, Object deserializedObject) {
        String actualValue = ((Utf8)((GenericData.Array)deserializedObject).get(0)).toString();
        Assertions.assertEquals((Object)array.get(0), (Object)actualValue);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_maps_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        String avroRecordMapName = "meta";
        String keyName = "testKey";
        Schema schemaForMap = SchemaLoader.loadSchema(AVRO_USER_MAP_SCHEMA_FILE);
        GenericData.Record mapRecord = new GenericData.Record(schemaForMap);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("testKey", 1L);
        mapRecord.put("meta", map);
        AWSAvroSerializer awsAvroSerializer = this.createAvroSerializer(compressionType.name());
        byte[] serializedData = awsAvroSerializer.serialize((Object)mapRecord, UUID.randomUUID());
        Object deserializedObject = this.createDeserializedObjectForGenericRecord(schemaForMap, serializedData);
        this.validateEnumRecord("meta", "testKey", map, deserializedObject);
    }

    private void validateEnumRecord(String avroRecordMapName, String keyName, Map<String, Long> map, Object deserializedObject) {
        HashMap deserializedMap = (HashMap)((GenericData.Record)deserializedObject).get(avroRecordMapName);
        Assertions.assertEquals((Object)map.keySet().iterator().next(), (Object)((Utf8)deserializedMap.keySet().iterator().next()).toString());
        Assertions.assertEquals((Long)map.get(keyName), (Long)((Long)deserializedMap.get(new Utf8(keyName))));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_allTypes_equalsOriginal(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_MIXED_TYPE_SCHEMA_FILE);
        String avroRecordMapName = "meta";
        String keyName = "testKey";
        GenericData.EnumSymbol enumSymbol = new GenericData.EnumSymbol(schema, "ONE");
        ArrayList<Integer> integerArrayList = new ArrayList<Integer>();
        integerArrayList.add(1);
        GenericData.Record genericRecordWithAllTypes = new GenericData.Record(schema);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("testKey", 1L);
        genericRecordWithAllTypes.put("name", (Object)"Joe");
        genericRecordWithAllTypes.put("favorite_number", (Object)1);
        genericRecordWithAllTypes.put("meta", map);
        genericRecordWithAllTypes.put("listOfColours", integerArrayList);
        genericRecordWithAllTypes.put("integerEnum", (Object)enumSymbol);
        AWSAvroSerializer awsAvroSerializer = this.createAvroSerializer(compressionType.name());
        byte[] serializedData = awsAvroSerializer.serialize((Object)genericRecordWithAllTypes, UUID.randomUUID());
        Object deserializedObject = this.createDeserializedObjectForGenericRecord(schema, serializedData);
        this.validateRecord("meta", "testKey", enumSymbol, integerArrayList, map, deserializedObject);
    }

    private void validateRecord(String avroRecordMapName, String keyName, GenericData.EnumSymbol enumSymbol, ArrayList<Integer> integerArrayList, Map<String, Long> map, Object deserializedObject) {
        GenericData.Record deserializedRecord = (GenericData.Record)deserializedObject;
        Assertions.assertEquals((Object)"Joe", (Object)deserializedRecord.get("name").toString());
        Assertions.assertEquals((Object)1, (Object)deserializedRecord.get("favorite_number"));
        this.validateEnumRecord(avroRecordMapName, keyName, map, deserializedObject);
        Assertions.assertEquals(integerArrayList, (Object)deserializedRecord.get("listOfColours"));
        Assertions.assertEquals((Object)enumSymbol, (Object)deserializedRecord.get("integerEnum"));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_unknownRecordType_throwsException(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        GenericRecord genericRecord = RecordGenerator.createGenericAvroRecord();
        ByteBuffer serializedData = this.createBasicSerializedData(genericRecord, compressionType.name());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.UNKNOWN);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> awsAvroDeserializer.deserialize(serializedData.array(), schema.toString()));
    }

    @Test
    public void testDeserialize_datumReaderIllegalAccess_throwsException() {
        GenericRecord genericRecord = RecordGenerator.createGenericAvroRecord();
        ByteBuffer serializedData = this.createBasicSerializedData(genericRecord, AWSSchemaRegistryConstants.COMPRESSION.NONE.name());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializerMock = (AWSAvroDeserializer)Mockito.mock(AWSAvroDeserializer.class);
        Mockito.when((Object)awsAvroDeserializerMock.deserialize((UUID)Mockito.any(UUID.class), (ByteBuffer)Mockito.any(ByteBuffer.class), Mockito.anyString())).thenCallRealMethod();
        try {
            Mockito.when((Object)awsAvroDeserializerMock.getDeserializedData((ByteBuffer)Mockito.any(ByteBuffer.class))).thenCallRealMethod();
        }
        catch (Exception e) {
            Assertions.fail((String)"Test failed with exception", (Throwable)e);
        }
        GlueSchemaRegistryConfiguration config = (GlueSchemaRegistryConfiguration)Mockito.mock(GlueSchemaRegistryConfiguration.class);
        awsAvroDeserializerMock.setSchemaRegistrySerDeConfigs(config);
        try {
            Mockito.when((Object)awsAvroDeserializerMock.createDatumReader((Schema)Mockito.any(Schema.class), (UUID)Mockito.any(UUID.class))).thenThrow(new Throwable[]{new IllegalAccessException("Illegal access!")});
        }
        catch (Exception e) {
            Assertions.fail((String)"Test failed with exception", (Throwable)e);
        }
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsAvroDeserializerMock.deserialize(UUID.randomUUID(), serializedData, schema.toString()));
    }

    @Test
    public void testDeserialize_datumReaderInstantiationFails_throwsException() {
        GenericRecord genericRecord = RecordGenerator.createGenericAvroRecord();
        ByteBuffer serializedData = this.createBasicSerializedData(genericRecord, AWSSchemaRegistryConstants.COMPRESSION.NONE.name());
        Schema schema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        AWSAvroDeserializer awsAvroDeserializerMock = (AWSAvroDeserializer)Mockito.mock(AWSAvroDeserializer.class);
        Mockito.when((Object)awsAvroDeserializerMock.deserialize((UUID)Mockito.any(UUID.class), (ByteBuffer)Mockito.any(ByteBuffer.class), Mockito.anyString())).thenCallRealMethod();
        try {
            Mockito.when((Object)awsAvroDeserializerMock.getDeserializedData((ByteBuffer)Mockito.any(ByteBuffer.class))).thenCallRealMethod();
        }
        catch (Exception e) {
            Assertions.fail((String)"Test failed with exception", (Throwable)e);
        }
        GlueSchemaRegistryConfiguration config = (GlueSchemaRegistryConfiguration)Mockito.mock(GlueSchemaRegistryConfiguration.class);
        Mockito.when((Object)config.getCompressionType()).thenReturn((Object)AWSSchemaRegistryConstants.COMPRESSION.NONE);
        awsAvroDeserializerMock.setSchemaRegistrySerDeConfigs(config);
        try {
            Mockito.when((Object)awsAvroDeserializerMock.createDatumReader((Schema)Mockito.any(Schema.class), (UUID)Mockito.any(UUID.class))).thenThrow(new Throwable[]{new InstantiationException("Instantiation errors!")});
        }
        catch (Exception e) {
            Assertions.fail((String)"Test failed with exception", (Throwable)e);
        }
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsAvroDeserializerMock.deserialize(UUID.randomUUID(), serializedData, schema.toString()));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testDeserialize_invalidSchema_throwsException(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        GenericRecord genericRecord = RecordGenerator.createGenericAvroRecord();
        ByteBuffer serializedData = this.createBasicSerializedData(genericRecord, compressionType.name());
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsAvroDeserializer.deserialize(UUID.randomUUID(), serializedData, "InvalidSchema"));
    }

    @Test
    public void testDeserialize_nullData_throwsException() {
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsAvroDeserializer.deserialize((byte[])null, "test-schema-name"));
    }

    @Test
    public void testDeserialize_nullByteBuffer_throwsException() {
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsAvroDeserializer.deserialize((ByteBuffer)null, "test-schema"));
    }

    @Test
    public void testDeserialize_nullSchemaWithData_throwsException() {
        byte[] serializedData = this.getTestSerializedByteData();
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsAvroDeserializer.deserialize(serializedData, null));
    }

    @Test
    public void testDeserialize_nullSchemaWithBuffer_throwsException() {
        ByteBuffer serializedByteBuffer = this.getTestSerializedByteBufferData();
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsAvroDeserializer.deserialize(serializedByteBuffer, null));
    }

    @Test
    public void testDeserialize_nullSchemaVersionIdWithBufferWithSchema_throwsException() {
        ByteBuffer serializedByteBuffer = this.getTestSerializedByteBufferData();
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsAvroDeserializer.deserialize(null, serializedByteBuffer, "test-schema"));
    }

    @Test
    public void testDeserialize_withSchemaVersionIdWithNullBufferWithSchema_throwsException() {
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsAvroDeserializer.deserialize(TEST_GENERIC_SCHEMA_VERSION_ID, null, "test-schema"));
    }

    @Test
    public void testDeserialize_withSchemaVersionIdWithBufferWithNullSchema_throwsException() {
        ByteBuffer serializedByteBuffer = this.getTestSerializedByteBufferData();
        AWSAvroDeserializer awsAvroDeserializer = this.createAvroDeserializer(AvroRecordType.GENERIC_RECORD);
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsAvroDeserializer.deserialize(TEST_GENERIC_SCHEMA_VERSION_ID, serializedByteBuffer, null));
    }

    public ByteBuffer getTestSerializedByteBufferData() {
        ByteBuffer serializedByteBuffer = SerializedByteArrayGenerator.constructBasicSerializedByteBuffer((byte)99, (byte)5, UUID.randomUUID());
        return serializedByteBuffer;
    }

    public byte[] getTestSerializedByteData() {
        byte[] serializedByteData = new byte[]{3, 5};
        return serializedByteData;
    }
}

