/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers.avro;

import com.amazonaws.services.schemaregistry.common.AWSDeserializerInput;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializer;
import com.amazonaws.services.schemaregistry.deserializers.avro.AWSKafkaAvroDeserializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@ExtendWith(value={MockitoExtension.class})
public class AWSKafkaAvroDeserializerTest {
    private Map<String, Object> configs = new HashMap<String, Object>();
    @Mock
    private AwsCredentialsProvider mockCredProvider;

    @BeforeEach
    public void setup() {
        this.configs.put("endpoint", "https://test");
        this.configs.put("region", "us-west-2");
        this.configs.put("compression", "NONE");
    }

    @Test
    public void test_Create() {
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer1 = new AWSKafkaAvroDeserializer();
        Assertions.assertNotNull((Object)awsKafkaAvroDeserializer1.getCredentialProvider());
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer2 = new AWSKafkaAvroDeserializer(this.mockCredProvider, this.configs);
        Assertions.assertNotNull((Object)awsKafkaAvroDeserializer2.getCredentialProvider());
    }

    @Test
    public void test_Create_With_Aws_Deserializer() {
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer(this.mockCredProvider, null);
        awsKafkaAvroDeserializer.setAwsDeserializer(AWSDeserializer.builder().credentialProvider(this.mockCredProvider).configs(this.configs).build());
        Assertions.assertNotNull((Object)awsKafkaAvroDeserializer.getCredentialProvider());
        Assertions.assertNotNull((Object)awsKafkaAvroDeserializer.getAwsDeserializer());
    }

    @Test
    public void test_Configure_Empty_Config() {
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer();
        Assertions.assertNotNull((Object)awsKafkaAvroDeserializer.getCredentialProvider());
        HashMap configs = new HashMap();
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsKafkaAvroDeserializer.configure(configs, false));
    }

    @Test
    public void test_Deserialize_Null_Input() {
        AWSDeserializer awsDeserializer = (AWSDeserializer)Mockito.mock(AWSDeserializer.class);
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer(this.mockCredProvider, null);
        awsKafkaAvroDeserializer.setAwsDeserializer(awsDeserializer);
        Object result = awsKafkaAvroDeserializer.deserialize("TestTopic", null);
        Assertions.assertNull((Object)result);
    }

    @Test
    public void test_Deserialize() {
        Object expectedObject = new Object();
        AWSDeserializer awsDeserializer = (AWSDeserializer)Mockito.mock(AWSDeserializer.class);
        Mockito.when((Object)awsDeserializer.deserialize((AWSDeserializerInput)Mockito.any(AWSDeserializerInput.class))).thenReturn(expectedObject);
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer(this.mockCredProvider, null);
        awsKafkaAvroDeserializer.setAwsDeserializer(awsDeserializer);
        Object deserializedObject = awsKafkaAvroDeserializer.deserialize("TestTopic", new byte[]{3});
        Assertions.assertEquals((Object)expectedObject, (Object)deserializedObject);
    }

    @Test
    public void testClose_callInternalAWSDeserializer_succeeds() {
        AWSDeserializer awsDeserializer = (AWSDeserializer)Mockito.mock(AWSDeserializer.class);
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer(this.mockCredProvider, null);
        awsKafkaAvroDeserializer.setAwsDeserializer(awsDeserializer);
        ((AWSDeserializer)Mockito.verify((Object)awsDeserializer, (VerificationMode)Mockito.atMost((int)1))).close();
    }

    @Test
    public void testConfigure_nullConfig_throwsException() {
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer();
        Assertions.assertNotNull((Object)awsKafkaAvroDeserializer.getCredentialProvider());
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsKafkaAvroDeserializer.configure(null, false));
    }

    @Test
    public void testConfigure_validConfig_throwsException() {
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer();
        Assertions.assertNotNull((Object)awsKafkaAvroDeserializer.getCredentialProvider());
        Assertions.assertDoesNotThrow(() -> awsKafkaAvroDeserializer.configure(this.configs, false));
    }

    @Test
    public void testConstructor_nullConfig_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AWSKafkaAvroDeserializer(null));
    }

    @Test
    public void testClose_succeeds() {
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer();
        awsKafkaAvroDeserializer.configure(this.configs, false);
        Assertions.assertDoesNotThrow(() -> awsKafkaAvroDeserializer.close());
    }

    @Test
    public void test_deserialize_assureSecondaryDeserializersAreIndependent() {
        HashMap<String, Object> config_1 = new HashMap<String, Object>(this.configs);
        config_1.put("secondaryDeserializer", TestingDeserializerImpl.class.getName());
        config_1.put("secondary.custom.config", "firstValue");
        AWSKafkaAvroDeserializer deserializer_1 = new AWSKafkaAvroDeserializer(config_1);
        HashMap<String, Object> config_2 = new HashMap<String, Object>(this.configs);
        config_2.put("secondaryDeserializer", TestingDeserializerImpl.class.getName());
        config_2.put("secondary.custom.config", "secondValue");
        AWSKafkaAvroDeserializer deserializer_2 = new AWSKafkaAvroDeserializer(config_2);
        byte[] testValue = new byte[]{0};
        Object deserializedValue_1 = deserializer_1.deserialize(null, testValue);
        Object deserializedValue_2 = deserializer_2.deserialize(null, testValue);
        Assertions.assertEquals((Object)"firstValue", (Object)deserializedValue_1);
        Assertions.assertEquals((Object)"secondValue", (Object)deserializedValue_2);
    }

    public static class TestingDeserializerImpl
    implements Deserializer<Object> {
        public static final String CUSTOM_CONFIG_KEY = "secondary.custom.config";
        private String value;

        public Object deserialize(String s, byte[] bytes) {
            return this.value;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.value = (String)configs.get(CUSTOM_CONFIG_KEY);
        }
    }
}

