/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers.avro;

import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializer;
import com.amazonaws.services.schemaregistry.deserializers.avro.AWSKafkaAvroDeserializer;
import com.amazonaws.services.schemaregistry.deserializers.avro.SecondaryDeserializer;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@ExtendWith(value={MockitoExtension.class})
public class SecondaryDeserializerTest {
    private final Map<String, Object> configs = new HashMap<String, Object>();
    private SecondaryDeserializer secondaryDeserializer;
    private GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs;
    private static final String VALID_SECONDARY_DESERIALIZER = "com.amazonaws.services.schemaregistry.deserializers.external.ThirdPartyDeserializer";
    private static final String NON_KAFKA_SECONDARY_DESERIALIZER = "com.amazonaws.services.schemaregistry.deserializers.external.NotKafkaDeserializer";
    private static final String EMPTY_SECONDARY_DESERIALIZER = "";
    private static final String NON_KAFKA_SECONDARY_DESERIALIZER_EXCEPTION_MSG = "The secondary deserializer is not from Kafka";
    private static final String EMPTY_SECONDARY_DESERIALIZER_EXCEPTION_MSG = "Can't find the class or instantiate it.";
    private static final String TEST_TOPIC = "TestTopic";
    @Mock
    private AwsCredentialsProvider mockCredProvider;
    @Mock
    private AWSDeserializer mockAwsDeserializer;

    @BeforeEach
    public void setup() {
        this.secondaryDeserializer = SecondaryDeserializer.newInstance();
        this.configs.put("endpoint", "https://test");
        this.configs.put("region", "us-west-2");
        this.schemaRegistrySerDeConfigs = new GlueSchemaRegistryConfiguration(this.configs);
    }

    @Test
    public void testDeserialize_nullObjField_throwsException() throws IllegalAccessException, NoSuchFieldException {
        Field objField = SecondaryDeserializer.class.getDeclaredField("obj");
        objField.setAccessible(true);
        objField.set(this.secondaryDeserializer, null);
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> this.secondaryDeserializer.deserialize(null, null));
    }

    @Test
    public void testClose_nullObjField_throwsException() throws IllegalAccessException, NoSuchFieldException {
        Field objField = SecondaryDeserializer.class.getDeclaredField("obj");
        objField.setAccessible(true);
        objField.set(this.secondaryDeserializer, null);
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> this.secondaryDeserializer.close());
    }

    @Test
    public void testSecondaryDeserializer_validDeserializer_deserializesSuccessfully() {
        byte[] serializedBytes = new byte[]{0};
        Map<String, Object> configs = this.getConfigsWithSecondaryDeserializer(VALID_SECONDARY_DESERIALIZER);
        Object deserializedObject = this.deserialize(configs, serializedBytes);
        Assertions.assertNotNull((Object)deserializedObject);
        Assertions.assertTrue((boolean)(deserializedObject instanceof Object));
    }

    @Test
    public void testSecondaryDeserializer_withStringDeserializer_deserializesSuccessfully() {
        StringSerializer stringSerializer = new StringSerializer();
        String objectToSerialize = "TestData";
        byte[] serializedBytes = stringSerializer.serialize(TEST_TOPIC, "TestData");
        Map<String, Object> deserializerConfigs = this.getConfigsWithSecondaryDeserializer(StringDeserializer.class.getName());
        Object deserializedObject = this.deserialize(deserializerConfigs, serializedBytes);
        Assertions.assertNotNull((Object)deserializedObject);
        Assertions.assertTrue((boolean)(deserializedObject instanceof String));
        Assertions.assertEquals((Object)"TestData", (Object)deserializedObject);
    }

    @Test
    public void testSecondaryDeserializer_withIntegerDeserializer_deserializesSuccessfully() {
        IntegerSerializer integerSerializer = new IntegerSerializer();
        Integer objectToSerialize = 1;
        byte[] serializedBytes = integerSerializer.serialize(TEST_TOPIC, objectToSerialize);
        Map<String, Object> deserializerConfigs = this.getConfigsWithSecondaryDeserializer(IntegerDeserializer.class.getName());
        Object deserializedObject = this.deserialize(deserializerConfigs, serializedBytes);
        Assertions.assertNotNull((Object)deserializedObject);
        Assertions.assertTrue((boolean)(deserializedObject instanceof Integer));
        Assertions.assertEquals((Object)objectToSerialize, (Object)deserializedObject);
    }

    @Test
    public void testSecondaryDeserializer_invalidDeserializer_throwsException() {
        Map<String, Object> configs = this.getConfigsWithSecondaryDeserializer(NON_KAFKA_SECONDARY_DESERIALIZER);
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer();
        Exception exception = (Exception)Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroDeserializer.configure(configs, true));
        Assertions.assertEquals((Object)NON_KAFKA_SECONDARY_DESERIALIZER_EXCEPTION_MSG, (Object)exception.getMessage());
    }

    @Test
    public void testSecondaryDeserializer_emptyDeserializer_throwsException() {
        Map<String, Object> configs = this.getConfigsWithSecondaryDeserializer(EMPTY_SECONDARY_DESERIALIZER);
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer();
        Exception exception = (Exception)Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroDeserializer.configure(configs, true));
        Assertions.assertEquals((Object)EMPTY_SECONDARY_DESERIALIZER_EXCEPTION_MSG, (Object)exception.getMessage());
    }

    @Test
    public void testSecondaryDeserializer_nullDeserializer_throwsException() {
        Map<String, Object> configs = this.getConfigsWithSecondaryDeserializer(null);
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer();
        Exception exception = (Exception)Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroDeserializer.configure(configs, true));
        Assertions.assertEquals((Object)EMPTY_SECONDARY_DESERIALIZER_EXCEPTION_MSG, (Object)exception.getMessage());
    }

    private Map<String, Object> getConfigsWithSecondaryDeserializer(String className) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("endpoint", "https://test");
        configs.put("region", "us-west-2");
        configs.put("secondaryDeserializer", className);
        return configs;
    }

    private Object deserialize(Map<String, Object> deserializerConfigs, byte[] serializedBytes) {
        AWSKafkaAvroDeserializer awsKafkaAvroDeserializer = new AWSKafkaAvroDeserializer(this.mockCredProvider, deserializerConfigs);
        awsKafkaAvroDeserializer.setAwsDeserializer(this.mockAwsDeserializer);
        return awsKafkaAvroDeserializer.deserialize(TEST_TOPIC, serializedBytes);
    }
}

