/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers;

import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistrySerializationFacade;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistrySerializerImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@ExtendWith(value={MockitoExtension.class})
public class GlueSchemaRegistrySerializerImplTest {
    private static final String TRANSPORT_NAME = "stream-foo";
    private static final String REGION = "us-west-2";
    private GlueSchemaRegistrySerializerImpl glueSchemaRegistrySerializer;
    @Mock
    private AwsCredentialsProvider credentialsProvider;
    @Mock
    private GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade;
    private static final byte[] ENCODED_DATA = new byte[]{8, 9, 12, 83, 82};
    private static final byte[] USER_DATA = new byte[]{12, 83, 82};
    private static final Schema SCHEMA_REGISTRY_SCHEMA = new Schema("{}", "AVRO", "schemaFoo");

    @BeforeEach
    void setUp() {
        this.glueSchemaRegistrySerializer = new GlueSchemaRegistrySerializerImpl(this.glueSchemaRegistrySerializationFacade);
    }

    @Test
    public void instantiate_WithNullConfiguration_CreatesInstance() {
        GlueSchemaRegistrySerializerImpl glueSchemaRegistrySerializer = new GlueSchemaRegistrySerializerImpl(this.credentialsProvider, new GlueSchemaRegistryConfiguration(REGION));
        Assertions.assertNotNull((Object)glueSchemaRegistrySerializer);
    }

    @Test
    public void instantiate_WithConfiguration_CreatesInstance() {
        GlueSchemaRegistryConfiguration configuration = new GlueSchemaRegistryConfiguration(REGION);
        GlueSchemaRegistrySerializerImpl glueSchemaRegistrySerializer = new GlueSchemaRegistrySerializerImpl(this.credentialsProvider, configuration);
        Assertions.assertNotNull((Object)glueSchemaRegistrySerializer);
    }

    @Test
    public void getSchema_WhenASchemaIsPassed_EncodesIntoSchemaRegistryMessage() {
        ((GlueSchemaRegistrySerializationFacade)Mockito.doReturn((Object)ENCODED_DATA).when((Object)this.glueSchemaRegistrySerializationFacade)).encode(TRANSPORT_NAME, SCHEMA_REGISTRY_SCHEMA, USER_DATA);
        byte[] actual = this.glueSchemaRegistrySerializer.encode(TRANSPORT_NAME, SCHEMA_REGISTRY_SCHEMA, USER_DATA);
        Assertions.assertEquals((Object)ENCODED_DATA, (Object)actual);
    }
}

