/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers.avro;

import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.AWSSerializerInput;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSAvroSerializer;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSKafkaAvroSerializer;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSSchemaRegistryValidationUtil;
import com.amazonaws.services.schemaregistry.serializers.avro.CustomerProvidedSchemaNamingStrategy;
import com.amazonaws.services.schemaregistry.serializers.avro.User;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;
import com.amazonaws.services.schemaregistry.utils.RecordGenerator;
import com.amazonaws.services.schemaregistry.utils.SchemaLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;

public class AWSKafkaAvroSerializerTest
extends AWSSchemaRegistryValidationUtil {
    private AWSSchemaRegistryClient mockClient;
    private final Map<String, Object> configs = new HashMap<String, Object>();
    private static final UUID USER_SCHEMA_VERSION_ID = UUID.fromString("b7b4a7f0-9c96-4e4a-a687-fb5de9ef0c63");
    private static final UUID EMPLOYEE_SCHEMA_VERSION_ID = UUID.fromString("2f8e6498-29af-4722-b4ae-80f2be386bee");
    private static final String AVRO_USER_SCHEMA_FILE = "src/test/java/resources/avro/user.avsc";
    private static final String AVRO_EMP_RECORD_SCHEMA_FILE_PATH = "src/test/java/resources/avro/emp_record.avsc";
    private static Schema userAvroSchema;
    private static String userSchemaDefinition;
    private static Schema employeeAvroSchema;
    private static String employeeSchemaDefinition;
    private User userDefinedPojo;
    private static GenericRecord genericUserAvroRecord;
    private static GenericRecord genericEmployeeAvroRecord;
    private static Map<String, UUID> schemaDefinitionToSchemaVersionIdMap;

    @BeforeEach
    public void setup() {
        this.mockClient = (AWSSchemaRegistryClient)Mockito.mock(AWSSchemaRegistryClient.class);
        this.userDefinedPojo = User.newBuilder().setName("test_avros_schema").setFavoriteColor("violet").setFavoriteNumber(10).build();
        HashMap<String, String> testTags = new HashMap<String, String>();
        testTags.put("testKey", "testValue");
        userAvroSchema = SchemaLoader.loadSchema(AVRO_USER_SCHEMA_FILE);
        employeeAvroSchema = SchemaLoader.loadSchema(AVRO_EMP_RECORD_SCHEMA_FILE_PATH);
        genericUserAvroRecord = RecordGenerator.createGenericAvroRecord();
        genericEmployeeAvroRecord = RecordGenerator.createGenericEmpRecord();
        userSchemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)genericUserAvroRecord);
        employeeSchemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)genericEmployeeAvroRecord);
        schemaDefinitionToSchemaVersionIdMap.put(userSchemaDefinition, USER_SCHEMA_VERSION_ID);
        schemaDefinitionToSchemaVersionIdMap.put(employeeSchemaDefinition, EMPLOYEE_SCHEMA_VERSION_ID);
        this.configs.put("endpoint", "https://test");
        this.configs.put("region", "us-west-2");
        this.configs.put("schemaName", "User-Topic");
        this.configs.put("schemaAutoRegistrationEnabled", true);
        this.configs.put("tags", testTags);
    }

    @Test
    public void testConfigure_schemaName_schemaNameMatches() {
        AwsCredentialsProvider cred = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(cred, null);
        awsKafkaAvroSerializer.configure(this.configs, true);
        Assertions.assertEquals((Object)"User-Topic", (Object)awsKafkaAvroSerializer.getSchemaName());
        Assertions.assertNull((Object)awsKafkaAvroSerializer.getSchemaNamingStrategy());
    }

    @Test
    public void testConfigure_schemaName_schemaNamingStrategyMatches() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("endpoint", "https://test");
        configs.put("region", "us-west-2");
        AwsCredentialsProvider cred = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(cred, null);
        awsKafkaAvroSerializer.configure(configs, true);
        Assertions.assertNotNull((Object)awsKafkaAvroSerializer.getSchemaNamingStrategy());
        Assertions.assertEquals((Object)"com.amazonaws.services.schemaregistry.common.AWSSchemaNamingStrategyDefaultImpl", (Object)awsKafkaAvroSerializer.getSchemaNamingStrategy().getClass().getName());
    }

    @Test
    public void testConfigure_customerProvidedStrategy_schemaNamingStrategyMatches() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("endpoint", "https://test");
        configs.put("region", "us-west-2");
        configs.put("schemaNameGenerationClass", "com.amazonaws.services.schemaregistry.serializers.avro.CustomerProvidedSchemaNamingStrategy");
        AwsCredentialsProvider cred = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(cred, null);
        awsKafkaAvroSerializer.configure(configs, true);
        Assertions.assertNotNull((Object)awsKafkaAvroSerializer.getSchemaNamingStrategy());
        Assertions.assertEquals((Object)"com.amazonaws.services.schemaregistry.serializers.avro.CustomerProvidedSchemaNamingStrategy", (Object)awsKafkaAvroSerializer.getSchemaNamingStrategy().getClass().getName());
    }

    @Test
    public void testConfigure_customerProvidedStrategy_throwsException() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("endpoint", "https://test");
        configs.put("region", "us-west-2");
        configs.put("schemaNameGenerationClass", "com.amazonaws.services.schemaregistry.serializers.avro.CustomerProvidedSchemaNamingStrategy1");
        configs.put("schemaAutoRegistrationEnabled", true);
        AwsCredentialsProvider cred = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(cred, null);
        AWSSchemaRegistryException awsSchemaRegistryException = (AWSSchemaRegistryException)Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroSerializer.configure(configs, true));
        String exceptedExceptionMessage = "Unable to locate the naming strategy class, check in the classpath for classname = " + configs.get("schemaNameGenerationClass");
        Assertions.assertEquals((Object)exceptedExceptionMessage, (Object)awsSchemaRegistryException.getMessage());
    }

    @Test
    public void testConfigure_nullConfigMapWithVersionId_throwsException() {
        AwsCredentialsProvider cred = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(cred, null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> awsKafkaAvroSerializer.configure((Map)null, true));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_customerProvidedStrategy_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws Exception {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("endpoint", "https://test");
        configs.put("region", "us-west-2");
        configs.put("schemaNameGenerationClass", "com.amazonaws.services.schemaregistry.serializers.avro.CustomerProvidedSchemaNamingStrategy");
        configs.put("schemaAutoRegistrationEnabled", true);
        configs.put("compression", compressionType.name());
        String fileName = "src/test/java/resources/avro/user3.avsc";
        Schema schema = this.getSchema(fileName);
        GenericData.EnumSymbol k = new GenericData.EnumSymbol(schema, "ONE");
        ArrayList<Integer> al = new ArrayList<Integer>();
        al.add(1);
        GenericData.Record genericRecordWithAllTypes = new GenericData.Record(schema);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("test", 1L);
        genericRecordWithAllTypes.put("name", (Object)"Joe");
        genericRecordWithAllTypes.put("favorite_number", (Object)1);
        genericRecordWithAllTypes.put("meta", map);
        genericRecordWithAllTypes.put("listOfColours", al);
        genericRecordWithAllTypes.put("integerEnum", (Object)k);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)genericRecordWithAllTypes);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(configs, schemaDefinition, this.mockClient, USER_SCHEMA_VERSION_ID);
        String schemaName = new CustomerProvidedSchemaNamingStrategy().getSchemaName("User-Topic", genericRecordWithAllTypes);
        Mockito.when((Object)this.mockClient.getORRegisterSchemaVersionId((String)ArgumentMatchers.eq((Object)schemaDefinition), (String)ArgumentMatchers.eq((Object)schemaName), (String)ArgumentMatchers.eq((Object)DataFormat.AVRO.name()), ArgumentMatchers.anyMap())).thenReturn((Object)USER_SCHEMA_VERSION_ID);
        byte[] serialize = awsKafkaAvroSerializer.serialize("User-Topic", (Object)genericRecordWithAllTypes);
        this.testForSerializedData(serialize, USER_SCHEMA_VERSION_ID, compressionType);
    }

    @Test
    public void testConstructor_defaultCredentialProvider_credentialProviderMatches() {
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer();
        Assertions.assertNull((Object)awsKafkaAvroSerializer.getSchemaVersionId());
        Assertions.assertEquals((Object)"software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider", (Object)awsKafkaAvroSerializer.getCredentialProvider().getClass().getName());
    }

    @Test
    public void testConstructor_nullCredentialProvider_succeeds() {
        Assertions.assertDoesNotThrow(() -> new AWSKafkaAvroSerializer(null, USER_SCHEMA_VERSION_ID, this.configs));
    }

    @Test
    public void testConstructor_configMap_succeeds() {
        Assertions.assertDoesNotThrow(() -> new AWSKafkaAvroSerializer(this.configs));
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(this.configs);
        Assertions.assertNotNull((Object)awsKafkaAvroSerializer);
    }

    @Test
    public void testConstructor_nullConfigMapWithVersionId_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AWSKafkaAvroSerializer((Map)null, USER_SCHEMA_VERSION_ID));
    }

    @Test
    public void testSerialize_nullData_returnsNull() {
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer();
        Assertions.assertNull((Object)awsKafkaAvroSerializer.serialize("test", null));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_customPojos_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, userSchemaDefinition, this.mockClient, USER_SCHEMA_VERSION_ID);
        byte[] serialize = awsKafkaAvroSerializer.serialize("test-topic", (Object)this.userDefinedPojo);
        this.testForSerializedData(serialize, USER_SCHEMA_VERSION_ID, compressionType);
    }

    @Test
    public void testSerialize_nullSchemaIdFromAvroSerializer_returnsNullByte() {
        AWSSerializerInput awsSerializerInput = AWSSerializerInput.builder().schemaDefinition(AVROUtils.getInstance().getSchemaDefinition((Object)genericUserAvroRecord)).schemaName("User-Topic").build();
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(this.configs, null);
        AWSAvroSerializer mockAWSAvroSerializer = (AWSAvroSerializer)Mockito.mock(AWSAvroSerializer.class);
        awsKafkaAvroSerializer.setAvroSerializer(mockAWSAvroSerializer);
        Mockito.when((Object)mockAWSAvroSerializer.registerSchema(awsSerializerInput)).thenReturn(null);
        Assertions.assertNull((Object)awsKafkaAvroSerializer.serialize("User-Topic", (Object)genericUserAvroRecord));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_parseSchema_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, userSchemaDefinition, this.mockClient, USER_SCHEMA_VERSION_ID);
        byte[] serialize = awsKafkaAvroSerializer.serialize("test-topic", (Object)genericUserAvroRecord);
        this.testForSerializedData(serialize, USER_SCHEMA_VERSION_ID, compressionType);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_multipleRecords_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, this.mockClient, schemaDefinitionToSchemaVersionIdMap);
        byte[] userSerializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)genericUserAvroRecord);
        this.testForSerializedData(userSerializedData, USER_SCHEMA_VERSION_ID, compressionType);
        byte[] employeeSerializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)genericEmployeeAvroRecord);
        this.testForSerializedData(employeeSerializedData, EMPLOYEE_SCHEMA_VERSION_ID, compressionType);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_preProvidedSchemaVersionId_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, USER_SCHEMA_VERSION_ID);
        byte[] serializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)genericUserAvroRecord);
        this.testForSerializedData(serializedData, USER_SCHEMA_VERSION_ID, compressionType);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_preProvidedSchemaVersionIdWithAnyRecord_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, USER_SCHEMA_VERSION_ID);
        byte[] serializedUserData = awsKafkaAvroSerializer.serialize("test-topic", (Object)genericEmployeeAvroRecord);
        this.testForSerializedData(serializedUserData, USER_SCHEMA_VERSION_ID, compressionType);
        byte[] employeeSerializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)genericEmployeeAvroRecord);
        this.testForSerializedData(employeeSerializedData, USER_SCHEMA_VERSION_ID, compressionType);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_sendMultipleMsgs_throwsExceptionAndSchemaVersionIdStateNotSaved(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws Exception {
        this.configs.put("compression", compressionType.name());
        String fileName = "src/test/java/resources/avro/user_array_String.avsc";
        Schema schema = this.getSchema(fileName);
        GenericData.Array array1 = new GenericData.Array(1, schema);
        array1.add((Object)"1");
        GenericData.Array array2 = new GenericData.Array(1, schema);
        array1.add((Object)"2");
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)array1);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, null);
        EntityNotFoundException.Builder builder = EntityNotFoundException.builder().message("Schema version is not found.");
        EntityNotFoundException entityNotFoundException = (EntityNotFoundException)builder.build();
        AWSSchemaRegistryException awsSchemaRegistryException = new AWSSchemaRegistryException((Throwable)entityNotFoundException);
        Mockito.when((Object)this.mockClient.getORRegisterSchemaVersionId((String)ArgumentMatchers.eq((Object)schemaDefinition), (String)ArgumentMatchers.eq((Object)"User-Topic"), (String)ArgumentMatchers.eq((Object)DataFormat.AVRO.name()), ArgumentMatchers.anyMap())).thenThrow(new Throwable[]{awsSchemaRegistryException});
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroSerializer.serialize("test-topic", (Object)array1));
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroSerializer.serialize("test-topic", (Object)array2));
        Assertions.assertNull((Object)awsKafkaAvroSerializer.getSchemaVersionId());
    }

    @Test
    public void testPrepareInput_nullDefinitionData_throwsException() throws NoSuchMethodException {
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer();
        Method method = AWSKafkaAvroSerializer.class.getDeclaredMethod("prepareInput", Object.class, String.class);
        method.setAccessible(true);
        try {
            method.invoke((Object)awsKafkaAvroSerializer, null, "User-Topic");
        }
        catch (Exception e) {
            Assertions.assertEquals(IllegalArgumentException.class, e.getCause().getClass());
        }
    }

    static {
        schemaDefinitionToSchemaVersionIdMap = new HashMap<String, UUID>();
    }
}

