/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers.avro;

import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSAvroSerializer;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSKafkaAvroSerializer;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.apache.avro.Schema;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;

public class AWSSchemaRegistryValidationUtil {
    protected Schema getSchema(String fileName) throws IOException {
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(new File(fileName));
    }

    protected AWSKafkaAvroSerializer initialize(Map<String, Object> configs, String schemaDefinition, AWSSchemaRegistryClient mockClient, UUID testGenericSchemaVersionId) {
        AwsCredentialsProvider cred = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        AWSAvroSerializer avroSerializer = AWSAvroSerializer.builder().configs(configs).credentialProvider(cred).schemaRegistryClient(mockClient).build();
        Mockito.when((Object)mockClient.getORRegisterSchemaVersionId((String)ArgumentMatchers.eq((Object)schemaDefinition), (String)ArgumentMatchers.eq((Object)"User-Topic"), (String)ArgumentMatchers.eq((Object)DataFormat.AVRO.name()), ArgumentMatchers.anyMap())).thenReturn((Object)testGenericSchemaVersionId);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(cred, null);
        awsKafkaAvroSerializer.configure(configs, true);
        GlueSchemaRegistryConfiguration mockConfig = (GlueSchemaRegistryConfiguration)Mockito.mock(GlueSchemaRegistryConfiguration.class);
        awsKafkaAvroSerializer.setAvroSerializer(avroSerializer);
        return awsKafkaAvroSerializer;
    }

    protected AWSKafkaAvroSerializer initialize(Map<String, Object> configs, AWSSchemaRegistryClient mockClient, Map<String, UUID> schemaDefinitionToSchemaVersionIdMap) {
        AwsCredentialsProvider cred = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        AWSAvroSerializer avroSerializer = AWSAvroSerializer.builder().configs(configs).credentialProvider(cred).schemaRegistryClient(mockClient).build();
        for (Map.Entry<String, UUID> entry : schemaDefinitionToSchemaVersionIdMap.entrySet()) {
            Mockito.when((Object)mockClient.getORRegisterSchemaVersionId((String)ArgumentMatchers.eq((Object)entry.getKey()), (String)ArgumentMatchers.eq((Object)"User-Topic"), (String)ArgumentMatchers.eq((Object)DataFormat.AVRO.name()), ArgumentMatchers.anyMap())).thenReturn((Object)entry.getValue());
        }
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(cred, null);
        awsKafkaAvroSerializer.configure(configs, true);
        awsKafkaAvroSerializer.setAvroSerializer(avroSerializer);
        return awsKafkaAvroSerializer;
    }

    protected AWSKafkaAvroSerializer initialize(Map<String, Object> configs, UUID testGenericSchemaVersionId) {
        AwsCredentialsProvider cred = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        AWSSchemaRegistryClient mockClient = (AWSSchemaRegistryClient)Mockito.mock(AWSSchemaRegistryClient.class);
        AWSAvroSerializer avroSerializer = AWSAvroSerializer.builder().configs(configs).credentialProvider(cred).schemaRegistryClient(mockClient).build();
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(configs, testGenericSchemaVersionId);
        awsKafkaAvroSerializer.configure(configs, true);
        awsKafkaAvroSerializer.setAvroSerializer(avroSerializer);
        return awsKafkaAvroSerializer;
    }

    protected void testForSerializedData(byte[] serializedData, UUID testGenericSchemaVersionId, AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Assertions.assertNotNull((Object)serializedData);
        ByteBuffer buffer = this.getByteBuffer(serializedData);
        byte headerVersionByte = this.getByte(buffer);
        byte compressionByte = this.getByte(buffer);
        UUID schemaVersionId = this.getSchemaVersionId(buffer);
        Assertions.assertEquals((byte)3, (byte)headerVersionByte);
        Assertions.assertEquals((Object)testGenericSchemaVersionId, (Object)schemaVersionId);
        if (compressionType.name().equals(AWSSchemaRegistryConstants.COMPRESSION.NONE.name())) {
            Assertions.assertEquals((byte)0, (byte)compressionByte);
        } else {
            Assertions.assertEquals((byte)5, (byte)compressionByte);
        }
    }

    private ByteBuffer getByteBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    private Byte getByte(ByteBuffer buffer) {
        return buffer.get();
    }

    private UUID getSchemaVersionId(ByteBuffer buffer) {
        long mostSigBits = buffer.getLong();
        long leastSigBits = buffer.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }
}

