/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers.avro;

import com.amazonaws.services.schemaregistry.caching.AWSCache;
import com.amazonaws.services.schemaregistry.caching.AWSSchemaRegistrySerializerCache;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.AWSSerializerInput;
import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistrySerializationFacade;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSAvroSerializer;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSKafkaAvroSerializer;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSSchemaRegistryValidationUtil;
import com.amazonaws.services.schemaregistry.serializers.avro.Customer;
import com.amazonaws.services.schemaregistry.serializers.avro.User;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.Compatibility;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.MetadataKeyValuePair;

public class GlueSchemaRegistrySerializationFacadeTest
extends AWSSchemaRegistryValidationUtil {
    public static final String UNKNOWN_DATA_FORMAT = "UNKNOWN_DATA_FORMAT";
    @Mock
    private AWSSchemaRegistryClient mockClient;
    private final Map<String, Object> configs = new HashMap<String, Object>();
    public static final String AVRO_USER_SCHEMA_FILE = "src/test/java/resources/avro/user.avsc";
    public static final String AVRO_USER_ENUM_SCHEMA_FILE = "src/test/java/resources/avro/user_enum.avsc";
    public static final String AVRO_USER_ARRAY_SCHEMA_FILE = "src/test/java/resources/avro/user_array.avsc";
    public static final String AVRO_USER_UNION_SCHEMA_FILE = "src/test/java/resources/avro/user_union.avsc";
    public static final String AVRO_USER_FIXED_SCHEMA_FILE = "src/test/java/resources/avro/user_fixed.avsc";
    public static final String AVRO_USER_ARRAY_LONG_SCHEMA_FILE = "src/test/java/resources/avro/user_array_long.avsc";
    public static final String AVRO_USER_ARRAY_STRING_SCHEMA_FILE = "src/test/java/resources/avro/user_array_String.avsc";
    public static final String AVRO_USER_MAP_SCHEMA_FILE = "src/test/java/resources/avro/user_map.avsc";
    public static final String AVRO_USER_MIXED_TYPE_SCHEMA_FILE = "src/test/java/resources/avro/user3.avsc";
    private static final UUID SCHEMA_VERSION_ID_FOR_TESTING = UUID.fromString("b7b4a7f0-9c96-4e4a-a687-fb5de9ef0c63");
    private static final String TRANSPORT_NAME = "default-stream";
    private static final String TEST_SCHEMA = "test-schema";
    private static final String AVRO_SCHEMA_TYPE = DataFormat.AVRO.name();
    private org.apache.avro.Schema schema = null;
    private User userDefinedPojo;
    private GenericRecord genericRecord;
    private Customer customer;
    @Mock
    private AwsCredentialsProvider cred;

    @BeforeEach
    public void setup() {
        this.mockClient = (AWSSchemaRegistryClient)Mockito.mock(AWSSchemaRegistryClient.class);
        this.cred = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        MockitoAnnotations.initMocks((Object)this);
        this.customer = new Customer();
        this.customer.setName("test");
        Map<String, String> metadata = this.getMetadata();
        HashMap<String, String> testTags = new HashMap<String, String>();
        testTags.put("testKey", "testValue");
        Schema.Parser parser = new Schema.Parser();
        try {
            this.schema = parser.parse(new File(AVRO_USER_SCHEMA_FILE));
        }
        catch (IOException e) {
            Assertions.fail((String)"Catch IOException: ", (Throwable)e);
        }
        this.userDefinedPojo = User.newBuilder().setName("test_avros_schema").setFavoriteColor("violet").setFavoriteNumber(10).build();
        this.genericRecord = new GenericData.Record(this.schema);
        this.genericRecord.put("name", (Object)"sansa");
        this.genericRecord.put("favorite_number", (Object)99);
        this.genericRecord.put("favorite_color", (Object)"red");
        this.configs.put("region", "us-west-2");
        this.configs.put("schemaName", "User-Topic");
        this.configs.put("schemaAutoRegistrationEnabled", true);
        this.configs.put("metadata", metadata);
        this.configs.put("tags", testTags);
    }

    private AWSSchemaRegistrySerializerCache createSerializerCache() {
        GlueSchemaRegistryConfiguration mockConfig = (GlueSchemaRegistryConfiguration)Mockito.mock(GlueSchemaRegistryConfiguration.class);
        AWSSchemaRegistrySerializerCache serializerCache = AWSSchemaRegistrySerializerCache.getInstance((GlueSchemaRegistryConfiguration)mockConfig);
        serializerCache.flushCache();
        return serializerCache;
    }

    private GlueSchemaRegistrySerializationFacade createGlueSerializationFacade(Map<String, Object> configs, AWSSchemaRegistryClient awsSchemaRegistryClient) {
        GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade = GlueSchemaRegistrySerializationFacade.builder().glueSchemaRegistryConfiguration(new GlueSchemaRegistryConfiguration(configs)).credentialProvider(this.cred).schemaRegistryClient(awsSchemaRegistryClient).build();
        AWSSchemaRegistrySerializerCache awsSchemaRegistrySerializerCache = this.createSerializerCache();
        glueSchemaRegistrySerializationFacade.setCache((AWSCache)awsSchemaRegistrySerializerCache);
        return glueSchemaRegistrySerializationFacade;
    }

    @Test
    public void testSerialize_schemaParsing_succeeds() {
        GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)this.genericRecord);
        Mockito.when((Object)this.mockClient.getORRegisterSchemaVersionId((String)ArgumentMatchers.eq((Object)schemaDefinition), (String)ArgumentMatchers.eq((Object)"User"), (String)ArgumentMatchers.eq((Object)DataFormat.AVRO.name()), ArgumentMatchers.anyMap())).thenReturn((Object)SCHEMA_VERSION_ID_FOR_TESTING);
        UUID schemaVersionId = glueSchemaRegistrySerializationFacade.getOrRegisterSchemaVersion(this.prepareInput(schemaDefinition, "User"));
        Assertions.assertNotNull((Object)glueSchemaRegistrySerializationFacade.serialize(DataFormat.AVRO, (Object)this.genericRecord, schemaVersionId));
    }

    @Test
    public void testSerialize_InvalidDataFormat_ThrowsException() {
        GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        Exception exception = (Exception)Assertions.assertThrows(AWSSchemaRegistryException.class, () -> glueSchemaRegistrySerializationFacade.serialize(DataFormat.UNKNOWN_TO_SDK_VERSION, (Object)this.genericRecord, SCHEMA_VERSION_ID_FOR_TESTING));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Unsupported data format:"));
    }

    @Test
    public void testSerialize_NullSchemaVersionId_ThrowsException() {
        GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        Assertions.assertThrows(IllegalArgumentException.class, () -> glueSchemaRegistrySerializationFacade.serialize(DataFormat.AVRO, (Object)this.genericRecord, null));
    }

    @Test
    public void testSerialize_NullData_ThrowsException() {
        GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        Assertions.assertThrows(IllegalArgumentException.class, () -> glueSchemaRegistrySerializationFacade.serialize(DataFormat.AVRO, null, SCHEMA_VERSION_ID_FOR_TESTING));
    }

    @Test
    public void testSerialize_customPojos_succeeds() {
        GlueSchemaRegistrySerializationFacade glueSerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)this.genericRecord);
        Mockito.when((Object)this.mockClient.getORRegisterSchemaVersionId((String)ArgumentMatchers.eq((Object)schemaDefinition), (String)ArgumentMatchers.eq((Object)"User"), (String)ArgumentMatchers.eq((Object)AVRO_SCHEMA_TYPE), ArgumentMatchers.anyMap())).thenReturn((Object)SCHEMA_VERSION_ID_FOR_TESTING);
        UUID schemaVersionId = glueSerializationFacade.getOrRegisterSchemaVersion(this.prepareInput(schemaDefinition, "User"));
        Assertions.assertNotNull((Object)glueSerializationFacade.serialize(DataFormat.AVRO, (Object)this.userDefinedPojo, schemaVersionId));
    }

    private AWSSerializerInput prepareInput(String schemaDefinition, String schemaName) {
        return AWSSerializerInput.builder().schemaDefinition(schemaDefinition).schemaName(schemaName).build();
    }

    @Test
    public void testBuildAWSAvroSerializer_nullConfig_throwsException() {
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> AWSAvroSerializer.builder().configs(null).credentialProvider(this.cred).schemaRegistryClient(this.mockClient).build());
    }

    @Test
    public void testBuildAWSAvroSerializer_nullConfigWithProp_throwsException() {
        Properties properties = new Properties();
        properties.put("region", "us-west-2");
        properties.put("endpoint", "https://test");
        properties.put("schemaName", "User-Topic");
        Assertions.assertDoesNotThrow(() -> AWSAvroSerializer.builder().configs(null).credentialProvider(this.cred).properties(properties).build());
    }

    @Test
    public void testBuildAWSAvroSerializer_nullCredentialProvider_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AWSAvroSerializer.builder().configs(this.configs).credentialProvider(null).build());
    }

    @Test
    public void testBuildAWSAvroSerializer_invalidConfigs_throwsException() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("compatibility", Compatibility.UNKNOWN_TO_SDK_VERSION.toString());
        configs.put("schemaName", "User-Topic");
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> AWSAvroSerializer.builder().configs(configs).credentialProvider(this.cred).schemaRegistryClient(this.mockClient).build());
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class, names={"NONE"}, mode=EnumSource.Mode.EXCLUDE)
    public void testBuildAWSAvroSerializer_withCompression_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        this.configs.put("compression", compressionType.name());
        GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        Assertions.assertNotNull((Object)glueSchemaRegistrySerializationFacade.getCache());
    }

    @Test
    public void testInitialize_nullCredentials_ThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GlueSchemaRegistrySerializationFacade(null, this.mockClient, new GlueSchemaRegistryConfiguration(this.configs)));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_nullTopic_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Schema.Parser parser = new Schema.Parser();
        org.apache.avro.Schema schemaComprisingEnum = null;
        try {
            schemaComprisingEnum = parser.parse(new File(AVRO_USER_ENUM_SCHEMA_FILE));
        }
        catch (IOException e) {
            Assertions.fail((String)"Catch IOException: ", (Throwable)e);
        }
        GenericData.EnumSymbol genericRecord2 = new GenericData.EnumSymbol(schemaComprisingEnum, "ONE");
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)genericRecord2);
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        String nullTopic = null;
        byte[] serializedData = awsKafkaAvroSerializer.serialize(nullTopic, (Object)genericRecord2);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, compressionType);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_enums_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        Schema.Parser parser = new Schema.Parser();
        org.apache.avro.Schema schemaComprisingEnum = null;
        try {
            schemaComprisingEnum = parser.parse(new File(AVRO_USER_ENUM_SCHEMA_FILE));
        }
        catch (IOException e) {
            Assertions.fail((String)"Catch IOException: ", (Throwable)e);
        }
        GenericData.EnumSymbol genericRecord2 = new GenericData.EnumSymbol(schemaComprisingEnum, "ONE");
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)genericRecord2);
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        byte[] serializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)genericRecord2);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, compressionType);
    }

    @Test
    public void testSerialize_enums_throwsException() {
        org.apache.avro.Schema schemaComprisingEnum = null;
        Schema.Parser parser = new Schema.Parser();
        try {
            schemaComprisingEnum = parser.parse(new File(AVRO_USER_ENUM_SCHEMA_FILE));
        }
        catch (IOException e) {
            Assertions.fail((String)"Catch IOException: ", (Throwable)e);
        }
        GenericData.EnumSymbol genericRecordWrongData = new GenericData.EnumSymbol(schemaComprisingEnum, "SPADE");
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)genericRecordWrongData);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroSerializer.serialize("test-topic", (Object)genericRecordWrongData));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_integerArrays_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_ARRAY_SCHEMA_FILE);
        GenericData.Array array = new GenericData.Array(1, schema);
        array.add((Object)1);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)array);
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        byte[] serializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)array);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, compressionType);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_objectArrays_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_ARRAY_SCHEMA_FILE);
        GenericData.Array array = new GenericData.Array(1, schema);
        array.add((Object)1);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)array);
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        byte[] serializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)array);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, compressionType);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_stringArrays_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_ARRAY_STRING_SCHEMA_FILE);
        GenericData.Array array = new GenericData.Array(1, schema);
        array.add((Object)"2");
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)array);
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        byte[] serializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)array);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, compressionType);
    }

    @Test
    public void testSerialize_arrays_throwsException() throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_ARRAY_SCHEMA_FILE);
        GenericData.Array array = new GenericData.Array(1, schema);
        array.add((Object)"s");
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)array);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroSerializer.serialize("test-topic", (Object)array));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_maps_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_MAP_SCHEMA_FILE);
        GenericData.Record mapRecord = new GenericData.Record(schema);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("test", 1L);
        mapRecord.put("meta", map);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)mapRecord);
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        byte[] serializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)mapRecord);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, compressionType);
    }

    @Test
    public void testSerialize_maps_throwsException() throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_MAP_SCHEMA_FILE);
        GenericData.Record mapRecord = new GenericData.Record(schema);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "s");
        mapRecord.put("meta", map);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)mapRecord);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroSerializer.serialize("test-topic", (Object)mapRecord));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_unions_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_UNION_SCHEMA_FILE);
        GenericData.Record unionRecord = new GenericData.Record(schema);
        unionRecord.put("experience", (Object)1);
        unionRecord.put("age", (Object)30);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)unionRecord);
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        byte[] serializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)unionRecord);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, compressionType);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_unionsNull_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_UNION_SCHEMA_FILE);
        GenericData.Record unionRecord = new GenericData.Record(schema);
        unionRecord.put("experience", null);
        unionRecord.put("age", (Object)30);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)unionRecord);
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        byte[] serializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)unionRecord);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, compressionType);
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_fixed_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_FIXED_SCHEMA_FILE);
        GenericData.Fixed fixedRecord = new GenericData.Fixed(schema);
        byte[] bytes = "byte array".getBytes();
        fixedRecord.bytes(bytes);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)fixedRecord);
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        byte[] serializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)fixedRecord);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, compressionType);
    }

    @Test
    public void testSerialize_fixed_throwsException() throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_FIXED_SCHEMA_FILE);
        GenericData.Fixed fixedRecord = new GenericData.Fixed(schema);
        byte[] bytes = "byte".getBytes();
        fixedRecord.bytes(bytes);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)fixedRecord);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroSerializer.serialize("test-topic", (Object)fixedRecord));
    }

    @Test
    public void testSerialize_unions_throwsException() throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_UNION_SCHEMA_FILE);
        GenericData.Record unionRecord = new GenericData.Record(schema);
        unionRecord.put("experience", (Object)"wrong_value");
        unionRecord.put("age", (Object)30);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)unionRecord);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroSerializer.serialize("test-topic", (Object)unionRecord));
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class)
    public void testSerialize_allTypes_succeeds(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws Exception {
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_MIXED_TYPE_SCHEMA_FILE);
        GenericData.EnumSymbol k = new GenericData.EnumSymbol(schema, "ONE");
        ArrayList<Integer> al = new ArrayList<Integer>();
        al.add(1);
        GenericData.Record genericRecordWithAllTypes = new GenericData.Record(schema);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("test", 1L);
        genericRecordWithAllTypes.put("name", (Object)"Joe");
        genericRecordWithAllTypes.put("favorite_number", (Object)1);
        genericRecordWithAllTypes.put("meta", map);
        genericRecordWithAllTypes.put("listOfColours", al);
        genericRecordWithAllTypes.put("integerEnum", (Object)k);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)genericRecordWithAllTypes);
        this.configs.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        byte[] serializedData = awsKafkaAvroSerializer.serialize("test-topic", (Object)genericRecordWithAllTypes);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, compressionType);
    }

    @Test
    public void testSerialize_unsupportedProtocolMessage_throwsException() throws Exception {
        String fileName = AVRO_USER_ARRAY_LONG_SCHEMA_FILE;
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_ARRAY_LONG_SCHEMA_FILE);
        GenericData.Array array = new GenericData.Array(1, schema);
        array.add((Object)1L);
        ArrayList<Integer> unSupportedFormatArray = new ArrayList<Integer>();
        unSupportedFormatArray.add(1);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = this.initialize(this.configs, null, this.mockClient, null);
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> awsKafkaAvroSerializer.serialize("test-topic", (Object)unSupportedFormatArray));
    }

    @Test
    public void testClose_succeeds() {
        AWSAvroSerializer avroSerializer = (AWSAvroSerializer)Mockito.mock(AWSAvroSerializer.class);
        AWSKafkaAvroSerializer awsKafkaAvroSerializer = new AWSKafkaAvroSerializer(this.cred, this.configs);
        awsKafkaAvroSerializer.setAvroSerializer(avroSerializer);
        awsKafkaAvroSerializer.close();
    }

    @ParameterizedTest
    @EnumSource(value=AWSSchemaRegistryConstants.COMPRESSION.class, names={"NONE"}, mode=EnumSource.Mode.EXCLUDE)
    public void testSerialize_arraysWithCompression_byteArraySizeIsReduced(AWSSchemaRegistryConstants.COMPRESSION compressionType) throws IOException {
        int capacity = 1000000;
        org.apache.avro.Schema schema = this.getSchema(AVRO_USER_ARRAY_STRING_SCHEMA_FILE);
        GenericData.Array array = new GenericData.Array(capacity, schema);
        for (int i = 0; i < capacity; ++i) {
            array.add((Object)"test");
        }
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)array);
        Map<String, Object> configsWithCompressionEnabled = this.configs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        configsWithCompressionEnabled.put("compression", compressionType.name());
        AWSKafkaAvroSerializer awsKafkaAvroSerializerWithoutCompression = this.initialize(this.configs, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        AWSKafkaAvroSerializer awsKafkaAvroSerializerWithCompression = this.initialize(configsWithCompressionEnabled, schemaDefinition, this.mockClient, SCHEMA_VERSION_ID_FOR_TESTING);
        byte[] serializedData = awsKafkaAvroSerializerWithoutCompression.serialize("test-topic", (Object)array);
        byte[] compressedAndSerializedData = awsKafkaAvroSerializerWithCompression.serialize("test-topic", (Object)array);
        Assertions.assertTrue((serializedData.length > compressedAndSerializedData.length ? 1 : 0) != 0);
    }

    @Test
    public void testSerializer_retrieveSchemaVersionId_schemaVersionIdIsCached() {
        GlueSchemaRegistrySerializationFacade glueSerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)this.genericRecord);
        Mockito.when((Object)this.mockClient.getORRegisterSchemaVersionId((String)ArgumentMatchers.eq((Object)schemaDefinition), (String)ArgumentMatchers.eq((Object)"User"), (String)ArgumentMatchers.eq((Object)DataFormat.AVRO.name()), ArgumentMatchers.anyMap())).thenReturn((Object)SCHEMA_VERSION_ID_FOR_TESTING);
        Schema key = new Schema(schemaDefinition, DataFormat.AVRO.name(), "User");
        AWSSchemaRegistrySerializerCache serializerCache = AWSSchemaRegistrySerializerCache.getInstance((GlueSchemaRegistryConfiguration)new GlueSchemaRegistryConfiguration(this.configs));
        Assertions.assertNull((Object)serializerCache.get(key));
        glueSerializationFacade.getOrRegisterSchemaVersion(this.prepareInput(schemaDefinition, "User"));
        Assertions.assertNotNull((Object)serializerCache.get(key));
        Mockito.when((Object)this.mockClient.getORRegisterSchemaVersionId((String)ArgumentMatchers.eq((Object)schemaDefinition), (String)ArgumentMatchers.eq((Object)"User"), (String)ArgumentMatchers.eq((Object)DataFormat.AVRO.name()), ArgumentMatchers.anyMap())).thenReturn(null);
        Assertions.assertDoesNotThrow(() -> glueSerializationFacade.getOrRegisterSchemaVersion(this.prepareInput(schemaDefinition, "User")));
    }

    @Test
    public void testSerializer_registerSchemaVersion_withMetadataConfig_succeeds() {
        GlueSchemaRegistrySerializationFacade glueSerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)this.genericRecord);
        Map<String, String> metadata = this.getMetadata();
        metadata.put("x-amz-meta-transport", TRANSPORT_NAME);
        Mockito.when((Object)this.mockClient.getORRegisterSchemaVersionId(schemaDefinition, "User", DataFormat.AVRO.name(), metadata)).thenReturn((Object)SCHEMA_VERSION_ID_FOR_TESTING);
        UUID schemaVersionId = glueSerializationFacade.getOrRegisterSchemaVersion(this.prepareInput(schemaDefinition, "User"));
        Assertions.assertEquals((Object)SCHEMA_VERSION_ID_FOR_TESTING, (Object)schemaVersionId);
    }

    @Test
    public void testSerializer_registerSchemaVersion_withoutMetadataConfig_succeeds() {
        this.configs.remove("metadata");
        GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)this.genericRecord);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("x-amz-meta-transport", TRANSPORT_NAME);
        Mockito.when((Object)this.mockClient.getORRegisterSchemaVersionId(schemaDefinition, "User", DataFormat.AVRO.name(), metadata)).thenReturn((Object)SCHEMA_VERSION_ID_FOR_TESTING);
        UUID schemaVersionId = glueSchemaRegistrySerializationFacade.getOrRegisterSchemaVersion(this.prepareInput(schemaDefinition, "User"));
        Assertions.assertEquals((Object)SCHEMA_VERSION_ID_FOR_TESTING, (Object)schemaVersionId);
    }

    @Test
    public void testSerializer_registerSchemaVersion_whenPutSchemaVersionMetadataThrowsException() {
        GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(this.configs);
        AWSSchemaRegistryClient awsSchemaRegistryClient = new AWSSchemaRegistryClient(this.cred, glueSchemaRegistryConfiguration);
        AWSSchemaRegistryClient spyClient = (AWSSchemaRegistryClient)Mockito.spy((Object)awsSchemaRegistryClient);
        GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade = this.createGlueSerializationFacade(this.configs, spyClient);
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)this.genericRecord);
        Map<String, String> metadata = this.getMetadata();
        metadata.put("x-amz-meta-transport", TRANSPORT_NAME);
        EntityNotFoundException entityNotFoundException = (EntityNotFoundException)EntityNotFoundException.builder().message("Schema version is not found.").build();
        AWSSchemaRegistryException awsSchemaRegistryException = new AWSSchemaRegistryException((Throwable)entityNotFoundException);
        ((AWSSchemaRegistryClient)Mockito.doThrow((Throwable[])new Throwable[]{awsSchemaRegistryException}).when((Object)spyClient)).getSchemaVersionIdByDefinition(schemaDefinition, "User", DataFormat.AVRO.name());
        GetSchemaVersionResponse getSchemaVersionResponse = this.createGetSchemaVersionResponse(SCHEMA_VERSION_ID_FOR_TESTING, schemaDefinition, DataFormat.AVRO.name());
        ((AWSSchemaRegistryClient)Mockito.doReturn((Object)getSchemaVersionResponse).when((Object)spyClient)).registerSchemaVersion(schemaDefinition, "User", DataFormat.AVRO.name());
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            MetadataKeyValuePair metadataKeyValuePair = this.createMetadataKeyValuePair(entry);
            ((AWSSchemaRegistryClient)Mockito.doThrow((Throwable[])new Throwable[]{new AWSSchemaRegistryException("Put schema version metadata failed.")}).when((Object)spyClient)).putSchemaVersionMetadata(SCHEMA_VERSION_ID_FOR_TESTING, metadataKeyValuePair);
        }
        ((AWSSchemaRegistryClient)Mockito.doNothing().when((Object)spyClient)).putSchemaVersionMetadata(SCHEMA_VERSION_ID_FOR_TESTING, metadata);
        UUID schemaVersionId = glueSchemaRegistrySerializationFacade.getOrRegisterSchemaVersion(this.prepareInput(schemaDefinition, "User"));
        Assertions.assertEquals((Object)SCHEMA_VERSION_ID_FOR_TESTING, (Object)schemaVersionId);
    }

    @Test
    public void testEncode_WhenValidInputIsPassed_EncodesTheBytes() throws Exception {
        String schemaDefinition = AVROUtils.getInstance().getSchemaDefinition((Object)this.genericRecord);
        Schema schema = new Schema(schemaDefinition, DataFormat.AVRO.name(), TEST_SCHEMA);
        byte[] genericRecordAsBytes = this.convertGenericRecordToBytes(this.genericRecord, schema);
        Map<String, String> metadata = this.getMetadata();
        metadata.put("x-amz-meta-transport", TRANSPORT_NAME);
        Mockito.when((Object)this.mockClient.getORRegisterSchemaVersionId(schemaDefinition, TEST_SCHEMA, AVRO_SCHEMA_TYPE, metadata)).thenReturn((Object)SCHEMA_VERSION_ID_FOR_TESTING);
        GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        byte[] serializedData = glueSchemaRegistrySerializationFacade.encode(TRANSPORT_NAME, schema, genericRecordAsBytes);
        this.testForSerializedData(serializedData, SCHEMA_VERSION_ID_FOR_TESTING, AWSSchemaRegistryConstants.COMPRESSION.NONE);
    }

    private byte[] convertGenericRecordToBytes(GenericRecord genericRecord, Schema schema) throws IOException {
        ByteArrayOutputStream genericRecordAsBytes = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)genericRecordAsBytes, null);
        GenericDatumWriter datumWriter = new GenericDatumWriter(AVROUtils.getInstance().getSchema((Object)genericRecord));
        datumWriter.write((Object)genericRecord, (Encoder)encoder);
        encoder.flush();
        return genericRecordAsBytes.toByteArray();
    }

    @Test
    public void testRegisterSchema_nullSerializerInput_throwsException() {
        GlueSchemaRegistrySerializationFacade glueSerializationFacade = this.createGlueSerializationFacade(this.configs, this.mockClient);
        Assertions.assertThrows(IllegalArgumentException.class, () -> glueSerializationFacade.getOrRegisterSchemaVersion(null));
    }

    private Map<String, String> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("event-source-1", "topic1");
        metadata.put("event-source-2", "topic2");
        metadata.put("event-source-3", "topic3");
        metadata.put("event-source-4", "topic4");
        metadata.put("event-source-5", "topic5");
        return metadata;
    }

    private GetSchemaVersionResponse createGetSchemaVersionResponse(UUID schemaVersionId, String schemaDefinition, String dataFormat) {
        return (GetSchemaVersionResponse)GetSchemaVersionResponse.builder().schemaVersionId(schemaVersionId.toString()).schemaDefinition(schemaDefinition).dataFormat(dataFormat).build();
    }

    private MetadataKeyValuePair createMetadataKeyValuePair(Map.Entry<String, String> metadataEntry) {
        return (MetadataKeyValuePair)MetadataKeyValuePair.builder().metadataKey(metadataEntry.getKey()).metadataValue(metadataEntry.getValue()).build();
    }
}

